/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.google.common.collect.BiMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.ConnectionId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.ChildEntityId;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityFamily;
import com.intellij.platform.workspace.storage.impl.ParentEntityId;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.containers.IntIntUniqueBiMap;
import com.intellij.platform.workspace.storage.impl.containers.LinkedBidirectionalMap;
import com.intellij.platform.workspace.storage.impl.containers.NonNegativeIntIntBiMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\u001c\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002\u001a \u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a2\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00062\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a8\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00032\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a0\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"assertConsistency", "", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "assertCorrectEntityClass", "connectionClass", "", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "assertResolvable", "storage", "clazz", "id", "checkAllStrongConnections", "entityFamilyClass", "keys", "", "debugInfo", "", "checkStrongAbstractConnection", "connectionKeys", "", "entityFamilyClasses", "checkStrongConnection", "Lit/unimi/dsi/fastutil/ints/IntSet;", "connectionTo", "connectionId", "Lcom/intellij/platform/workspace/storage/ConnectionId;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsistencyChecker.kt\ncom/intellij/platform/workspace/storage/impl/ConsistencyCheckerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 NonNegativeIntIntBiMap.kt\ncom/intellij/platform/workspace/storage/impl/containers/NonNegativeIntIntBiMap\n+ 6 IntIntUniqueBiMap.kt\ncom/intellij/platform/workspace/storage/impl/containers/IntIntUniqueBiMap\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,179:1\n67#2,4:180\n1617#3,9:184\n1869#3:193\n1870#3:195\n1626#3:196\n827#3:197\n855#3,2:198\n1869#3,2:200\n1869#3:202\n1870#3:204\n1869#3,2:205\n1878#3,3:207\n1563#3:214\n1634#3,3:215\n1634#3,3:220\n1563#3:223\n1#4:194\n1#4:203\n115#5,2:210\n105#6,2:212\n216#7,2:218\n*S KotlinDebug\n*F\n+ 1 ConsistencyChecker.kt\ncom/intellij/platform/workspace/storage/impl/ConsistencyCheckerKt\n*L\n14#1:180,4\n23#1:184,9\n23#1:193\n23#1:195\n23#1:196\n112#1:197\n112#1:198,2\n112#1:200,2\n143#1:202\n143#1:204\n153#1:205,2\n163#1:207,3\n84#1:214\n84#1:215,3\n107#1:220,3\n107#1:223\n23#1:194\n35#1:210,2\n56#1:212,2\n95#1:218,2\n*E\n"})
public final class ConsistencyCheckerKt {
    public static final void assertConsistency(@NotNull EntityStorage $this$assertConsistency) {
        Intrinsics.checkNotNullParameter((Object)$this$assertConsistency, (String)"<this>");
        ConsistencyCheckerKt.assertConsistency((AbstractEntityStorage)$this$assertConsistency);
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertConsistency(@NotNull AbstractEntityStorage $this$assertConsistency) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$assertConsistency, (String)"<this>");
        Logger $this$trace$iv = AbstractEntityStorage.Companion.getLOG();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Checking consistency of " + $this$assertConsistency);
        }
        $this$assertConsistency.getEntitiesByType$intellij_platform_workspace_storage().assertConsistency($this$assertConsistency);
        Iterable $this$mapNotNull$iv = $this$assertConsistency.getEntitiesByType$intellij_platform_workspace_storage().getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List<ConnectionId> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            EntityFamily it = (EntityFamily)element$iv$iv;
            boolean bl2 = false;
            Object object = it;
            if ((object != null && (object = ((EntityFamily)object).getEntities$intellij_platform_workspace_storage()) != null && (object = (WorkspaceEntityData)CollectionsKt.firstOrNull((List)object)) != null && (object = ((WorkspaceEntityData)object).createEntity($this$assertConsistency)) != null && (object = UtilsKt.asBase((WorkspaceEntity)object)) != null ? ((WorkspaceEntityBase)object).connectionIdList() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set existingConnectionIds = CollectionsKt.toMutableSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        $this$assertConsistency.getRefs$intellij_platform_workspace_storage().getOneToManyContainer$intellij_platform_workspace_storage().forEach((Function1<Map.Entry<ConnectionId, NonNegativeIntIntBiMap>, Unit>)((Function1)arg_0 -> ConsistencyCheckerKt.assertConsistency$lambda$2(existingConnectionIds, $this$assertConsistency, arg_0)));
        $this$assertConsistency.getRefs$intellij_platform_workspace_storage().getOneToOneContainer$intellij_platform_workspace_storage().forEach((Function1<Map.Entry<ConnectionId, IntIntUniqueBiMap>, Unit>)((Function1)arg_0 -> ConsistencyCheckerKt.assertConsistency$lambda$3(existingConnectionIds, $this$assertConsistency, arg_0)));
        $this$assertConsistency.getRefs$intellij_platform_workspace_storage().getOneToAbstractManyContainer$intellij_platform_workspace_storage().forEach((Function1<Map.Entry<ConnectionId, LinkedBidirectionalMap<ChildEntityId, ParentEntityId>>, Unit>)((Function1)arg_0 -> ConsistencyCheckerKt.assertConsistency$lambda$4(existingConnectionIds, $this$assertConsistency, arg_0)));
        $this$assertConsistency.getRefs$intellij_platform_workspace_storage().getAbstractOneToOneContainer$intellij_platform_workspace_storage().forEach((Function1<Map.Entry<ConnectionId, BiMap<ChildEntityId, ParentEntityId>>, Unit>)((Function1)arg_0 -> ConsistencyCheckerKt.assertConsistency$lambda$5(existingConnectionIds, $this$assertConsistency, arg_0)));
        Iterable $this$filterNot$iv = existingConnectionIds;
        boolean $i$f$filterNot = false;
        $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ConnectionId it = (ConnectionId)element$iv$iv;
            boolean bl = false;
            if (it.isParentNullable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            ConnectionId connectionId = (ConnectionId)element$iv;
            boolean bl4 = false;
            int childrenClass = connectionId.getChildClass();
            EntityFamily<? extends WorkspaceEntity> entityFamily = $this$assertConsistency.getEntitiesByType$intellij_platform_workspace_storage().get(childrenClass);
            WorkspaceEntityData childWithoutParent = entityFamily != null && (entityFamily = entityFamily.getEntities$intellij_platform_workspace_storage()) != null ? (WorkspaceEntityData)CollectionsKt.firstOrNull((List)((Object)entityFamily)) : null;
            boolean bl5 = bl = childWithoutParent == null;
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl6 = false;
            WorkspaceEntityData workspaceEntityData = childWithoutParent;
            Intrinsics.checkNotNull((Object)workspaceEntityData);
            String string = StringsKt.trimIndent((String)("\n        There is an entity " + EntityIdKt.asString(workspaceEntityData.createEntityId()) + " of type " + ClassToIntConverterKt.findWorkspaceEntity(childrenClass).getSimpleName() + " without a parent of type " + ClassToIntConverterKt.findWorkspaceEntity(connectionId.getParentClass()).getSimpleName() + "\n        However, the parent field in child is not nullable\n        Child full type: " + ClassToIntConverterKt.findWorkspaceEntity(childrenClass) + "\n        Parent full type: " + ClassToIntConverterKt.findWorkspaceEntity(connectionId.getParentClass()) + "\n        "));
            throw new AssertionError((Object)string);
        }
        $this$assertConsistency.getIndexes$intellij_platform_workspace_storage().assertConsistency($this$assertConsistency);
    }

    private static final void assertCorrectEntityClass(int connectionClass, long entityId) {
        boolean bl = ClassToIntConverterKt.findWorkspaceEntity(connectionClass).isAssignableFrom(ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(entityId)));
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Entity storage with connection class " + ClassToIntConverterKt.findWorkspaceEntity(connectionClass) + " contains entity data of wrong type " + entityId;
            throw new AssertionError((Object)string);
        }
    }

    private static final void assertResolvable(AbstractEntityStorage storage, int clazz, int id) {
        boolean bl;
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage.getEntitiesByType$intellij_platform_workspace_storage().get(clazz);
        boolean bl2 = bl = (entityFamily != null ? entityFamily.get(id) : null) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Reference to " + ClassToIntConverterKt.findWorkspaceEntity(clazz) + "-:-" + id + " cannot be resolved";
            throw new AssertionError((Object)string);
        }
    }

    private static final void checkAllStrongConnections(AbstractEntityStorage storage, int entityFamilyClass, Set<Long> keys, String debugInfo) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage.getEntitiesByType$intellij_platform_workspace_storage().getEntityFamilies$intellij_platform_workspace_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            throw new IllegalStateException(("Entity family doesn't exist. " + debugInfo).toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        Iterable $this$forEach$iv = entityFamily2.getEntities$intellij_platform_workspace_storage();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntityData entity = (WorkspaceEntityData)element$iv;
            boolean bl = false;
            if (entity == null) continue;
            boolean removed = keys.remove(entity.createEntityId());
            if (!_Assertions.ENABLED || removed) continue;
            boolean bl2 = false;
            String string = "Entity " + entity + " doesn't have a correct connection. " + debugInfo;
            throw new AssertionError((Object)string);
        }
    }

    private static final void checkStrongAbstractConnection(AbstractEntityStorage storage, Set<Long> connectionKeys, Set<Integer> entityFamilyClasses, String debugInfo) {
        Set keys = CollectionsKt.toMutableSet((Iterable)connectionKeys);
        Iterable $this$forEach$iv = entityFamilyClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int entityFamilyClass = ((Number)element$iv).intValue();
            boolean bl = false;
            ConsistencyCheckerKt.checkAllStrongConnections(storage, entityFamilyClass, keys, debugInfo);
        }
        boolean bl = keys.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Store is inconsistent. " + debugInfo;
            throw new AssertionError((Object)string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkStrongConnection(AbstractEntityStorage storage, IntSet connectionKeys, int entityFamilyClass, int connectionTo, ConnectionId connectionId) {
        boolean bl;
        int counter = 0;
        EntityFamily entityFamily = storage.getEntitiesByType$intellij_platform_workspace_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            entityFamily = new ImmutableEntityFamily();
        }
        EntityFamily entityFamily2 = entityFamily;
        Iterable $this$forEachIndexed$iv = entityFamily2.getEntities$intellij_platform_workspace_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entity;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv;
            int i = n;
            boolean bl2 = false;
            if (entity == null) continue;
            boolean bl3 = connectionKeys.contains(i);
            if (_Assertions.ENABLED && !bl3) {
                boolean bl4 = false;
                String string = StringsKt.trimMargin$default((String)("\n            |Storage inconsistency. Hard reference broken.\n            |Existing entity " + (WorkspaceEntityData)entity + "\n            |Misses a reference to " + ClassToIntConverterKt.findWorkspaceEntity(connectionTo) + "\n            |Reference id: " + i + "\n            |ConnectionId: " + connectionId + "\n            "), null, (int)1, null);
                throw new AssertionError((Object)string);
            }
            ++counter;
        }
        boolean bl5 = bl = counter == connectionKeys.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Store is inconsistent";
            throw new AssertionError((Object)string);
        }
    }

    private static final Unit assertConsistency$lambda$2(Set $existingConnectionIds, AbstractEntityStorage $this_assertConsistency, Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ConnectionId connectionId = (ConnectionId)entry.getKey();
        NonNegativeIntIntBiMap map2 = (NonNegativeIntIntBiMap)entry.getValue();
        $existingConnectionIds.remove(connectionId);
        boolean bl2 = bl = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_MANY;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        NonNegativeIntIntBiMap this_$iv = map2;
        boolean $i$f$forEachKey = false;
        Int2IntMaps.fastForEach((Int2IntMap)((Int2IntMap)NonNegativeIntIntBiMap.access$getKey2Value(this_$iv).getBackingMap$intellij_platform_workspace_storage()), (Consumer)new Consumer($this_assertConsistency, connectionId){
            final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
            final /* synthetic */ ConnectionId $connectionId$inlined;
            {
                this.$this_assertConsistency$inlined = abstractEntityStorage;
                this.$connectionId$inlined = connectionId;
            }

            public final void accept(Int2IntMap.Entry it) {
                int parentId = it.getIntValue();
                int childId = it.getIntKey();
                boolean bl = false;
                ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
            }
        });
        if (!connectionId.isParentNullable()) {
            ConsistencyCheckerKt.checkStrongConnection($this_assertConsistency, map2.getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
        }
        map2.assertConsistency$intellij_platform_workspace_storage();
        return Unit.INSTANCE;
    }

    private static final Unit assertConsistency$lambda$3(Set $existingConnectionIds, AbstractEntityStorage $this_assertConsistency, Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ConnectionId connectionId = (ConnectionId)entry.getKey();
        IntIntUniqueBiMap map2 = (IntIntUniqueBiMap)entry.getValue();
        $existingConnectionIds.remove(connectionId);
        boolean bl2 = bl = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ONE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        IntIntUniqueBiMap this_$iv = map2;
        boolean $i$f$forEachKey = false;
        Int2IntMaps.fastForEach((Int2IntMap)((Int2IntMap)IntIntUniqueBiMap.access$getKey2Value(this_$iv).getBackingMap$intellij_platform_workspace_storage()), (Consumer)new Consumer($this_assertConsistency, connectionId){
            final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
            final /* synthetic */ ConnectionId $connectionId$inlined;
            {
                this.$this_assertConsistency$inlined = abstractEntityStorage;
                this.$connectionId$inlined = connectionId;
            }

            public final void accept(Int2IntMap.Entry it) {
                int parentId = it.getIntValue();
                int childId = it.getIntKey();
                boolean bl = false;
                ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
            }
        });
        if (!connectionId.isParentNullable()) {
            ConsistencyCheckerKt.checkStrongConnection($this_assertConsistency, map2.getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
        }
        return Unit.INSTANCE;
    }

    private static final Unit assertConsistency$lambda$4(Set $existingConnectionIds, AbstractEntityStorage $this_assertConsistency, Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ConnectionId connectionId = (ConnectionId)entry.getKey();
        LinkedBidirectionalMap map2 = (LinkedBidirectionalMap)entry.getValue();
        $existingConnectionIds.remove(connectionId);
        boolean bl2 = bl = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        map2.forEach(arg_0 -> ConsistencyCheckerKt.assertConsistency$lambda$4$0($this_assertConsistency, connectionId, arg_0));
        if (!connectionId.isParentNullable()) {
            Collection<Integer> collection;
            long it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = map2.getKeys();
            AbstractEntityStorage abstractEntityStorage = $this_assertConsistency;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                long l = ((ChildEntityId)item$iv$iv).unbox-impl();
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(it);
            }
            $this$map$iv = map2.getKeys();
            collection2 = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = ((ChildEntityId)item$iv$iv).unbox-impl();
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(EntityIdKt.getClazz(it));
            }
            collection = (List)destination$iv$iv;
            ConsistencyCheckerKt.checkStrongAbstractConnection(abstractEntityStorage, (Set<Long>)collection2, CollectionsKt.toSet((Iterable)collection), connectionId.debugStr());
        }
        return Unit.INSTANCE;
    }

    private static final Unit assertConsistency$lambda$4$0(AbstractEntityStorage $this_assertConsistency, ConnectionId $connectionId, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        long childId = ((ChildEntityId)entry.getKey()).unbox-impl();
        long parentId = ((ParentEntityId)entry.getValue()).unbox-impl();
        ConsistencyCheckerKt.assertResolvable($this_assertConsistency, EntityIdKt.getClazz(parentId), EntityIdKt.getArrayId(parentId));
        ConsistencyCheckerKt.assertResolvable($this_assertConsistency, EntityIdKt.getClazz(childId), EntityIdKt.getArrayId(childId));
        ConsistencyCheckerKt.assertCorrectEntityClass($connectionId.getParentClass(), parentId);
        ConsistencyCheckerKt.assertCorrectEntityClass($connectionId.getChildClass(), childId);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit assertConsistency$lambda$5(Set $existingConnectionIds, AbstractEntityStorage $this_assertConsistency, Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ConnectionId connectionId = (ConnectionId)entry.getKey();
        BiMap map2 = (BiMap)entry.getValue();
        $existingConnectionIds.remove(connectionId);
        boolean bl2 = bl = connectionId.getConnectionType() == ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object $this$forEach$iv = (Map)map2;
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator.next();
            boolean bl3 = false;
            Object k = entry3.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            long childId = ((ChildEntityId)k).unbox-impl();
            Object v = entry3.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            long parentId = ((ParentEntityId)v).unbox-impl();
            ConsistencyCheckerKt.assertResolvable($this_assertConsistency, EntityIdKt.getClazz(parentId), EntityIdKt.getArrayId(parentId));
            ConsistencyCheckerKt.assertResolvable($this_assertConsistency, EntityIdKt.getClazz(childId), EntityIdKt.getArrayId(childId));
            ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getParentClass(), parentId);
            ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getChildClass(), childId);
        }
        if (!connectionId.isParentNullable()) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Set set;
            void destination$iv;
            Iterable $this$mapTo$iv;
            $this$forEach$iv = map2.keySet();
            Collection $i$f$forEach22 = new HashSet();
            AbstractEntityStorage abstractEntityStorage = $this_assertConsistency;
            boolean $i$f$mapTo232 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                long bl3 = ((ChildEntityId)item$iv).unbox-impl();
                set = destination$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)ChildEntityId.box-impl((long)it));
                set.add((long)it);
            }
            $this$mapTo$iv = CollectionsKt.toMutableSet((Iterable)map2.keySet());
            set = (Set)destination$iv;
            boolean $i$f$map = false;
            void $i$f$mapTo232 = $this$map$iv;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long bl4 = ((ChildEntityId)item$iv$iv).unbox-impl();
                collection = collection2;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)ChildEntityId.box-impl((long)it));
                collection.add(EntityIdKt.getClazz((long)it));
            }
            collection = (List)collection2;
            ConsistencyCheckerKt.checkStrongAbstractConnection(abstractEntityStorage, set, CollectionsKt.toSet((Iterable)collection), connectionId.debugStr());
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$assertResolvable(AbstractEntityStorage storage, int clazz, int id) {
        ConsistencyCheckerKt.assertResolvable(storage, clazz, id);
    }
}

