/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.google.common.collect.HashBiMap;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.AbstractStorageIndexes;
import com.intellij.platform.workspace.storage.impl.ImmutableStorageIndexes;
import com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.NotThisEntityId;
import com.intellij.platform.workspace.storage.impl.SoftLinkable;
import com.intellij.platform.workspace.storage.impl.ThisEntityId;
import com.intellij.platform.workspace.storage.impl.WorkspaceBuilderChangeLog;
import com.intellij.platform.workspace.storage.impl.WorkspaceBuilderChangeLogKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.external.AbstractExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.external.ImmutableExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.ImmutableMultimapStorageIndex;
import com.intellij.platform.workspace.storage.impl.indices.MutableMultimapStorageIndex;
import com.intellij.platform.workspace.storage.impl.indices.SymbolicIdInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndex;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001a\u0010\u000b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u001b\u001a\u00020\u001c\"\b\b\u0000\u0010\u001d*\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"H\u0000\u00a2\u0006\u0002\b#J\u0012\u0010$\u001a\u00020\u001c2\n\u0010%\u001a\u00060&j\u0002`'J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*J&\u0010,\u001a\u00020\u001c2\n\u0010-\u001a\u00060&j\u0002`'2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010/\u001a\u000200J2\u00101\u001a\u00020\u001c\"\b\b\u0000\u0010\u001d*\u00020\u001e2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u0010\u00103\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u000104H\u0002J*\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u0002072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;092\u0006\u0010<\u001a\u000207J&\u0010=\u001a\u00020\u001c2\n\u0010>\u001a\u00060&j\u0002`'2\n\u0010?\u001a\u00060&j\u0002`'2\u0006\u0010@\u001a\u00020\u0001JP\u0010A\u001a\u00020\u001c\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010/\u001a\u0002072\u0006\u0010B\u001a\u00020\u001e2\f\u0010C\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u0012\b\u0002\u00103\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u000104J(\u0010D\u001a\u00020\u001c2\u0006\u0010/\u001a\u0002072\n\u0010C\u001a\u0006\u0012\u0002\b\u00030\"2\n\u0010E\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J\u0006\u0010F\u001a\u00020GR\u0014\u0010\u0002\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R(\u0010\u000b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006H"}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableStorageIndexes;", "Lcom/intellij/platform/workspace/storage/impl/AbstractStorageIndexes;", "softLinks", "Lcom/intellij/platform/workspace/storage/impl/indices/MutableMultimapStorageIndex;", "virtualFileIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "entitySourceIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "symbolicIdIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex$MutableSymbolicIdInternalIndex;", "externalMappings", "", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl;", "<init>", "(Lcom/intellij/platform/workspace/storage/impl/indices/MutableMultimapStorageIndex;Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex$MutableSymbolicIdInternalIndex;Ljava/util/Map;)V", "getSoftLinks$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/MutableMultimapStorageIndex;", "getVirtualFileIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "getEntitySourceIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "getSymbolicIdIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex$MutableSymbolicIdInternalIndex;", "getExternalMappings$intellij_platform_workspace_storage", "()Ljava/util/Map;", "entityAdded", "", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityData", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "symbolicId", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "entityAdded$intellij_platform_workspace_storage", "entityRemoved", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "updateSoftLinksIndex", "softLinkable", "Lcom/intellij/platform/workspace/storage/impl/SoftLinkable;", "removeFromSoftLinksIndex", "updateIndices", "oldEntityId", "newEntityData", "builder", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "simpleUpdateSoftReferences", "copiedData", "modifiableEntity", "Lcom/intellij/platform/workspace/storage/impl/ModifiableWorkspaceEntityBase;", "applyExternalMappingChanges", "diff", "Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;", "replaceMap", "Lcom/google/common/collect/HashBiMap;", "Lcom/intellij/platform/workspace/storage/impl/NotThisEntityId;", "Lcom/intellij/platform/workspace/storage/impl/ThisEntityId;", "target", "updateExternalMappingForEntityId", "replaceWithEntityId", "targetEntityId", "replaceWithIndexes", "updateSymbolicIdIndexes", "updatedEntity", "beforeSymbolicId", "updateComposedIds", "newSymbolicId", "toImmutable", "Lcom/intellij/platform/workspace/storage/impl/ImmutableStorageIndexes;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nStorageIndexes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/platform/workspace/storage/impl/MutableStorageIndexes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,288:1\n1#2:289\n1869#3,2:290\n1321#4,2:292\n216#5,2:294\n216#5,2:296\n*S KotlinDebug\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/platform/workspace/storage/impl/MutableStorageIndexes\n*L\n180#1:290,2\n215#1:292,2\n219#1:294,2\n232#1:296,2\n*E\n"})
public final class MutableStorageIndexes
extends AbstractStorageIndexes {
    @NotNull
    private final MutableMultimapStorageIndex softLinks;
    @NotNull
    private final VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex;
    @NotNull
    private final EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> entitySourceIndex;
    @NotNull
    private final SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex symbolicIdIndex;
    @NotNull
    private final Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> externalMappings;

    public MutableStorageIndexes(@NotNull MutableMultimapStorageIndex softLinks, @NotNull VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex symbolicIdIndex, @NotNull Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> externalMappings) {
        Intrinsics.checkNotNullParameter((Object)softLinks, (String)"softLinks");
        Intrinsics.checkNotNullParameter((Object)virtualFileIndex, (String)"virtualFileIndex");
        Intrinsics.checkNotNullParameter(entitySourceIndex, (String)"entitySourceIndex");
        Intrinsics.checkNotNullParameter((Object)symbolicIdIndex, (String)"symbolicIdIndex");
        Intrinsics.checkNotNullParameter(externalMappings, (String)"externalMappings");
        super(null);
        this.softLinks = softLinks;
        this.virtualFileIndex = virtualFileIndex;
        this.entitySourceIndex = entitySourceIndex;
        this.symbolicIdIndex = symbolicIdIndex;
        this.externalMappings = externalMappings;
    }

    @Override
    @NotNull
    public MutableMultimapStorageIndex getSoftLinks$intellij_platform_workspace_storage() {
        return this.softLinks;
    }

    @Override
    @NotNull
    public VirtualFileIndex.MutableVirtualFileIndex getVirtualFileIndex$intellij_platform_workspace_storage() {
        return this.virtualFileIndex;
    }

    @NotNull
    public EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> getEntitySourceIndex$intellij_platform_workspace_storage() {
        return this.entitySourceIndex;
    }

    @Override
    @NotNull
    public SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex getSymbolicIdIndex$intellij_platform_workspace_storage() {
        return this.symbolicIdIndex;
    }

    @NotNull
    public Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> getExternalMappings$intellij_platform_workspace_storage() {
        return this.externalMappings;
    }

    public final <T extends WorkspaceEntity> void entityAdded$intellij_platform_workspace_storage(@NotNull WorkspaceEntityData<T> entityData, @Nullable SymbolicEntityId<?> symbolicId) {
        block1: {
            Intrinsics.checkNotNullParameter(entityData, (String)"entityData");
            long pid = entityData.createEntityId();
            EntitySource entitySource = entityData.getEntitySource();
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspace_storage()).index$intellij_platform_workspace_storage(pid, entitySource);
            if (symbolicId != null) {
                this.getSymbolicIdIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(pid, symbolicId);
            }
            VirtualFileUrl virtualFileUrl = entitySource.getVirtualFileUrl();
            if (virtualFileUrl == null) break block1;
            VirtualFileUrl it = virtualFileUrl;
            boolean bl = false;
            this.getVirtualFileIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(pid, "entitySource", it);
        }
    }

    public final void entityRemoved(long entityId) {
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex.index$intellij_platform_workspace_storage$default((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspace_storage(), entityId, null, 2, null);
        SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex.index$intellij_platform_workspace_storage$default(this.getSymbolicIdIndex$intellij_platform_workspace_storage(), entityId, null, 2, null);
        this.getVirtualFileIndex$intellij_platform_workspace_storage().removeRecordsByEntityId$intellij_platform_workspace_storage(entityId);
        Iterable $this$forEach$iv = this.getExternalMappings$intellij_platform_workspace_storage().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableExternalEntityMappingImpl it = (MutableExternalEntityMappingImpl)element$iv;
            boolean bl = false;
            it.remove$intellij_platform_workspace_storage(entityId);
        }
    }

    public final void updateSoftLinksIndex(@NotNull SoftLinkable softLinkable) {
        Intrinsics.checkNotNullParameter((Object)softLinkable, (String)"softLinkable");
        softLinkable.index(this.getSoftLinks$intellij_platform_workspace_storage());
    }

    public final void removeFromSoftLinksIndex(@NotNull SoftLinkable softLinkable) {
        Intrinsics.checkNotNullParameter((Object)softLinkable, (String)"softLinkable");
        long pid = ((WorkspaceEntityData)((Object)softLinkable)).createEntityId();
        for (SymbolicEntityId<?> link : softLinkable.getLinks()) {
            this.getSoftLinks$intellij_platform_workspace_storage().remove$intellij_platform_workspace_storage(pid, link);
        }
    }

    public final void updateIndices(long oldEntityId, @NotNull WorkspaceEntityData<?> newEntityData, @NotNull AbstractEntityStorage builder) {
        block0: {
            SymbolicEntityId<?> symbolicEntityId;
            Intrinsics.checkNotNullParameter(newEntityData, (String)"newEntityData");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            long newEntityId = newEntityData.createEntityId();
            this.getVirtualFileIndex$intellij_platform_workspace_storage().updateIndex$intellij_platform_workspace_storage(oldEntityId, newEntityId, builder.getIndexes$intellij_platform_workspace_storage().getVirtualFileIndex$intellij_platform_workspace_storage());
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspace_storage()).index$intellij_platform_workspace_storage(newEntityId, newEntityData.getEntitySource());
            SymbolicEntityId<?> symbolicEntityId2 = builder.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getEntryById$intellij_platform_workspace_storage(oldEntityId);
            if (symbolicEntityId2 == null) break block0;
            SymbolicEntityId<?> it = symbolicEntityId = symbolicEntityId2;
            boolean bl = false;
            this.getSymbolicIdIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(newEntityId, it);
        }
    }

    private final <T extends WorkspaceEntity> void simpleUpdateSoftReferences(WorkspaceEntityData<T> copiedData, ModifiableWorkspaceEntityBase<?, ?> modifiableEntity) {
        long pid = copiedData.createEntityId();
        if (copiedData instanceof SoftLinkable) {
            ((SoftLinkable)((Object)copiedData)).updateLinksIndex(this.getSoftLinks$intellij_platform_workspace_storage().getEntriesById$intellij_platform_workspace_storage(pid), this.getSoftLinks$intellij_platform_workspace_storage());
        }
    }

    public final void applyExternalMappingChanges(@NotNull MutableEntityStorageImpl diff, @NotNull HashBiMap<NotThisEntityId, ThisEntityId> replaceMap, @NotNull MutableEntityStorageImpl target) {
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Intrinsics.checkNotNullParameter(replaceMap, (String)"replaceMap");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object $this$forEach$iv = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)diff.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage().keySet()), arg_0 -> MutableStorageIndexes.applyExternalMappingChanges$lambda$0(this, arg_0));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            ExternalMappingKey it = (ExternalMappingKey)element$iv;
            boolean bl = false;
            this.getExternalMappings$intellij_platform_workspace_storage().put(it, new MutableExternalEntityMappingImpl());
        }
        $this$forEach$iv = diff.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = iterator.next();
            boolean bl = false;
            ExternalMappingKey identifier = (ExternalMappingKey)object.getKey();
            MutableExternalEntityMappingImpl index = (MutableExternalEntityMappingImpl)object.getValue();
            MutableExternalEntityMappingImpl<?> mapping = this.getExternalMappings$intellij_platform_workspace_storage().get(identifier);
            if (mapping == null) continue;
            mapping.applyChanges(index, replaceMap, target);
            if (!mapping.getIndex$intellij_platform_workspace_storage().isEmpty()) continue;
            this.getExternalMappings$intellij_platform_workspace_storage().remove(identifier);
        }
    }

    public final void updateExternalMappingForEntityId(long replaceWithEntityId, long targetEntityId, @NotNull AbstractStorageIndexes replaceWithIndexes) {
        Intrinsics.checkNotNullParameter((Object)replaceWithIndexes, (String)"replaceWithIndexes");
        Map<ExternalMappingKey<?>, AbstractExternalEntityMappingImpl<?>> $this$forEach$iv = replaceWithIndexes.getExternalMappings$intellij_platform_workspace_storage();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ExternalMappingKey<?>, AbstractExternalEntityMappingImpl<?>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object data;
            Map.Entry<ExternalMappingKey<?>, AbstractExternalEntityMappingImpl<?>> element$iv;
            Map.Entry<ExternalMappingKey<?>, AbstractExternalEntityMappingImpl<?>> entry = element$iv = iterator.next();
            boolean bl = false;
            ExternalMappingKey<?> mappingId = entry.getKey();
            AbstractExternalEntityMappingImpl<?> mapping = entry.getValue();
            if (mapping.getIndex$intellij_platform_workspace_storage().get(replaceWithEntityId) == null) continue;
            MutableExternalEntityMappingImpl<?> externalMapping = this.getExternalMappings$intellij_platform_workspace_storage().get(mappingId);
            if (externalMapping == null) {
                MutableExternalEntityMappingImpl newMapping = new MutableExternalEntityMappingImpl();
                newMapping.add$intellij_platform_workspace_storage(targetEntityId, data);
                this.getExternalMappings$intellij_platform_workspace_storage().put(mappingId, newMapping);
                continue;
            }
            externalMapping.add$intellij_platform_workspace_storage(targetEntityId, data);
        }
    }

    public final <T extends WorkspaceEntity> void updateSymbolicIdIndexes(@NotNull MutableEntityStorageImpl builder, @NotNull WorkspaceEntity updatedEntity, @Nullable SymbolicEntityId<?> beforeSymbolicId, @NotNull WorkspaceEntityData<T> copiedData, @Nullable ModifiableWorkspaceEntityBase<?, ?> modifiableEntity) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)updatedEntity, (String)"updatedEntity");
        Intrinsics.checkNotNullParameter(copiedData, (String)"copiedData");
        long entityId = ((WorkspaceEntityBase)updatedEntity).getId();
        if (updatedEntity instanceof WorkspaceEntityWithSymbolicId) {
            SymbolicEntityId<WorkspaceEntityWithSymbolicId> newSymbolicId = ((WorkspaceEntityWithSymbolicId)updatedEntity).getSymbolicId();
            if (beforeSymbolicId != null && !Intrinsics.areEqual(beforeSymbolicId, newSymbolicId)) {
                this.getSymbolicIdIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(entityId, newSymbolicId);
                this.updateComposedIds(builder, beforeSymbolicId, newSymbolicId);
            }
        }
        this.simpleUpdateSoftReferences(copiedData, modifiableEntity);
    }

    public static /* synthetic */ void updateSymbolicIdIndexes$default(MutableStorageIndexes mutableStorageIndexes, MutableEntityStorageImpl mutableEntityStorageImpl, WorkspaceEntity workspaceEntity, SymbolicEntityId symbolicEntityId, WorkspaceEntityData workspaceEntityData, ModifiableWorkspaceEntityBase modifiableWorkspaceEntityBase, int n, Object object) {
        if ((n & 0x10) != 0) {
            modifiableWorkspaceEntityBase = null;
        }
        mutableStorageIndexes.updateSymbolicIdIndexes(mutableEntityStorageImpl, workspaceEntity, symbolicEntityId, workspaceEntityData, modifiableWorkspaceEntityBase);
    }

    private final void updateComposedIds(MutableEntityStorageImpl builder, SymbolicEntityId<?> beforeSymbolicId, SymbolicEntityId<?> newSymbolicId) {
        HashSet idsWithSoftRef = new HashSet(this.getSoftLinks$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(beforeSymbolicId));
        Iterator iterator = idsWithSoftRef.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            WorkspaceEntityData<?> originalEntityData;
            WorkspaceEntityData<?> entity;
            Long entityId = (Long)iterator2.next();
            Intrinsics.checkNotNull((Object)entityId);
            Intrinsics.checkNotNull(WorkspaceBuilderChangeLogKt.getOriginalEntityData(builder, entityId), (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<com.intellij.platform.workspace.storage.WorkspaceEntity>");
            Intrinsics.checkNotNull(builder.getEntitiesByType$intellij_platform_workspace_storage().getEntityDataForModification(entityId), (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<com.intellij.platform.workspace.storage.WorkspaceEntity>");
            Object obj = entity.createEntity(builder);
            WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = obj instanceof WorkspaceEntityWithSymbolicId ? (WorkspaceEntityWithSymbolicId)obj : null;
            SymbolicEntityId<WorkspaceEntityWithSymbolicId> editingBeforeSymbolicId = workspaceEntityWithSymbolicId != null ? workspaceEntityWithSymbolicId.getSymbolicId() : null;
            ((SoftLinkable)((Object)entity)).updateLink(beforeSymbolicId, newSymbolicId);
            WorkspaceBuilderChangeLog.addReplaceDataEvent$intellij_platform_workspace_storage$default(builder.getChangeLog$intellij_platform_workspace_storage(), entityId, entity, originalEntityData, false, 8, null);
            MutableStorageIndexes.updateSymbolicIdIndexes$default(builder.getIndexes$intellij_platform_workspace_storage(), builder, entity.createEntity(builder), editingBeforeSymbolicId, entity, null, 16, null);
        }
    }

    @NotNull
    public final ImmutableStorageIndexes toImmutable() {
        ImmutableMultimapStorageIndex copiedLinks = this.getSoftLinks$intellij_platform_workspace_storage().toImmutable();
        VirtualFileIndex newVirtualFileIndex = this.getVirtualFileIndex$intellij_platform_workspace_storage().toImmutable();
        EntityStorageInternalIndex<EntitySource> newEntitySourceIndex = ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspace_storage()).toImmutable();
        SymbolicIdInternalIndex newSymbolicIdIndex = this.getSymbolicIdIndex$intellij_platform_workspace_storage().toImmutable();
        Map<ExternalMappingKey<?>, ImmutableExternalEntityMappingImpl<?>> newExternalMappings = MutableExternalEntityMappingImpl.Companion.toImmutable(this.getExternalMappings$intellij_platform_workspace_storage());
        return new ImmutableStorageIndexes(copiedLinks, newVirtualFileIndex, newEntitySourceIndex, newSymbolicIdIndex, newExternalMappings);
    }

    private static final boolean applyExternalMappingChanges$lambda$0(MutableStorageIndexes this$0, ExternalMappingKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getExternalMappings$intellij_platform_workspace_storage().keySet().contains(it);
    }
}

