/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.CachedValueWithParameter;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00062\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ;\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u000b0\t2\u0006\u0010\u0011\u001a\u0002H\u00102\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0006J3\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u000b0\t2\u0006\u0010\u0011\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0015R \u0010\u0004\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\"\u0012\u0016\u0012\u0014\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u0012\u0002\b\u00030\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ValuesCache;", "", "<init>", "()V", "cachedValues", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/platform/workspace/storage/CachedValue;", "cachedValuesWithParameter", "Lkotlin/Pair;", "Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;", "cachedValue", "R", "value", "storage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "(Lcom/intellij/platform/workspace/storage/CachedValue;Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;)Ljava/lang/Object;", "P", "parameter", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nVersionedEntityStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionedEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/ValuesCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n1#2:293\n*E\n"})
final class ValuesCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<CachedValue<?>, Object> cachedValues;
    @NotNull
    private final Cache<Pair<CachedValueWithParameter<?, ?>, ?>, Object> cachedValuesWithParameter;
    @NotNull
    private static final AtomicLong cachedValueFromCacheCounter = new AtomicLong();
    @NotNull
    private static final AtomicLong cachedValueCalculatedCounter = new AtomicLong();
    @NotNull
    private static final AtomicLong cachedValueWithParametersFromCacheCounter = new AtomicLong();
    @NotNull
    private static final AtomicLong cachedValueWithParametersCalculatedCounter = new AtomicLong();
    @NotNull
    private static final AtomicLong cachedValueClearCounter = new AtomicLong();
    @NotNull
    private static final AtomicLong cachedValueWithParametersClearCounter = new AtomicLong();

    public ValuesCache() {
        Cache cache = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cachedValues = cache;
        Cache cache2 = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.cachedValuesWithParameter = cache2;
    }

    public final <R> R cachedValue(@NotNull CachedValue<R> value, @NotNull ImmutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Object o = this.cachedValues.getIfPresent(value);
        Object valueToReturn = null;
        if (o != null) {
            valueToReturn = o;
            cachedValueFromCacheCounter.incrementAndGet();
        } else {
            cachedValueCalculatedCounter.incrementAndGet();
            Object object = value.getSource().invoke((Object)storage);
            Intrinsics.checkNotNull((Object)object);
            valueToReturn = object;
            this.cachedValues.put(value, valueToReturn);
        }
        Object object = valueToReturn;
        if (object == null) {
            boolean bl = false;
            String string = "Cached value must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        return (R)object;
    }

    public final <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter, @NotNull ImmutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Object o = this.cachedValuesWithParameter.getIfPresent((Object)TuplesKt.to(value, parameter));
        Object valueToReturn = null;
        if (o != null) {
            valueToReturn = o;
            cachedValueWithParametersFromCacheCounter.incrementAndGet();
        } else {
            cachedValueWithParametersCalculatedCounter.incrementAndGet();
            Object object = value.getSource().invoke((Object)storage, parameter);
            Intrinsics.checkNotNull((Object)object);
            valueToReturn = object;
            this.cachedValuesWithParameter.put((Object)TuplesKt.to(value, parameter), valueToReturn);
        }
        Object object = valueToReturn;
        if (object == null) {
            boolean bl = false;
            String string = "Cached value with parameter must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        return (R)object;
    }

    public final <R> void clearCachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        cachedValueClearCounter.incrementAndGet();
        this.cachedValues.invalidate(value);
    }

    public final <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        cachedValueWithParametersClearCounter.incrementAndGet();
        this.cachedValuesWithParameter.invalidate((Object)TuplesKt.to(value, parameter));
    }

    static {
        ValuesCache.Companion.setupOpenTelemetryReporting(TelemetryManager.Companion.getMeter(PlatformScopesKt.WorkspaceModel));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ValuesCache$Companion;", "", "<init>", "()V", "cachedValueFromCacheCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "cachedValueCalculatedCounter", "cachedValueWithParametersFromCacheCounter", "cachedValueWithParametersCalculatedCounter", "cachedValueClearCounter", "cachedValueWithParametersClearCounter", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement cachedValueFromCacheMeterCounter = meter.counterBuilder("workspaceModel.cachedValue.from.cache.count").buildObserver();
            ObservableLongMeasurement cachedValueCalculatedMeterCounter = meter.counterBuilder("workspaceModel.cachedValue.calculated.count").buildObserver();
            ObservableLongMeasurement cachedValueTotalMeterCounter = meter.counterBuilder("workspaceModel.cachedValue.total.get.count").buildObserver();
            ObservableLongMeasurement cachedValueWithParametersFromCacheMeterCounter = meter.counterBuilder("workspaceModel.cachedValueWithParameters.from.cache.count").buildObserver();
            ObservableLongMeasurement cachedValueWithParametersCalculatedMeterCounter = meter.counterBuilder("workspaceModel.cachedValueWithParameters.calculated.count").buildObserver();
            ObservableLongMeasurement cachedValueWithParametersTotalMeterCounter = meter.counterBuilder("workspaceModel.cachedValueWithParameters.total.get.count").buildObserver();
            ObservableLongMeasurement cachedValueClearMeterCounter = meter.counterBuilder("workspaceModel.cachedValue.clear.count").buildObserver();
            ObservableLongMeasurement cachedValueWithParametersClearMeterCounter = meter.counterBuilder("workspaceModel.cachedValueWithParameters.clear.count").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{cachedValueCalculatedMeterCounter, cachedValueTotalMeterCounter, cachedValueWithParametersFromCacheMeterCounter, cachedValueWithParametersCalculatedMeterCounter, cachedValueWithParametersTotalMeterCounter, cachedValueClearMeterCounter, cachedValueWithParametersClearMeterCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(cachedValueFromCacheMeterCounter, cachedValueCalculatedMeterCounter, cachedValueTotalMeterCounter, cachedValueWithParametersFromCacheMeterCounter, cachedValueWithParametersCalculatedMeterCounter, cachedValueWithParametersTotalMeterCounter, cachedValueClearMeterCounter, cachedValueWithParametersClearMeterCounter), (ObservableMeasurement)cachedValueFromCacheMeterCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $cachedValueFromCacheMeterCounter, ObservableLongMeasurement $cachedValueCalculatedMeterCounter, ObservableLongMeasurement $cachedValueTotalMeterCounter, ObservableLongMeasurement $cachedValueWithParametersFromCacheMeterCounter, ObservableLongMeasurement $cachedValueWithParametersCalculatedMeterCounter, ObservableLongMeasurement $cachedValueWithParametersTotalMeterCounter, ObservableLongMeasurement $cachedValueClearMeterCounter, ObservableLongMeasurement $cachedValueWithParametersClearMeterCounter) {
            $cachedValueFromCacheMeterCounter.record(cachedValueFromCacheCounter.get());
            $cachedValueCalculatedMeterCounter.record(cachedValueCalculatedCounter.get());
            $cachedValueTotalMeterCounter.record(cachedValueFromCacheCounter.get() + cachedValueCalculatedCounter.get());
            $cachedValueWithParametersFromCacheMeterCounter.record(cachedValueWithParametersFromCacheCounter.get());
            $cachedValueWithParametersCalculatedMeterCounter.record(cachedValueWithParametersCalculatedCounter.get());
            $cachedValueWithParametersTotalMeterCounter.record(cachedValueWithParametersFromCacheCounter.get() + cachedValueWithParametersCalculatedCounter.get());
            $cachedValueClearMeterCounter.record(cachedValueClearCounter.get());
            $cachedValueWithParametersClearMeterCounter.record(cachedValueWithParametersClearCounter.get());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

