/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.CachedValueWithParameter;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.ReferenceChange;
import com.intellij.platform.workspace.storage.VersionedEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.StorageSnapshotCache;
import com.intellij.platform.workspace.storage.impl.ValuesCache;
import com.intellij.platform.workspace.storage.impl.VersionedStorageChangeImpl;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0016\u00a2\u0006\u0002\u0010 J5\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010!\"\u0004\b\u0001\u0010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H\u001d0\"2\u0006\u0010#\u001a\u0002H!H\u0016\u00a2\u0006\u0002\u0010$J\u001c\u0010%\u001a\u00020&\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0016J5\u0010%\u001a\u00020&\"\u0004\b\u0000\u0010!\"\u0004\b\u0001\u0010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H\u001d0\"2\u0006\u0010#\u001a\u0002H!H\u0016\u00a2\u0006\u0002\u0010'Jj\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00032 \u0010+\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0.0,2\u0010\u00100\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u000302012\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020&042\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020&04R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010(\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/platform/workspace/storage/impl/VersionedEntityStorageImpl;", "Lcom/intellij/platform/workspace/storage/VersionedEntityStorage;", "initialStorage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "<init>", "(Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;)V", "currentSnapshot", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/platform/workspace/storage/impl/StorageSnapshotCache;", "valuesCache", "Lcom/intellij/platform/workspace/storage/impl/ValuesCache;", "getValuesCache", "()Lcom/intellij/platform/workspace/storage/impl/ValuesCache;", "current", "getCurrent", "()Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "base", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "getBase", "()Lcom/intellij/platform/workspace/storage/EntityStorage;", "version", "", "getVersion", "()J", "pointer", "Lcom/intellij/platform/workspace/storage/impl/VersionedEntityStorageImpl$Current;", "getPointer", "()Lcom/intellij/platform/workspace/storage/impl/VersionedEntityStorageImpl$Current;", "cachedValue", "R", "value", "Lcom/intellij/platform/workspace/storage/CachedValue;", "(Lcom/intellij/platform/workspace/storage/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;", "parameter", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "currentPointer", "replace", "newStorage", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/platform/workspace/storage/EntityChange;", "symbolicEntityIdsChanges", "", "Lcom/intellij/platform/workspace/storage/ReferenceChange;", "beforeChanged", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "afterChanged", "Current", "intellij.platform.workspace.storage"})
public class VersionedEntityStorageImpl
implements VersionedEntityStorage {
    @NotNull
    private final AtomicReference<StorageSnapshotCache> currentSnapshot;
    @NotNull
    private volatile Current currentPointer;

    public VersionedEntityStorageImpl(@NotNull ImmutableEntityStorage initialStorage) {
        Intrinsics.checkNotNullParameter((Object)initialStorage, (String)"initialStorage");
        this.currentSnapshot = new AtomicReference();
        this.currentPointer = new Current(0L, initialStorage);
    }

    private final ValuesCache getValuesCache() {
        Current pointer = this.currentPointer;
        StorageSnapshotCache snapshotCache = this.currentSnapshot.get();
        if (snapshotCache == null || pointer.getVersion() != snapshotCache.getStorageVersion()) {
            ValuesCache cache = new ValuesCache();
            this.currentSnapshot.set(new StorageSnapshotCache(pointer.getVersion(), cache, pointer.getStorage()));
            return cache;
        }
        return snapshotCache.getCache();
    }

    @Override
    @NotNull
    public ImmutableEntityStorage getCurrent() {
        return this.currentPointer.getStorage();
    }

    @Override
    @NotNull
    public EntityStorage getBase() {
        return this.getCurrent();
    }

    @Override
    public long getVersion() {
        return this.currentPointer.getVersion();
    }

    @NotNull
    public final Current getPointer() {
        return this.currentPointer;
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getValuesCache().cachedValue(value, this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getValuesCache().cachedValue(value, parameter, this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getValuesCache().clearCachedValue(value);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getValuesCache().clearCachedValue(value, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void replace(@NotNull ImmutableEntityStorage newStorage, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes, @NotNull Set<? extends ReferenceChange<?>> symbolicEntityIdsChanges, @NotNull Function1<? super VersionedStorageChange, Unit> beforeChanged, @NotNull Function1<? super VersionedStorageChange, Unit> afterChanged) {
        Intrinsics.checkNotNullParameter((Object)newStorage, (String)"newStorage");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(symbolicEntityIdsChanges, (String)"symbolicEntityIdsChanges");
        Intrinsics.checkNotNullParameter(beforeChanged, (String)"beforeChanged");
        Intrinsics.checkNotNullParameter(afterChanged, (String)"afterChanged");
        Current oldCopy = this.currentPointer;
        if (Intrinsics.areEqual((Object)oldCopy.getStorage(), (Object)newStorage)) {
            return;
        }
        VersionedStorageChangeImpl change = new VersionedStorageChangeImpl(oldCopy.getStorage(), newStorage, changes, symbolicEntityIdsChanges);
        try {
            AbstractEntityStorage abstractEntityStorage = newStorage instanceof AbstractEntityStorage ? (AbstractEntityStorage)((Object)newStorage) : null;
            if (abstractEntityStorage != null) {
                abstractEntityStorage.setEventHandling$intellij_platform_workspace_storage(true);
            }
            beforeChanged.invoke((Object)change);
            this.currentPointer = new Current(oldCopy.getVersion() + 1L, newStorage);
            afterChanged.invoke((Object)change);
        }
        catch (Throwable throwable) {
            AbstractEntityStorage abstractEntityStorage = newStorage instanceof AbstractEntityStorage ? (AbstractEntityStorage)((Object)newStorage) : null;
            if (abstractEntityStorage != null) {
                abstractEntityStorage.setEventHandling$intellij_platform_workspace_storage(false);
            }
            throw throwable;
        }
        AbstractEntityStorage abstractEntityStorage = newStorage instanceof AbstractEntityStorage ? (AbstractEntityStorage)((Object)newStorage) : null;
        if (abstractEntityStorage != null) {
            abstractEntityStorage.setEventHandling$intellij_platform_workspace_storage(false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/workspace/storage/impl/VersionedEntityStorageImpl$Current;", "", "version", "", "storage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "<init>", "(JLcom/intellij/platform/workspace/storage/ImmutableEntityStorage;)V", "getVersion", "()J", "getStorage", "()Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "intellij.platform.workspace.storage"})
    public static final class Current {
        private final long version;
        @NotNull
        private final ImmutableEntityStorage storage;

        public Current(long version, @NotNull ImmutableEntityStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            this.version = version;
            this.storage = storage;
        }

        public final long getVersion() {
            return this.version;
        }

        @NotNull
        public final ImmutableEntityStorage getStorage() {
            return this.storage;
        }
    }
}

