/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.ReferenceChange;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.VersionedStorageChangeInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012 \u0010\u0005\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0006\u0012\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ,\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\t0\b\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0007H\u0016J4\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\f0\u0017\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00180\u001b0\u0007H\u0016J\u0012\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u001dH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R(\u0010\u0005\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/workspace/storage/impl/VersionedStorageChangeImpl;", "Lcom/intellij/platform/workspace/storage/impl/VersionedStorageChangeInternal;", "storageBefore", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "storageAfter", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/platform/workspace/storage/EntityChange;", "referenceChanges", "", "Lcom/intellij/platform/workspace/storage/ReferenceChange;", "<init>", "(Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Ljava/util/Map;Ljava/util/Set;)V", "getStorageBefore", "()Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "getStorageAfter", "getChanges", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "getChangedReferences", "", "E", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "referenceSymbolicEntityIdClass", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "getAllChanges", "Lkotlin/sequences/Sequence;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nVersionedEntityStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionedEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/VersionedStorageChangeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n774#2:293\n865#2,2:294\n*S KotlinDebug\n*F\n+ 1 VersionedEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/VersionedStorageChangeImpl\n*L\n286#1:293\n286#1:294,2\n*E\n"})
final class VersionedStorageChangeImpl
implements VersionedStorageChangeInternal {
    @NotNull
    private final ImmutableEntityStorage storageBefore;
    @NotNull
    private final ImmutableEntityStorage storageAfter;
    @NotNull
    private final Map<Class<?>, List<EntityChange<?>>> changes;
    @NotNull
    private final Set<ReferenceChange<?>> referenceChanges;

    public VersionedStorageChangeImpl(@NotNull ImmutableEntityStorage storageBefore, @NotNull ImmutableEntityStorage storageAfter, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes, @NotNull Set<? extends ReferenceChange<?>> referenceChanges) {
        Intrinsics.checkNotNullParameter((Object)storageBefore, (String)"storageBefore");
        Intrinsics.checkNotNullParameter((Object)storageAfter, (String)"storageAfter");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(referenceChanges, (String)"referenceChanges");
        this.storageBefore = storageBefore;
        this.storageAfter = storageAfter;
        this.changes = changes;
        this.referenceChanges = referenceChanges;
    }

    @Override
    @NotNull
    public ImmutableEntityStorage getStorageBefore() {
        return this.storageBefore;
    }

    @Override
    @NotNull
    public ImmutableEntityStorage getStorageAfter() {
        return this.storageAfter;
    }

    @Override
    @NotNull
    public <T extends WorkspaceEntity> List<EntityChange<T>> getChanges(@NotNull Class<T> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        List list = this.changes.get(entityClass);
        List list2 = list instanceof List ? list : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <E extends WorkspaceEntityWithSymbolicId> Collection<ReferenceChange<E>> getChangedReferences(@NotNull Class<? extends SymbolicEntityId<? extends E>> referenceSymbolicEntityIdClass) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(referenceSymbolicEntityIdClass, (String)"referenceSymbolicEntityIdClass");
        Iterable $this$filter$iv = this.referenceChanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReferenceChange it = (ReferenceChange)element$iv$iv;
            boolean bl = false;
            if (!referenceSymbolicEntityIdClass.isInstance(it.getSymbolicEntityId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Sequence<EntityChange<?>> getAllChanges() {
        return SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.changes.values()));
    }
}

