/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.query;

import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.cache.PropagationResult;
import com.intellij.platform.workspace.storage.impl.cache.UpdateType;
import com.intellij.platform.workspace.storage.impl.query.Cell;
import com.intellij.platform.workspace.storage.impl.query.CellId;
import com.intellij.platform.workspace.storage.impl.query.Match;
import com.intellij.platform.workspace.storage.impl.query.MatchList;
import com.intellij.platform.workspace.storage.impl.query.MatchWithEntityId;
import com.intellij.platform.workspace.storage.trace.ReadTrace;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/workspace/storage/impl/query/EntityCell;", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "Lcom/intellij/platform/workspace/storage/impl/query/Cell;", "", "id", "Lcom/intellij/platform/workspace/storage/impl/query/CellId;", "type", "Lkotlin/reflect/KClass;", "<init>", "(Lcom/intellij/platform/workspace/storage/impl/query/CellId;Lkotlin/reflect/KClass;)V", "getType", "()Lkotlin/reflect/KClass;", "snapshotInput", "Lcom/intellij/platform/workspace/storage/impl/cache/PropagationResult;", "snapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "input", "prevData", "Lcom/intellij/platform/workspace/storage/impl/query/MatchList;", "newSnapshot", "data", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nCell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cell.kt\ncom/intellij/platform/workspace/storage/impl/query/EntityCell\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,283:1\n1#2:284\n1869#3,2:285\n1321#4,2:287\n1321#4,2:289\n*S KotlinDebug\n*F\n+ 1 Cell.kt\ncom/intellij/platform/workspace/storage/impl/query/EntityCell\n*L\n96#1:285,2\n106#1:287,2\n110#1:289,2\n*E\n"})
public final class EntityCell<T extends WorkspaceEntity>
extends Cell<List<? extends T>> {
    @NotNull
    private final KClass<T> type;

    public EntityCell(@NotNull CellId id, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        super(id, null);
        this.type = type;
    }

    @NotNull
    public final KClass<T> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public PropagationResult<List<T>> snapshotInput(@NotNull ImmutableEntityStorage snapshot) {
        Object object;
        Sequence sequence;
        List<WorkspaceEntityData<? extends WorkspaceEntity>> list;
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        EntityCell<T> newCell = new EntityCell<T>(this.getId(), this.type);
        ImmutableEntityStorageImpl snapshotImpl = (ImmutableEntityStorageImpl)snapshot;
        int toClassId = ClassToIntConverterKt.toClassId(JvmClassMappingKt.getJavaClass(this.type));
        EntityFamily<? extends WorkspaceEntity> entityFamily = snapshotImpl.getEntitiesByType$intellij_platform_workspace_storage().get(toClassId);
        Sequence ids = entityFamily != null && (list = entityFamily.getEntities$intellij_platform_workspace_storage()) != null && (sequence = CollectionsKt.asSequence((Iterable)list)) != null && (object = SequencesKt.mapIndexedNotNull((Sequence)sequence, (arg_0, arg_1) -> EntityCell.snapshotInput$lambda$0(toClassId, arg_0, arg_1))) != null ? object : SequencesKt.emptySequence();
        List matches = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)ids, EntityCell::snapshotInput$lambda$1));
        LongOpenHashSet traces = new LongOpenHashSet();
        traces.add(new ReadTrace.EntitiesOfType(JvmClassMappingKt.getJavaClass(this.type)).getHash());
        Object set = object = new MatchList();
        boolean bl = false;
        Iterable $this$forEach$iv = matches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchWithEntityId it = (MatchWithEntityId)element$iv;
            boolean bl2 = false;
            ((MatchList)set).addedMatch(it);
        }
        Object matchList = object;
        return new PropagationResult<List<T>>(newCell, (MatchList)matchList, CollectionsKt.listOf((Object)TuplesKt.to((Object)traces, (Object)UpdateType.DIFF.INSTANCE)));
    }

    @Override
    @NotNull
    public PropagationResult<List<T>> input(@NotNull MatchList prevData, @NotNull ImmutableEntityStorage newSnapshot) {
        Match it;
        Sequence $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)prevData, (String)"prevData");
        Intrinsics.checkNotNullParameter((Object)newSnapshot, (String)"newSnapshot");
        MatchList matchList = new MatchList();
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)prevData.addedMatches()), arg_0 -> EntityCell.input$lambda$0(this, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Match)element$iv;
            boolean bl = false;
            matchList.addedMatch(it);
        }
        $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)prevData.removedMatches()), arg_0 -> EntityCell.input$lambda$2(this, arg_0));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Match)element$iv;
            boolean bl = false;
            matchList.removedMatch(it);
        }
        LongOpenHashSet traces = new LongOpenHashSet();
        traces.add(new ReadTrace.EntitiesOfType(JvmClassMappingKt.getJavaClass(this.type)).getHash());
        return new PropagationResult<List<T>>(new EntityCell<T>(this.getId(), this.type), matchList, CollectionsKt.listOf((Object)TuplesKt.to((Object)traces, (Object)UpdateType.DIFF.INSTANCE)));
    }

    @Override
    @NotNull
    public List<T> data() {
        throw new IllegalStateException("This should not be accessed".toString());
    }

    private static final Long snapshotInput$lambda$0(int $toClassId, int index, WorkspaceEntityData workspaceEntityData) {
        return workspaceEntityData == null ? null : Long.valueOf(EntityIdKt.createEntityId(index, $toClassId));
    }

    private static final MatchWithEntityId snapshotInput$lambda$1(long value) {
        return new MatchWithEntityId(value, null, 2, null);
    }

    private static final boolean input$lambda$0(EntityCell this$0, Match it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)JvmClassMappingKt.getKotlinClass(ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(((MatchWithEntityId)it).getEntityId()))), this$0.type);
    }

    private static final boolean input$lambda$2(EntityCell this$0, Match it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)JvmClassMappingKt.getKotlinClass(ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(((MatchWithEntityId)it).getEntityId()))), this$0.type);
    }
}

