/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.metadata.diff;

import com.intellij.platform.workspace.storage.metadata.diff.ComparisonResult;
import com.intellij.platform.workspace.storage.metadata.diff.MetadataComparatorLog;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/workspace/storage/metadata/diff/EntitiesComparatorLog;", "Lcom/intellij/platform/workspace/storage/metadata/diff/MetadataComparatorLog;", "<init>", "()V", "log", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "", "indentLevel", "", "startComparing", "", "toCompare", "comparisonResult", "output", "Lcom/intellij/platform/workspace/storage/metadata/diff/ComparisonResult;", "endComparing", "isCompared", "ignoreComparing", "isIgnored", "line", "string", "printLog", "getIndent", "Companion", "intellij.platform.workspace.storage"})
public final class EntitiesComparatorLog
implements MetadataComparatorLog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder log = new StringBuilder();
    @NotNull
    private final String indent;
    private int indentLevel;
    @NotNull
    private static EntitiesComparatorLog INSTANCE = new EntitiesComparatorLog();

    private EntitiesComparatorLog() {
        this.indent = "  ";
    }

    @Override
    public void startComparing(@NotNull String toCompare) {
        Intrinsics.checkNotNullParameter((Object)toCompare, (String)"toCompare");
        this.line("Start comparing " + toCompare);
        int n = this.indentLevel;
        this.indentLevel = n + 1;
    }

    @Override
    public void comparisonResult(@NotNull String output, @NotNull ComparisonResult comparisonResult) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)comparisonResult, (String)"comparisonResult");
        this.line(output + " " + this.indent + " Result: " + comparisonResult);
    }

    @Override
    public void endComparing(@NotNull String isCompared, @NotNull ComparisonResult comparisonResult) {
        Intrinsics.checkNotNullParameter((Object)isCompared, (String)"isCompared");
        Intrinsics.checkNotNullParameter((Object)comparisonResult, (String)"comparisonResult");
        int n = this.indentLevel;
        this.indentLevel = n + -1;
        this.line("End comparing " + isCompared + " " + this.indent + " Result: " + comparisonResult);
    }

    @Override
    public void ignoreComparing(@NotNull String isIgnored) {
        Intrinsics.checkNotNullParameter((Object)isIgnored, (String)"isIgnored");
        this.line(isIgnored + " was not compared");
    }

    private final void line(String string) {
        this.log.append(this.getIndent() + string).append('\n');
    }

    @Override
    @NotNull
    public String printLog() {
        String string = this.log.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getIndent() {
        return StringsKt.repeat((CharSequence)this.indent, (int)this.indentLevel);
    }

    public /* synthetic */ EntitiesComparatorLog(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\u0005R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/workspace/storage/metadata/diff/EntitiesComparatorLog$Companion;", "", "<init>", "()V", "value", "Lcom/intellij/platform/workspace/storage/metadata/diff/EntitiesComparatorLog;", "INSTANCE", "getINSTANCE", "()Lcom/intellij/platform/workspace/storage/metadata/diff/EntitiesComparatorLog;", "newInstance", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntitiesComparatorLog getINSTANCE() {
            return INSTANCE;
        }

        @NotNull
        public final EntitiesComparatorLog newInstance() {
            INSTANCE = new EntitiesComparatorLog(null);
            return this.getINSTANCE();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

