/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.metadata.diff;

import com.intellij.platform.workspace.storage.metadata.diff.ComparisonResult;
import com.intellij.platform.workspace.storage.metadata.diff.ComparisonUtil;
import com.intellij.platform.workspace.storage.metadata.diff.ComparisonsBuilder;
import com.intellij.platform.workspace.storage.metadata.diff.Equal;
import com.intellij.platform.workspace.storage.metadata.diff.MetadataComparator;
import com.intellij.platform.workspace.storage.metadata.diff.MetadataComparatorKt;
import com.intellij.platform.workspace.storage.metadata.diff.PropertiesComparator;
import com.intellij.platform.workspace.storage.metadata.model.EntityMetadata;
import com.intellij.platform.workspace.storage.metadata.model.ExtendableClassMetadata;
import com.intellij.platform.workspace.storage.metadata.model.FinalClassMetadata;
import com.intellij.platform.workspace.storage.metadata.model.PropertyMetadata;
import com.intellij.platform.workspace.storage.metadata.model.StorageTypeMetadata;
import com.intellij.platform.workspace.storage.metadata.utils.TypesCollectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\b\u0002\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0010\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002J$\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/workspace/storage/metadata/diff/TypesMetadataComparator;", "Lcom/intellij/platform/workspace/storage/metadata/diff/MetadataComparator;", "Lcom/intellij/platform/workspace/storage/metadata/model/StorageTypeMetadata;", "cacheTypesByFqn", "", "", "currentTypesByFqn", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "cache", "current", "(Lcom/intellij/platform/workspace/storage/metadata/model/StorageTypeMetadata;Lcom/intellij/platform/workspace/storage/metadata/model/StorageTypeMetadata;)V", "propertiesComparator", "Lcom/intellij/platform/workspace/storage/metadata/model/PropertyMetadata;", "comparedTypes", "", "Lkotlin/Pair;", "areEquals", "Lcom/intellij/platform/workspace/storage/metadata/diff/ComparisonResult;", "typesAreEquals", "findType", "type", "typesByFqn", "notComputableProperties", "", "properties", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nMetadataComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataComparator.kt\ncom/intellij/platform/workspace/storage/metadata/diff/TypesMetadataComparator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n827#2:171\n855#2,2:172\n*S KotlinDebug\n*F\n+ 1 MetadataComparator.kt\ncom/intellij/platform/workspace/storage/metadata/diff/TypesMetadataComparator\n*L\n77#1:171\n77#1:172,2\n*E\n"})
public final class TypesMetadataComparator
implements MetadataComparator<StorageTypeMetadata> {
    @NotNull
    private final Map<String, StorageTypeMetadata> cacheTypesByFqn;
    @NotNull
    private final Map<String, StorageTypeMetadata> currentTypesByFqn;
    @NotNull
    private final MetadataComparator<PropertyMetadata> propertiesComparator;
    @NotNull
    private final Set<Pair<String, String>> comparedTypes;

    private TypesMetadataComparator(Map<String, ? extends StorageTypeMetadata> cacheTypesByFqn, Map<String, ? extends StorageTypeMetadata> currentTypesByFqn) {
        this.cacheTypesByFqn = cacheTypesByFqn;
        this.currentTypesByFqn = currentTypesByFqn;
        this.propertiesComparator = new PropertiesComparator(this);
        this.comparedTypes = new LinkedHashSet();
    }

    public TypesMetadataComparator(@NotNull StorageTypeMetadata cache, @NotNull StorageTypeMetadata current) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        this(TypesCollectorKt.collectTypesByFqn$default(cache, null, 1, null), TypesCollectorKt.collectTypesByFqn$default(current, null, 1, null));
    }

    @Override
    @NotNull
    public ComparisonResult areEquals(@NotNull StorageTypeMetadata cache, @NotNull StorageTypeMetadata current) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        if (this.comparedTypes.contains(TuplesKt.to((Object)cache.getFqName(), (Object)current.getFqName()))) {
            return Equal.INSTANCE;
        }
        StorageTypeMetadata cacheType = this.findType(cache, this.cacheTypesByFqn);
        StorageTypeMetadata currentType = this.findType(current, this.currentTypesByFqn);
        return this.typesAreEquals(cacheType, currentType);
    }

    private final ComparisonResult typesAreEquals(StorageTypeMetadata cache, StorageTypeMetadata current) {
        this.comparedTypes.add((Pair<String, String>)TuplesKt.to((Object)cache.getFqName(), (Object)current.getFqName()));
        return ComparisonUtil.INSTANCE.compareMetadata$intellij_platform_workspace_storage(cache, cache.getFqName(), current, current.getFqName(), (Function1<? super ComparisonsBuilder, Unit>)((Function1)arg_0 -> TypesMetadataComparator.typesAreEquals$lambda$0(cache, current, this, arg_0)));
    }

    private final StorageTypeMetadata findType(StorageTypeMetadata type, Map<String, ? extends StorageTypeMetadata> typesByFqn) {
        StorageTypeMetadata storageTypeMetadata = typesByFqn.get(type.getFqName());
        if (storageTypeMetadata == null) {
            storageTypeMetadata = type;
        }
        return storageTypeMetadata;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PropertyMetadata> notComputableProperties(List<? extends PropertyMetadata> properties) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = properties;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PropertyMetadata it = (PropertyMetadata)element$iv$iv;
            boolean bl = false;
            if (it.isComputable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit typesAreEquals$lambda$0(StorageTypeMetadata $cache, StorageTypeMetadata $current, TypesMetadataComparator this$0, ComparisonsBuilder $this$compareMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$compareMetadata, (String)"$this$compareMetadata");
        $this$compareMetadata.compare("name", $cache.getFqName(), $current.getFqName(), MetadataComparatorKt.getFqnsComparator());
        ComparisonsBuilder.compareAll$default($this$compareMetadata, "supertypes", $cache.getSupertypes(), $current.getSupertypes(), null, 8, null);
        if ($current instanceof EntityMetadata) {
            Intrinsics.checkNotNull((Object)$cache, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.metadata.model.EntityMetadata");
            EntityMetadata cfr_ignored_0 = (EntityMetadata)$cache;
            $this$compareMetadata.compare("entity data", ((EntityMetadata)$cache).getEntityDataFqName(), ((EntityMetadata)$current).getEntityDataFqName(), MetadataComparatorKt.getFqnsComparator());
            ComparisonsBuilder.compare$default($this$compareMetadata, "isAbstract", ((EntityMetadata)$cache).isAbstract(), ((EntityMetadata)$current).isAbstract(), null, 8, null);
            $this$compareMetadata.compareAll("extension properties", (Iterable)this$0.notComputableProperties(((EntityMetadata)$cache).getExtProperties()), (Iterable)this$0.notComputableProperties(((EntityMetadata)$current).getExtProperties()), this$0.propertiesComparator);
        }
        if ($current instanceof FinalClassMetadata.EnumClassMetadata) {
            Intrinsics.checkNotNull((Object)$cache, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.metadata.model.FinalClassMetadata.EnumClassMetadata");
            FinalClassMetadata.EnumClassMetadata cfr_ignored_1 = (FinalClassMetadata.EnumClassMetadata)$cache;
            ComparisonsBuilder.compareAll$default($this$compareMetadata, "enum entries", ((FinalClassMetadata.EnumClassMetadata)$cache).getValues(), CollectionsKt.take((Iterable)((FinalClassMetadata.EnumClassMetadata)$current).getValues(), (int)((FinalClassMetadata.EnumClassMetadata)$cache).getValues().size()), null, 8, null);
        }
        if ($current instanceof ExtendableClassMetadata) {
            Intrinsics.checkNotNull((Object)$cache, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.metadata.model.ExtendableClassMetadata");
            ExtendableClassMetadata cfr_ignored_2 = (ExtendableClassMetadata)$cache;
            $this$compareMetadata.compareAll("subclasses", (Iterable)((ExtendableClassMetadata)$cache).getSubclasses(), (Iterable)((ExtendableClassMetadata)$current).getSubclasses(), this$0);
        } else {
            $this$compareMetadata.compareAll("properties", (Iterable)this$0.notComputableProperties($cache.getProperties()), (Iterable)this$0.notComputableProperties($current.getProperties()), this$0.propertiesComparator);
        }
        return Unit.INSTANCE;
    }
}

