/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalProcessAuthHelper;

import com.intellij.externalProcessAuthHelper.ExternalProcessHandlerService;
import com.intellij.externalProcessAuthHelper.ExternalProcessHandlerServiceKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.NettyKt;
import externalApp.ExternalAppHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.Future;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0014\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0005H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\"\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0005H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/intellij/externalProcessAuthHelper/ExternalProcessRest;", "T", "LexternalApp/ExternalAppHandler;", "Lorg/jetbrains/ide/RestService;", "entryPointName", "", "Lorg/jetbrains/annotations/NonNls;", "<init>", "(Ljava/lang/String;)V", "externalProcessHandler", "Lcom/intellij/externalProcessAuthHelper/ExternalProcessHandlerService;", "getExternalProcessHandler", "()Lcom/intellij/externalProcessAuthHelper/ExternalProcessHandlerService;", "getServiceName", "reportErrorsAsPlainText", "", "getReportErrorsAsPlainText", "()Z", "isMethodSupported", "method", "Lio/netty/handler/codec/http/HttpMethod;", "getRequesterId", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "execute", "getHandlerUUID", "Ljava/util/UUID;", "runHandler", "indicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "uuid", "bodyContent", "intellij.platform.externalProcessAuthHelper"})
public abstract class ExternalProcessRest<T extends ExternalAppHandler>
extends RestService {
    @NotNull
    private final String entryPointName;

    public ExternalProcessRest(@NotNull String entryPointName) {
        Intrinsics.checkNotNullParameter((Object)entryPointName, (String)"entryPointName");
        this.entryPointName = entryPointName;
    }

    @NotNull
    protected abstract ExternalProcessHandlerService<T> getExternalProcessHandler();

    @NotNull
    protected String getServiceName() {
        return this.entryPointName;
    }

    protected boolean getReportErrorsAsPlainText() {
        return true;
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return method == HttpMethod.POST;
    }

    @NotNull
    protected Object getRequesterId(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        UUID uuid = this.getHandlerUUID(urlDecoder);
        if (uuid != null && this.getExternalProcessHandler().validateHandler$intellij_platform_externalProcessAuthHelper(uuid)) {
            return uuid;
        }
        return super.getRequesterId(urlDecoder, request, context);
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        UUID uUID = this.getHandlerUUID(urlDecoder);
        if (uUID == null) {
            return "Handler is not specified";
        }
        UUID uuid = uUID;
        ByteBuf byteBuf = request.content();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
        String bodyContent = NettyKt.readUtf8((ByteBuf)byteBuf);
        Channel channel = context.channel();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        channel.closeFuture().addListener(arg_0 -> ExternalProcessRest.execute$lambda$0(indicator, arg_0));
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        ExecutorService executor = executorService;
        CompletableFuture.supplyAsync(() -> ExternalProcessRest.execute$lambda$1(this, indicator, uuid, bodyContent), executor).handle((arg_0, arg_1) -> ExternalProcessRest.execute$lambda$3((arg_0, arg_1) -> ExternalProcessRest.execute$lambda$2(channel, request, context, arg_0, arg_1), arg_0, arg_1));
        return null;
    }

    private final UUID getHandlerUUID(QueryStringDecoder urlDecoder) {
        Object object = (List)urlDecoder.parameters().get("handlerId");
        if (object == null || (object = (String)CollectionsKt.singleOrNull((List)object)) == null) {
            return null;
        }
        Object handlerId = object;
        return UUID.fromString((String)handlerId);
    }

    private final String runHandler(EmptyProgressIndicator indicator, UUID uuid, String bodyContent) {
        return (String)ProgressManager.getInstance().runProcess(() -> ExternalProcessRest.runHandler$lambda$0(this, uuid, bodyContent), (ProgressIndicator)indicator);
    }

    private static final void execute$lambda$0(EmptyProgressIndicator $indicator, Future it) {
        $indicator.cancel();
    }

    private static final String execute$lambda$1(ExternalProcessRest this$0, EmptyProgressIndicator $indicator, UUID $uuid, String $bodyContent) {
        return this$0.runHandler($indicator, $uuid, $bodyContent);
    }

    private static final Object execute$lambda$2(Channel $channel, FullHttpRequest $request, ChannelHandlerContext $context, String res, Throwable err) {
        ChannelFuture channelFuture;
        if (err != null) {
            if (err instanceof ProcessCanceledException) {
                channelFuture = $channel.close();
            } else {
                ExternalProcessHandlerServiceKt.access$getLOG_REST$p().warn(new Throwable(err));
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
                Intrinsics.checkNotNull((Object)$channel);
                RestService.Companion.sendStatus(httpResponseStatus, false, $channel);
                channelFuture = Unit.INSTANCE;
            }
        } else if (res != null) {
            HttpRequest httpRequest = (HttpRequest)$request;
            CharSequence charSequence = res;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            RestService.Companion.sendResponse(httpRequest, $context, (HttpResponse)Responses.response((CharSequence)charSequence, (Charset)charset));
            channelFuture = Unit.INSTANCE;
        } else {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NO_CONTENT;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NO_CONTENT");
            Intrinsics.checkNotNull((Object)$channel);
            RestService.Companion.sendStatus(httpResponseStatus, false, $channel);
            channelFuture = Unit.INSTANCE;
        }
        return channelFuture;
    }

    private static final Object execute$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        return $tmp0.invoke(p0, (Object)p1);
    }

    private static final String runHandler$lambda$0(ExternalProcessRest this$0, UUID $uuid, String $bodyContent) {
        return this$0.getExternalProcessHandler().invokeHandler$intellij_platform_externalProcessAuthHelper($uuid, $bodyContent);
    }
}

