/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events.scheme;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nJ\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rb\u0010\b\u001aV\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u00070\u0005j*\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0007`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/RegisteredLogDescriptionsProcessor;", "", "<init>", "()V", "groupDescriptionsMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "eventDescriptionsMap", "descriptionRegistrationEnabled", "", "resetDescriptions", "", "configureDescriptionRegistration", "isEnabled", "registerGroupDescription", "groupId", "description", "registerEventDescription", "eventId", "calculateGroupDescription", "calculateEventDescription", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class RegisteredLogDescriptionsProcessor {
    @NotNull
    public static final RegisteredLogDescriptionsProcessor INSTANCE = new RegisteredLogDescriptionsProcessor();
    @NotNull
    private static final HashMap<String, String> groupDescriptionsMap = new HashMap();
    @NotNull
    private static final HashMap<String, HashMap<String, String>> eventDescriptionsMap = new HashMap();
    private static boolean descriptionRegistrationEnabled;

    private RegisteredLogDescriptionsProcessor() {
    }

    public final void resetDescriptions() {
        groupDescriptionsMap.clear();
        eventDescriptionsMap.clear();
    }

    public final void configureDescriptionRegistration(boolean isEnabled) {
        descriptionRegistrationEnabled = isEnabled;
    }

    public final void registerGroupDescription(@NotNull String groupId, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        if (!descriptionRegistrationEnabled || description == null || ((CharSequence)description).length() == 0) {
            return;
        }
        if (groupDescriptionsMap.containsKey(groupId) && !Intrinsics.areEqual((Object)groupDescriptionsMap.get(groupId), (Object)description)) {
            throw new IllegalStateException("Trying to override registered event log group description in group '" + groupId + "'. Old description: " + groupDescriptionsMap.get(groupId) + ", new description: " + description + ".");
        }
        ((Map)groupDescriptionsMap).put(groupId, description);
    }

    public final void registerEventDescription(@NotNull String groupId, @NotNull String eventId, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        if (!descriptionRegistrationEnabled || description == null || ((CharSequence)description).length() == 0) {
            return;
        }
        HashMap<String, String> groupMap = eventDescriptionsMap.get(groupId);
        if (groupMap == null) {
            Map map = eventDescriptionsMap;
            Object object = new Pair[]{TuplesKt.to((Object)eventId, (Object)description)};
            object = MapsKt.hashMapOf((Pair[])object);
            map.put(groupId, object);
            return;
        }
        if (!groupMap.containsKey(eventId)) {
            ((Map)groupMap).put(eventId, description);
            return;
        }
        if (!Intrinsics.areEqual((Object)groupMap.get(eventId), (Object)description)) {
            throw new IllegalStateException("Trying to override registered event log description for event '" + eventId + "' in group '" + groupId + "'. Old description: " + groupMap.get(eventId) + ", new description: " + description + ".");
        }
    }

    @Nullable
    public final String calculateGroupDescription(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        if (!descriptionRegistrationEnabled) {
            return null;
        }
        return groupDescriptionsMap.get(groupId);
    }

    @Nullable
    public final String calculateEventDescription(@NotNull String groupId, @NotNull String eventId) {
        HashMap<String, String> groupMap;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        if (!descriptionRegistrationEnabled) {
            return null;
        }
        HashMap<String, String> hashMap = groupMap = eventDescriptionsMap.get(groupId);
        return hashMap != null ? hashMap.get(eventId) : null;
    }

    static {
        String string = System.getenv("FUS_DESCRIPTION_REGISTRATION_ENABLED");
        descriptionRegistrationEnabled = string != null ? Boolean.parseBoolean(string) : false;
    }
}

