/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.ObservableList;
import runtime.reactive.Signal;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00016B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\u0016\u0010\u001f\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J7\u0010 \u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u001e\u0010!\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000#\u0012\u0004\u0012\u00020\u000f0\"H\u0082\bJ\u0016\u0010$\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\u0016\u0010(\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010)\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\u0016\u0010*\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010+\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u000fH\u0016J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000/H\u0096\u0002J\u0015\u00100\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00028\u000002H\u0016J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00028\u0000022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u0014H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010%\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00067"}, d2={"Lruntime/reactive/ObservableMutableList;", "T", "Lruntime/reactive/ObservableList;", "", "initial", "", "<init>", "(Ljava/util/List;)V", "storage", "change", "Lruntime/reactive/Signal;", "Lruntime/reactive/ObservableList$Change;", "getChange", "()Lruntime/reactive/Signal;", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "", "(ILjava/lang/Object;)V", "removeAt", "(I)Ljava/lang/Object;", "remove", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "addAll", "elements", "", "clear", "removeAll", "filterElementsInplace", "predicate", "Lkotlin/Function2;", "", "retainAll", "size", "getSize", "()I", "contains", "containsAll", "get", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "MyIterator", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nObservableList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObservableList.kt\nruntime/reactive/ObservableMutableList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n107#1,8:221\n115#1:231\n107#1,8:234\n115#1:244\n1#2:214\n1863#3,2:215\n1863#3,2:217\n1863#3,2:219\n1863#3,2:229\n1863#3,2:232\n1863#3,2:242\n*S KotlinDebug\n*F\n+ 1 ObservableList.kt\nruntime/reactive/ObservableMutableList\n*L\n103#1:221,8\n103#1:231\n120#1:234,8\n120#1:244\n79#1:215,2\n89#1:217,2\n99#1:219,2\n103#1:229,2\n114#1:232,2\n120#1:242,2\n*E\n"})
public final class ObservableMutableList<T>
implements ObservableList<T>,
List<T>,
KMutableList {
    @NotNull
    private final List<T> storage;
    @NotNull
    private final Signal<ObservableList.Change<T>> change;

    /*
     * WARNING - void declaration
     */
    public ObservableMutableList(@NotNull List<? extends T> initial2) {
        void $this$storage_u24lambda_u240;
        List list2;
        Intrinsics.checkNotNullParameter(initial2, (String)"initial");
        List list3 = list2 = (List)new ArrayList();
        ObservableMutableList observableMutableList = this;
        boolean bl = false;
        $this$storage_u24lambda_u240.addAll((Collection)initial2);
        observableMutableList.storage = list2;
        this.change = Signal.Companion.create();
    }

    @Override
    @NotNull
    public Signal<ObservableList.Change<T>> getChange() {
        return this.change;
    }

    @Override
    public boolean add(T element) {
        this.storage.add(element);
        this.getChange().fire(new ObservableList.Change.Add<T>(this.size() - 1, element));
        return true;
    }

    @Override
    public void add(int index, T element) {
        this.storage.add(index, element);
        this.getChange().fire(new ObservableList.Change.Add<T>(index, element));
    }

    public T removeAt(int index) {
        T res = this.storage.remove(index);
        this.getChange().fire(new ObservableList.Change.Remove<T>(index, res));
        return res;
    }

    @Override
    public boolean remove(Object element) {
        int index = this.storage.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public T set(int index, T element) {
        T old = this.storage.set(index, element);
        this.getChange().fire(new ObservableList.Change.Update<T>(index, old, element));
        return old;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        ArrayList<ObservableList.Change.Add<T>> changes2 = new ArrayList<ObservableList.Change.Add<T>>();
        int idx = index;
        for (T element : elements2) {
            this.storage.add(idx, element);
            changes2.add(new ObservableList.Change.Add<T>(idx, element));
            ++idx;
        }
        Iterable $this$forEach$iv = changes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObservableList.Change it = (ObservableList.Change)element$iv;
            boolean bl = false;
            this.getChange().fire(it);
        }
        return !((Collection)changes2).isEmpty();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        ArrayList<ObservableList.Change.Add<T>> changes2 = new ArrayList<ObservableList.Change.Add<T>>();
        for (T element : elements2) {
            this.storage.add(element);
            changes2.add(new ObservableList.Change.Add<T>(this.size() - 1, element));
        }
        Iterable $this$forEach$iv = changes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObservableList.Change it = (ObservableList.Change)element$iv;
            boolean bl = false;
            this.getChange().fire(it);
        }
        return !((Collection)changes2).isEmpty();
    }

    @Override
    public void clear() {
        ArrayList<ObservableList.Change.Remove<T>> changes2 = new ArrayList<ObservableList.Change.Remove<T>>();
        for (int i = this.storage.size() - 1; -1 < i; --i) {
            changes2.add(new ObservableList.Change.Remove<T>(i, this.storage.get(i)));
        }
        this.storage.clear();
        Iterable $this$forEach$iv = changes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObservableList.Change it = (ObservableList.Change)element$iv;
            boolean bl = false;
            this.getChange().fire(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        ObservableMutableList this_$iv = this;
        boolean $i$f$filterElementsInplace = false;
        Set elementsSet$iv = CollectionsKt.toSet((Iterable)elements2);
        ArrayList<ObservableList.Change.Remove<T>> changes$iv = new ArrayList<ObservableList.Change.Remove<T>>();
        for (int index$iv = CollectionsKt.getLastIndex(this_$iv.storage); -1 < index$iv; --index$iv) {
            void elementsSet;
            Set set = elementsSet$iv;
            int index = index$iv;
            boolean bl = false;
            if (!elementsSet.contains(this.storage.get(index))) continue;
            changes$iv.add(new ObservableList.Change.Remove<T>(index$iv, this_$iv.storage.remove(index$iv)));
        }
        Iterable $this$forEach$iv$iv = changes$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ObservableList.Change it$iv = (ObservableList.Change)element$iv$iv;
            boolean bl = false;
            this_$iv.getChange().fire(it$iv);
        }
        return !((Collection)changes$iv).isEmpty();
    }

    private final boolean filterElementsInplace(Collection<? extends T> elements2, Function2<? super Integer, ? super Set<? extends T>, Boolean> predicate) {
        boolean $i$f$filterElementsInplace = false;
        Set elementsSet = CollectionsKt.toSet((Iterable)elements2);
        ArrayList<ObservableList.Change.Remove<T>> changes2 = new ArrayList<ObservableList.Change.Remove<T>>();
        for (int index = CollectionsKt.getLastIndex(this.storage); -1 < index; --index) {
            if (!((Boolean)predicate.invoke((Object)index, (Object)elementsSet)).booleanValue()) continue;
            changes2.add(new ObservableList.Change.Remove<T>(index, this.storage.remove(index)));
        }
        Iterable $this$forEach$iv = changes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObservableList.Change it = (ObservableList.Change)element$iv;
            boolean bl = false;
            this.getChange().fire(it);
        }
        return !((Collection)changes2).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        ObservableMutableList this_$iv = this;
        boolean $i$f$filterElementsInplace = false;
        Set elementsSet$iv = CollectionsKt.toSet((Iterable)elements2);
        ArrayList<ObservableList.Change.Remove<T>> changes$iv = new ArrayList<ObservableList.Change.Remove<T>>();
        for (int index$iv = CollectionsKt.getLastIndex(this_$iv.storage); -1 < index$iv; --index$iv) {
            void elementsSet;
            Set set = elementsSet$iv;
            int index = index$iv;
            boolean bl = false;
            if (!(!elementsSet.contains(this.storage.get(index)))) continue;
            changes$iv.add(new ObservableList.Change.Remove<T>(index$iv, this_$iv.storage.remove(index$iv)));
        }
        Iterable $this$forEach$iv$iv = changes$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ObservableList.Change it$iv = (ObservableList.Change)element$iv$iv;
            boolean bl = false;
            this_$iv.getChange().fire(it$iv);
        }
        return !((Collection)changes$iv).isEmpty();
    }

    public int getSize() {
        return this.storage.size();
    }

    @Override
    public boolean contains(Object element) {
        return this.storage.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        return this.storage.containsAll(elements2);
    }

    @Override
    public T get(int index) {
        return this.storage.get(index);
    }

    @Override
    public int indexOf(Object element) {
        return this.storage.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.storage.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return new MyIterator(this.storage.listIterator());
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return new MyIterator(this.storage.listIterator(index));
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010+\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\u0015\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\r\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0003J\t\u0010\u0011\u001a\u00020\u0010H\u0096\u0001J\t\u0010\u0012\u001a\u00028\u0000H\u0096\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\t\u0010\u0015\u001a\u00020\u0014H\u0096\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lruntime/reactive/ObservableMutableList$MyIterator;", "", "baseIterator", "<init>", "(Lruntime/reactive/ObservableMutableList;Ljava/util/ListIterator;)V", "getBaseIterator", "()Ljava/util/ListIterator;", "add", "", "element", "(Ljava/lang/Object;)V", "remove", "set", "previous", "()Ljava/lang/Object;", "hasNext", "", "hasPrevious", "next", "nextIndex", "", "previousIndex", "platform-runtime"})
    private final class MyIterator
    implements ListIterator<T>,
    KMutableListIterator {
        @NotNull
        private final ListIterator<T> baseIterator;

        public MyIterator(ListIterator<T> baseIterator) {
            Intrinsics.checkNotNullParameter(baseIterator, (String)"baseIterator");
            this.baseIterator = baseIterator;
        }

        @NotNull
        public final ListIterator<T> getBaseIterator() {
            return this.baseIterator;
        }

        @Override
        public boolean hasNext() {
            return this.baseIterator.hasNext();
        }

        @Override
        public T next() {
            return this.baseIterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.baseIterator.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.baseIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.baseIterator.previousIndex();
        }

        @Override
        public void add(T element) {
            this.baseIterator.add(element);
            ObservableMutableList.this.getChange().fire(new ObservableList.Change.Add(this.previousIndex(), element));
        }

        @Override
        public void remove() {
            int index = this.previousIndex();
            Object element = ObservableMutableList.this.storage.get(index);
            this.baseIterator.remove();
            ObservableMutableList.this.getChange().fire(new ObservableList.Change.Remove(index, element));
        }

        @Override
        public void set(T element) {
            int index = this.previousIndex();
            Object oldElement = ObservableMutableList.this.storage.get(index);
            this.baseIterator.set(element);
            ObservableMutableList.this.getChange().fire(new ObservableList.Change.Update(index, oldElement, element));
        }

        @Override
        public T previous() {
            throw new UnsupportedOperationException("Can't use previous here");
        }
    }
}

