/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PathResolverKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.plugins.parser.impl.LoadPathUtil;
import com.intellij.platform.plugins.parser.impl.LoadPathUtilKt;
import com.intellij.platform.plugins.parser.impl.LoadedXIncludeReference;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorBuilder;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorFromXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorReaderContext;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumerKt;
import com.intellij.platform.plugins.parser.impl.XIncludeLoader;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B:\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\tH\u0016J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\tH\u0016J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010 \u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/intellij/ide/plugins/ClassPathXmlPathResolver;", "Lcom/intellij/ide/plugins/PathResolver;", "Lcom/intellij/platform/plugins/parser/impl/XIncludeLoader;", "classLoader", "Ljava/lang/ClassLoader;", "isRunningFromSourcesWithoutDevBuild", "", "isOptionalProductModule", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "moduleId", "<init>", "(Ljava/lang/ClassLoader;ZLkotlin/jvm/functions/Function1;)V", "isFlat", "()Z", "loadXIncludeReference", "Lcom/intellij/platform/plugins/parser/impl/LoadedXIncludeReference;", "path", "dataLoader", "Lcom/intellij/ide/plugins/DataLoader;", "doLoadXIncludeReference", "", "resolveModuleFile", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorBuilder;", "readContext", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorReaderContext;", "resolvePath", "relativePath", "getXmlReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "toString", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClassPathXmlPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassPathXmlPathResolver.kt\ncom/intellij/ide/plugins/ClassPathXmlPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,110:1\n1#2:111\n13#3:112\n60#3,5:113\n*S KotlinDebug\n*F\n+ 1 ClassPathXmlPathResolver.kt\ncom/intellij/ide/plugins/ClassPathXmlPathResolver\n*L\n53#1:112\n64#1:113,5\n*E\n"})
public final class ClassPathXmlPathResolver
implements PathResolver,
XIncludeLoader {
    @NotNull
    private final ClassLoader classLoader;
    @JvmField
    public final boolean isRunningFromSourcesWithoutDevBuild;
    @NotNull
    private final Function1<String, Boolean> isOptionalProductModule;

    public ClassPathXmlPathResolver(@NotNull ClassLoader classLoader, boolean isRunningFromSourcesWithoutDevBuild, @NotNull Function1<? super String, Boolean> isOptionalProductModule) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(isOptionalProductModule, (String)"isOptionalProductModule");
        this.classLoader = classLoader;
        this.isRunningFromSourcesWithoutDevBuild = isRunningFromSourcesWithoutDevBuild;
        this.isOptionalProductModule = isOptionalProductModule;
    }

    @Override
    public boolean isFlat() {
        return true;
    }

    @Override
    @Nullable
    public LoadedXIncludeReference loadXIncludeReference(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] byArray = this.doLoadXIncludeReference(path);
        if (byArray == null) {
            return null;
        }
        return new LoadedXIncludeReference(byArray, this.toString());
    }

    @Override
    @Nullable
    public LoadedXIncludeReference loadXIncludeReference(@NotNull DataLoader dataLoader2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] byArray = this.doLoadXIncludeReference(path);
        if (byArray == null) {
            return null;
        }
        return new LoadedXIncludeReference(byArray, dataLoader2.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] doLoadXIncludeReference(String path) {
        byte[] byArray;
        if (this.classLoader instanceof UrlClassLoader) {
            return ((UrlClassLoader)this.classLoader).getResourceAsBytes(path, true);
        }
        InputStream inputStream = this.classLoader.getResourceAsStream(path);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byte[] byArray2 = ByteStreamsKt.readBytes((InputStream)it);
                byArray = byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    @Override
    @NotNull
    public PluginDescriptorBuilder resolveModuleFile(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] resource = null;
        if (this.classLoader instanceof UrlClassLoader) {
            resource = ((UrlClassLoader)this.classLoader).getResourceAsBytes(path, true);
        } else {
            InputStream inputStream = this.classLoader.getResourceAsStream(path);
            if (inputStream != null) {
                InputStream it = inputStream;
                boolean bl = false;
                PluginDescriptorFromXmlStreamConsumer reader = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.createXIncludeLoader(this, dataLoader2));
                PluginXmlStreamConsumerKt.consume((PluginXmlStreamConsumer)reader, it, dataLoader2.toString());
                return reader.getBuilder();
            }
            resource = null;
        }
        if (resource == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ClassPathXmlPathResolver.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger log = logger;
            String moduleId = StringsKt.removeSuffix((String)path, (CharSequence)".xml");
            if (this.isRunningFromSourcesWithoutDevBuild && LoadPathUtilKt.isV2ModulePath(path) && dataLoader2.getEmptyDescriptorIfCannotResolve()) {
                PluginDescriptorBuilder it;
                log.trace("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", classLoader=" + this.classLoader + "). ");
                PluginDescriptorBuilder $this$resolveModuleFile_u24lambda_u241 = it = PluginDescriptorBuilder.Companion.builder();
                boolean bl = false;
                $this$resolveModuleFile_u24lambda_u241.setPackage("unresolved." + moduleId);
                return it;
            }
            if (((Boolean)this.isOptionalProductModule.invoke((Object)moduleId)).booleanValue()) {
                PluginDescriptorBuilder pluginDescriptorBuilder;
                Logger $this$debug_u24default$iv = log;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger2 = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger2.debug("Skip module '" + path + "' since its descriptor cannot be found and it's optional", t$iv);
                }
                PluginDescriptorBuilder $this$resolveModuleFile_u24lambda_u243 = pluginDescriptorBuilder = PluginDescriptorBuilder.Companion.builder();
                boolean bl = false;
                $this$resolveModuleFile_u24lambda_u243.setPackage("unresolved." + moduleId);
                return pluginDescriptorBuilder;
            }
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", classLoader=" + this.classLoader + ", isRunningFromSourcesWithoutDevBuild=" + this.isRunningFromSourcesWithoutDevBuild + ", dataLoader.emptyDescriptorIfCannotResolve=" + dataLoader2.getEmptyDescriptorIfCannotResolve() + ", path.startsWith(\"intellij.\")=" + StringsKt.startsWith$default((String)path, (String)"intellij.", (boolean)false, (int)2, null) + ", )");
        }
        PluginDescriptorFromXmlStreamConsumer consumer = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.createXIncludeLoader(this, dataLoader2));
        PluginXmlStreamConsumerKt.consume((PluginXmlStreamConsumer)consumer, resource, dataLoader2.toString());
        return consumer.getBuilder();
    }

    @Override
    @Nullable
    public PluginDescriptorBuilder resolvePath(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader2, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String path = LoadPathUtil.toLoadPath$default(LoadPathUtil.INSTANCE, relativePath, null, 2, null);
        XMLStreamReader2 xMLStreamReader2 = this.getXmlReader(this.classLoader, path, dataLoader2);
        if (xMLStreamReader2 == null) {
            return null;
        }
        XMLStreamReader2 reader = xMLStreamReader2;
        PluginDescriptorFromXmlStreamConsumer it = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.createXIncludeLoader(this, dataLoader2));
        boolean bl = false;
        it.consume(reader);
        return it.getBuilder();
    }

    private final XMLStreamReader2 getXmlReader(ClassLoader classLoader, String path, DataLoader dataLoader2) {
        if (classLoader instanceof UrlClassLoader) {
            byte[] byArray = ((UrlClassLoader)classLoader).getResourceAsBytes(path, true);
            if (byArray == null) {
                return null;
            }
            return StaxFactory.createNonCoalescingXmlStreamReader((byte[])byArray, (String)dataLoader2.toString());
        }
        InputStream inputStream = classLoader.getResourceAsStream(path);
        if (inputStream == null) {
            return null;
        }
        return StaxFactory.createNonCoalescingXmlStreamReader((InputStream)inputStream, (String)dataLoader2.toString());
    }

    @NotNull
    public String toString() {
        ClassLoader classLoader = this.classLoader;
        UrlClassLoader urlClassLoader = classLoader instanceof UrlClassLoader ? (UrlClassLoader)classLoader : null;
        return "ClassPathXmlPathResolver(classLoader=" + this.classLoader.getClass().getSimpleName() + "(files=" + (urlClassLoader != null ? urlClassLoader.getFiles() : null) + "), isRunningFromSourcesWithoutDevBuild=" + this.isRunningFromSourcesWithoutDevBuild + ')';
    }
}

