/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.util.lang.ZipEntryResolverPool;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/ImmutableZipFileDataLoader;", "Lcom/intellij/ide/plugins/DataLoader;", "resolver", "Lcom/intellij/util/lang/ZipEntryResolverPool$EntryResolver;", "zipPath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/util/lang/ZipEntryResolverPool$EntryResolver;Ljava/nio/file/Path;)V", "load", "", "path", "", "pluginDescriptorSourceOnly", "", "isExcludedFromSubSearch", "jarFile", "toString", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class ImmutableZipFileDataLoader
implements DataLoader {
    @NotNull
    private final ZipEntryResolverPool.EntryResolver resolver;
    @NotNull
    private final Path zipPath;

    public ImmutableZipFileDataLoader(@NotNull ZipEntryResolverPool.EntryResolver resolver, @NotNull Path zipPath) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
        this.resolver = resolver;
        this.zipPath = zipPath;
    }

    @Override
    @Nullable
    public byte[] load(@NotNull String path, boolean pluginDescriptorSourceOnly) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.charAt(0) == '/') {
            String string2 = path.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = path;
        }
        return this.resolver.loadZipEntry(string);
    }

    @Override
    public boolean isExcludedFromSubSearch(@NotNull Path jarFile) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        return jarFile == this.zipPath;
    }

    @Override
    @NotNull
    public String toString() {
        return this.resolver.toString();
    }
}

