/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependencies;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginInitializationContext;
import com.intellij.ide.plugins.PluginLoadingIsDisabledCompletely;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.ide.plugins.PluginNonLoadReason;
import com.intellij.ide.plugins.PluginUtils;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.ArchivedCompilationContextUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.text.HtmlChunk;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001aF\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u001af\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\b0\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00062\u001c\u0010\u0017\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u001a0\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u0003H\u0002\u001a\u0016\u0010!\u001a\u0004\u0018\u00010\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0007\u001a\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u0007H\u0007\u001a8\u0010%\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\b2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0006H\u0007\u001a8\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u00072\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0006H\u0007\u001a8\u0010)\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u00072\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0006H\u0007\u001a8\u0010)\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0006H\u0007\u001a\u0014\u0010+\u001a\u00020\u000f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0007\u00a8\u0006,"}, d2={"selectPluginsForLoading", "", "descriptors", "", "Lcom/intellij/ide/plugins/PluginMainDescriptor;", "idMap", "", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "errors", "", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "initContext", "Lcom/intellij/ide/plugins/PluginInitializationContext;", "processAllNonOptionalDependencies", "", "rootDescriptor", "depProcessed", "", "pluginIdMap", "contentModuleIdMap", "Lcom/intellij/ide/plugins/PluginModuleId;", "Lcom/intellij/ide/plugins/ContentModuleDescriptor;", "consumer", "Lkotlin/Function2;", "Ljava/nio/file/FileVisitResult;", "prepareActions", "", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/util/text/HtmlChunk;", "pluginNamesToDisable", "", "pluginNamesToEnable", "getPluginDistDirByClass", "Ljava/nio/file/Path;", "aClass", "Ljava/lang/Class;", "pluginRequiresUltimatePluginButItsDisabled", "plugin", "rootPlugin", "pluginMap", "pluginRequiresUltimatePlugin", "contentModuleMap", "isPlatformOrJetBrainsDistributionPlugin", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nPluginManagerCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManagerCore.kt\ncom/intellij/ide/plugins/PluginManagerCoreKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1159:1\n1236#2,4:1160\n1#3:1164\n*S KotlinDebug\n*F\n+ 1 PluginManagerCore.kt\ncom/intellij/ide/plugins/PluginManagerCoreKt\n*L\n946#1:1160,4\n*E\n"})
public final class PluginManagerCoreKt {
    /*
     * WARNING - void declaration
     */
    private static final void selectPluginsForLoading(Collection<PluginMainDescriptor> descriptors, Map<PluginId, ? extends IdeaPluginDescriptorImpl> idMap, Map<PluginId, PluginNonLoadReason> errors, PluginInitializationContext initContext) {
        if (initContext.getExplicitPluginSubsetToLoad() != null) {
            Set<PluginId> set = initContext.getExplicitPluginSubsetToLoad();
            Intrinsics.checkNotNull(set);
            Set rootPluginsToLoad = SetsKt.plus((Set)CollectionsKt.toHashSet((Iterable)set), (Iterable)initContext.getEssentialPlugins());
            LinkedHashSet<IdeaPluginDescriptorImpl> pluginsToLoad = new LinkedHashSet<IdeaPluginDescriptorImpl>(rootPluginsToLoad.size());
            HashMap contentModuleIdMap = new HashMap();
            for (PluginMainDescriptor descriptor : descriptors) {
                void $this$associateByTo$iv;
                Iterable iterable = descriptor.getContentModules();
                Map destination$iv = contentModuleIdMap;
                boolean $i$f$associateByTo = false;
                for (Object element$iv : $this$associateByTo$iv) {
                    void it;
                    ContentModuleDescriptor contentModuleDescriptor = (ContentModuleDescriptor)element$iv;
                    Map map = destination$iv;
                    boolean bl = false;
                    map.put(it.moduleId, element$iv);
                }
            }
            for (PluginId id : rootPluginsToLoad) {
                IdeaPluginDescriptorImpl descriptor;
                if (idMap.get(id) == null) continue;
                pluginsToLoad.add(descriptor);
                PluginManagerCore.INSTANCE.processAllNonOptionalDependencies(descriptor, idMap, contentModuleIdMap, (Function1<? super IdeaPluginDescriptorImpl, ? extends FileVisitResult>)((Function1)arg_0 -> PluginManagerCoreKt.selectPluginsForLoading$lambda$1(pluginsToLoad, arg_0)));
            }
            for (PluginMainDescriptor descriptor : descriptors) {
                if (Intrinsics.areEqual((Object)descriptor.getPluginId(), (Object)PluginManagerCore.CORE_ID) || pluginsToLoad.contains(descriptor)) continue;
                descriptor.setMarkedForLoading(false);
                PluginManagerCore.getLogger().info("Plugin '" + descriptor.getName() + "' is not in 'idea.load.plugins.id' system property and won't be loaded");
            }
        } else if (initContext.getDisablePluginLoadingCompletely()) {
            for (PluginMainDescriptor descriptor : descriptors) {
                if (Intrinsics.areEqual((Object)descriptor.getPluginId(), (Object)PluginManagerCore.CORE_ID)) continue;
                descriptor.setMarkedForLoading(false);
                errors.put(descriptor.getPluginId(), new PluginLoadingIsDisabledCompletely(descriptor));
            }
        } else {
            for (PluginId essentialId : initContext.getEssentialPlugins()) {
                IdeaPluginDescriptorImpl essentialPlugin;
                if (idMap.get(essentialId) == null) continue;
                for (PluginId incompatibleId : essentialPlugin.getIncompatiblePlugins()) {
                    IdeaPluginDescriptorImpl incompatiblePlugin;
                    if (idMap.get(incompatibleId) == null || !incompatiblePlugin.isMarkedForLoading()) continue;
                    incompatiblePlugin.setMarkedForLoading(false);
                    PluginManagerCore.getLogger().info("Plugin '" + incompatiblePlugin.getName() + "' conflicts with required plugin '" + essentialPlugin.getName() + "' and won't be loaded");
                }
            }
        }
    }

    private static final boolean processAllNonOptionalDependencies(IdeaPluginDescriptorImpl rootDescriptor, Set<? super IdeaPluginDescriptorImpl> depProcessed, Map<PluginId, ? extends IdeaPluginDescriptorImpl> pluginIdMap, Map<PluginModuleId, ContentModuleDescriptor> contentModuleIdMap, Function2<? super PluginId, ? super IdeaPluginDescriptorImpl, ? extends FileVisitResult> consumer) {
        for (PluginDependency dependency : rootDescriptor.getDependencies()) {
            if (dependency.isOptional() || PluginManagerCoreKt.processAllNonOptionalDependencies$processDependency(pluginIdMap, contentModuleIdMap, consumer, depProcessed, dependency.getPluginId(), null)) continue;
            return false;
        }
        if (!PluginManagerCoreKt.processAllNonOptionalDependencies$processModuleDependencies(pluginIdMap, contentModuleIdMap, consumer, depProcessed, rootDescriptor.getModuleDependencies())) {
            return false;
        }
        if (rootDescriptor instanceof PluginMainDescriptor) {
            for (ContentModuleDescriptor contentModule : ((PluginMainDescriptor)rootDescriptor).getContentModules()) {
                if (!contentModule.moduleLoadingRule.getRequired() || PluginManagerCoreKt.processAllNonOptionalDependencies$processModuleDependencies(pluginIdMap, contentModuleIdMap, consumer, depProcessed, contentModule.getModuleDependencies())) continue;
                return false;
            }
        }
        return true;
    }

    private static final List<Supplier<HtmlChunk>> prepareActions(Collection<String> pluginNamesToDisable, Collection<String> pluginNamesToEnable) {
        String string;
        if (pluginNamesToDisable.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Supplier<HtmlChunk>> actions = new ArrayList<Supplier<HtmlChunk>>();
        String pluginNameToDisable = (String)CollectionsKt.singleOrNull((Iterable)pluginNamesToDisable);
        if (pluginNameToDisable != null) {
            Object[] objectArray = new Object[]{pluginNameToDisable};
            string = CoreBundle.message((String)"link.text.disable.plugin", (Object[])objectArray);
        } else {
            string = CoreBundle.message((String)"link.text.disable.not.loaded.plugins", (Object[])new Object[0]);
        }
        String disableMessage = string;
        actions.add(() -> PluginManagerCoreKt.prepareActions$lambda$0(disableMessage));
        if (!pluginNamesToEnable.isEmpty()) {
            String string2;
            String pluginNameToEnable = (String)CollectionsKt.singleOrNull((Iterable)pluginNamesToEnable);
            if (pluginNameToEnable != null) {
                Object[] objectArray = new Object[]{pluginNameToEnable};
                string2 = CoreBundle.message((String)"link.text.enable.plugin", (Object[])objectArray);
            } else {
                string2 = CoreBundle.message((String)"link.text.enable.all.necessary.plugins", (Object[])new Object[0]);
            }
            String enableMessage = string2;
            actions.add(() -> PluginManagerCoreKt.prepareActions$lambda$1(enableMessage));
        }
        actions.add(PluginManagerCoreKt::prepareActions$lambda$2);
        return actions;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Path getPluginDistDirByClass(@NotNull Class<?> aClass) {
        Path pluginDir;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Object object = aClass.getClassLoader();
        PluginAwareClassLoader pluginAwareClassLoader = object instanceof PluginAwareClassLoader ? (PluginAwareClassLoader)object : null;
        Path path = pluginAwareClassLoader != null && (pluginAwareClassLoader = pluginAwareClassLoader.getPluginDescriptor()) != null ? pluginAwareClassLoader.getPluginPath() : (pluginDir = null);
        if (pluginDir != null) {
            return pluginDir;
        }
        Path path2 = PathManager.getJarForClass(aClass);
        if (path2 == null) {
            throw new IllegalStateException(("Can't find plugin dist home for " + aClass.getSimpleName()).toString());
        }
        Path jarInsideLib = path2;
        if (StringsKt.endsWith((String)((Object)jarInsideLib.getFileName()).toString(), (String)"jar", (boolean)true)) {
            String string = ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation();
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (jarInsideLib.startsWith(it)) {
                    return null;
                }
            }
            Object it = object = jarInsideLib.getParent();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)"lib")) {
                boolean bl2 = false;
                String string2 = it + " should be lib directory";
                throw new IllegalStateException(string2.toString());
            }
            return object.getParent();
        }
        return null;
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePluginButItsDisabled(@NotNull PluginId plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
        Map<PluginModuleId, ContentModuleDescriptor> contentModuleIdMap = PluginManagerCore.getPluginSet().buildContentModuleIdMap();
        return PluginManagerCoreKt.pluginRequiresUltimatePluginButItsDisabled(plugin, idMap, contentModuleIdMap);
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePluginButItsDisabled(@NotNull IdeaPluginDescriptorImpl rootPlugin, @NotNull Map<PluginId, ? extends IdeaPluginDescriptorImpl> pluginMap, @NotNull Map<PluginModuleId, ContentModuleDescriptor> contentModuleIdMap) {
        Intrinsics.checkNotNullParameter((Object)rootPlugin, (String)"rootPlugin");
        Intrinsics.checkNotNullParameter(pluginMap, (String)"pluginMap");
        Intrinsics.checkNotNullParameter(contentModuleIdMap, (String)"contentModuleIdMap");
        if (!PluginManagerCore.isDisabled(PluginManagerCore.ULTIMATE_PLUGIN_ID)) {
            return false;
        }
        return PluginManagerCoreKt.pluginRequiresUltimatePlugin(rootPlugin, pluginMap, contentModuleIdMap);
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePluginButItsDisabled(@NotNull PluginId plugin, @NotNull Map<PluginId, ? extends IdeaPluginDescriptorImpl> pluginMap, @NotNull Map<PluginModuleId, ContentModuleDescriptor> contentModuleIdMap) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter(pluginMap, (String)"pluginMap");
        Intrinsics.checkNotNullParameter(contentModuleIdMap, (String)"contentModuleIdMap");
        if (!PluginManagerCore.isDisabled(PluginManagerCore.ULTIMATE_PLUGIN_ID)) {
            return false;
        }
        return PluginManagerCoreKt.pluginRequiresUltimatePlugin(plugin, pluginMap, contentModuleIdMap);
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePlugin(@NotNull PluginId plugin, @NotNull Map<PluginId, ? extends IdeaPluginDescriptorImpl> pluginMap, @NotNull Map<PluginModuleId, ContentModuleDescriptor> contentModuleMap) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter(pluginMap, (String)"pluginMap");
        Intrinsics.checkNotNullParameter(contentModuleMap, (String)"contentModuleMap");
        IdeaPluginDescriptorImpl rootDescriptor = pluginMap.get(plugin);
        if (rootDescriptor == null) {
            return false;
        }
        return PluginManagerCoreKt.pluginRequiresUltimatePlugin(rootDescriptor, pluginMap, contentModuleMap);
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePlugin(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, ? extends IdeaPluginDescriptorImpl> pluginMap, @NotNull Map<PluginModuleId, ContentModuleDescriptor> contentModuleMap) {
        Intrinsics.checkNotNullParameter((Object)rootDescriptor, (String)"rootDescriptor");
        Intrinsics.checkNotNullParameter(pluginMap, (String)"pluginMap");
        Intrinsics.checkNotNullParameter(contentModuleMap, (String)"contentModuleMap");
        return !PluginManagerCore.INSTANCE.processAllNonOptionalDependencies(rootDescriptor, pluginMap, contentModuleMap, (Function1<? super IdeaPluginDescriptorImpl, ? extends FileVisitResult>)((Function1)PluginManagerCoreKt::pluginRequiresUltimatePlugin$lambda$0));
    }

    @IntellijInternalApi
    @ApiStatus.Internal
    public static final boolean isPlatformOrJetBrainsDistributionPlugin(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        ClassLoader classLoader = aClass.getClassLoader();
        if (classLoader instanceof PluginAwareClassLoader) {
            PluginDescriptor pluginDescriptor = ((PluginAwareClassLoader)classLoader).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"getPluginDescriptor(...)");
            PluginDescriptor plugin = pluginDescriptor;
            return (plugin.isBundled() || PluginManagerCore.isUpdatedBundledPlugin(plugin)) && PluginManagerCore.isDevelopedByJetBrains(plugin);
        }
        if (PluginManagerCore.isRunningFromSources()) {
            return true;
        }
        return PluginUtils.INSTANCE.getPluginDescriptorIfIdeaClassLoaderIsUsed(aClass) == null;
    }

    private static final FileVisitResult selectPluginsForLoading$lambda$1(LinkedHashSet $pluginsToLoad, IdeaPluginDescriptorImpl dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        $pluginsToLoad.add(dependency);
        return FileVisitResult.CONTINUE;
    }

    private static final boolean processAllNonOptionalDependencies$processDependency(Map<PluginId, ? extends IdeaPluginDescriptorImpl> $pluginIdMap, Map<PluginModuleId, ContentModuleDescriptor> $contentModuleIdMap, Function2<? super PluginId, ? super IdeaPluginDescriptorImpl, ? extends FileVisitResult> $consumer, Set<? super IdeaPluginDescriptorImpl> $depProcessed, PluginId pluginId, PluginModuleId moduleId) {
        PluginId pluginId2 = pluginId;
        IdeaPluginDescriptorImpl descriptor = pluginId2 != null ? $pluginIdMap.get(pluginId2) : (IdeaPluginDescriptorImpl)$contentModuleIdMap.get(moduleId);
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor;
        if (ideaPluginDescriptorImpl == null || (ideaPluginDescriptorImpl = ideaPluginDescriptorImpl.getPluginId()) == null) {
            ideaPluginDescriptorImpl = pluginId;
        }
        IdeaPluginDescriptorImpl pluginId3 = ideaPluginDescriptorImpl;
        switch (WhenMappings.$EnumSwitchMapping$0[((FileVisitResult)((Object)$consumer.invoke((Object)pluginId3, (Object)descriptor))).ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                if (descriptor == null || !$depProcessed.add(descriptor) || PluginManagerCoreKt.processAllNonOptionalDependencies(descriptor, $depProcessed, $pluginIdMap, $contentModuleIdMap, $consumer)) break;
                return false;
            }
            case 3: {
                break;
            }
            case 4: {
                throw new UnsupportedOperationException("FileVisitResult.SKIP_SIBLINGS is not supported");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return true;
    }

    private static final boolean processAllNonOptionalDependencies$processModuleDependencies(Map<PluginId, ? extends IdeaPluginDescriptorImpl> $pluginIdMap, Map<PluginModuleId, ContentModuleDescriptor> $contentModuleIdMap, Function2<? super PluginId, ? super IdeaPluginDescriptorImpl, ? extends FileVisitResult> $consumer, Set<? super IdeaPluginDescriptorImpl> $depProcessed, ModuleDependencies moduleDependencies) {
        for (PluginId plugin : moduleDependencies.getPlugins()) {
            if (PluginManagerCoreKt.processAllNonOptionalDependencies$processDependency($pluginIdMap, $contentModuleIdMap, $consumer, $depProcessed, plugin, null)) continue;
            return false;
        }
        for (PluginModuleId module : moduleDependencies.getModules()) {
            if (PluginManagerCoreKt.processAllNonOptionalDependencies$processDependency($pluginIdMap, $contentModuleIdMap, $consumer, $depProcessed, null, module)) continue;
            return false;
        }
        return true;
    }

    private static final HtmlChunk prepareActions$lambda$0(String $disableMessage) {
        return (HtmlChunk)HtmlChunk.link((String)"disable", (String)$disableMessage);
    }

    private static final HtmlChunk prepareActions$lambda$1(String $enableMessage) {
        return (HtmlChunk)HtmlChunk.link((String)"enable", (String)$enableMessage);
    }

    private static final HtmlChunk prepareActions$lambda$2() {
        return (HtmlChunk)HtmlChunk.link((String)"edit", (String)CoreBundle.message((String)"link.text.open.plugin.manager", (Object[])new Object[0]));
    }

    private static final FileVisitResult pluginRequiresUltimatePlugin$lambda$0(IdeaPluginDescriptorImpl descriptorImpl) {
        Intrinsics.checkNotNullParameter((Object)descriptorImpl, (String)"descriptorImpl");
        return Intrinsics.areEqual((Object)descriptorImpl.getPluginId(), (Object)PluginManagerCore.ULTIMATE_PLUGIN_ID) ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    public static final /* synthetic */ void access$selectPluginsForLoading(Collection descriptors, Map idMap, Map errors, PluginInitializationContext initContext) {
        PluginManagerCoreKt.selectPluginsForLoading(descriptors, idMap, errors, initContext);
    }

    public static final /* synthetic */ List access$prepareActions(Collection pluginNamesToDisable, Collection pluginNamesToEnable) {
        return PluginManagerCoreKt.prepareActions(pluginNamesToDisable, pluginNamesToEnable);
    }

    public static final /* synthetic */ boolean access$processAllNonOptionalDependencies(IdeaPluginDescriptorImpl rootDescriptor, Set depProcessed, Map pluginIdMap, Map contentModuleIdMap, Function2 consumer) {
        return PluginManagerCoreKt.processAllNonOptionalDependencies(rootDescriptor, depProcessed, pluginIdMap, contentModuleIdMap, (Function2<? super PluginId, ? super IdeaPluginDescriptorImpl, ? extends FileVisitResult>)consumer);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileVisitResult.values().length];
            try {
                nArray[FileVisitResult.TERMINATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileVisitResult.CONTINUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileVisitResult.SKIP_SUBTREE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileVisitResult.SKIP_SIBLINGS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

