/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import java.util.concurrent.ConcurrentMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0003H\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/PluginModuleId;", "", "name", "", "namespace", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getNamespace", "toString", "equals", "", "other", "hashCode", "", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginModuleId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String namespace;
    @NotNull
    private static final ConcurrentMap<String, PluginModuleId> interner;
    private static final boolean useNamespaceInId;
    @NotNull
    public static final String JETBRAINS_NAMESPACE = "jetbrains";

    private PluginModuleId(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.ide.plugins.PluginModuleId");
        PluginModuleId cfr_ignored_0 = (PluginModuleId)object2;
        return Intrinsics.areEqual((Object)this.name, (Object)((PluginModuleId)other).name) && (!useNamespaceInId || Intrinsics.areEqual((Object)this.namespace, (Object)((PluginModuleId)other).namespace));
    }

    public int hashCode() {
        return useNamespaceInId ? this.name.hashCode() + 31 * this.namespace.hashCode() : this.name.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final PluginModuleId getId(@NotNull String name, @NotNull String namespace) {
        return Companion.getId(name, namespace);
    }

    public /* synthetic */ PluginModuleId(String name, String namespace, DefaultConstructorMarker $constructor_marker) {
        this(name, namespace);
    }

    static {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakKeyWeakValueMap(...)");
        interner = concurrentMap;
        useNamespaceInId = SystemProperties.getBooleanProperty((String)"intellij.platform.plugin.modules.use.namespace.in.id", (boolean)false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0019\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0086\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0011\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006H\u0087\u0002R3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/PluginModuleId$Companion;", "", "<init>", "()V", "interner", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/ide/plugins/PluginModuleId;", "useNamespaceInId", "", "getId", "name", "namespace", "invoke", "JETBRAINS_NAMESPACE", "intellij.platform.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PluginModuleId getId(@NotNull String name, @NotNull String namespace) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            PluginModuleId interned = (PluginModuleId)interner.get(name);
            if (interned != null && Intrinsics.areEqual((Object)interned.getNamespace(), (Object)namespace)) {
                return interned;
            }
            PluginModuleId moduleId = new PluginModuleId(name, namespace, null);
            PluginModuleId old = interner.putIfAbsent(name, moduleId);
            if (old != null && Intrinsics.areEqual((Object)old.getNamespace(), (Object)namespace)) {
                return old;
            }
            return moduleId;
        }

        @NotNull
        public final PluginModuleId invoke(@NotNull String name, @NotNull String namespace) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            return this.getId(name, namespace);
        }

        @Deprecated(message="Use getId(name, namespace) instead")
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final PluginModuleId getId(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getId(name, PluginModuleId.JETBRAINS_NAMESPACE);
        }

        @Deprecated(message="Use PluginModuleId(name, namespace) instead")
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final PluginModuleId invoke(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getId(name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

