/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptorExtensions;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginNonLoadReason;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\r\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0019\u0010\u0014\u001a\u00070\r\u00a2\u0006\u0002\b\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\r*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/plugins/PluginPackagePrefixConflict;", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "module", "conflictingModule", "<init>", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "getModule", "getConflictingModule", "detailedMessage", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "getDetailedMessage", "()Ljava/lang/String;", "shortMessage", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getShortMessage", "logMessage", "Lorg/jetbrains/annotations/NonNls;", "getLogMessage", "shouldNotifyUser", "", "getShouldNotifyUser", "()Z", "moduleId", "getModuleId", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)Ljava/lang/String;", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginPackagePrefixConflict
implements PluginNonLoadReason {
    @NotNull
    private final IdeaPluginDescriptorImpl plugin;
    @NotNull
    private final IdeaPluginDescriptorImpl module;
    @NotNull
    private final IdeaPluginDescriptorImpl conflictingModule;
    private final boolean shouldNotifyUser;

    public PluginPackagePrefixConflict(@NotNull IdeaPluginDescriptorImpl plugin, @NotNull IdeaPluginDescriptorImpl module, @NotNull IdeaPluginDescriptorImpl conflictingModule) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)conflictingModule, (String)"conflictingModule");
        this.plugin = plugin;
        this.module = module;
        this.conflictingModule = conflictingModule;
        this.shouldNotifyUser = true;
    }

    @Override
    @NotNull
    public IdeaPluginDescriptorImpl getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final IdeaPluginDescriptorImpl getModule() {
        return this.module;
    }

    @NotNull
    public final IdeaPluginDescriptorImpl getConflictingModule() {
        return this.conflictingModule;
    }

    @Override
    @NotNull
    public String getDetailedMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getName(), this.conflictingModule.getName(), this.getModuleId(this.module), this.getModuleId(this.conflictingModule)};
        return CoreBundle.message((String)"plugin.loading.error.long.package.prefix.conflict", (Object[])objectArray);
    }

    @Override
    @NotNull
    public String getShortMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getName(), this.conflictingModule.getName()};
        return CoreBundle.message((String)"plugin.loading.error.short.package.prefix.conflict", (Object[])objectArray);
    }

    @Override
    @NotNull
    public String getLogMessage() {
        return "Plugin '" + this.module.getName() + "' conflicts with '" + this.conflictingModule.getName() + "' and may work incorrectly. Their respective modules '" + this.getModuleId(this.module) + "' and '" + this.getModuleId(this.conflictingModule) + "' declare the same package prefix";
    }

    @Override
    public boolean getShouldNotifyUser() {
        return this.shouldNotifyUser;
    }

    private final String getModuleId(IdeaPluginDescriptorImpl $this$moduleId) {
        String string = IdeaPluginDescriptorExtensions.getContentModuleName($this$moduleId);
        if (string == null) {
            string = $this$moduleId.getPluginId().getIdString();
        }
        return string;
    }
}

