/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginStringSetFile;
import com.intellij.ide.plugins.PluginStringSetFileKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.NioFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tJ$\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\fJ\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\fJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/plugins/PluginStringSetFile;", "", "<init>", "()V", "writeIdsSafe", "", "path", "Ljava/nio/file/Path;", "ids", "", "Lcom/intellij/openapi/extensions/PluginId;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "append", "", "strings", "", "appendIdsSafe", "consumeSafe", "consumeIdsSafe", "readSafe", "log", "readIdsSafe", "read", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginStringSetFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginStringSetFile.kt\ncom/intellij/ide/plugins/PluginStringSetFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1634#2,3:110\n1634#2,3:113\n1634#2,3:116\n1634#2,3:119\n*S KotlinDebug\n*F\n+ 1 PluginStringSetFile.kt\ncom/intellij/ide/plugins/PluginStringSetFile\n*L\n34#1:110,3\n53#1:113,3\n78#1:116,3\n92#1:119,3\n*E\n"})
public final class PluginStringSetFile {
    @NotNull
    public static final PluginStringSetFile INSTANCE = new PluginStringSetFile();

    private PluginStringSetFile() {
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean writeIdsSafe(@NotNull Path path, @NotNull Set<PluginId> ids, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            void destination$iv;
            void $this$mapTo$iv;
            Iterable iterable = ids;
            Collection collection = new LinkedHashSet();
            Path path2 = path;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                PluginId pluginId = (PluginId)item$iv;
                void var12_13 = destination$iv;
                boolean bl = false;
                var12_13.add(it.getIdString());
            }
            PluginStringSetFileKt.writePluginStringSet(path2, (Set)destination$iv);
            return true;
        }
        catch (IOException e) {
            logger.warn("failed to write plugin strings to " + path, (Throwable)e);
            return false;
        }
    }

    public final synchronized void append(@NotNull Path path, @NotNull Set<String> strings) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        NioFiles.createDirectories((Path)path.getParent());
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
        Files.write(path, (Iterable<? extends CharSequence>)new TreeSet(strings), openOptionArray);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean appendIdsSafe(@NotNull Path path, @NotNull Set<PluginId> ids, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            void var13_14;
            void destination$iv;
            void $this$mapTo$iv;
            Iterable iterable = ids;
            Collection collection = new LinkedHashSet();
            Path path2 = path;
            PluginStringSetFile pluginStringSetFile = this;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                PluginId pluginId = (PluginId)item$iv;
                var13_14 = destination$iv;
                boolean bl = false;
                var13_14.add(it.getIdString());
            }
            var13_14 = destination$iv;
            pluginStringSetFile.append(path2, (Set)var13_14);
            return true;
        }
        catch (IOException e) {
            logger.warn("failed to append plugin strings to " + path, (Throwable)e);
            return false;
        }
    }

    @NotNull
    public final synchronized Set<String> consumeSafe(@NotNull Path path, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            Set<String> ids = this.read(path);
            if (!ids.isEmpty()) {
                Files.delete(path);
            }
            return ids;
        }
        catch (IOException e) {
            logger.error(((Object)path).toString(), (Throwable)e);
            return SetsKt.emptySet();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Set<PluginId> consumeIdsSafe(@NotNull Path path, @NotNull Logger logger) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Iterable iterable = this.consumeSafe(path, logger);
        Collection collection = new LinkedHashSet();
        PluginId.Companion companion = PluginId.Companion;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            String string = (String)item$iv;
            void var11_11 = destination$iv;
            boolean bl = false;
            var11_11.add(companion.getId((String)p0));
        }
        return (Set)destination$iv;
    }

    @NotNull
    public final synchronized Set<String> readSafe(@NotNull Path path, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        try {
            return this.read(path);
        }
        catch (IOException e) {
            log.warn("Unable to read plugin string set from: " + path, (Throwable)e);
            return SetsKt.emptySet();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Set<PluginId> readIdsSafe(@NotNull Path path, @NotNull Logger log) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Iterable iterable = this.readSafe(path, log);
        Collection collection = new LinkedHashSet();
        PluginId.Companion companion = PluginId.Companion;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            String string = (String)item$iv;
            void var11_11 = destination$iv;
            boolean bl = false;
            var11_11.add(companion.getId((String)p0));
        }
        return (Set)destination$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final synchronized Set<String> read(@NotNull Path path) throws IOException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Set set;
            object = Files.lines(path);
            Throwable throwable = null;
            try {
                Stream lines = (Stream)object;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)lines);
                set = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)lines), (Function1)read.1.1.INSTANCE), PluginStringSetFile::read$lambda$0$0));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = set;
        }
        catch (NoSuchFileException noSuchFileException) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    private static final boolean read$lambda$0$0(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return !(((CharSequence)line).length() == 0);
    }
}

