/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleDescriptor;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0007J\u001a\u0010\u000e\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u000f\u001a\u00020\nH\u0007J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0007J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0007J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0002R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/ide/plugins/PluginUtils;", "", "<init>", "()V", "toPluginIdSet", "", "Lcom/intellij/openapi/extensions/PluginId;", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "parseAsPluginIdSet", "", "toPluginDescriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "joinedPluginIds", "operation", "pluginPathToUserString", "file", "Ljava/nio/file/Path;", "findLoadedClassHandle", "Ljava/lang/invoke/MethodHandle;", "getFindLoadedClassHandle", "()Ljava/lang/invoke/MethodHandle;", "findLoadedClassHandle$delegate", "Lkotlin/Lazy;", "getPluginDescriptorOrPlatformByClassName", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "className", "getPluginDescriptorIfIdeaClassLoaderIsUsed", "aClass", "Ljava/lang/Class;", "findClassInPluginThatUsesCoreClassloader", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginUtils.kt\ncom/intellij/ide/plugins/PluginUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1634#2,3:125\n1617#2,9:131\n1869#2:140\n1870#2:142\n1626#2:143\n1163#3,3:128\n1#4:141\n*S KotlinDebug\n*F\n+ 1 PluginUtils.kt\ncom/intellij/ide/plugins/PluginUtils\n*L\n20#1:125,3\n31#1:131,9\n31#1:140\n31#1:142\n31#1:143\n26#1:128,3\n31#1:141\n*E\n"})
public final class PluginUtils {
    @NotNull
    public static final PluginUtils INSTANCE = new PluginUtils();
    @NotNull
    private static final Lazy findLoadedClassHandle$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, PluginUtils::findLoadedClassHandle_delegate$lambda$0);

    private PluginUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Set<PluginId> toPluginIdSet(@NotNull Iterable<? extends IdeaPluginDescriptor> $this$toPluginIdSet) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter($this$toPluginIdSet, (String)"<this>");
        Iterable<? extends IdeaPluginDescriptor> iterable = $this$toPluginIdSet;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getPluginId());
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Set<PluginId> parseAsPluginIdSet(@NotNull Iterable<String> $this$parseAsPluginIdSet) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter($this$parseAsPluginIdSet, (String)"<this>");
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence($this$parseAsPluginIdSet), PluginUtils::parseAsPluginIdSet$lambda$0), PluginUtils::parseAsPluginIdSet$lambda$1);
        Collection collection = new LinkedHashSet();
        PluginId.Companion companion = PluginId.Companion;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            void destination$iv;
            String string = (String)item$iv;
            void var9_9 = destination$iv;
            boolean bl = false;
            var9_9.add(companion.getId((String)p0));
        }
        return (Set)collection;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<IdeaPluginDescriptorImpl> toPluginDescriptors(@NotNull Iterable<PluginId> $this$toPluginDescriptors) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toPluginDescriptors, (String)"<this>");
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
        Iterable<PluginId> $this$mapNotNull$iv = $this$toPluginDescriptors;
        boolean $i$f$mapNotNull = false;
        Iterable<PluginId> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IdeaPluginDescriptorImpl it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PluginId it = (PluginId)element$iv$iv;
            boolean bl2 = false;
            if (pluginIdMap.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final String joinedPluginIds(@NotNull Iterable<PluginId> $this$joinedPluginIds, @NotNull String operation) {
        Intrinsics.checkNotNullParameter($this$joinedPluginIds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return CollectionsKt.joinToString$default($this$joinedPluginIds, null, (CharSequence)("Plugins to " + operation + ": ["), (CharSequence)"]", (int)0, null, PluginUtils::joinedPluginIds$lambda$0, (int)25, null);
    }

    @JvmStatic
    @NotNull
    public static final String pluginPathToUserString(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return StringsKt.replace$default((String)((Object)file).toString(), (String)(System.getProperty("user.home") + File.separatorChar), (String)("" + '~' + File.separatorChar), (boolean)false, (int)4, null);
    }

    private final MethodHandle getFindLoadedClassHandle() {
        Lazy lazy = findLoadedClassHandle$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (MethodHandle)object;
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        PluginSet pluginSet = PluginManagerCore.getPluginSetOrNull();
        if (pluginSet == null || PluginManagerCore.isPlatformClass(className) || !StringsKt.contains$default((CharSequence)className, (char)'.', (boolean)false, (int)2, null)) {
            return null;
        }
        IdeaPluginDescriptorImpl result = null;
        for (PluginModuleDescriptor descriptor : pluginSet.getEnabledModules()) {
            ClassLoader classLoader = descriptor.getPluginClassLoader();
            if (classLoader instanceof UrlClassLoader) {
                if (!((UrlClassLoader)classLoader).hasLoadedClass(className)) continue;
                result = descriptor;
                break;
            }
            if (classLoader == null || INSTANCE.getFindLoadedClassHandle().invoke(classLoader, className) == null) continue;
            result = descriptor;
            break;
        }
        if (result == null) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)result.getPluginId()) || StringsKt.startsWith$default((String)className, (String)"com.jetbrains.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"org.jetbrains.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"com.intellij.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"org.intellij.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"com.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"git4idea.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"org.angularjs.", (boolean)false, (int)2, null)) {
            return (PluginDescriptor)result;
        }
        return (PluginDescriptor)INSTANCE.findClassInPluginThatUsesCoreClassloader(className, pluginSet);
    }

    @ApiStatus.Internal
    @Nullable
    public final PluginDescriptor getPluginDescriptorIfIdeaClassLoaderIsUsed(@NotNull Class<?> aClass) {
        PluginSet pluginSet;
        String className;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
                className = aClass.getName();
                pluginSet = PluginManagerCore.getPluginSetOrNull();
                if (pluginSet == null) break block2;
                Intrinsics.checkNotNull((Object)className);
                if (!PluginManagerCore.isPlatformClass(className) && StringsKt.contains$default((CharSequence)className, (char)'.', (boolean)false, (int)2, null)) break block3;
            }
            return null;
        }
        return (PluginDescriptor)this.findClassInPluginThatUsesCoreClassloader(className, pluginSet);
    }

    private final IdeaPluginDescriptorImpl findClassInPluginThatUsesCoreClassloader(String className, PluginSet pluginSet) {
        String root = null;
        for (PluginMainDescriptor descriptor : pluginSet.enabledPlugins) {
            if (!descriptor.getUseIdeaClassLoader()) continue;
            if (root == null && (root = PathManager.getResourceRoot((ClassLoader)descriptor.getClassLoader(), (String)(StringsKt.replace$default((String)className, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class"))) == null) {
                return null;
            }
            Path path = descriptor.getPluginPath();
            if (!StringsKt.startsWith$default(root, (String)PathsKt.getInvariantSeparatorsPathString((Path)path), (boolean)false, (int)2, null)) continue;
            return descriptor;
        }
        return null;
    }

    private static final String parseAsPluginIdSet$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean parseAsPluginIdSet$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    private static final CharSequence joinedPluginIds$lambda$0(PluginId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIdString();
    }

    private static final MethodHandle findLoadedClassHandle_delegate$lambda$0() {
        Class[] classArray = new Class[]{String.class};
        Method method = ClassLoader.class.getDeclaredMethod("findLoadedClass", classArray);
        method.setAccessible(true);
        return MethodHandles.lookup().unreflect(method);
    }
}

