/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ThreadingRuntimeFlagsKt;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandDescriptor;
import com.intellij.openapi.command.impl.CommandIdService;
import com.intellij.openapi.command.impl.CommandPublisher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreCommandProcessor
extends CommandProcessorEx {
    @ApiStatus.Internal
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.impl");
    private final CommandPublisher eventPublisher = new CommandPublisher();
    private final Stack<@Nullable CommandDescriptor> interruptedCommands = new Stack();
    @Nullable
    private CommandDescriptor currentCommand;
    private int undoTransparentCount;
    private int allowMergeGlobalCommandsCount;

    public void executeCommand(@Nullable Project project, @NotNull Runnable runnable, @Nullable String name, @Nullable Object groupId) {
        if (runnable == null) {
            CoreCommandProcessor.$$$reportNull$$$0(0);
        }
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    public void executeCommand(@Nullable Project project, @NotNull Runnable runnable, @Nullable String name, @Nullable Object groupId, @Nullable Document document) {
        if (runnable == null) {
            CoreCommandProcessor.$$$reportNull$$$0(1);
        }
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT, document);
    }

    public void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(2);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(3);
        }
        this.executeCommand(project, command, name, groupId, undoConfirmationPolicy, null);
    }

    public void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, @Nullable Document document) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(4);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(5);
        }
        this.executeCommand(project, command, name, groupId, undoConfirmationPolicy, true, document);
    }

    public void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordCommandForActiveDocument) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(6);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(7);
        }
        this.executeCommand(project, command, name, groupId, undoConfirmationPolicy, shouldRecordCommandForActiveDocument, null);
    }

    public void executeCommand(@Nullable Project project, @NotNull Runnable command, @NlsContexts.Command @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordCommandForActiveDocument, @Nullable Document document) {
        CommandDescriptor descriptor;
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(8);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("executeCommand: %s, name = %s, groupId = %s, in command = %s, in transparent action = %s", command, name, groupId, this.currentCommand == null ? "<null>" : this.currentCommand.getName(), this.isUndoTransparentActionInProgress()));
        }
        if (project != null && project.isDisposed()) {
            LOG.error("Failed to start a command because " + project + " is already disposed");
            return;
        }
        if (this.currentCommand != null) {
            CoreCommandProcessor.runCommandTask(command);
            return;
        }
        this.currentCommand = descriptor = new CommandDescriptor(command, project, name, groupId, undoConfirmationPolicy, shouldRecordCommandForActiveDocument, document);
        Runnable commandTask = () -> {
            Throwable throwable = null;
            try {
                this.fireCommandStarted();
                command.run();
            }
            catch (Throwable th) {
                throwable = th;
            }
            finally {
                Throwable finalThrowable = throwable;
                ProgressManager.getInstance().executeNonCancelableSection(() -> this.finishCommand(descriptor, finalThrowable));
                if (finalThrowable instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)finalThrowable;
                }
            }
        };
        CoreCommandProcessor.runCommandTask(commandTask);
    }

    @Override
    @Nullable
    public CommandToken startCommand(@Nullable Project project, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        CommandDescriptor descriptor;
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (project != null && project.isDisposed()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("startCommand: name = " + name + ", groupId = " + groupId);
        }
        if (this.currentCommand != null) {
            return null;
        }
        this.currentCommand = descriptor = new CommandDescriptor(EmptyRunnable.INSTANCE, project, name, groupId, undoConfirmationPolicy, true, CoreCommandProcessor.getDocumentFromGroupId(groupId));
        this.fireCommandStarted();
        return descriptor;
    }

    @Override
    public void finishCommand(@NotNull CommandToken command, @Nullable Throwable throwable) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.currentCommand != null, (Object)"no current command in progress");
        this.fireCommandFinished();
    }

    @Override
    public void enterModal() {
        ThreadingAssertions.assertEventDispatchThread();
        this.interruptedCommands.push((Object)this.currentCommand);
        if (this.currentCommand != null) {
            this.fireCommandFinished();
        }
    }

    @Override
    public void leaveModal() {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.currentCommand == null, (Object)("Command must not run: " + this.currentCommand));
        this.currentCommand = (CommandDescriptor)this.interruptedCommands.pop();
        if (this.currentCommand != null) {
            this.fireCommandStarted();
        }
    }

    public void setCurrentCommandName(String name) {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.currentCommand != null);
        this.currentCommand = this.currentCommand.withName(name);
    }

    public void setCurrentCommandGroupId(Object groupId) {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.currentCommand != null);
        this.currentCommand = this.currentCommand.withGroupId(groupId);
    }

    @Nullable
    public Runnable getCurrentCommand() {
        return (Runnable)ObjectUtils.doIfNotNull((Object)this.currentCommand, command -> command.getCommand());
    }

    @Nullable
    public String getCurrentCommandName() {
        if (this.currentCommand != null) {
            return this.currentCommand.getName();
        }
        if (!this.interruptedCommands.isEmpty()) {
            return (String)ObjectUtils.doIfNotNull((Object)((CommandDescriptor)this.interruptedCommands.peek()), command -> command.getName());
        }
        return null;
    }

    @Nullable
    public Object getCurrentCommandGroupId() {
        if (this.currentCommand != null) {
            return this.currentCommand.getGroupId();
        }
        if (!this.interruptedCommands.isEmpty()) {
            return ObjectUtils.doIfNotNull((Object)((CommandDescriptor)this.interruptedCommands.peek()), command -> command.getGroupId());
        }
        return null;
    }

    @Nullable
    public Project getCurrentCommandProject() {
        return (Project)ObjectUtils.doIfNotNull((Object)this.currentCommand, command -> command.getProject());
    }

    public void addCommandListener(@NotNull CommandListener listener) {
        if (listener == null) {
            CoreCommandProcessor.$$$reportNull$$$0(12);
        }
        this.eventPublisher.addCommandListener(listener);
    }

    public void runUndoTransparentAction(@NotNull Runnable action2) {
        if (action2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(13);
        }
        this.startUndoTransparentAction();
        try {
            action2.run();
        }
        finally {
            this.finishUndoTransparentAction();
        }
    }

    @NotNull
    public final AutoCloseable withUndoTransparentAction() {
        this.startUndoTransparentAction();
        AutoCloseable autoCloseable = () -> this.finishUndoTransparentAction();
        if (autoCloseable == null) {
            CoreCommandProcessor.$$$reportNull$$$0(14);
        }
        return autoCloseable;
    }

    public boolean isUndoTransparentActionInProgress() {
        return this.undoTransparentCount > 0;
    }

    public void markCurrentCommandAsGlobal(@Nullable Project project) {
    }

    public void addAffectedDocuments(@Nullable Project project, Document ... docs) {
        if (docs == null) {
            CoreCommandProcessor.$$$reportNull$$$0(15);
        }
    }

    public void addAffectedFiles(@Nullable Project project, VirtualFile ... files) {
        if (files == null) {
            CoreCommandProcessor.$$$reportNull$$$0(16);
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public boolean isMergeGlobalCommandsAllowed() {
        return this.allowMergeGlobalCommandsCount > 0;
    }

    @Override
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public AccessToken allowMergeGlobalCommands() {
        ThreadingAssertions.assertWriteIntentReadAccess();
        ++this.allowMergeGlobalCommandsCount;
        return new AccessToken(){

            public void finish() {
                ThreadingAssertions.assertWriteIntentReadAccess();
                CoreCommandProcessor.this.allowMergeGlobalCommandsCount--;
            }
        };
    }

    public void allowMergeGlobalCommands(@NotNull Runnable action2) {
        if (action2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(17);
        }
        try (AccessToken ignored = this.allowMergeGlobalCommands();){
            action2.run();
        }
    }

    @ApiStatus.Internal
    protected boolean isCommandTokenActive(@NotNull CommandToken command) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(18);
        }
        return command.equals(this.currentCommand);
    }

    private void startUndoTransparentAction() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("runUndoTransparentAction in command = " + (this.currentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (this.undoTransparentCount++ == 0) {
            CommandIdService.advanceTransparentCommandId();
            this.eventPublisher.undoTransparentActionStarted();
        }
    }

    private void finishUndoTransparentAction() {
        if (this.undoTransparentCount == 1) {
            this.eventPublisher.beforeUndoTransparentActionFinished();
        }
        if (--this.undoTransparentCount == 0) {
            this.eventPublisher.undoTransparentActionFinished();
        }
    }

    private void fireCommandStarted() {
        CommandIdService.advanceCommandId();
        CommandEvent event = this.createCurrentCommandEvent();
        this.eventPublisher.commandStarted(event);
    }

    private void fireCommandFinished() {
        CommandEvent event = this.createCurrentCommandEvent();
        try {
            this.eventPublisher.beforeCommandFinished(event);
        }
        finally {
            this.currentCommand = null;
            this.eventPublisher.commandFinished(event);
        }
        LOG.debug("finishCommand: name = " + event.getCommandName() + ", groupId = " + event.getCommandGroupId());
    }

    @NotNull
    private CommandEvent createCurrentCommandEvent() {
        CommandDescriptor command = this.currentCommand;
        if (command == null) {
            throw new IllegalStateException("No current command in progress");
        }
        CommandEvent commandEvent = command.toCommandEvent(this);
        if (commandEvent == null) {
            CoreCommandProcessor.$$$reportNull$$$0(19);
        }
        return commandEvent;
    }

    @Nullable
    private static Document getDocumentFromGroupId(@Nullable Object groupId) {
        Object value;
        if (groupId instanceof Document) {
            return (Document)groupId;
        }
        if (groupId instanceof Ref && (value = ((Ref)groupId).get()) instanceof Document) {
            return (Document)value;
        }
        return null;
    }

    private static void runCommandTask(Runnable commandTask) {
        if (ThreadingRuntimeFlagsKt.getWrapCommandsInWriteIntent()) {
            WriteIntentReadAction.run((Runnable)commandTask);
        } else {
            commandTask.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoConfirmationPolicy";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/CoreCommandProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withUndoTransparentAction";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createCurrentCommandEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startCommand";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "finishCommand";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCommandListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runUndoTransparentAction";
                break;
            }
            case 14: 
            case 19: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedDocuments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedFiles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "allowMergeGlobalCommands";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCommandTokenActive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

