/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.util.DocumentEventUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ManualRangeMarker
implements Segment {
    private final boolean myGreedyLeft;
    private final boolean myGreedyRight;
    private final boolean mySurviveOnExternalChange;
    private final PersistentRangeMarker.LinesCols myLinesCols;
    private final long myRange;

    public ManualRangeMarker(int start, int end, boolean greedyLeft, boolean greedyRight, boolean surviveOnExternalChange, @Nullable PersistentRangeMarker.LinesCols linesCols) {
        this.myRange = TextRangeScalarUtil.toScalarRange((int)start, (int)end);
        this.myGreedyLeft = greedyLeft;
        this.myGreedyRight = greedyRight;
        this.mySurviveOnExternalChange = surviveOnExternalChange;
        this.myLinesCols = linesCols;
    }

    @Nullable
    public ManualRangeMarker getUpdatedRange(@NotNull DocumentEvent event, @NotNull FrozenDocument documentBefore) {
        int srcOffset;
        long newRange;
        if (event == null) {
            ManualRangeMarker.$$$reportNull$$$0(0);
        }
        if (documentBefore == null) {
            ManualRangeMarker.$$$reportNull$$$0(1);
        }
        if (this.mySurviveOnExternalChange && PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, this.myRange)) {
            Pair.NonNull<TextRange, PersistentRangeMarker.LinesCols> pair;
            PersistentRangeMarker.LinesCols linesCols = this.myLinesCols != null ? this.myLinesCols : PersistentRangeMarker.storeLinesAndCols(documentBefore, this.myRange);
            Pair.NonNull<TextRange, PersistentRangeMarker.LinesCols> nonNull = pair = linesCols == null ? null : PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
            if (pair != null) {
                return new ManualRangeMarker(((TextRange)pair.first).getStartOffset(), ((TextRange)pair.first).getEndOffset(), this.myGreedyLeft, this.myGreedyRight, true, (PersistentRangeMarker.LinesCols)pair.second);
            }
        }
        if ((newRange = RangeMarkerImpl.applyChange(event, this.myRange, this.myGreedyLeft, this.myGreedyRight, false)) == -1L) {
            return null;
        }
        int delta = 0;
        if (DocumentEventUtil.isMoveInsertion(event) && (srcOffset = event.getMoveOffset()) <= TextRangeScalarUtil.startOffset((long)newRange) && TextRangeScalarUtil.endOffset((long)newRange) <= srcOffset + event.getNewLength()) {
            delta = event.getOffset() - srcOffset;
        }
        return new ManualRangeMarker(TextRangeScalarUtil.startOffset((long)newRange) + delta, TextRangeScalarUtil.endOffset((long)newRange) + delta, this.myGreedyLeft, this.myGreedyRight, this.mySurviveOnExternalChange, null);
    }

    public int getStartOffset() {
        return TextRangeScalarUtil.startOffset((long)this.myRange);
    }

    public int getEndOffset() {
        return TextRangeScalarUtil.endOffset((long)this.myRange);
    }

    public String toString() {
        return "ManualRangeMarker " + TextRange.create((Segment)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "event";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "documentBefore";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/ManualRangeMarker";
        objectArray[2] = "getUpdatedRange";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

