/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.VarHandleWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public abstract class RedBlackTree<K> {
    static boolean VERIFY;
    private int nodeSize;
    protected Node<K> root = null;
    private volatile int modCount;
    private static final VarHandleWrapper MOD_COUNT_HANDLE;

    RedBlackTree() {
        this.verifyProperties();
    }

    void incModCount() {
        MOD_COUNT_HANDLE.getAndAdd((Object)this, 1);
    }

    int getModCount() {
        return this.modCount;
    }

    protected void rotateLeft(@NotNull Node<K> n) {
        if (n == null) {
            RedBlackTree.$$$reportNull$$$0(0);
        }
        Node<K> r = n.getRight();
        this.replaceNode(n, r);
        n.setRight(r.getLeft());
        if (r.getLeft() != null) {
            r.getLeft().setParent(n);
        }
        r.setLeft(n);
        n.setParent(r);
    }

    protected void rotateRight(@NotNull Node<K> n) {
        if (n == null) {
            RedBlackTree.$$$reportNull$$$0(1);
        }
        Node<K> l = n.getLeft();
        this.replaceNode(n, l);
        n.setLeft(l.getRight());
        if (l.getRight() != null) {
            l.getRight().setParent(n);
        }
        l.setRight(n);
        n.setParent(l);
    }

    protected void replaceNode(@NotNull Node<K> oldN, Node<K> newN) {
        Node<K> parent;
        if (oldN == null) {
            RedBlackTree.$$$reportNull$$$0(2);
        }
        if ((parent = oldN.getParent()) == null) {
            this.root = newN;
        } else if (oldN == parent.getLeft()) {
            parent.setLeft(newN);
        } else {
            parent.setRight(newN);
        }
        if (newN != null) {
            newN.setParent(parent);
        }
    }

    void onInsertNode() {
        ++this.nodeSize;
    }

    void insertCase1(Node<K> n) {
        if (n.getParent() == null) {
            ((Node)n).setBlack();
        } else {
            this.insertCase2(n);
        }
    }

    private void insertCase2(Node<K> n) {
        if (!RedBlackTree.isBlack(n.getParent())) {
            this.insertCase3(n);
        }
    }

    private void insertCase3(Node<K> n) {
        if (!RedBlackTree.isBlack(((Node)n).uncle())) {
            ((Node)n.getParent()).setBlack();
            ((Node)((Node)n).uncle()).setBlack();
            ((Node)n).grandparent().setRed();
            this.insertCase1(((Node)n).grandparent());
        } else {
            this.insertCase4(n);
        }
    }

    private void insertCase4(Node<K> n) {
        if (n == n.getParent().getRight() && n.getParent() == ((Node)n).grandparent().getLeft()) {
            this.rotateLeft(n.getParent());
            n = n.getLeft();
        } else if (n == n.getParent().getLeft() && n.getParent() == ((Node)n).grandparent().getRight()) {
            this.rotateRight(n.getParent());
            n = n.getRight();
        }
        this.insertCase5(n);
    }

    private void insertCase5(Node<K> n) {
        ((Node)n.getParent()).setBlack();
        ((Node)n).grandparent().setRed();
        if (n == n.getParent().getLeft() && n.getParent() == ((Node)n).grandparent().getLeft()) {
            this.rotateRight(((Node)n).grandparent());
        } else {
            assert (n == n.getParent().getRight());
            assert (n.getParent() == ((Node)n).grandparent().getRight());
            this.rotateLeft(((Node)n).grandparent());
        }
    }

    private static <K> void assertParentChild(Node<K> node1) {
        assert (node1 == null || node1.getParent() == null || node1.getParent().getLeft() == node1 || node1.getParent().getRight() == node1);
    }

    protected void deleteNode(@NotNull Node<K> n) {
        Node<K> child;
        if (n == null) {
            RedBlackTree.$$$reportNull$$$0(3);
        }
        this.incModCount();
        Node<K> e = n;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        assert (e == this.root) : e;
        if (n.getLeft() != null && n.getRight() != null) {
            Node<K> predNode = this.maximumNode(n.getLeft());
            n = this.swapWithMaxPred(n, predNode);
        }
        assert (n.getLeft() == null || n.getRight() == null);
        Node<K> node = child = n.getRight() == null ? n.getLeft() : n.getRight();
        if (RedBlackTree.isBlack(n)) {
            n.setColor(RedBlackTree.isBlack(child));
            this.deleteCase1(n);
        }
        this.replaceNode(n, child);
        if (!RedBlackTree.isBlack(this.root)) {
            ((Node)this.root).setBlack();
        }
        assert (this.nodeSize > 0) : this.nodeSize;
        --this.nodeSize;
        this.verifyProperties();
    }

    @NotNull
    protected abstract Node<K> swapWithMaxPred(@NotNull Node<K> var1, @NotNull Node<K> var2);

    @NotNull
    protected Node<K> maximumNode(@NotNull Node<K> n) {
        if (n == null) {
            RedBlackTree.$$$reportNull$$$0(4);
        }
        while (n.getRight() != null) {
            n = n.getRight();
        }
        Node<K> node = n;
        if (node == null) {
            RedBlackTree.$$$reportNull$$$0(5);
        }
        return node;
    }

    private void deleteCase1(Node<K> n) {
        if (n.getParent() != null) {
            this.deleteCase2(n);
        }
    }

    private void deleteCase2(Node<K> n) {
        if (!RedBlackTree.isBlack(((Node)n).sibling())) {
            n.getParent().setRed();
            ((Node)((Node)n).sibling()).setBlack();
            if (n == n.getParent().getLeft()) {
                this.rotateLeft(n.getParent());
            } else {
                this.rotateRight(n.getParent());
            }
        }
        this.deleteCase3(n);
    }

    private void deleteCase3(Node<K> n) {
        if (RedBlackTree.isBlack(n.getParent()) && RedBlackTree.isBlack(((Node)n).sibling()) && RedBlackTree.isBlack(((Node)n).sibling().getLeft()) && RedBlackTree.isBlack(((Node)n).sibling().getRight())) {
            ((Node)n).sibling().setRed();
            this.deleteCase1(n.getParent());
        } else {
            this.deleteCase4(n);
        }
    }

    private void deleteCase4(Node<K> n) {
        if (!RedBlackTree.isBlack(n.getParent()) && RedBlackTree.isBlack(((Node)n).sibling()) && RedBlackTree.isBlack(((Node)n).sibling().getLeft()) && RedBlackTree.isBlack(((Node)n).sibling().getRight())) {
            ((Node)n).sibling().setRed();
            ((Node)n.getParent()).setBlack();
        } else {
            this.deleteCase5(n);
        }
    }

    private void deleteCase5(Node<K> n) {
        if (n == n.getParent().getLeft() && RedBlackTree.isBlack(((Node)n).sibling()) && !RedBlackTree.isBlack(((Node)n).sibling().getLeft()) && RedBlackTree.isBlack(((Node)n).sibling().getRight())) {
            ((Node)n).sibling().setRed();
            ((Node)n).sibling().getLeft().setBlack();
            this.rotateRight(((Node)n).sibling());
        } else if (n == n.getParent().getRight() && RedBlackTree.isBlack(((Node)n).sibling()) && !RedBlackTree.isBlack(((Node)n).sibling().getRight()) && RedBlackTree.isBlack(((Node)n).sibling().getLeft())) {
            ((Node)n).sibling().setRed();
            ((Node)n).sibling().getRight().setBlack();
            this.rotateLeft(((Node)n).sibling());
        }
        this.deleteCase6(n);
    }

    private void deleteCase6(Node<K> n) {
        ((Node)n).sibling().setColor(RedBlackTree.isBlack(n.getParent()));
        ((Node)n.getParent()).setBlack();
        if (n == n.getParent().getLeft()) {
            assert (!RedBlackTree.isBlack(((Node)n).sibling().getRight()));
            ((Node)n).sibling().getRight().setBlack();
            this.rotateLeft(n.getParent());
        } else {
            assert (!RedBlackTree.isBlack(((Node)n).sibling().getLeft()));
            ((Node)n).sibling().getLeft().setBlack();
            this.rotateRight(n.getParent());
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public static void runAssertingInternalInvariants(@NotNull ThrowableRunnable<?> runnable) throws Throwable {
        if (runnable == null) {
            RedBlackTree.$$$reportNull$$$0(6);
        }
        boolean old = VERIFY;
        VERIFY = true;
        try {
            runnable.run();
        }
        finally {
            VERIFY = old;
        }
    }

    protected int size() {
        return this.nodeSize;
    }

    int nodeSize() {
        return this.nodeSize;
    }

    protected void verifyProperties() {
        if (VERIFY) {
            RedBlackTree.verifyProperty1(this.root);
            RedBlackTree.verifyProperty2(this.root);
            RedBlackTree.verifyProperty4(this.root);
            RedBlackTree.verifyProperty5(this.root);
        }
    }

    private static void verifyProperty1(Node<?> n) {
        if (n == null) {
            return;
        }
        assert (n.getParent() != n);
        assert (n.getLeft() != n);
        assert (n.getRight() != n);
        RedBlackTree.assertParentChild(n);
        RedBlackTree.verifyProperty1(n.getLeft());
        RedBlackTree.verifyProperty1(n.getRight());
    }

    private static void verifyProperty2(Node<?> root) {
        assert (RedBlackTree.isBlack(root));
    }

    @Contract(pure=true)
    private static boolean isBlack(@Nullable Node<?> n) {
        return n == null || n.isBlack();
    }

    private static void verifyProperty4(Node<?> n) {
        if (!RedBlackTree.isBlack(n)) {
            assert (RedBlackTree.isBlack(n.getLeft()));
            assert (RedBlackTree.isBlack(n.getRight()));
            assert (RedBlackTree.isBlack(n.getParent()));
        }
        if (n == null) {
            return;
        }
        RedBlackTree.verifyProperty4(n.getLeft());
        RedBlackTree.verifyProperty4(n.getRight());
    }

    private static void verifyProperty5(Node<?> root) {
        RedBlackTree.verifyProperty5Helper(root, 0, -1);
    }

    private static int verifyProperty5Helper(Node<?> n, int blackCount, int pathBlackCount) {
        if (RedBlackTree.isBlack(n)) {
            ++blackCount;
        }
        if (n == null) {
            if (pathBlackCount == -1) {
                pathBlackCount = blackCount;
            } else assert (blackCount == pathBlackCount);
            return pathBlackCount;
        }
        pathBlackCount = RedBlackTree.verifyProperty5Helper(n.getLeft(), blackCount, pathBlackCount);
        pathBlackCount = RedBlackTree.verifyProperty5Helper(n.getRight(), blackCount, pathBlackCount);
        return pathBlackCount;
    }

    protected void clear() {
        this.incModCount();
        this.root = null;
        this.nodeSize = 0;
    }

    static {
        MOD_COUNT_HANDLE = VarHandleWrapper.getFactory().create(RedBlackTree.class, "modCount", Integer.TYPE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldN";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RedBlackTree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RedBlackTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "maximumNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deleteNode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "maximumNode";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runAssertingInternalInvariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class Node<K> {
        protected Node<K> left;
        protected Node<K> right;
        protected Node<K> parent;
        private volatile byte myFlags;
        private static final VarHandleWrapper MY_FLAGS_HANDLER = VarHandleWrapper.getFactory().create(Node.class, "myFlags", Byte.TYPE);
        static final byte COLOR_MASK = 1;

        protected Node() {
        }

        @Contract(pure=true)
        @ApiStatus.Internal
        protected boolean isFlagSet(byte mask) {
            return BitUtil.isSet((byte)this.myFlags, (byte)mask);
        }

        protected void setFlag(byte mask, boolean value) {
            byte flags;
            while (!MY_FLAGS_HANDLER.compareAndSetByte((Object)this, flags = this.myFlags, BitUtil.set((byte)flags, (byte)mask, (boolean)value))) {
            }
        }

        private Node<K> grandparent() {
            assert (this.getParent() != null);
            assert (this.getParent().getParent() != null);
            return this.getParent().getParent();
        }

        private Node<K> sibling() {
            Node<K> parent = this.getParent();
            assert (parent != null);
            return this == parent.getLeft() ? parent.getRight() : parent.getLeft();
        }

        private Node<K> uncle() {
            assert (this.getParent() != null);
            assert (this.getParent().getParent() != null);
            return super.sibling();
        }

        protected Node<K> getLeft() {
            return this.left;
        }

        protected void setLeft(Node<K> left) {
            this.left = left;
        }

        protected Node<K> getRight() {
            return this.right;
        }

        protected void setRight(Node<K> right) {
            this.right = right;
        }

        protected Node<K> getParent() {
            return this.parent;
        }

        protected void setParent(Node<K> parent) {
            this.parent = parent;
        }

        protected abstract boolean processAliveKeys(@NotNull Processor<? super K> var1);

        protected abstract boolean hasAliveKey(boolean var1);

        @Contract(pure=true)
        protected boolean isBlack() {
            return this.isFlagSet((byte)1);
        }

        private void setBlack() {
            this.setFlag((byte)1, true);
        }

        void setRed() {
            this.setFlag((byte)1, false);
        }

        protected void setColor(boolean isBlack) {
            this.setFlag((byte)1, isBlack);
        }
    }
}

