/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSetEx;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.containers.IdBitSet;
import com.intellij.util.indexing.containers.IntIdsIterator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class CompactVirtualFileSet
extends AbstractSet<VirtualFile>
implements VirtualFileSetEx {
    @VisibleForTesting
    public static final int INT_SET_LIMIT = 10;
    @VisibleForTesting
    public static final int BIT_SET_LIMIT = 1000;
    @VisibleForTesting
    public static final int PARTITION_BIT_SET_LIMIT = 20000;
    private static final int PARTITION_BIT_SET_THRESHOLD = 25;
    private static final int PARTITION_BIT_SET_PARTITION_SIZE = 2048;
    private final Set<VirtualFile> weirdFiles;
    @Nullable
    private SetStorage storage;
    private boolean frozen;

    @VisibleForTesting
    public CompactVirtualFileSet() {
        this.weirdFiles = new HashSet<VirtualFile>();
    }

    CompactVirtualFileSet(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(0);
        }
        this.weirdFiles = new HashSet<VirtualFile>();
        this.addAll(files);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public CompactVirtualFileSet(@NotNull IntSet fileIds) {
        if (fileIds == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(1);
        }
        this.weirdFiles = new HashSet<VirtualFile>();
        this.storage = new IntSetStorage(fileIds);
        if (this.storage.size() > 1000) {
            this.convertToBitSet();
        }
    }

    public boolean containsId(int fileId) {
        if (this.storage != null) {
            return this.storage.containsId(fileId);
        }
        for (VirtualFile file : this.weirdFiles) {
            if (!(file instanceof VirtualFileWithId) || ((VirtualFileWithId)file).getId() != fileId) continue;
            return true;
        }
        return false;
    }

    public int @NotNull [] onlyInternalFileIds() {
        if (this.storage != null) {
            int[] nArray = this.storage.toIntArray();
            if (nArray == null) {
                CompactVirtualFileSet.$$$reportNull$$$0(2);
            }
            return nArray;
        }
        int[] nArray = this.weirdFiles.stream().filter(f -> f instanceof VirtualFileWithId).mapToInt(f -> ((VirtualFileWithId)f).getId()).toArray();
        if (nArray == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(3);
        }
        return nArray;
    }

    @Override
    public boolean contains(Object file) {
        if (file instanceof VirtualFileWithId) {
            int id = ((VirtualFileWithId)file).getId();
            if (this.storage != null) {
                return this.storage.containsId(id);
            }
        }
        return this.weirdFiles.contains(file);
    }

    @Override
    public boolean add(@NotNull VirtualFile file) {
        if (file == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(4);
        }
        this.assertNotFrozen();
        if (!(file instanceof VirtualFileWithId)) {
            return this.weirdFiles.add(file);
        }
        if (this.storage == null) {
            boolean added = this.weirdFiles.add(file);
            if (this.weirdFiles.size() > 10) {
                this.convertToIntSet();
            }
            return added;
        }
        int id = ((VirtualFileWithId)file).getId();
        return this.addToStorageWithUpgradeCheck(id);
    }

    private boolean addToStorageWithUpgradeCheck(int fileId) {
        if (this.storage instanceof IntSetStorage && this.storage.shouldUpgradeBeforeAdd(fileId)) {
            this.convertToBitSet();
        }
        if (this.storage instanceof IdBitSetStorage && this.storage.shouldUpgradeBeforeAdd(fileId)) {
            this.convertToPartitionedBitSet();
        }
        return this.storage.add(fileId);
    }

    private void convertToIntSet() {
        this.storage = new IntSetStorage();
        Iterator<VirtualFile> iterator = this.weirdFiles.iterator();
        while (iterator.hasNext()) {
            VirtualFile wf = iterator.next();
            if (!(wf instanceof VirtualFileWithId)) continue;
            this.addToStorageWithUpgradeCheck(((VirtualFileWithId)wf).getId());
            iterator.remove();
        }
    }

    private void convertToBitSet() {
        IntIterator iterator = this.storage.intIterator();
        this.storage = new IdBitSetStorage();
        while (iterator.hasNext()) {
            this.addToStorageWithUpgradeCheck(iterator.nextInt());
        }
    }

    private void convertToPartitionedBitSet() {
        IntIterator iterator = this.storage.intIterator();
        this.storage = new PartitionedBitSetStorage();
        while (iterator.hasNext()) {
            this.storage.add(iterator.nextInt());
        }
    }

    @Override
    public boolean remove(Object o) {
        this.assertNotFrozen();
        if (this.weirdFiles.remove(o)) {
            return true;
        }
        if (!(o instanceof VirtualFileWithId)) {
            return false;
        }
        int fileId = ((VirtualFileWithId)o).getId();
        if (this.storage != null) {
            return this.storage.remove(fileId);
        }
        return false;
    }

    @Override
    public void clear() {
        this.assertNotFrozen();
        this.weirdFiles.clear();
        this.storage = null;
    }

    public void freeze() {
        this.frozen = true;
    }

    @NotNull
    public @Unmodifiable Set<VirtualFile> freezed() {
        this.freeze();
        CompactVirtualFileSet compactVirtualFileSet = this;
        if (compactVirtualFileSet == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(5);
        }
        return compactVirtualFileSet;
    }

    public boolean process(@NotNull Processor<? super VirtualFile> processor) {
        if (processor == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(6);
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        if (this.storage != null) {
            IntIterator iterator = this.storage.intIterator();
            while (iterator.hasNext()) {
                VirtualFile file = virtualFileManager.findFileById(iterator.nextInt());
                if (file == null || processor.process((Object)file)) continue;
                return false;
            }
        }
        for (VirtualFile t : this.weirdFiles) {
            if (processor.process((Object)t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return (this.storage != null ? this.storage.size() : 0) + this.weirdFiles.size();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(7);
        }
        this.assertNotFrozen();
        if (c instanceof CompactVirtualFileSet) {
            CompactVirtualFileSet compactVirtualFileSet = (CompactVirtualFileSet)c;
            boolean modified = false;
            if (this.storage != null) {
                IntIterator iterator = this.storage.intIterator();
                while (iterator.hasNext()) {
                    int id = iterator.nextInt();
                    if (compactVirtualFileSet.containsId(id)) continue;
                    iterator.remove();
                    modified = true;
                }
            }
            Iterator<VirtualFile> it = this.weirdFiles.iterator();
            while (it.hasNext()) {
                VirtualFile file = it.next();
                if (c.contains(file)) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
        return super.retainAll(c);
    }

    private void assertNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Must not mutate the set after freeze() was called");
        }
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends VirtualFile> c) {
        if (c == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(8);
        }
        this.assertNotFrozen();
        if (c instanceof CompactVirtualFileSet) {
            boolean modified = false;
            CompactVirtualFileSet setToAdd = (CompactVirtualFileSet)c;
            for (VirtualFile file : setToAdd.weirdFiles) {
                if (!this.add(file)) continue;
                modified = true;
            }
            if (setToAdd.storage == null) {
                return modified;
            }
            if (this.storage == null) {
                this.convertToIntSet();
            }
            IntIterator toAdd = setToAdd.storage.intIterator();
            while (toAdd.hasNext()) {
                int id = toAdd.nextInt();
                this.addToStorageWithUpgradeCheck(id);
            }
            return modified;
        }
        return super.addAll(c);
    }

    @Override
    @NotNull
    public Iterator<VirtualFile> iterator() {
        final VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Iterator<VirtualFile> storageIterator = this.storage == null || this.storage.size() == 0 ? Collections.emptyIterator() : new Iterator<VirtualFile>(){
            final IntIterator iterator;
            {
                this.iterator = CompactVirtualFileSet.this.storage.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public VirtualFile next() {
                ProgressManager.checkCanceled();
                return virtualFileManager.findFileById(this.iterator.nextInt());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
        final Iterator totalIterator = ContainerUtil.concatIterators((Iterator[])new Iterator[]{storageIterator, this.weirdFiles.iterator()});
        return new Iterator<VirtualFile>(){
            VirtualFile next;
            Boolean hasNext;

            @Override
            public boolean hasNext() {
                this.findNext();
                return this.hasNext;
            }

            private void findNext() {
                if (this.hasNext == null) {
                    this.hasNext = false;
                    while (totalIterator.hasNext()) {
                        ProgressManager.checkCanceled();
                        VirtualFile t = (VirtualFile)totalIterator.next();
                        if (t == null) continue;
                        this.next = t;
                        this.hasNext = true;
                        break;
                    }
                }
            }

            @Override
            public VirtualFile next() {
                this.findNext();
                if (!this.hasNext.booleanValue()) {
                    throw new NoSuchElementException();
                }
                VirtualFile result = this.next;
                this.hasNext = null;
                return result;
            }

            @Override
            public void remove() {
                totalIterator.remove();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIds";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyInternalFileIds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "freezed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface SetStorage {
        public int size();

        public boolean containsId(int var1);

        default public int[] toIntArray() {
            int[] result = new int[this.size()];
            IntIterator iterator = this.intIterator();
            for (int i = 0; i < result.length; ++i) {
                result[i] = iterator.nextInt();
            }
            return result;
        }

        public boolean add(int var1);

        public IntIterator intIterator();

        public boolean remove(int var1);

        public boolean shouldUpgradeBeforeAdd(int var1);
    }

    private static class IntSetStorage
    implements SetStorage {
        private final IntSet set;

        IntSetStorage() {
            this.set = new IntOpenHashSet();
        }

        IntSetStorage(IntSet ids) {
            this.set = new IntOpenHashSet((IntCollection)ids);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean containsId(int id) {
            return this.set.contains(id);
        }

        @Override
        public int[] toIntArray() {
            return this.set.toIntArray();
        }

        @Override
        public boolean shouldUpgradeBeforeAdd(int id) {
            return this.set.size() >= 1000;
        }

        @Override
        public boolean add(int id) {
            return this.set.add(id);
        }

        @Override
        public boolean remove(int id) {
            return this.set.remove(id);
        }

        @Override
        public IntIterator intIterator() {
            return this.set.intIterator();
        }
    }

    private static class IdBitSetStorage
    implements SetStorage {
        private final IdBitSet set = new IdBitSet(10);

        private IdBitSetStorage() {
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean containsId(int id) {
            return this.set.contains(id);
        }

        @Override
        public boolean shouldUpgradeBeforeAdd(int id) {
            int size = this.set.size();
            if (size == 0) {
                return false;
            }
            int setMin = this.set.getMin();
            int setMax = this.set.getMax();
            if (setMin <= id && id <= setMax) {
                return false;
            }
            int min = Math.min(setMin, id);
            int max = Math.max(setMax, id);
            if (max - min < 20000) {
                return false;
            }
            return 100 * (size + 1) / (max - min) < 25;
        }

        @Override
        public boolean add(int id) {
            return this.set.add(id);
        }

        @Override
        public boolean remove(int id) {
            return this.set.remove(id);
        }

        @Override
        public IntIterator intIterator() {
            return new IdBitSetIterator(this.set);
        }
    }

    private static class PartitionedBitSetStorage
    implements SetStorage {
        private final Int2ObjectMap<BitSet> map = new Int2ObjectOpenHashMap();

        private PartitionedBitSetStorage() {
        }

        @Override
        public int size() {
            int result = 0;
            for (Int2ObjectMap.Entry entry : this.map.int2ObjectEntrySet()) {
                result += ((BitSet)entry.getValue()).cardinality();
            }
            return result;
        }

        @Override
        public boolean containsId(int id) {
            BitSet partition = (BitSet)this.map.get(id / 2048);
            return partition != null && partition.get(id % 2048);
        }

        @Override
        public boolean shouldUpgradeBeforeAdd(int id) {
            return false;
        }

        @Override
        public boolean add(int id) {
            BitSet partition = (BitSet)this.map.computeIfAbsent(id / 2048, k -> new BitSet(2047));
            if (partition.get(id % 2048)) {
                return false;
            }
            partition.set(id % 2048);
            return true;
        }

        @Override
        public boolean remove(int id) {
            BitSet partition = (BitSet)this.map.get(id / 2048);
            if (partition == null || !partition.get(id % 2048)) {
                return false;
            }
            partition.clear(id % 2048);
            if (partition.cardinality() == 0) {
                this.map.remove(id / 2048);
            }
            return true;
        }

        @Override
        public IntIterator intIterator() {
            return new PartitionedBitSetIterator(this.map);
        }
    }

    private static class PartitionedBitSetIterator
    implements IntIterator {
        private int next;
        private boolean canRemove;
        private Boolean hasNext;
        private BitSetIterator idIterator;
        private Int2ObjectMap.Entry<BitSet> curEntry;
        private final Iterator<Int2ObjectMap.Entry<BitSet>> entryIterator;

        PartitionedBitSetIterator(Int2ObjectMap<BitSet> map) {
            this.entryIterator = map.int2ObjectEntrySet().iterator();
        }

        public boolean hasNext() {
            this.canRemove = false;
            this.findNext();
            return this.hasNext;
        }

        private void findNext() {
            if (this.hasNext == null) {
                this.hasNext = false;
                int id = -1;
                if (this.curEntry != null && this.idIterator != null && this.idIterator.hasNext()) {
                    id = this.idIterator.nextInt();
                } else {
                    while (this.entryIterator.hasNext()) {
                        this.curEntry = this.entryIterator.next();
                        this.idIterator = new BitSetIterator((BitSet)this.curEntry.getValue());
                        if (!this.idIterator.hasNext()) continue;
                        id = this.idIterator.nextInt();
                        break;
                    }
                }
                if (id >= 0) {
                    int offset = this.curEntry.getIntKey() * 2048;
                    this.next = id + offset;
                    this.hasNext = true;
                }
            }
        }

        public int nextInt() {
            this.findNext();
            if (!this.hasNext.booleanValue()) {
                throw new NoSuchElementException();
            }
            this.canRemove = true;
            int result = this.next;
            this.hasNext = null;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Cannot remove element using PartitionedBitSetIterator after a call to hasNext().");
            }
            this.idIterator.remove();
            if (((BitSet)this.curEntry.getValue()).isEmpty()) {
                this.entryIterator.remove();
            }
        }
    }

    private static class BitSetIterator
    implements IntIterator {
        @NotNull
        private final BitSet myBitSet;
        private int currentBit;
        private int toRemoveBit;
        private Boolean hasNext;

        private BitSetIterator(@NotNull BitSet set) {
            if (set == null) {
                BitSetIterator.$$$reportNull$$$0(0);
            }
            this.currentBit = -1;
            this.toRemoveBit = -1;
            this.myBitSet = set;
        }

        public boolean hasNext() {
            this.findNext();
            return this.hasNext;
        }

        public int nextInt() {
            this.findNext();
            if (!this.hasNext.booleanValue()) {
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            this.toRemoveBit = this.currentBit;
            return this.currentBit;
        }

        public void remove() {
            if (this.toRemoveBit >= 0) {
                this.myBitSet.clear(this.toRemoveBit);
                this.toRemoveBit = -1;
            }
        }

        private void findNext() {
            if (this.hasNext == null) {
                this.currentBit = this.myBitSet.nextSetBit(this.currentBit + 1);
                this.hasNext = this.currentBit != -1;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/openapi/vfs/CompactVirtualFileSet$BitSetIterator", "<init>"));
        }
    }

    private static class IdBitSetIterator
    implements IntIterator {
        private final IdBitSet set;
        @NotNull
        private final IntIdsIterator iterator;
        private int toRemove;

        private IdBitSetIterator(@NotNull IdBitSet set) {
            if (set == null) {
                IdBitSetIterator.$$$reportNull$$$0(0);
            }
            this.set = set;
            this.iterator = set.intIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public int nextInt() {
            this.toRemove = this.iterator.next();
            return this.toRemove;
        }

        public void remove() {
            this.set.remove(this.toRemove);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/openapi/vfs/CompactVirtualFileSet$IdBitSetIterator", "<init>"));
        }
    }
}

