/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.impl.util;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\rJ\u0015\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/syntax/impl/util/MutableBitSet;", "", "<init>", "()V", "bitset", "", "add", "", "markerId", "", "add$intellij_platform_syntax", "contains", "", "contains$intellij_platform_syntax", "remove", "remove$intellij_platform_syntax", "ensureCapacity", "intellij.platform.syntax"})
public final class MutableBitSet {
    @NotNull
    private long[] bitset;

    public MutableBitSet() {
        int n = 0;
        long[] lArray = new long[16];
        MutableBitSet mutableBitSet = this;
        while (n < 16) {
            int n2 = n++;
            lArray[n2] = 0L;
        }
        mutableBitSet.bitset = lArray;
    }

    public final void add$intellij_platform_syntax(int markerId) {
        this.ensureCapacity(markerId);
        int index = markerId >> 6;
        this.bitset[index] = this.bitset[index] | 1L << markerId;
    }

    public final boolean contains$intellij_platform_syntax(int markerId) {
        int index = markerId >> 6;
        if (index >= this.bitset.length) {
            return false;
        }
        return (this.bitset[index] & 1L << markerId) != 0L;
    }

    public final void remove$intellij_platform_syntax(int markerId) {
        int index = markerId >> 6;
        this.bitset[index] = this.bitset[index] & (1L << markerId ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private final void ensureCapacity(int markerId) {
        int index = markerId >> 6;
        int size = this.bitset.length;
        if (index < size) {
            return;
        }
        while (index >= size) {
            size = size * 3 / 2;
        }
        long[] lArray = Arrays.copyOf(this.bitset, size);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        this.bitset = lArray;
    }
}

