/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextUtil;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ThreadContext;
import com.intellij.core.CoreBundle;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeActionUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SlowOperations;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManagerEx
implements DocumentListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(PsiDocumentManagerBase.class);
    private static final Key<Document> HARD_REF_TO_DOCUMENT = Key.create((String)"HARD_REFERENCE_TO_DOCUMENT");
    private boolean isInsideCommitHandler;
    private final Map<Document, List<Consumer<? super Document>>> documentCommitActions;
    private final Map<Object, Runnable> identifiedAllDocumentCommitActions;
    private final List<Runnable> allDocumentCommitActions;
    @ApiStatus.Internal
    protected final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentCommitProcessor myDocumentCommitProcessor;
    private final Set<Document> myUncommittedDocuments;
    private final Map<Document, Throwable> myUncommittedDocumentTraces;
    private final Key<UncommittedInfo> UNCOMMITTED_INFO_KEY;
    private boolean myPerformBackgroundCommit;
    private final ThreadLocal<Integer> myIsCommitInProgress;
    private static final ThreadLocal<Boolean> ourIsFullReparseInProgress = new ThreadLocal();
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners;
    @ApiStatus.Internal
    protected volatile boolean myUnitTestMode;

    protected PsiDocumentManagerBase(@NotNull Project project) {
        if (project == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(0);
        }
        this.documentCommitActions = CollectionFactory.createConcurrentWeakMap();
        this.identifiedAllDocumentCommitActions = new LinkedHashMap<Object, Runnable>();
        this.allDocumentCommitActions = new ArrayList<Runnable>();
        this.myUncommittedDocuments = Collections.newSetFromMap(CollectionFactory.createConcurrentWeakMap());
        this.myUncommittedDocumentTraces = CollectionFactory.createConcurrentWeakMap();
        this.UNCOMMITTED_INFO_KEY = Key.create((String)"UNCOMMITTED_INFO");
        this.myPerformBackgroundCommit = true;
        this.myIsCommitInProgress = new ThreadLocal();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myProject = project;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myDocumentCommitProcessor = (DocumentCommitProcessor)ApplicationManager.getApplication().getService(DocumentCommitProcessor.class);
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, project.getMessageBus());
        project.getMessageBus().connect((Disposable)this).subscribe(FileDocumentManagerListener.TOPIC, (Object)new FileDocumentManagerListener(){

            public void fileContentLoaded(@NotNull VirtualFile virtualFile, @NotNull Document document) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiDocumentManagerBase.this.myProject.isDisposed() || !virtualFile.isValid() ? null : PsiDocumentManagerBase.this.getCachedPsiFile(virtualFile, CodeInsightContexts.anyContext()));
                PsiDocumentManagerBase.this.fireDocumentCreated(document, psiFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "virtualFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/PsiDocumentManagerBase$1";
                objectArray[2] = "fileContentLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(1);
        }
        return this.getPsiFile(document, CodeInsightContexts.anyContext());
    }

    @ApiStatus.Experimental
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document, @NotNull CodeInsightContext context) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(3);
        }
        if (document instanceof DocumentWindow && !((DocumentWindow)document).isValid()) {
            return null;
        }
        PsiFile psiFile = this.getCachedPsiFile(document, context);
        if (psiFile != null) {
            return PsiDocumentManagerBase.ensureValidFile(psiFile, "Cached PSI");
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = this.getFileManager().findFile(virtualFile, context);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document, psiFile);
        return psiFile;
    }

    @NotNull
    private static PsiFile ensureValidFile(@NotNull PsiFile psiFile, @NotNull @NonNls String debugInfo) {
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(4);
        }
        if (debugInfo == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(5);
        }
        if (!psiFile.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)psiFile, debugInfo);
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(6);
        }
        return psiFile2;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(7);
        }
        return project;
    }

    @Override
    @ApiStatus.Internal
    public void associatePsi(@NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(9);
        }
        if (file.getProject() != this.myProject) {
            throw new IllegalArgumentException("Method associatePsi() called with file from the wrong project. Expected: " + this.myProject + " but got: " + file.getProject());
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(vFile);
        if (cachedDocument != null && cachedDocument != document) {
            throw new IllegalStateException("Can't replace existing document");
        }
        FileDocumentManagerBase.registerDocument(document, vFile);
    }

    @Nullable
    public final PsiFile getCachedPsiFile(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(10);
        }
        return this.getCachedPsiFile(document, CodeInsightContexts.anyContext());
    }

    @ApiStatus.Internal
    public final PsiFile getCachedPsiFile(@NotNull Document document, @NotNull CodeInsightContext context) {
        VirtualFile virtualFile;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(12);
        }
        return (virtualFile = FileDocumentManager.getInstance().getFile(document)) == null || !virtualFile.isValid() ? null : this.getCachedPsiFile(virtualFile, context);
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public final PsiFile getRawCachedFile(@NotNull VirtualFile virtualFile, @NotNull CodeInsightContext context) {
        if (virtualFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(14);
        }
        FileManagerEx manager = (FileManagerEx)this.getFileManager();
        return manager.getRawCachedFile(virtualFile, context);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public final @Unmodifiable List<FileViewProvider> getCachedViewProviders(@NotNull Document document) {
        VirtualFile virtualFile;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(15);
        }
        if ((virtualFile = PsiDocumentManagerBase.getVirtualFile(document)) == null) {
            List<FileViewProvider> list = Collections.emptyList();
            if (list == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<FileViewProvider> list = this.getFileManager().findCachedViewProviders(virtualFile);
        if (list == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Document document) {
        VirtualFile virtualFile;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(18);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile(document)) == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    @Nullable
    private PsiFile getCachedPsiFile(@NotNull VirtualFile virtualFile, @NotNull CodeInsightContext context) {
        if (virtualFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(20);
        }
        return this.getFileManager().getCachedPsiFile(virtualFile, context);
    }

    @NotNull
    private FileManager getFileManager() {
        FileManager fileManager = ((PsiManagerEx)this.myPsiManager).getFileManager();
        if (fileManager == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(21);
        }
        return fileManager;
    }

    public Document getDocument(@NotNull PsiFile psiFile) {
        Document document;
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(22);
        }
        if ((document = this.getCachedDocument(psiFile)) != null) {
            if (!psiFile.getViewProvider().isPhysical()) {
                PsiUtilCore.ensureValid((PsiElement)psiFile);
                this.associatePsi(document, psiFile);
            }
            return document;
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        if (!viewProvider.isEventSystemEnabled()) {
            return null;
        }
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        document = FileDocumentManager.getInstance().getDocument(virtualFile, this.myProject);
        if (document != null) {
            if (document.getTextLength() != psiFile.getTextLength()) {
                String fileText;
                String message = "Document/PSI mismatch: " + psiFile + " of " + psiFile.getClass() + "; viewProvider=" + viewProvider + "; uncommitted=" + Arrays.toString(this.getUncommittedDocuments());
                String documentText = document.getText();
                try {
                    fileText = psiFile.getText();
                }
                catch (AssertionError e) {
                    fileText = "file.getText() failed with an error: " + e;
                }
                throw new RuntimeExceptionWithAttachments(message, new Attachment[]{new Attachment("document.txt", documentText), new Attachment("psi.txt", fileText)});
            }
            if (!viewProvider.isPhysical()) {
                PsiUtilCore.ensureValid((PsiElement)psiFile);
                this.associatePsi(document, psiFile);
                psiFile.putUserData(HARD_REF_TO_DOCUMENT, (Object)document);
            }
        }
        return document;
    }

    public Document getCachedDocument(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(23);
        }
        if (!psiFile.isPhysical()) {
            return null;
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    public void commitAllDocuments() {
        ThreadingAssertions.assertEventDispatchThread();
        WriteIntentReadAction.run(() -> {
            Document[] documents;
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
            if (this.myUncommittedDocuments.isEmpty()) {
                return;
            }
            for (Document document : documents = this.getUncommittedDocuments()) {
                if (this.isCommitted(document)) {
                    if (!this.isEventSystemEnabled(document)) continue;
                    LOG.error("Committed document in uncommitted set: " + document);
                }
                if (this.doCommit(document) || !this.isEventSystemEnabled(document)) continue;
                LOG.error("Couldn't commit " + document);
            }
            LOG.assertTrue(!this.hasEventSystemEnabledUncommittedDocuments(), this.myUncommittedDocuments);
        });
    }

    public boolean commitAllDocumentsUnderProgress() {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (application.isWriteAccessAllowed()) {
                this.commitAllDocuments();
                if (!application.isUnitTestMode()) {
                    LOG.error("Do not call commitAllDocumentsUnderProgress inside write-action");
                }
                return true;
            }
            if (application.isUnitTestMode()) {
                WriteAction.run(() -> this.commitAllDocuments());
                return true;
            }
        }
        int semaphoreTimeoutInMs = 50;
        Runnable commitAllDocumentsRunnable = () -> {
            final Semaphore semaphore = new Semaphore(1);
            AppUIExecutor.onWriteThread().later().submit(() -> PsiDocumentManagerBase.getInstance((Project)this.myProject).performWhenAllCommitted(new Runnable(){

                @Override
                public void run() {
                    semaphore.up();
                }

                public String toString() {
                    return "commitAllDocumentsUnderProgress()";
                }
            }));
            while (!semaphore.waitFor(50L)) {
                ProgressManager.checkCanceled();
            }
        };
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(commitAllDocumentsRunnable, CoreBundle.message((String)"progress.title.processing.documents", (Object[])new Object[0]), true, this.myProject);
    }

    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action2) {
        Document document;
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(24);
        }
        if (action2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(25);
        }
        if (this.isCommitted(document = PsiDocumentManagerBase.getTopLevelDocument(doc))) {
            action2.run();
        } else {
            this.addRunOnCommit(document, (? super Document __) -> action2.run());
        }
    }

    @Override
    @ApiStatus.Internal
    public boolean cancelAndRunWhenAllCommitted(@NonNls @NotNull Object key, @NotNull Runnable action2) {
        if (key == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(26);
        }
        if (action2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myProject.isDisposed()) {
            action2.run();
            return true;
        }
        if (!this.hasEventSystemEnabledUncommittedDocuments()) {
            if (!this.isCommitInProgress()) assert (this.identifiedAllDocumentCommitActions.isEmpty() && this.allDocumentCommitActions.isEmpty()) : this.identifiedAllDocumentCommitActions + "; " + this.allDocumentCommitActions + "; uncommitted docs: " + StringUtil.join(this.myUncommittedDocuments, document -> document + ":isEventSystemEnabled=" + this.isEventSystemEnabled((Document)document) + ":virtualFile=" + PsiDocumentManagerBase.getVirtualFile(document), (String)",");
            action2.run();
            return true;
        }
        this.assertWeAreOutsideAfterCommitHandler();
        this.identifiedAllDocumentCommitActions.put(key, ClientId.decorateRunnable((Runnable)action2));
        return false;
    }

    @Override
    @ApiStatus.Internal
    public void addRunOnCommit(@NotNull Document document, @NotNull @NotNull Consumer<? super @NotNull Document> action2) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(28);
        }
        if (action2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(29);
        }
        List actions = this.documentCommitActions.computeIfAbsent(document, __ -> ContainerUtil.createConcurrentList());
        actions.add(ThreadContext.captureThreadContext(action2));
    }

    @Deprecated
    @ApiStatus.Internal
    public void addRunOnCommit(@NotNull Document document, @NotNull Runnable action2) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(30);
        }
        if (action2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(31);
        }
        throw new AbstractMethodError();
    }

    @NotNull
    private @Unmodifiable List<Consumer<? super Document>> getAndClearDocumentCommitActions(@NotNull Document document) {
        List<Consumer<? super Document>> list;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(32);
        }
        List<Object> list2 = (list = this.documentCommitActions.remove(document)) == null ? Collections.emptyList() : list;
        if (list2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(33);
        }
        return list2;
    }

    @NotNull
    private @Unmodifiable List<Runnable> getAndClearAllDocumentCommitActions() {
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        actions.addAll(this.identifiedAllDocumentCommitActions.values());
        actions.addAll(this.allDocumentCommitActions);
        this.identifiedAllDocumentCommitActions.clear();
        this.allDocumentCommitActions.clear();
        ArrayList<Runnable> arrayList = actions;
        if (arrayList == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    public void commitDocument(@NotNull Document doc) {
        Document document;
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(35);
        }
        if (this.isEventSystemEnabled(document = PsiDocumentManagerBase.getTopLevelDocument(doc))) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        if (!this.isCommitted(document)) {
            this.doCommit(document);
        }
    }

    @Override
    @ApiStatus.Internal
    public boolean isEventSystemEnabled(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(36);
        }
        return (Boolean)ReadAction.compute(() -> {
            List<FileViewProvider> viewProviders = this.getCachedViewProviders(document);
            return CodeInsightContextUtil.isEventSystemEnabled(viewProviders);
        });
    }

    @Override
    @ApiStatus.Internal
    public boolean finishCommit(@NotNull Document document, @NotNull @Unmodifiable List<? extends BooleanRunnable> finishProcessors, @NotNull @Unmodifiable List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, @NotNull Object reason) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(37);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(38);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(39);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(40);
        }
        assert (!this.myProject.isDisposed()) : "Already disposed";
        if (this.isEventSystemEnabled(document)) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        boolean[] ok = new boolean[]{true};
        if (synchronously) {
            ok[0] = this.finishCommitInWriteAction(document, finishProcessors, reparseInjectedProcessors, true);
        } else {
            ApplicationManager.getApplication().runWriteAction(() -> {
                ok[0] = this.finishCommitInWriteAction(document, finishProcessors, reparseInjectedProcessors, false);
            });
        }
        if (ok[0]) {
            this.runAfterCommitActions(document);
            if (DebugUtil.DO_EXPENSIVE_CHECKS && !ApplicationManagerEx.isInStressTest()) {
                this.checkAllElementsValid(document, reason);
            }
        }
        return ok[0];
    }

    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull @Unmodifiable List<? extends BooleanRunnable> finishProcessors, @NotNull @Unmodifiable List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(41);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(42);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(43);
        }
        if (this.isEventSystemEnabled(document)) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        assert (!(document instanceof DocumentWindow));
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().fastenBelts(virtualFile);
        }
        List<FileViewProvider> viewProviders = this.getCachedViewProviders(document);
        AtomicBoolean success = new AtomicBoolean(true);
        this.executeInsideCommit(() -> {
            try {
                success.set((Boolean)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
                    if (viewProviders.isEmpty()) {
                        this.handleCommitWithoutPsi(document);
                        return true;
                    }
                    return this.commitToExistingPsi(document, finishProcessors, reparseInjectedProcessors, synchronously, virtualFile);
                }));
            }
            catch (Throwable e) {
                try {
                    this.forceReload(virtualFile, viewProviders);
                }
                finally {
                    LOG.error("Exception while committing " + viewProviders + ", eventSystemEnabled=" + this.isEventSystemEnabled(document), e);
                }
            }
            finally {
                if (success.get()) {
                    this.myUncommittedDocuments.remove(document);
                    this.myUncommittedDocumentTraces.remove(document);
                }
            }
        });
        return success.get();
    }

    private boolean commitToExistingPsi(@NotNull Document document, @NotNull @Unmodifiable List<? extends BooleanRunnable> finishProcessors, @NotNull @Unmodifiable List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, @Nullable VirtualFile virtualFile) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(44);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(45);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(46);
        }
        for (BooleanRunnable booleanRunnable : finishProcessors) {
            boolean bl = booleanRunnable.run();
            if (synchronously) assert (bl) : booleanRunnable + " in " + finishProcessors;
            if (bl) continue;
            return false;
        }
        this.clearUncommittedInfo(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().updatePointerTargetsAfterReparse(virtualFile);
        }
        List<FileViewProvider> viewProviders = this.getCachedViewProviders(document);
        for (FileViewProvider fileViewProvider : viewProviders) {
            fileViewProvider.contentsSynchronized();
        }
        for (BooleanRunnable booleanRunnable : reparseInjectedProcessors) {
            if (booleanRunnable.run()) continue;
            return false;
        }
        return true;
    }

    @Override
    @ApiStatus.Internal
    public void forceReload(@Nullable VirtualFile virtualFile, @NotNull @Unmodifiable List<? extends FileViewProvider> viewProviders) {
        if (viewProviders == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(47);
        }
        if (!viewProviders.isEmpty()) {
            DebugUtil.performPsiModification("psi.forceReload", () -> {
                for (FileViewProvider viewProvider : viewProviders) {
                    ((AbstractFileViewProvider)viewProvider).markInvalidated();
                }
            });
        }
        if (virtualFile != null) {
            ((FileManagerEx)this.getFileManager()).forceReload(virtualFile);
        }
    }

    private void checkAllElementsValid(@NotNull Document document, final @NotNull Object reason) {
        PsiFile psiFile;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(48);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(49);
        }
        if ((psiFile = this.getCachedPsiFile(document)) != null) {
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!element.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element + "; Reason: '" + reason + "'"));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/PsiDocumentManagerBase$3", "visitElement"));
                }
            });
        }
    }

    private boolean doCommit(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(50);
        }
        assert (!this.isCommitInProgress()) : "Do not call commitDocument() from inside PSI change listener";
        if (this.getSynchronizer().isDocumentAffectedByTransactions(document)) {
            return false;
        }
        PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            this.myUncommittedDocuments.remove(document);
            this.myUncommittedDocumentTraces.remove(document);
            this.runAfterCommitActions(document);
            return true;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.doCommit(document, psiFile));
        } else {
            this.doCommit(document, psiFile);
        }
        return true;
    }

    private void doCommit(@NotNull Document document, @NotNull PsiFile psiFile) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(51);
        }
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(52);
        }
        assert (!this.isCommitInProgress()) : "Do not call commitDocument() from inside PSI change listener";
        this.executeInsideCommit(() -> this.myDocumentCommitProcessor.commitSynchronously(document, this.myProject, psiFile));
        assert (!this.isInUncommittedSet(document)) : "Document :" + document;
        this.runAfterCommitActions(document);
    }

    @Override
    public boolean isCommitInProgress() {
        return this.myIsCommitInProgress.get() != null || PsiDocumentManagerBase.isFullReparseInProgress();
    }

    private void executeInsideCommit(@NotNull Runnable runnable) {
        Integer counter;
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(53);
        }
        this.myIsCommitInProgress.set((counter = this.myIsCommitInProgress.get()) == null ? 1 : counter + 1);
        try {
            runnable.run();
        }
        finally {
            this.myIsCommitInProgress.set(counter);
        }
    }

    @ApiStatus.Internal
    public static boolean isFullReparseInProgress() {
        return ourIsFullReparseInProgress.get() == Boolean.TRUE;
    }

    public <T> T commitAndRunReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(54);
        }
        Ref ref = Ref.create(null);
        this.commitAndRunReadAction(() -> ref.set(computation.compute()));
        return (T)ref.get();
    }

    public void reparseFiles(@NotNull Collection<? extends VirtualFile> files, boolean includeOpenFiles) {
        if (files == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(55);
        }
        FileContentUtilCore.reparseFiles(files);
    }

    public void commitAndRunReadAction(@NotNull Runnable runnable) {
        boolean executed;
        Application application;
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(56);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            this.commitAllDocuments();
            runnable.run();
            return;
        }
        if (application.holdsReadLock()) {
            LOG.error("Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock. " + Thread.currentThread());
        }
        while (!(executed = ((Boolean)ReadAction.compute(() -> {
            if (!this.hasEventSystemEnabledUncommittedDocuments()) {
                runnable.run();
                return true;
            }
            return false;
        })).booleanValue())) {
            ModalityState modality = ModalityState.defaultModalityState();
            Semaphore semaphore = new Semaphore(1);
            AppUIExecutor.onWriteThread((ModalityState)ModalityState.any()).submit(() -> {
                if (this.myProject.isDisposed()) {
                    semaphore.up();
                    return;
                }
                this.performWhenAllCommitted(modality, () -> semaphore.up());
            });
            while (!semaphore.waitFor(10L)) {
                ProgressManager.checkCanceled();
            }
        }
    }

    public boolean performWhenAllCommitted(@NotNull Runnable action2) {
        if (action2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(57);
        }
        return this.performWhenAllCommitted(ModalityState.defaultModalityState(), action2);
    }

    private boolean performWhenAllCommitted(@NotNull ModalityState modality, @NotNull Runnable action2) {
        if (modality == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(58);
        }
        if (action2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(59);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.assertWeAreOutsideAfterCommitHandler();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (!this.hasEventSystemEnabledUncommittedDocuments()) {
            action2.run();
            return true;
        }
        this.allDocumentCommitActions.add(ThreadContext.captureThreadContext((Runnable)action2));
        if (modality != ModalityState.nonModal() && TransactionGuard.getInstance().isWriteSafeModality(modality)) {
            for (Document document : this.myUncommittedDocuments) {
                try (AccessToken ignore = SlowOperations.knownIssue((String)"IJPL-162971");){
                    this.commitAsync(document, "re-added because performWhenAllCommitted(" + modality + ") was called", modality);
                }
            }
        }
        return false;
    }

    public void performLaterWhenAllCommitted(@NotNull Runnable runnable) {
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(60);
        }
        this.performLaterWhenAllCommitted(ModalityState.defaultModalityState(), runnable);
    }

    public void performLaterWhenAllCommitted(final @NotNull ModalityState modalityState, final @NotNull Runnable runnable) {
        if (modalityState == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(61);
        }
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(62);
        }
        Runnable whenAllCommitted = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (PsiDocumentManagerBase.this.hasEventSystemEnabledUncommittedDocuments()) {
                        PsiDocumentManagerBase.this.performLaterWhenAllCommitted(runnable);
                    } else {
                        runnable.run();
                    }
                }, modalityState, PsiDocumentManagerBase.this.myProject.getDisposed());
            }

            public String toString() {
                return "performLaterWhenAllCommitted(" + runnable + ")";
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread() && this.isInsideCommitHandler()) {
            whenAllCommitted.run();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    this.performWhenAllCommitted(whenAllCommitted);
                }
            });
        }
    }

    private void runAfterCommitActions(@NotNull Document document) {
        Application app;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(63);
        }
        if (!(app = ApplicationManager.getApplication()).isDispatchThread() && this.isEventSystemEnabled(document)) {
            app.invokeLater(() -> {
                if (!this.myProject.isDisposed() && this.isCommitted(document)) {
                    this.runAfterCommitActions(document);
                }
            });
            return;
        }
        PsiDocumentManagerBase.runActions(document, this.getAndClearDocumentCommitActions(document));
        if (app.isDispatchThread()) {
            this.runActionsWhenAllCommitted();
        } else if (this.isEventSystemEnabled(document)) {
            app.invokeLater(() -> this.runActionsWhenAllCommitted(), this.myProject.getDisposed());
        }
    }

    @RequiresEdt
    private void runActionsWhenAllCommitted() {
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.mayRunActionsWhenAllCommitted()) {
            return;
        }
        this.isInsideCommitHandler = true;
        try {
            PsiDocumentManagerBase.runActions(this.getAndClearAllDocumentCommitActions());
        }
        finally {
            this.isInsideCommitHandler = false;
        }
    }

    private static void runActions(@NotNull @Unmodifiable List<? extends Runnable> actions) {
        if (actions == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(64);
        }
        ArrayList<Pair> exceptions = new ArrayList<Pair>();
        for (Runnable runnable : actions) {
            try {
                ThreadContext.resetThreadContext(() -> {
                    action2.run();
                    return null;
                });
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                exceptions.add(Pair.create((Object)runnable, (Object)e));
            }
        }
        for (Pair pair : exceptions) {
            Runnable action3 = (Runnable)pair.getFirst();
            Throwable e = (Throwable)pair.getSecond();
            LOG.error("During running " + action3, e);
        }
    }

    private static void runActions(@NotNull Document document, @NotNull @Unmodifiable List<? extends Consumer<? super Document>> actions) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(65);
        }
        if (actions == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(66);
        }
        ArrayList<Pair> exceptions = new ArrayList<Pair>();
        for (Consumer<? super Document> consumer : actions) {
            try {
                ThreadContext.resetThreadContext(() -> {
                    action2.accept(document);
                    return null;
                });
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                exceptions.add(Pair.create(consumer, (Object)e));
            }
        }
        for (Pair pair : exceptions) {
            Consumer action3 = (Consumer)pair.getFirst();
            Throwable e = (Throwable)pair.getSecond();
            LOG.error("During running " + action3, e);
        }
    }

    private boolean mayRunActionsWhenAllCommitted() {
        ThreadingAssertions.assertEventDispatchThread();
        return !this.isCommitInProgress() && (!this.identifiedAllDocumentCommitActions.isEmpty() || !this.allDocumentCommitActions.isEmpty()) && !this.hasEventSystemEnabledUncommittedDocuments();
    }

    public boolean hasEventSystemEnabledUncommittedDocuments() {
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-319884, EA-831652, IDEA-301732, EA-659436, IDEA-307614, EA-773260");){
            boolean bl = ContainerUtil.exists(this.myUncommittedDocuments, document -> this.isEventSystemEnabled((Document)document));
            return bl;
        }
    }

    private void assertWeAreOutsideAfterCommitHandler() {
        if (this.isInsideCommitHandler()) {
            throw new IncorrectOperationException("You must not call performWhenAllCommitted()/cancelAndRunWhenCommitted() from within after-commit handler");
        }
    }

    private boolean isInsideCommitHandler() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.isInsideCommitHandler;
    }

    public boolean isDocumentBlockedByPsi(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(67);
        }
        return false;
    }

    public void doPostponedOperationsAndUnblockDocument(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(68);
        }
    }

    private void fireDocumentCreated(@NotNull Document document, PsiFile file) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(69);
        }
        ((PsiDocumentListener)this.myProject.getMessageBus().syncPublisher(PsiDocumentListener.TOPIC)).documentCreated(document, file, this.myProject);
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.documentCreated(document, file);
        }
    }

    private void fireFileCreated(@NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(70);
        }
        if (file == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(71);
        }
        ((PsiDocumentListener)this.myProject.getMessageBus().syncPublisher(PsiDocumentListener.TOPIC)).fileCreated(file, document);
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.fileCreated(file, document);
        }
    }

    @NotNull
    public CharSequence getLastCommittedText(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(72);
        }
        CharSequence charSequence = this.getLastCommittedDocument(document).getImmutableCharSequence();
        if (charSequence == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(73);
        }
        return charSequence;
    }

    public long getLastCommittedStamp(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(74);
        }
        return this.getLastCommittedDocument(PsiDocumentManagerBase.getTopLevelDocument(document)).getModificationStamp();
    }

    @Nullable
    public Document getLastCommittedDocument(@NotNull PsiFile psiFile) {
        Document document;
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(75);
        }
        return (document = this.getDocument(psiFile)) == null ? null : this.getLastCommittedDocument(document);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public DocumentEx getLastCommittedDocument(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(76);
        }
        if (document instanceof FrozenDocument) {
            DocumentEx documentEx = (DocumentEx)document;
            if (documentEx == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(77);
            }
            return documentEx;
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow answer;
            DocumentWindow window = (DocumentWindow)document;
            Document delegate = window.getDelegate();
            if (delegate instanceof FrozenDocument) {
                DocumentEx documentEx = (DocumentEx)window;
                if (documentEx == null) {
                    PsiDocumentManagerBase.$$$reportNull$$$0(78);
                }
                return documentEx;
            }
            if (!window.isValid()) {
                throw new AssertionError((Object)("host committed: " + this.isCommitted(delegate) + ", window=" + window));
            }
            UncommittedInfo info = this.getUncommittedInfo(delegate);
            DocumentWindow documentWindow = answer = info == null ? null : (DocumentWindow)info.myFrozenWindows.get(window);
            if (answer == null) {
                answer = this.freezeWindow(window);
            }
            if (info != null) {
                answer = (DocumentWindow)ConcurrencyUtil.cacheOrGet((ConcurrentMap)info.myFrozenWindows, (Object)window, (Object)answer);
            }
            DocumentEx documentEx = (DocumentEx)answer;
            if (documentEx == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(79);
            }
            return documentEx;
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.getUncommittedInfo(document);
        FrozenDocument frozenDocument = info != null ? info.myFrozen : ((DocumentImpl)document).freeze();
        if (frozenDocument == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(80);
        }
        return frozenDocument;
    }

    @Nullable
    private UncommittedInfo getUncommittedInfo(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(81);
        }
        return (UncommittedInfo)document.getUserData(this.UNCOMMITTED_INFO_KEY);
    }

    private void associateUncommittedInfo(Document document, UncommittedInfo info) {
        document.putUserData(this.UNCOMMITTED_INFO_KEY, (Object)info);
    }

    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(82);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public @Unmodifiable List<DocumentEvent> getEventsSinceCommit(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(83);
        }
        assert (document instanceof DocumentImpl) : document;
        UncommittedInfo info = this.getUncommittedInfo(document);
        if (info != null) {
            return new ArrayList<DocumentEvent>(info.myEvents);
        }
        List<DocumentEvent> list = Collections.emptyList();
        if (list == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(84);
        }
        return list;
    }

    @NotNull
    public @NotNull Document @NotNull [] getUncommittedDocuments() {
        ThreadingAssertions.assertReadAccess();
        if (this.myUncommittedDocuments.isEmpty()) {
            if (Document.EMPTY_ARRAY == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(85);
            }
            return Document.EMPTY_ARRAY;
        }
        Object[] documents = this.myUncommittedDocuments.toArray(Document.EMPTY_ARRAY);
        Document[] documentArray = (Document[])ArrayUtil.stripTrailingNulls((Object[])documents);
        if (documentArray == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(86);
        }
        return documentArray;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public Map<Document, Throwable> getUncommitedDocumentsWithTraces() {
        Map<Document, Throwable> map = Collections.unmodifiableMap(this.myUncommittedDocumentTraces);
        if (map == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(87);
        }
        return map;
    }

    @Override
    @ApiStatus.Internal
    public boolean isInUncommittedSet(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(88);
        }
        return this.myUncommittedDocuments.contains(PsiDocumentManagerBase.getTopLevelDocument(document));
    }

    public boolean isUncommited(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(89);
        }
        return !this.isCommitted(document);
    }

    public boolean isCommitted(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(90);
        }
        document = PsiDocumentManagerBase.getTopLevelDocument(document);
        if (this.getSynchronizer().isInSynchronization(document)) {
            return true;
        }
        return (!(document instanceof DocumentEx) || !((DocumentEx)document).isInEventsHandling()) && !this.isInUncommittedSet(document);
    }

    @NotNull
    public static Document getTopLevelDocument(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(91);
        }
        Document document2 = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(92);
        }
        return document2;
    }

    public boolean hasUncommitedDocuments() {
        return !this.isCommitInProgress() && !this.myUncommittedDocuments.isEmpty();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        boolean isRelevant;
        if (event == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(93);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean bl = isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        if (document instanceof DocumentImpl && this.getUncommittedInfo(document) == null) {
            this.associateUncommittedInfo(document, new UncommittedInfo((DocumentImpl)document));
        }
        List<FileViewProvider> viewProviders = this.getCachedViewProviders(document);
        for (FileViewProvider viewProvider : viewProviders) {
            boolean inMyProject;
            boolean bl2 = inMyProject = viewProvider.getManager() == this.myPsiManager;
            if (!isRelevant || !inMyProject) {
                return;
            }
            List files = viewProvider.getAllFiles();
            PsiFile psiCause = null;
            for (PsiFile file : files) {
                if (file == null) {
                    throw new AssertionError((Object)("View provider " + viewProvider + " (" + viewProvider.getClass() + ") returned null in its files array: " + files + " for file " + viewProvider.getVirtualFile()));
                }
                if (!PsiToDocumentSynchronizer.isInsideAtomicChange(file)) continue;
                psiCause = file;
            }
            if (psiCause != null) continue;
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(94);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentChanged(@NotNull DocumentEvent event) {
        block18: {
            boolean forceCommit;
            if (event == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(95);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            Document document = event.getDocument();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            boolean isRelevant = virtualFile != null && this.isRelevant(virtualFile);
            List<FileViewProvider> viewProviders = this.getCachedViewProviders(document);
            if (viewProviders.isEmpty()) {
                this.handleCommitWithoutPsi(document);
                return;
            }
            if (!isRelevant) {
                this.clearUncommittedInfo(document);
                return;
            }
            List files = ContainerUtil.flatMap(viewProviders, p -> p.getAllFiles());
            if (files.isEmpty()) {
                this.handleCommitWithoutPsi(document);
                return;
            }
            boolean commitNecessary = !ContainerUtil.exists((Iterable)files, file -> PsiToDocumentSynchronizer.isInsideAtomicChange(file) || !(file instanceof PsiFileImpl));
            Application application = ApplicationManager.getApplication();
            boolean bl = forceCommit = ExternalChangeActionUtil.isExternalChangeInProgress() && (SystemProperties.getBooleanProperty((String)"idea.force.commit.on.external.change", (boolean)false) || application.isHeadlessEnvironment() && !application.isUnitTestMode());
            if (event.isWholeTextReplaced() && document.getTextLength() > 100000) {
                document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
            }
            if (commitNecessary) {
                assert (!(document instanceof DocumentWindow));
                this.myUncommittedDocuments.add(document);
                if (Registry.is((String)"ide.activity.tracking.enable.debug")) {
                    this.myUncommittedDocumentTraces.put(document, new Throwable());
                }
                if (forceCommit) {
                    this.commitDocument(document);
                } else if (!document.isInBulkUpdate() && this.myPerformBackgroundCommit) {
                    this.commitAsync(document, event, ModalityState.defaultModalityState());
                }
            } else {
                this.clearUncommittedInfo(document);
            }
            if (this.myUnitTestMode && this.isUncommited(document) && PsiDocumentManagerBase.areTooManyDocumentsInTheQueue(this.myUncommittedDocuments)) {
                try {
                    Logger.getInstance(((Object)((Object)this)).getClass()).error("Too many uncommitted documents (" + this.myUncommittedDocuments.size() + "):\n" + StringUtil.join(this.myUncommittedDocuments, (String)"\n") + this.myProject);
                    if (!PomModelImpl.isAllowPsiModification() || !ApplicationManager.getApplication().isWriteAccessAllowed()) break block18;
                    for (Document uncommitted : this.myUncommittedDocuments) {
                        if (uncommitted == document) continue;
                        this.commitDocument(uncommitted);
                        break;
                    }
                }
                finally {
                    this.clearUncommittedDocuments();
                }
            }
        }
    }

    public void bulkUpdateStarting(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(96);
        }
        document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
    }

    public void bulkUpdateFinished(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(97);
        }
        this.commitAsync(document, "Bulk update finished", ModalityState.defaultModalityState());
    }

    private void commitAsync(@NotNull Document document, @NotNull Object reason, @NotNull ModalityState modality) {
        List<FileViewProvider> viewProviders;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(98);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(99);
        }
        if (modality == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(100);
        }
        if (CodeInsightContextUtil.isEventSystemEnabled(viewProviders = this.getCachedViewProviders(document))) {
            ThreadingAssertions.assertEventDispatchThread();
            this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, this, document, reason, modality);
        }
    }

    @ApiStatus.Internal
    public static boolean areTooManyDocumentsInTheQueue(@NotNull Collection<? extends Document> documents) {
        if (documents == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(101);
        }
        if (documents.size() > 100) {
            return true;
        }
        int totalSize = 0;
        for (Document document : documents) {
            if ((totalSize += document.getTextLength()) <= FileSizeLimit.getDefaultContentLoadLimit()) continue;
            return true;
        }
        return false;
    }

    @Override
    @ApiStatus.Internal
    public void handleCommitWithoutPsi(@NotNull Document document) {
        UncommittedInfo prevInfo;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(102);
        }
        if ((prevInfo = this.clearUncommittedInfo(document)) == null) {
            return;
        }
        this.myUncommittedDocuments.remove(document);
        this.myUncommittedDocumentTraces.remove(document);
        if (!this.myProject.isInitialized() || this.myProject.isDisposed() || this.myProject.isDefault()) {
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            FileManager fileManager = this.getFileManager();
            List<FileViewProvider> viewProviders = fileManager.findCachedViewProviders(virtualFile);
            boolean isWriteAccess = ApplicationManager.getApplication().isWriteAccessAllowed();
            if (!viewProviders.isEmpty()) {
                ApplicationManager.getApplication().runWriteAction(ExternalChangeActionUtil.externalChangeAction(() -> {
                    List<FileViewProvider> effectiveViewProviders = isWriteAccess ? viewProviders : fileManager.findCachedViewProviders(virtualFile);
                    for (FileViewProvider viewProvider : effectiveViewProviders) {
                        ((AbstractFileViewProvider)viewProvider).onContentReload();
                    }
                }));
            } else if (FileIndexFacade.getInstance((Project)this.myProject).isInContent(virtualFile)) {
                ApplicationManager.getApplication().runWriteAction(ExternalChangeActionUtil.externalChangeAction(() -> ((FileManagerEx)fileManager).firePropertyChangedForUnloadedPsi()));
            }
        }
        this.runAfterCommitActions(document);
    }

    @Nullable
    private UncommittedInfo clearUncommittedInfo(@NotNull Document document) {
        UncommittedInfo info;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(103);
        }
        if ((info = this.getUncommittedInfo(document)) != null) {
            document.putUserData(this.UNCOMMITTED_INFO_KEY, null);
            this.getSmartPointerManager().updatePointers(document, info.myFrozen, info.myEvents);
        }
        return info;
    }

    private SmartPointerManagerEx getSmartPointerManager() {
        return (SmartPointerManagerEx)SmartPointerManager.getInstance((Project)this.myProject);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(104);
        }
        return !this.myProject.isDisposed() && !virtualFile.getFileType().isBinary();
    }

    public static boolean checkConsistency(@NotNull PsiFile psiFile, @NotNull Document document) {
        int i;
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(105);
        }
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(106);
        }
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        @NonNls String error = "File '" + psiFile.getName() + "' text mismatch after reparse. File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i = 0; i < documentLength; ++i) {
            if (i >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (i >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (editorText.charAt(i) == fileText[i]) continue;
            error = error + "first unequal char i=" + i + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile);
            if (context != null) {
                error = error + "context: " + context + "; text: '" + context.getText() + "'\n";
                error = error + "context file: " + context.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    @Override
    @TestOnly
    @ApiStatus.Internal
    public void clearUncommittedDocuments() {
        this.myUncommittedDocuments.clear();
        this.myUncommittedDocumentTraces.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    @Override
    @TestOnly
    @ApiStatus.Internal
    public void disableBackgroundCommit(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(107);
        }
        assert (this.myPerformBackgroundCommit);
        this.myPerformBackgroundCommit = false;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myPerformBackgroundCommit = true;
        });
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public PsiToDocumentSynchronizer getSynchronizer() {
        PsiToDocumentSynchronizer psiToDocumentSynchronizer = this.mySynchronizer;
        if (psiToDocumentSynchronizer == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(108);
        }
        return psiToDocumentSynchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ApiStatus.Internal
    public void reparseFileFromText(@NotNull PsiFileImpl file) {
        if (file == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(109);
        }
        if (this.isCommitInProgress()) {
            throw new IllegalStateException("Re-entrant commit is not allowed");
        }
        FileElement node = file.calcTreeElement();
        CharSequence text = node.getChars();
        ourIsFullReparseInProgress.set(Boolean.TRUE);
        try {
            ProgressIndicator indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator());
            DiffLog log = BlockSupportImpl.makeFullParse((PsiFileImpl)file, (FileASTNode)node, (CharSequence)text, (ProgressIndicator)indicator, (CharSequence)text).log;
            log.doActualPsiChange(file);
            file.getViewProvider().contentsSynchronized();
        }
        finally {
            ourIsFullReparseInProgress.remove();
        }
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public @Unmodifiable List<BooleanRunnable> reparseChangedInjectedFragments(@NotNull Document hostDocument, @NotNull PsiFile hostPsiFile, @NotNull TextRange range, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
        if (hostDocument == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(110);
        }
        if (hostPsiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(111);
        }
        if (range == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(112);
        }
        if (indicator == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(113);
        }
        if (oldRoot == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(114);
        }
        if (newRoot == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(115);
        }
        List<BooleanRunnable> list = Collections.emptyList();
        if (list == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(116);
        }
        return list;
    }

    @Override
    @TestOnly
    @ApiStatus.Internal
    public boolean isDefaultProject() {
        return this.myProject.isDefault();
    }

    @Override
    @NonNls
    public String someDocumentDebugInfo(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(117);
        }
        @NotNull List<FileViewProvider> viewProviders = this.getCachedViewProviders(document);
        return "cachedProvider: " + viewProviders + "; isEventSystemEnabled: " + this.isEventSystemEnabled(document) + "; isCommitted:" + this.isCommitted(document) + "; myIsCommitInProgress:" + this.isCommitInProgress() + "; isInUncommittedSet:" + this.isInUncommittedSet(document);
    }

    @Override
    @ApiStatus.Internal
    public void assertFileIsFromCorrectProject(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(118);
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public <T extends Throwable> void executeTestInProductionMode(@NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(119);
        }
        boolean old = this.myUnitTestMode;
        this.myUnitTestMode = false;
        try {
            runnable.run();
        }
        finally {
            this.myUnitTestMode = old;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 21: 
            case 33: 
            case 34: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 108: 
            case 116: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 21: 
            case 33: 
            case 34: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 108: 
            case 116: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 28: 
            case 30: 
            case 32: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 48: 
            case 50: 
            case 51: 
            case 63: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 76: 
            case 81: 
            case 82: 
            case 83: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 96: 
            case 97: 
            case 98: 
            case 102: 
            case 103: 
            case 106: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 12: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 22: 
            case 23: 
            case 52: 
            case 75: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugInfo";
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 21: 
            case 33: 
            case 34: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 108: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiDocumentManagerBase";
                break;
            }
            case 9: 
            case 71: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 19: 
            case 104: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 38: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishProcessors";
                break;
            }
            case 39: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparseInjectedProcessors";
                break;
            }
            case 40: 
            case 49: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProviders";
                break;
            }
            case 53: 
            case 56: 
            case 60: 
            case 62: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 58: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documents";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiDocumentManagerBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureValidFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedViewProviders";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearDocumentCommitActions";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearAllDocumentCommitActions";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommittedText";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommittedDocument";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsSinceCommit";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncommittedDocuments";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncommitedDocumentsWithTraces";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelDocument";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynchronizer";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "reparseChangedInjectedFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidFile";
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 21: 
            case 33: 
            case 34: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 108: 
            case 116: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "associatePsi";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRawCachedFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCachedViewProviders";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "performForCommittedDocument";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRunWhenAllCommitted";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addRunOnCommit";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAndClearDocumentCommitActions";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isEventSystemEnabled";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "finishCommit";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "finishCommitInWriteAction";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "commitToExistingPsi";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "forceReload";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkAllElementsValid";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "executeInsideCommit";
                break;
            }
            case 54: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "commitAndRunReadAction";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "reparseFiles";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "performWhenAllCommitted";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "performLaterWhenAllCommitted";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "runAfterCommitActions";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "runActions";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentBlockedByPsi";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedOperationsAndUnblockDocument";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "fireDocumentCreated";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "fireFileCreated";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedText";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedStamp";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedDocument";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getUncommittedInfo";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "freezeWindow";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getEventsSinceCommit";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isInUncommittedSet";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isUncommited";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "isCommitted";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelDocument";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChangeOnUnlockedDocument";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "bulkUpdateStarting";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "bulkUpdateFinished";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "commitAsync";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "areTooManyDocumentsInTheQueue";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitWithoutPsi";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "clearUncommittedInfo";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "isRelevant";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "checkConsistency";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "disableBackgroundCommit";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "reparseFileFromText";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "reparseChangedInjectedFragments";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "someDocumentDebugInfo";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "assertFileIsFromCorrectProject";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "executeTestInProductionMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 21: 
            case 33: 
            case 34: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 108: 
            case 116: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UncommittedInfo {
        private final FrozenDocument myFrozen;
        private final List<DocumentEvent> myEvents;
        private final ConcurrentMap<DocumentWindow, DocumentWindow> myFrozenWindows;

        private UncommittedInfo(@NotNull DocumentImpl original) {
            if (original == null) {
                UncommittedInfo.$$$reportNull$$$0(0);
            }
            this.myEvents = new ArrayList<DocumentEvent>();
            this.myFrozenWindows = new ConcurrentHashMap<DocumentWindow, DocumentWindow>();
            this.myFrozen = original.freeze();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/PsiDocumentManagerBase$UncommittedInfo", "<init>"));
        }
    }

    @ApiStatus.Internal
    public class PriorityEventCollector
    implements PrioritizedDocumentListener {
        public int getPriority() {
            return 40;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            UncommittedInfo info;
            if (event == null) {
                PriorityEventCollector.$$$reportNull$$$0(0);
            }
            if ((info = PsiDocumentManagerBase.this.getUncommittedInfo(event.getDocument())) != null) {
                info.myEvents.add(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiDocumentManagerBase$PriorityEventCollector", "documentChanged"));
        }
    }
}

