/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SharedProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class NamedObjectProviderBinding
implements ProviderBinding {
    private final Map<String, @NotNull ProviderBinding.ProviderInfo<ElementPattern<?>>[]> myNamesToProvidersMap = new ConcurrentHashMap<String, ProviderBinding.ProviderInfo<ElementPattern<?>>[]>(5);
    private final Map<String, @NotNull ProviderBinding.ProviderInfo<ElementPattern<?>>[]> myNamesToProvidersMapInsensitive = new ConcurrentHashMap<String, ProviderBinding.ProviderInfo<ElementPattern<?>>[]>(5);

    public synchronized void registerProvider(@NonNls String @NotNull [] names, @NotNull ElementPattern<?> filter, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority) {
        if (filter == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(1);
        }
        if (names == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(2);
        }
        Map<String, @NotNull ProviderBinding.ProviderInfo<ElementPattern<?>>[]> map = caseSensitive ? this.myNamesToProvidersMap : this.myNamesToProvidersMapInsensitive;
        for (String attributeName : names) {
            String key = caseSensitive ? attributeName : StringUtil.toLowerCase((String)attributeName);
            ProviderBinding.ProviderInfo<ElementPattern<?>>[] psiReferenceProviders = map.get(key);
            ProviderBinding.ProviderInfo newInfo = new ProviderBinding.ProviderInfo(provider, filter, priority);
            ProviderBinding.ProviderInfo<ElementPattern<?>>[] newProviders = NamedObjectProviderBinding.appendToArray(psiReferenceProviders, newInfo);
            map.put(key, newProviders);
        }
    }

    @NotNull
    static @NotNull ProviderBinding.ProviderInfo<ElementPattern<?>> @NotNull [] appendToArray(@NotNull ProviderBinding.ProviderInfo<ElementPattern<?>> @Nullable [] psiReferenceProviders, @NotNull ProviderBinding.ProviderInfo<ElementPattern<?>> newInfo) {
        ProviderBinding.ProviderInfo[] newProviders;
        ProviderBinding.ProviderInfo[] providerInfoArray;
        if (newInfo == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(3);
        }
        if (psiReferenceProviders == null) {
            ProviderBinding.ProviderInfo[] providerInfoArray2 = new ProviderBinding.ProviderInfo[1];
            providerInfoArray = providerInfoArray2;
            providerInfoArray2[0] = newInfo;
        } else {
            providerInfoArray = newProviders = (ProviderBinding.ProviderInfo[])ArrayUtil.append((Object[])psiReferenceProviders, newInfo);
        }
        if (newProviders == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(4);
        }
        return newProviders;
    }

    @Override
    public void addAcceptableReferenceProviders(@NotNull PsiElement position, @NotNull List<? super ProviderBinding.ProviderInfo<ProcessingContext>> list, @NotNull PsiReferenceService.Hints hints) {
        String name;
        if (position == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(5);
        }
        if (list == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(6);
        }
        if (hints == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(7);
        }
        if ((name = this.getName(position)) != null) {
            NamedObjectProviderBinding.addMatchingProviders(position, this.myNamesToProvidersMap.get(name), list, hints);
            NamedObjectProviderBinding.addMatchingProviders(position, this.myNamesToProvidersMapInsensitive.get(StringUtil.toLowerCase((String)name)), list, hints);
        }
    }

    @Override
    public synchronized void unregisterProvider(@NotNull PsiReferenceProvider provider) {
        if (provider == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(8);
        }
        for (Map.Entry<String, ProviderBinding.ProviderInfo<ElementPattern<?>>[]> entry : this.myNamesToProvidersMap.entrySet()) {
            entry.setValue(NamedObjectProviderBinding.removeFromArray(provider, entry.getValue()));
        }
        for (Map.Entry<String, ProviderBinding.ProviderInfo<ElementPattern<?>>[]> entry : this.myNamesToProvidersMapInsensitive.entrySet()) {
            entry.setValue(NamedObjectProviderBinding.removeFromArray(provider, entry.getValue()));
        }
    }

    @NotNull
    static @NotNull ProviderBinding.ProviderInfo<ElementPattern<?>> @NotNull [] removeFromArray(@NotNull PsiReferenceProvider provider, @NotNull @NotNull ProviderBinding.ProviderInfo<ElementPattern<?>> @NotNull [] array) {
        int i;
        if (provider == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(9);
        }
        if (array == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(10);
        }
        if ((i = ContainerUtil.indexOf((Object[])array, trinity -> trinity.provider.equals(provider))) != -1) {
            ProviderBinding.ProviderInfo[] providerInfoArray = (ProviderBinding.ProviderInfo[])ArrayUtil.remove((Object[])array, (int)i, ProviderBinding.ProviderInfo.ARRAY_FACTORY);
            if (providerInfoArray == null) {
                NamedObjectProviderBinding.$$$reportNull$$$0(11);
            }
            return providerInfoArray;
        }
        if (array == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(12);
        }
        return array;
    }

    boolean isEmpty() {
        return this.myNamesToProvidersMap.isEmpty() && this.myNamesToProvidersMapInsensitive.isEmpty();
    }

    @Nullable
    protected abstract String getName(@NotNull PsiElement var1);

    static void addMatchingProviders(@NotNull PsiElement position, @NotNull ProviderBinding.ProviderInfo<ElementPattern<?>> @Nullable [] providerList, @NotNull Collection<? super ProviderBinding.ProviderInfo<ProcessingContext>> output, @NotNull PsiReferenceService.Hints hints) {
        if (position == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(13);
        }
        if (output == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(14);
        }
        if (hints == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(15);
        }
        if (providerList == null) {
            return;
        }
        SharedProcessingContext sharedProcessingContext = new SharedProcessingContext();
        for (ProviderBinding.ProviderInfo<ElementPattern<?>> info : providerList) {
            if (hints != PsiReferenceService.Hints.NO_HINTS && !info.provider.acceptsHints(position, hints)) continue;
            ProcessingContext context = new ProcessingContext(sharedProcessingContext);
            boolean suitable = false;
            try {
                suitable = ((ElementPattern)info.processingContext).accepts((Object)position, context);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (!suitable) continue;
            output.add(new ProviderBinding.ProviderInfo<ProcessingContext>(info.provider, context, info.priority));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "appendToArray";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendToArray";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAcceptableReferenceProviders";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterProvider";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeFromArray";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addMatchingProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

