/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FCTSBackedLighterAST;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.AstSpine;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.stubs.LanguageStubDefinition;
import com.intellij.psi.stubs.LanguageStubDescriptor;
import com.intellij.psi.stubs.LightLanguageStubDefinition;
import com.intellij.psi.stubs.StubElementFactory;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileElement
extends LazyParseableElement
implements FileASTNode {
    public static final FileElement[] EMPTY_ARRAY = new FileElement[0];
    private volatile CharTable myCharTable;
    private volatile boolean myDetached;
    private volatile AstSpine myStubbedSpine;

    @Override
    protected PsiElement createPsiNoLock() {
        return this.myDetached ? null : super.createPsiNoLock();
    }

    public void detachFromFile() {
        this.myDetached = true;
        this.clearPsi();
    }

    @NotNull
    public CharTable getCharTable() {
        CharTable charTable = this.myCharTable;
        if (charTable == null) {
            FileElement.$$$reportNull$$$0(0);
        }
        return charTable;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public LighterAST getLighterAST() {
        LightLanguageStubDefinition lightStubFactory;
        if (!this.isParsed() && (lightStubFactory = this.getLightStubFactory()) != null) {
            @NotNull FlyweightCapableTreeStructure structure = lightStubFactory.parseContentsLight((ASTNode)this);
            return new FCTSBackedLighterAST(this.getCharTable(), structure);
        }
        return new TreeBackedLighterAST((FileASTNode)this);
    }

    @Nullable
    private LightLanguageStubDefinition getLightStubFactory() {
        Language language = this.getElementType().getLanguage();
        LanguageStubDescriptor stubDescriptor = StubElementRegistryService.getInstance().getStubDescriptor(language);
        if (stubDescriptor == null) {
            return null;
        }
        LanguageStubDefinition stubDefinition = stubDescriptor.getStubDefinition();
        if (!(stubDefinition instanceof LightLanguageStubDefinition)) {
            return null;
        }
        return (LightLanguageStubDefinition)stubDefinition;
    }

    public FileElement(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            FileElement.$$$reportNull$$$0(1);
        }
        super(type, text);
        this.myCharTable = new CharTableImpl();
    }

    @Override
    public PsiManagerEx getManager() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent != null) {
            return treeParent.getManager();
        }
        PsiElement psi = this.getPsi();
        if (psi == null) {
            throw PsiInvalidElementAccessException.createByNode((ASTNode)this, null);
        }
        return (PsiManagerEx)psi.getManager();
    }

    @Override
    public ASTNode copyElement() {
        PsiFileImpl psiElement = (PsiFileImpl)this.getPsi();
        PsiFileImpl psiElementCopy = (PsiFileImpl)psiElement.copy();
        return psiElementCopy.getTreeElement();
    }

    public void setCharTable(@NotNull CharTable table) {
        if (table == null) {
            FileElement.$$$reportNull$$$0(2);
        }
        this.myCharTable = table;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myStubbedSpine = null;
    }

    @ApiStatus.Internal
    @NotNull
    public final AstSpine getStubbedSpine() {
        AstSpine result = this.myStubbedSpine;
        if (result == null) {
            PsiFileImpl file = (PsiFileImpl)this.getPsi();
            LanguageStubDescriptor descriptor = file.getStubDescriptor();
            if (descriptor == null) {
                AstSpine astSpine = AstSpine.EMPTY_SPINE;
                if (astSpine == null) {
                    FileElement.$$$reportNull$$$0(3);
                }
                return astSpine;
            }
            result = (AstSpine)RecursionManager.doPreventingRecursion((Object)file, (boolean)false, () -> new AstSpine(this.calcStubbedDescendants(descriptor.getStubDefinition().getBuilder())));
            if (result == null) {
                throw new StackOverflowPreventedException("Endless recursion prevented");
            }
            this.myStubbedSpine = result;
        }
        AstSpine astSpine = result;
        if (astSpine == null) {
            FileElement.$$$reportNull$$$0(4);
        }
        return astSpine;
    }

    private List<CompositeElement> calcStubbedDescendants(final StubBuilder builder) {
        final ArrayList<CompositeElement> result = new ArrayList<CompositeElement>();
        result.add(this);
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitComposite(CompositeElement node) {
                CompositeElement parent = node.getTreeParent();
                if (parent != null && builder.skipChildProcessingWhenBuildingStubs((ASTNode)parent, (ASTNode)node)) {
                    return;
                }
                IElementType type = node.getElementType();
                StubElementFactory factory = StubElementRegistryService.getInstance().getStubFactory(type);
                if (factory != null && factory.shouldCreateStub((ASTNode)node)) {
                    result.add(node);
                }
                super.visitNode(node);
            }
        });
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCharTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

