/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefValueHashMapUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class DebugReflectionUtil {
    private static final Map<Class<?>, Field[]> allFields;
    private static final Field[] EMPTY_FIELD_ARRAY;
    private static final Method ClassLoader_findLoadedClass;

    private static Field @NotNull [] getAllFields(@NotNull Class<?> aClass) {
        Field[] cached;
        if (aClass == null) {
            DebugReflectionUtil.$$$reportNull$$$0(0);
        }
        if ((cached = allFields.get(aClass)) == null) {
            try {
                Field[] declaredFields = aClass.getDeclaredFields();
                ArrayList<Field> fields = new ArrayList<Field>(declaredFields.length + 5);
                for (Field declaredField : declaredFields) {
                    declaredField.setAccessible(true);
                    Class<?> type = declaredField.getType();
                    if (DebugReflectionUtil.isTrivial(type)) continue;
                    fields.add(declaredField);
                }
                Class<?> superclass = aClass.getSuperclass();
                if (superclass != null) {
                    for (Field sup : DebugReflectionUtil.getAllFields(superclass)) {
                        if (fields.contains(sup)) continue;
                        fields.add(sup);
                    }
                }
                cached = fields.isEmpty() ? EMPTY_FIELD_ARRAY : fields.toArray(new Field[0]);
            }
            catch (IncompatibleClassChangeError | NoClassDefFoundError | SecurityException e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    cached = EMPTY_FIELD_ARRAY;
                }
                throw e;
            }
            allFields.put(aClass, cached);
        }
        if (cached == null) {
            DebugReflectionUtil.$$$reportNull$$$0(1);
        }
        return cached;
    }

    private static boolean isTrivial(@NotNull Class<?> type) {
        if (type == null) {
            DebugReflectionUtil.$$$reportNull$$$0(2);
        }
        return type.isPrimitive() || type == String.class || type.isArray() && DebugReflectionUtil.isTrivial(type.getComponentType());
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static boolean isInitialized(ClassLoader classLoader, @NotNull String rootName) {
        if (rootName == null) {
            DebugReflectionUtil.$$$reportNull$$$0(3);
        }
        boolean isInitialized = false;
        if (classLoader == null) {
            return false;
        }
        try {
            isInitialized = ClassLoader_findLoadedClass.invoke((Object)classLoader, rootName) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isInitialized;
    }

    public static <V> boolean walkObjects(int maxDepth, @NotNull Map<Object, String> startRoots, @NotNull Class<V> lookFor, @NotNull Predicate<Object> shouldExamineValue, @NotNull PairProcessor<? super V, ? super BackLink<?>> leakProcessor) {
        if (startRoots == null) {
            DebugReflectionUtil.$$$reportNull$$$0(4);
        }
        if (lookFor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(5);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(6);
        }
        if (leakProcessor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(7);
        }
        return DebugReflectionUtil.walkObjects(maxDepth, Integer.MAX_VALUE, startRoots, lookFor, shouldExamineValue, leakProcessor);
    }

    public static <V> boolean walkObjects(int maxDepth, int maxQueueSize, @NotNull Map<Object, String> startRoots, @NotNull Class<V> lookFor, @NotNull Predicate<Object> shouldExamineValue, @NotNull PairProcessor<? super V, ? super BackLink<?>> leakProcessor) {
        if (startRoots == null) {
            DebugReflectionUtil.$$$reportNull$$$0(8);
        }
        if (lookFor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(9);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(10);
        }
        if (leakProcessor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(11);
        }
        IntOpenHashSet visited = new IntOpenHashSet(1000);
        ArrayDeque<2> toVisit = new ArrayDeque<2>(1000);
        IdentityHashMap<Object, String> alreadyReported = new IdentityHashMap<Object, String>();
        for (Map.Entry<Object, String> entry : startRoots.entrySet()) {
            Object startRoot = entry.getKey();
            final String description = entry.getValue();
            toVisit.addLast(new BackLink<Object>(startRoot, null, -2, null){

                @Override
                void print(@NotNull StringBuilder result) {
                    if (result == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.print(result);
                    result.append(" (from ").append(description).append(")");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/ref/DebugReflectionUtil$2", "print"));
                }
            });
        }
        BackLink backLink;
        while ((backLink = (BackLink)toVisit.pollFirst()) != null) {
            if (backLink.depth > maxDepth) continue;
            Object value = backLink.value;
            if (lookFor.isAssignableFrom(value.getClass()) && alreadyReported.put(value, "") == null && !leakProcessor.process(value, (Object)backLink)) {
                return false;
            }
            if (!visited.add(System.identityHashCode(value))) continue;
            DebugReflectionUtil.queueStronglyReferencedValues(toVisit, maxQueueSize, value, backLink, shouldExamineValue);
        }
        return true;
    }

    private static void queueStronglyReferencedValues(@NotNull Deque<? super BackLink<?>> queue, int maxQueueSize, @NotNull Object root, @NotNull BackLink<?> backLink, @NotNull Predicate<Object> shouldExamineValue) {
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(12);
        }
        if (root == null) {
            DebugReflectionUtil.$$$reportNull$$$0(13);
        }
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(14);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(15);
        }
        Class<?> rootClass = root.getClass();
        if (root instanceof Map) {
            RefValueHashMapUtil.expungeStaleEntries((Map)((Map)root));
        }
        for (Field field : DebugReflectionUtil.getAllFields(rootClass)) {
            Object value;
            String fieldName = field.getName();
            if (root instanceof Reference && ("referent".equals(fieldName) || "discovered".equals(fieldName))) continue;
            try {
                value = field.get(root);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            DebugReflectionUtil.queue(value, field, -1, backLink, queue, maxQueueSize, shouldExamineValue);
        }
        if (rootClass.isArray()) {
            try {
                Object[] objects = (Object[])root;
                for (int i = 0; i < objects.length; ++i) {
                    Object value = objects[i];
                    DebugReflectionUtil.queue(value, null, i, backLink, queue, maxQueueSize, shouldExamineValue);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (root instanceof Class && DebugReflectionUtil.isInitialized(((Class)root).getClassLoader(), ((Class)root).getName())) {
            for (Field field : DebugReflectionUtil.getAllFields((Class)root)) {
                if ((field.getModifiers() & 8) == 0) continue;
                try {
                    Object value = field.get(null);
                    DebugReflectionUtil.queue(value, field, -1, backLink, queue, maxQueueSize, shouldExamineValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static void queue(@Nullable Object value, @Nullable Field field, int arrayIndex, @NotNull BackLink<?> backLink, @NotNull Deque<? super BackLink<?>> queue, int maxQueueSize, @NotNull Predicate<Object> shouldExamineValue) {
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(16);
        }
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(17);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(18);
        }
        if (value == null || DebugReflectionUtil.isTrivial(value.getClass())) {
            return;
        }
        if (shouldExamineValue.test(value) && queue.size() < maxQueueSize) {
            queue.addLast(new BackLink<Object>(value, field, arrayIndex, backLink));
        }
    }

    static {
        Method findLoadedClass;
        allFields = Collections.synchronizedMap(CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)new HashingStrategy<Class<?>>(){

            public int hashCode(@Nullable Class<?> aClass) {
                return aClass == null ? 0 : aClass.getName().hashCode();
            }

            public boolean equals(@Nullable Class<?> o1, @Nullable Class<?> o2) {
                return o1 == o2;
            }
        }));
        EMPTY_FIELD_ARRAY = new Field[0];
        try {
            findLoadedClass = ReflectionUtil.getDeclaredMethod(Class.forName("java.lang.ClassLoader"), (String)"findLoadedClass", (Class[])new Class[]{String.class});
        }
        catch (ClassNotFoundException ignored) {
            findLoadedClass = null;
        }
        ClassLoader_findLoadedClass = findLoadedClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootName";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRoots";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookFor";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldExamineValue";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leakProcessor";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTrivial";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInitialized";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "walkObjects";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "queueStronglyReferencedValues";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BackLink<V> {
        @NotNull
        private final V value;
        private final Field field;
        private final int arrayIndex;
        private final BackLink<?> backLink;
        private final int depth;

        BackLink(@NotNull V value, @Nullable Field field, int arrayIndex, @Nullable BackLink<?> backLink) {
            if (value == null) {
                BackLink.$$$reportNull$$$0(0);
            }
            this.value = value;
            this.field = field;
            this.arrayIndex = arrayIndex;
            assert (field != null ^ arrayIndex != -1) : "One of field/arrayIndex must be present and the other should not, but got: " + field + "/" + arrayIndex;
            this.backLink = backLink;
            this.depth = backLink == null ? 0 : backLink.depth + 1;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (BackLink<?> backLink = this; backLink != null; backLink = backLink.prev()) {
                backLink.print(result);
            }
            return result.toString();
        }

        BackLink<?> prev() {
            return this.backLink;
        }

        String getFieldName() {
            return this.arrayIndex == -2 ? " (root)" : (this.arrayIndex != -1 ? "[" + this.arrayIndex + "]" : this.field.getDeclaringClass().getName() + "." + this.field.getName());
        }

        void print(@NotNull StringBuilder result) {
            String valueStr;
            if (result == null) {
                BackLink.$$$reportNull$$$0(1);
            }
            V value = this.value;
            try {
                valueStr = value instanceof FList ? "FList (size=" + ((FList)value).size() + ")" : (value instanceof Collection ? "Collection (size=" + ((Collection)value).size() + ")" : (value instanceof Object[] ? Arrays.toString((Object[])value) : String.valueOf(value)));
                valueStr = StringUtil.first((String)StringUtil.convertLineSeparators((String)valueStr, (String)"\\n"), (int)200, (boolean)true);
            }
            catch (Throwable e) {
                valueStr = "(" + e.getMessage() + " while computing .toString())";
            }
            result.append("via '").append(this.getFieldName()).append("'; Value: '").append(valueStr).append("' of ").append(value.getClass()).append("\n");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ref/DebugReflectionUtil$BackLink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

