/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.registry.RegistryValueSource;
import com.intellij.openapi.util.registry.ValueWithSource;
import java.awt.Color;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.future.FutureKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u001b\u001a\u00020\n2\u000b\u0010\u001c\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010 \u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b!2\u000b\u0010\u001c\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001dJ)\u0010\"\u001a\u00070\u0006\u00a2\u0006\u0002\b!2\u000b\u0010\u001c\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001d2\b\u0010#\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020&H\u0007J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070(H\u0007J\u0014\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060(H\u0007J\b\u0010*\u001a\u00020\u001fH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0011R\u0011\u0010,\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0011\u00a8\u0006."}, d2={"Lcom/intellij/openapi/util/registry/Registry;", "", "<init>", "()V", "userProperties", "Ljava/util/LinkedHashMap;", "", "Lcom/intellij/openapi/util/registry/ValueWithSource;", "values", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/util/registry/RegistryValue;", "contributedKeys", "", "Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;", "value", "", "isLoaded", "()Z", "loadFuture", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "valueChangeListener", "getValueChangeListener", "()Lcom/intellij/openapi/util/registry/RegistryValueListener;", "valueProducer", "Ljava/util/function/Function;", "resolveValue", "key", "Lorg/jetbrains/annotations/NonNls;", "reset", "", "getBundleValueOrNull", "Lcom/intellij/openapi/util/NlsSafe;", "getBundleValue", "keyDescriptor", "getBundleValue$intellij_platform_util", "getState", "Lorg/jdom/Element;", "getStoredProperties", "", "getUserProperties", "restoreDefaults", "isInDefaultState", "isRestartNeeded", "Companion", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Registry.kt\ncom/intellij/openapi/util/registry/Registry\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,434:1\n463#2:435\n413#2:436\n1252#3,4:437\n*S KotlinDebug\n*F\n+ 1 Registry.kt\ncom/intellij/openapi/util/registry/Registry\n*L\n408#1:435\n408#1:436\n408#1:437,4\n*E\n"})
public final class Registry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, ValueWithSource> userProperties = new LinkedHashMap();
    @NotNull
    private final ConcurrentHashMap<String, RegistryValue> values = new ConcurrentHashMap();
    @NotNull
    private Map<String, RegistryKeyDescriptor> contributedKeys = MapsKt.emptyMap();
    private volatile boolean isLoaded;
    @NotNull
    private volatile CompletableFuture<Void> loadFuture = new CompletableFuture();
    @NotNull
    private volatile RegistryValueListener valueChangeListener = EMPTY_VALUE_LISTENER;
    @NotNull
    private final Function<String, RegistryValue> valueProducer = arg_0 -> Registry.valueProducer$lambda$0(this, arg_0);
    @Nullable
    private static Reference<Map<String, String>> bundledRegistry;
    @NotNull
    public static final String REGISTRY_BUNDLE = "misc.registry";
    @NotNull
    private static final RegistryValueListener EMPTY_VALUE_LISTENER;
    @NotNull
    private static final Lazy<Registry> staticRegistry$delegate;
    @Nullable
    private static Function0<Registry> registrySupplier;

    public final boolean isLoaded() {
        return this.isLoaded;
    }

    @NotNull
    public final RegistryValueListener getValueChangeListener() {
        return this.valueChangeListener;
    }

    private final RegistryValue resolveValue(String key) {
        RegistryValue registryValue = this.values.computeIfAbsent(key, this.valueProducer);
        Intrinsics.checkNotNullExpressionValue(registryValue, "computeIfAbsent(...)");
        return registryValue;
    }

    @TestOnly
    public final void reset() {
        this.userProperties.clear();
        this.values.clear();
        this.isLoaded = false;
        this.loadFuture.cancel(false);
        this.loadFuture = new CompletableFuture();
    }

    @Nullable
    public final String getBundleValueOrNull(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Object object = this.contributedKeys.get(key);
        if (object == null || (object = ((RegistryKeyDescriptor)object).getDefaultValue()) == null) {
            Map map2 = Registry.Companion.loadFromBundledConfig();
            object = map2 != null ? (String)map2.get(key) : null;
        }
        return object;
    }

    @NotNull
    public final String getBundleValue$intellij_platform_util(@NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) throws MissingResourceException {
        Intrinsics.checkNotNullParameter(key, "key");
        Object object = keyDescriptor;
        if (object == null || (object = ((RegistryKeyDescriptor)object).getDefaultValue()) == null) {
            RegistryKeyDescriptor registryKeyDescriptor = this.contributedKeys.get(key);
            object = registryKeyDescriptor != null ? registryKeyDescriptor.getDefaultValue() : null;
            if (object == null) {
                Map map2 = Registry.Companion.loadFromBundledConfig();
                object = map2 != null ? (String)map2.get(key) : null;
                if (object == null) {
                    throw new MissingResourceException("Registry key " + key + " is not defined", REGISTRY_BUNDLE, key);
                }
            }
        }
        return object;
    }

    @ApiStatus.Internal
    @NotNull
    public final Element getState() {
        Element state = new Element("registry");
        for (Map.Entry entry : ((Map)this.userProperties).entrySet()) {
            String key = (String)entry.getKey();
            ValueWithSource value = (ValueWithSource)entry.getValue();
            RegistryValue registryValue = Registry.Companion.getRegistry().resolveValue(key);
            if (!registryValue.isChangedFromDefault()) continue;
            Element entryElement = new Element("entry");
            entryElement.setAttribute("key", key);
            entryElement.setAttribute("value", value.getValue());
            entryElement.setAttribute("source", value.getSource().name());
            state.addContent(entryElement);
        }
        return state;
    }

    @ApiStatus.Internal
    @NotNull
    public final Map<String, ValueWithSource> getStoredProperties() {
        return this.userProperties;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use `getStoredProperties`, changes to this map no longer have any effect", replaceWith=@ReplaceWith(expression="getStoredProperties()", imports={}))
    @ApiStatus.Internal
    @NotNull
    public final Map<String, String> getUserProperties() {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map copy = new LinkedHashMap();
        Map map2 = this.userProperties;
        Map map3 = copy;
        boolean $i$f$mapValues = false;
        void var4_5 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map5 = map4;
            boolean bl2 = false;
            String string = ((ValueWithSource)it.getValue()).getValue();
            map5.put(k, string);
        }
        map3.putAll(destination$iv$iv$iv);
        return copy;
    }

    @ApiStatus.Internal
    public final void restoreDefaults() {
        LinkedHashMap old = new LinkedHashMap(this.userProperties);
        Registry registry = Companion.getInstance();
        for (String key : old.keySet()) {
            Intrinsics.checkNotNull(key);
            String v = registry.getBundleValueOrNull(key);
            if (v == null) {
                this.values.remove(key);
                continue;
            }
            RegistryValue registryValue = registry.values.get(key);
            if (registryValue == null) continue;
            registryValue.setValue(v);
        }
    }

    public final boolean isInDefaultState() {
        return this.userProperties.isEmpty();
    }

    public final boolean isRestartNeeded() {
        return Registry.Companion.isRestartNeeded(this.userProperties);
    }

    private static final RegistryValue valueProducer$lambda$0(Registry this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new RegistryValue(this$0, it, this$0.contributedKeys.get(it));
    }

    private static final Registry staticRegistry_delegate$lambda$0() {
        return new Registry();
    }

    @JvmStatic
    @NotNull
    public static final RegistryValue get(@NotNull String key) {
        return Companion.get(key);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final RegistryValue _getWithoutStateCheck(@NotNull String key) {
        return Companion._getWithoutStateCheck(key);
    }

    @JvmStatic
    public static final boolean is(@NotNull String key) throws MissingResourceException {
        return Companion.is(key);
    }

    @JvmStatic
    public static final boolean is(@NotNull String key, boolean defaultValue) {
        return Companion.is(key, defaultValue);
    }

    @JvmStatic
    public static final int intValue(@NotNull String key) throws MissingResourceException {
        return Companion.intValue(key);
    }

    @JvmStatic
    public static final int intValue(@NotNull String key, int defaultValue) {
        return Companion.intValue(key, defaultValue);
    }

    @JvmStatic
    public static final double doubleValue(@NotNull String key, double defaultValue) {
        return Companion.doubleValue(key, defaultValue);
    }

    @JvmStatic
    public static final double doubleValue(@NotNull String key) throws MissingResourceException {
        return Companion.doubleValue(key);
    }

    @JvmStatic
    @NotNull
    public static final String stringValue(@NotNull String key) throws MissingResourceException {
        return Companion.stringValue(key);
    }

    @JvmStatic
    @Nullable
    public static final Color getColor(@NotNull String key, @Nullable Color defaultValue) throws MissingResourceException {
        return Companion.getColor(key, defaultValue);
    }

    @JvmStatic
    @NotNull
    public static final Registry getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final int intValue(@NotNull String key, int defaultValue, int minValue, int maxValue) {
        return Companion.intValue(key, defaultValue, minValue, maxValue);
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void markAsLoaded() {
        Companion.markAsLoaded();
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final List<RegistryValue> getAll() {
        return Companion.getAll();
    }

    static {
        EMPTY_VALUE_LISTENER = new RegistryValueListener(){};
        staticRegistry$delegate = LazyKt.lazy(Registry::staticRegistry_delegate$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u001a\u001a\u00020\u001b2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J%\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00132\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\b\b\u0002\u0010\u001f\u001a\u00020\u001eH\u0007J\u0015\u0010 \u001a\u00020\u001b2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u0015\u0010!\u001a\u00020\u001e2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u001d\u0010!\u001a\u00020\u001e2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u001f\u001a\u00020\u001eH\u0007J\u0015\u0010\"\u001a\u00020#2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u001d\u0010\"\u001a\u00020#2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u001f\u001a\u00020#H\u0007J\u001d\u0010$\u001a\u00020%2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u001f\u001a\u00020%H\u0007J\u0015\u0010$\u001a\u00020%2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u0015\u0010&\u001a\u00020\u00072\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J!\u0010'\u001a\u0004\u0018\u00010(2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\b\u0010\u001f\u001a\u0004\u0018\u00010(H\u0007J\u0016\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0002J$\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00072\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070-H\u0002J\b\u0010.\u001a\u00020\rH\u0007J-\u0010\"\u001a\u00020#2\u000b\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u001f\u001a\u00020#2\u0006\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020#H\u0007J\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002020\u00062\u0006\u00103\u001a\u000204H\u0002J&\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002020\u00062\u0006\u0010\u0018\u001a\u00020\r2\b\u00103\u001a\u0004\u0018\u000104H\u0002J4\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002020\u00062\b\u00103\u001a\u0004\u0018\u0001042\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0007J\b\u00108\u001a\u000209H\u0007J\u000e\u0010:\u001a\u000209H\u0087@\u00a2\u0006\u0002\u0010;J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001b0=H\u0007J\u001c\u0010>\u001a\u00020\u001e2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002020\u0006H\u0002J\u001c\u0010@\u001a\u0002092\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020B0\u0006H\u0007J4\u0010C\u001a\u0002092*\u0010D\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020B0\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020B0\u00060EH\u0007J\u0012\u0010F\u001a\u0002092\b\u0010G\u001a\u0004\u0018\u00010\u000bH\u0007J<\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002020\u00062\u0006\u0010\u0018\u001a\u00020\r2\b\u00103\u001a\u0004\u0018\u0001042\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0002R\"\u0010\u0004\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00138\u0007@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006I\u00b2\u0006\n\u0010J\u001a\u00020\u001bX\u008a\u0084\u0002"}, d2={"Lcom/intellij/openapi/util/registry/Registry$Companion;", "", "<init>", "()V", "bundledRegistry", "Ljava/lang/ref/Reference;", "", "", "REGISTRY_BUNDLE", "Lorg/jetbrains/annotations/NonNls;", "EMPTY_VALUE_LISTENER", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "staticRegistry", "Lcom/intellij/openapi/util/registry/Registry;", "getStaticRegistry", "()Lcom/intellij/openapi/util/registry/Registry;", "staticRegistry$delegate", "Lkotlin/Lazy;", "registrySupplier", "Lkotlin/Function0;", "getRegistrySupplier", "()Lkotlin/jvm/functions/Function0;", "setRegistrySupplier", "(Lkotlin/jvm/functions/Function0;)V", "registry", "getRegistry", "get", "Lcom/intellij/openapi/util/registry/RegistryValue;", "key", "booleanValueHotSupplier", "", "defaultValue", "_getWithoutStateCheck", "is", "intValue", "", "doubleValue", "", "stringValue", "getColor", "Ljava/awt/Color;", "loadFromBundledConfig", "loadFromResource", "sourceResourceName", "targetMap", "", "getInstance", "minValue", "maxValue", "fromState", "Lcom/intellij/openapi/util/registry/ValueWithSource;", "state", "Lorg/jdom/Element;", "updateStateInternal", "loadState", "earlyAccess", "markAsLoaded", "", "awaitLoad", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAll", "", "isRestartNeeded", "map", "setContributedKeys", "descriptors", "Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;", "mutateContributedKeys", "mutator", "Lkotlin/Function1;", "setValueChangeListener", "listener", "loadStateInternal", "intellij.platform.util", "valueHandle"})
    @SourceDebugExtension(value={"SMAP\nRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Registry.kt\ncom/intellij/openapi/util/registry/Registry$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,434:1\n463#2:435\n413#2:436\n1252#3,4:437\n*S KotlinDebug\n*F\n+ 1 Registry.kt\ncom/intellij/openapi/util/registry/Registry$Companion\n*L\n345#1:435\n345#1:436\n345#1:437,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Registry getStaticRegistry() {
            Lazy lazy = staticRegistry$delegate;
            return (Registry)lazy.getValue();
        }

        @ApiStatus.Internal
        @Nullable
        public final Function0<Registry> getRegistrySupplier() {
            return registrySupplier;
        }

        @ApiStatus.Internal
        public final void setRegistrySupplier(@Nullable Function0<Registry> function0) {
            registrySupplier = function0;
        }

        private final Registry getRegistry() {
            Function0<Registry> function0 = this.getRegistrySupplier();
            if (function0 == null || (function0 = function0.invoke()) == null) {
                function0 = this.getStaticRegistry();
            }
            return function0;
        }

        @JvmStatic
        @NotNull
        public final RegistryValue get(@NotNull String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.getInstance().resolveValue(key);
        }

        @ApiStatus.Experimental
        @ApiStatus.Internal
        @NotNull
        public final Function0<Boolean> booleanValueHotSupplier(@NotNull String key, boolean defaultValue) {
            Intrinsics.checkNotNullParameter(key, "key");
            Lazy<RegistryValue> valueHandle$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> Companion.booleanValueHotSupplier$lambda$0(key));
            return () -> Companion.booleanValueHotSupplier$lambda$2(defaultValue, valueHandle$delegate);
        }

        public static /* synthetic */ Function0 booleanValueHotSupplier$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.booleanValueHotSupplier(string, bl);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final RegistryValue _getWithoutStateCheck(@NotNull String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.getRegistry().resolveValue(key);
        }

        @JvmStatic
        public final boolean is(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.getInstance().resolveValue(key).asBoolean();
        }

        @JvmStatic
        public final boolean is(@NotNull String key, boolean defaultValue) {
            Intrinsics.checkNotNullParameter(key, "key");
            if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
                return defaultValue;
            }
            try {
                return this.getRegistry().resolveValue(key).asBoolean();
            }
            catch (MissingResourceException missingResourceException) {
                return defaultValue;
            }
        }

        @JvmStatic
        public final int intValue(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.getInstance().resolveValue(key).asInteger();
        }

        @JvmStatic
        public final int intValue(@NotNull String key, int defaultValue) {
            Intrinsics.checkNotNullParameter(key, "key");
            if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
                LoadingState.COMPONENTS_REGISTERED.checkOccurred();
                return defaultValue;
            }
            try {
                return this.getRegistry().resolveValue(key).asInteger();
            }
            catch (MissingResourceException missingResourceException) {
                return defaultValue;
            }
        }

        @JvmStatic
        public final double doubleValue(@NotNull String key, double defaultValue) {
            Intrinsics.checkNotNullParameter(key, "key");
            if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
                LoadingState.COMPONENTS_REGISTERED.checkOccurred();
                return defaultValue;
            }
            try {
                return this.getRegistry().resolveValue(key).asDouble();
            }
            catch (MissingResourceException missingResourceException) {
                return defaultValue;
            }
        }

        @JvmStatic
        public final double doubleValue(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.getInstance().resolveValue(key).asDouble();
        }

        @JvmStatic
        @NotNull
        public final String stringValue(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.getInstance().resolveValue(key).asString();
        }

        @JvmStatic
        @Nullable
        public final Color getColor(@NotNull String key, @Nullable Color defaultValue) throws MissingResourceException {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.getInstance().resolveValue(key).asColor(defaultValue);
        }

        private final Map<String, String> loadFromBundledConfig() throws IOException {
            Map map2;
            Reference reference = bundledRegistry;
            if (reference != null && (map2 = (Map)reference.get()) != null) {
                Map it = map2;
                boolean bl = false;
                return it;
            }
            LinkedHashMap map3 = new LinkedHashMap(1800);
            boolean mainFound = this.loadFromResource("misc/registry.properties", map3);
            boolean overrideFound = this.loadFromResource("misc/registry.override.properties", map3);
            if (!mainFound && !overrideFound) {
                return null;
            }
            bundledRegistry = new SoftReference(map3);
            return map3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean loadFromResource(String sourceResourceName, Map<String, String> targetMap) {
            InputStream inputStream = Registry.class.getClassLoader().getResourceAsStream(sourceResourceName);
            if (inputStream == null) {
                return false;
            }
            InputStream stream = inputStream;
            Closeable closeable = stream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                new Properties(targetMap){
                    final /* synthetic */ Map<String, String> $targetMap;
                    {
                        this.$targetMap = $targetMap;
                    }

                    public Object put(Object key, Object value) {
                        Intrinsics.checkNotNullParameter(key, "key");
                        Intrinsics.checkNotNullParameter(value, "value");
                        return this.$targetMap.put((String)key, (String)value);
                    }
                }.load(stream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return true;
        }

        @JvmStatic
        @NotNull
        public final Registry getInstance() {
            LoadingState.COMPONENTS_LOADED.checkOccurred();
            return this.getRegistry();
        }

        @JvmStatic
        public final int intValue(@NotNull String key, int defaultValue, int minValue, int maxValue) {
            Intrinsics.checkNotNullParameter(key, "key");
            if (!(defaultValue >= minValue && defaultValue <= maxValue)) {
                boolean bl = false;
                String string = "Wrong values for default:min:max (" + defaultValue + ':' + minValue + ':' + maxValue + ')';
                throw new IllegalArgumentException(string.toString());
            }
            return RangesKt.coerceIn(this.intValue(key, defaultValue), minValue, maxValue);
        }

        private final Map<String, ValueWithSource> fromState(Element state) {
            LinkedHashMap<String, ValueWithSource> map2 = new LinkedHashMap<String, ValueWithSource>();
            for (Element entry : state.getChildren("entry")) {
                String value;
                String key;
                if (entry.getAttributeValue("key") == null || entry.getAttributeValue("value") == null) continue;
                String string = entry.getAttributeValue("source");
                RegistryValueSource source = Intrinsics.areEqual(string, "USER") ? RegistryValueSource.USER : (Intrinsics.areEqual(string, "MANAGER") ? RegistryValueSource.MANAGER : RegistryValueSource.SYSTEM);
                map2.put(key, new ValueWithSource(value, source));
            }
            return map2;
        }

        private final Map<String, ValueWithSource> updateStateInternal(Registry registry, Element state) {
            LinkedHashMap userProperties = registry.userProperties;
            if (state == null) {
                userProperties.clear();
                return userProperties;
            }
            Map<String, ValueWithSource> map2 = this.fromState(state);
            HashSet keysToProcess = new HashSet(userProperties.keySet());
            for (Map.Entry<String, ValueWithSource> entry : map2.entrySet()) {
                String key = entry.getKey();
                ValueWithSource value = entry.getValue();
                RegistryValue registryValue = registry.resolveValue(key);
                String currentValue = registryValue.resolveNotRequiredValue(key);
                if (currentValue != null && !Intrinsics.areEqual(currentValue, value.getValue())) {
                    registryValue.setValue(value.getValue());
                }
                keysToProcess.remove(key);
            }
            Iterator iterator2 = keysToProcess.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<Map.Entry<String, ValueWithSource>> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                String key = (String)((Object)iterator3.next());
                Intrinsics.checkNotNull(key);
                registry.resolveValue(key).resetToDefault();
            }
            return userProperties;
        }

        @ApiStatus.Internal
        @NotNull
        public final Map<String, ValueWithSource> loadState(@Nullable Element state, @Nullable Map<String, String> earlyAccess) {
            Registry registry = this.getRegistry();
            if (registry.isLoaded()) {
                return this.updateStateInternal(registry, state);
            }
            return this.loadStateInternal(registry, state, earlyAccess);
        }

        @JvmStatic
        @ApiStatus.Internal
        public final void markAsLoaded() {
            this.getRegistry().isLoaded = true;
            this.getRegistry().loadFuture.complete(null);
        }

        @ApiStatus.Internal
        @Nullable
        public final Object awaitLoad(@NotNull Continuation<? super Unit> $completion) {
            Object object = FutureKt.asDeferred((CompletionStage)this.getRegistry().loadFuture).join($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final List<RegistryValue> getAll() {
            Set<String> set;
            Map<String, String> bundle = null;
            try {
                bundle = this.loadFromBundledConfig();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ((set = bundle) == null || (set = set.keySet()) == null) {
                set = SetsKt.emptySet();
            }
            Set<String> keys2 = set;
            ArrayList<RegistryValue> result = new ArrayList<RegistryValue>();
            Registry registry = this.getRegistry();
            Map contributedKeys = registry.contributedKeys;
            for (String key : keys2) {
                if (StringsKt.endsWith$default(key, ".description", false, 2, null) || StringsKt.endsWith$default(key, ".restartRequired", false, 2, null) || contributedKeys.containsKey(key)) continue;
                result.add(registry.resolveValue(key));
            }
            for (String key : contributedKeys.keySet()) {
                result.add(registry.resolveValue(key));
            }
            return result;
        }

        private final boolean isRestartNeeded(Map<String, ValueWithSource> map2) {
            Registry instance = this.getInstance();
            for (String s : map2.keySet()) {
                RegistryValue eachValue = instance.resolveValue(s);
                if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
                return true;
            }
            return false;
        }

        @ApiStatus.Internal
        public final synchronized void setContributedKeys(@NotNull Map<String, RegistryKeyDescriptor> descriptors) {
            Intrinsics.checkNotNullParameter(descriptors, "descriptors");
            this.getRegistry().contributedKeys = descriptors;
        }

        @ApiStatus.Internal
        public final synchronized void mutateContributedKeys(@NotNull Function1<? super Map<String, RegistryKeyDescriptor>, ? extends Map<String, RegistryKeyDescriptor>> mutator) {
            Intrinsics.checkNotNullParameter(mutator, "mutator");
            this.getRegistry().contributedKeys = mutator.invoke(this.getRegistry().contributedKeys);
        }

        @ApiStatus.Internal
        public final void setValueChangeListener(@Nullable RegistryValueListener listener) {
            Registry registry = this.getRegistry();
            RegistryValueListener registryValueListener = listener;
            if (registryValueListener == null) {
                registryValueListener = EMPTY_VALUE_LISTENER;
            }
            registry.valueChangeListener = registryValueListener;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, ValueWithSource> loadStateInternal(Registry registry, Element state, Map<String, String> earlyAccess) {
            Object registryValue;
            Map<String, Object> map2;
            LinkedHashMap userProperties = registry.userProperties;
            userProperties.clear();
            if (state != null) {
                map2 = this.fromState(state);
                for (Map.Entry<String, ValueWithSource> entry : map2.entrySet()) {
                    String key = entry.getKey();
                    ValueWithSource value = entry.getValue();
                    registryValue = registry.resolveValue(key);
                    if (Intrinsics.areEqual(value.getValue(), registry.getBundleValueOrNull(((RegistryValue)registryValue).getKey()))) continue;
                    userProperties.put(key, value);
                    ((RegistryValue)registryValue).resetCache$intellij_platform_util();
                }
            }
            if (earlyAccess != null) {
                void $this$associateByTo$iv$iv$iv;
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                Map.Entry<String, ValueWithSource> entry;
                map2 = earlyAccess;
                LinkedHashMap linkedHashMap = userProperties;
                boolean $i$f$mapValues = false;
                entry = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                registryValue = $this$mapValuesTo$iv$iv.entrySet();
                Map destination$iv$iv$iv = destination$iv$iv;
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv$iv;
                    boolean bl = false;
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl2 = false;
                    ValueWithSource valueWithSource = new ValueWithSource((String)it.getValue(), RegistryValueSource.SYSTEM);
                    map4.put(k, valueWithSource);
                }
                linkedHashMap.putAll(destination$iv$iv$iv);
            }
            registry.isLoaded = true;
            registry.loadFuture.complete(null);
            return userProperties;
        }

        private static final RegistryValue booleanValueHotSupplier$lambda$0(String $key) {
            return Companion.getRegistry().resolveValue($key);
        }

        private static final RegistryValue booleanValueHotSupplier$lambda$1(Lazy<? extends RegistryValue> $valueHandle$delegate) {
            Lazy<? extends RegistryValue> lazy = $valueHandle$delegate;
            return lazy.getValue();
        }

        private static final boolean booleanValueHotSupplier$lambda$2(boolean $defaultValue, Lazy $valueHandle$delegate) {
            boolean bl;
            try {
                bl = com.intellij.openapi.util.registry.Registry$Companion.booleanValueHotSupplier$lambda$1($valueHandle$delegate).asBoolean();
            }
            catch (MissingResourceException missingResourceException) {
                bl = $defaultValue;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

