/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel;

import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatform;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\"\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0005\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\"\u0015\u0010\r\u001a\u00020\u0001*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0011\u001a\u00020\u000f*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"isPosix", "", "Lcom/intellij/platform/eel/EelOsFamily;", "(Lcom/intellij/platform/eel/EelOsFamily;)Z", "Lcom/intellij/platform/eel/EelPlatform;", "(Lcom/intellij/platform/eel/EelPlatform;)Z", "isMac", "isLinux", "isWindows", "isFreeBSD", "isArm32", "isArm64", "isX86", "isX86_64", "UNIX_DIRECTORY_SEPARATORS", "", "WINDOWS_DIRECTORY_SEPARATORS", "directorySeparators", "getDirectorySeparators", "(Lcom/intellij/platform/eel/EelOsFamily;)[C", "pathSeparator", "", "getPathSeparator", "(Lcom/intellij/platform/eel/EelOsFamily;)Ljava/lang/String;", "intellij.platform.eel"})
public final class EelPlatformKt {
    @NotNull
    private static final char[] UNIX_DIRECTORY_SEPARATORS;
    @NotNull
    private static final char[] WINDOWS_DIRECTORY_SEPARATORS;

    @ApiStatus.Experimental
    public static final boolean isPosix(@NotNull EelOsFamily $this$isPosix) {
        Intrinsics.checkNotNullParameter((Object)$this$isPosix, "<this>");
        return $this$isPosix == EelOsFamily.Posix;
    }

    @ApiStatus.Experimental
    public static final boolean isPosix(@NotNull EelPlatform $this$isPosix) {
        Intrinsics.checkNotNullParameter($this$isPosix, "<this>");
        return EelPlatformKt.isPosix($this$isPosix.getOsFamily());
    }

    @ApiStatus.Experimental
    public static final boolean isMac(@NotNull EelPlatform $this$isMac) {
        Intrinsics.checkNotNullParameter($this$isMac, "<this>");
        return $this$isMac instanceof EelPlatform.Darwin;
    }

    @ApiStatus.Experimental
    public static final boolean isLinux(@NotNull EelPlatform $this$isLinux) {
        Intrinsics.checkNotNullParameter($this$isLinux, "<this>");
        return $this$isLinux instanceof EelPlatform.Linux;
    }

    @ApiStatus.Experimental
    public static final boolean isWindows(@NotNull EelOsFamily $this$isWindows) {
        Intrinsics.checkNotNullParameter((Object)$this$isWindows, "<this>");
        return $this$isWindows == EelOsFamily.Windows;
    }

    @ApiStatus.Experimental
    public static final boolean isWindows(@NotNull EelPlatform $this$isWindows) {
        Intrinsics.checkNotNullParameter($this$isWindows, "<this>");
        return EelPlatformKt.isWindows($this$isWindows.getOsFamily());
    }

    @ApiStatus.Experimental
    public static final boolean isFreeBSD(@NotNull EelPlatform $this$isFreeBSD) {
        Intrinsics.checkNotNullParameter($this$isFreeBSD, "<this>");
        return $this$isFreeBSD instanceof EelPlatform.FreeBSD;
    }

    @ApiStatus.Experimental
    public static final boolean isArm32(@NotNull EelPlatform $this$isArm32) {
        Intrinsics.checkNotNullParameter($this$isArm32, "<this>");
        return $this$isArm32.getArch() instanceof EelPlatform.Arch.ARM_32;
    }

    @ApiStatus.Experimental
    public static final boolean isArm64(@NotNull EelPlatform $this$isArm64) {
        Intrinsics.checkNotNullParameter($this$isArm64, "<this>");
        return $this$isArm64.getArch() instanceof EelPlatform.Arch.ARM_64;
    }

    @ApiStatus.Experimental
    public static final boolean isX86(@NotNull EelPlatform $this$isX86) {
        Intrinsics.checkNotNullParameter($this$isX86, "<this>");
        return $this$isX86.getArch() instanceof EelPlatform.Arch.X86;
    }

    @ApiStatus.Experimental
    public static final boolean isX86_64(@NotNull EelPlatform $this$isX86_64) {
        Intrinsics.checkNotNullParameter($this$isX86_64, "<this>");
        return $this$isX86_64.getArch() instanceof EelPlatform.Arch.X86_64;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final char[] getDirectorySeparators(@NotNull EelOsFamily $this$directorySeparators) {
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)$this$directorySeparators, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$directorySeparators.ordinal()]) {
            case 1: {
                cArray = WINDOWS_DIRECTORY_SEPARATORS;
                break;
            }
            case 2: {
                cArray = UNIX_DIRECTORY_SEPARATORS;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return cArray;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final String getPathSeparator(@NotNull EelOsFamily $this$pathSeparator) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$pathSeparator, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$pathSeparator.ordinal()]) {
            case 2: {
                string = ":";
                break;
            }
            case 1: {
                string = ";";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    static {
        char[] cArray = new char[]{'/'};
        UNIX_DIRECTORY_SEPARATORS = cArray;
        cArray = new char[]{'/', '\\'};
        WINDOWS_DIRECTORY_SEPARATORS = cArray;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EelOsFamily.values().length];
            try {
                nArray[EelOsFamily.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelOsFamily.Posix.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

