/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class BoundedScheduledExecutorService
extends SchedulingWrapper {
    @VisibleForTesting
    public BoundedScheduledExecutorService(@NotNull @NonNls String name, @NotNull ExecutorService backendExecutor, int maxThreads) {
        if (name == null) {
            BoundedScheduledExecutorService.$$$reportNull$$$0(0);
        }
        if (backendExecutor == null) {
            BoundedScheduledExecutorService.$$$reportNull$$$0(1);
        }
        super(new BoundedTaskExecutor(name, backendExecutor, maxThreads, true));
        assert (!(backendExecutor instanceof ScheduledExecutorService)) : "backendExecutor is already ScheduledExecutorService: " + backendExecutor;
    }

    @Override
    void onDelayQueuePurgedOnShutdown() {
        this.backendExecutorService.shutdown();
    }

    @Override
    public @Unmodifiable @NotNull List<Runnable> shutdownNow() {
        List<Runnable> runnables = super.shutdownNow();
        List<Runnable> list = ContainerUtil.concat(runnables, this.backendExecutorService.shutdownNow());
        if (list == null) {
            BoundedScheduledExecutorService.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/BoundedScheduledExecutorService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/BoundedScheduledExecutorService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

