/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/text/NameUtilCore;", "", "<init>", "()V", "KANA_START", "", "KANA_END", "KANA2_START", "KANA2_END", "splitNameIntoWordList", "", "", "name", "splitNameIntoWords", "", "(Ljava/lang/String;)[Ljava/lang/String;", "nextWord", "text", "start", "isWordStart", "", "i", "maybeKana", "codePoint", "isKanaBreak", "cur", "prev", "nameToWords", "nameToWordList", "intellij.platform.util.base"})
public final class NameUtilCore {
    @NotNull
    public static final NameUtilCore INSTANCE = new NameUtilCore();
    private static final int KANA_START = 12352;
    private static final int KANA_END = 13144;
    private static final int KANA2_START = 65382;
    private static final int KANA2_END = 65437;

    private NameUtilCore() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitNameIntoWordList(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        char[] cArray = new char[]{'_'};
        List underlineDelimited = StringsKt.split$default((CharSequence)name, cArray, false, 0, 6, null);
        List result = new ArrayList();
        for (String word : underlineDelimited) {
            int start = 0;
            while (start < word.length()) {
                int next = NameUtilCore.nextWord(word, start);
                String string = word.substring(start, next);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                result.add(string);
                start = next;
            }
        }
        return result;
    }

    @JvmStatic
    @Deprecated(message="use {@link #splitNameIntoWordList(String)} to avoid redundant allocations\n    <p>\n    Splits an identifier into words, separated with underscores or upper-case characters\n    (camel-case).\n   \n    ")
    @NotNull
    public static final String[] splitNameIntoWords(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)NameUtilCore.splitNameIntoWordList(name));
        Intrinsics.checkNotNullExpressionValue(stringArray, "toStringArray(...)");
        return stringArray;
    }

    @JvmStatic
    public static final int nextWord(@NotNull String text, int start) {
        int i;
        int codePoint;
        Intrinsics.checkNotNullParameter(text, "text");
        int ch = text.codePointAt(start);
        int chLen = Character.charCount(ch);
        if (!Character.isLetterOrDigit(ch)) {
            return start + chLen;
        }
        for (i = start; i < text.length() && Character.isDigit(codePoint = text.codePointAt(i)); i += Character.charCount(codePoint)) {
        }
        if (i > start) {
            return i;
        }
        while (i < text.length() && Character.isUpperCase(codePoint = text.codePointAt(i))) {
            i += Character.charCount(codePoint);
        }
        if (i > start + chLen) {
            if (i == text.length() || !Character.isLetter(text.codePointAt(i))) {
                return i;
            }
            return i - Character.charCount(text.codePointBefore(i));
        }
        if (i == start) {
            i += chLen;
        }
        while (i < text.length() && Character.isLetter(codePoint = text.codePointAt(i)) && !NameUtilCore.isWordStart(text, i)) {
            i += Character.charCount(codePoint);
        }
        return i;
    }

    @JvmStatic
    public static final boolean isWordStart(@NotNull String text, int i) {
        int prev;
        Intrinsics.checkNotNullParameter(text, "text");
        int cur = text.codePointAt(i);
        int n = prev = i > 0 ? text.codePointBefore(i) : -1;
        if (Character.isUpperCase(cur)) {
            if (Character.isUpperCase(prev)) {
                int nextPos = i + Character.charCount(cur);
                return nextPos < text.length() && Character.isLowerCase(text.codePointAt(nextPos));
            }
            return true;
        }
        if (Character.isDigit(cur)) {
            return true;
        }
        if (!Character.isLetter(cur)) {
            return false;
        }
        if (Character.isIdeographic(cur)) {
            return true;
        }
        return i == 0 || !Character.isLetterOrDigit(text.charAt(i - 1)) || INSTANCE.isKanaBreak(cur, prev);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean maybeKana(int codePoint) {
        boolean bl;
        if (12352 <= codePoint) {
            if (codePoint < 13145) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (65382 > codePoint) return false;
        if (codePoint >= 65438) return false;
        return true;
    }

    private final boolean isKanaBreak(int cur, int prev) {
        if (!this.maybeKana(cur) && !this.maybeKana(prev)) {
            return false;
        }
        Character.UnicodeScript curScript = Character.UnicodeScript.of(cur);
        Character.UnicodeScript prevScript = Character.UnicodeScript.of(prev);
        if (prevScript == curScript) {
            return false;
        }
        return (curScript == Character.UnicodeScript.KATAKANA || curScript == Character.UnicodeScript.HIRAGANA || prevScript == Character.UnicodeScript.KATAKANA || prevScript == Character.UnicodeScript.HIRAGANA) && prevScript != Character.UnicodeScript.COMMON && curScript != Character.UnicodeScript.COMMON;
    }

    @JvmStatic
    @Deprecated(message="use {@link #nameToWordList(String)} to avoid redundant allocations")
    @NotNull
    public static final String[] nameToWords(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)NameUtilCore.nameToWordList(name));
        Intrinsics.checkNotNullExpressionValue(stringArray, "toStringArray(...)");
        return stringArray;
    }

    @JvmStatic
    @NotNull
    public static final List<String> nameToWordList(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        List array = new ArrayList();
        int index = 0;
        while (index < name.length()) {
            CharSequence word;
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            if (!(!StringsKt.isBlank(word = name.subSequence(wordStart, index)))) continue;
            array.add(((Object)word).toString());
        }
        return array;
    }
}

