/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ijent;

import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.MountType;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.ijent.DockerEelDescriptor;
import com.intellij.docker.ijent.DockerEelMachine;
import com.intellij.docker.ijent.DockerEelMachineProvider;
import com.intellij.docker.ijent.DockerMountRoot;
import com.intellij.docker.ijent.DockerMountsAwareHelperKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelMachineProvider;
import com.intellij.platform.eel.provider.EelMountProvider;
import com.intellij.platform.eel.provider.EelMountRoot;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/ijent/DockerMountProvider;", "Lcom/intellij/platform/eel/provider/EelMountProvider;", "<init>", "()V", "getMountRoot", "Lcom/intellij/platform/eel/provider/EelMountRoot;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "adjustSourcePath", "mount", "Lcom/github/dockerjava/api/model/Mount;", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerMountsAwareHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerMountsAwareHelper.kt\ncom/intellij/docker/ijent/DockerMountProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
public final class DockerMountProvider
implements EelMountProvider {
    @NotNull
    public static final DockerMountProvider INSTANCE = new DockerMountProvider();

    private DockerMountProvider() {
    }

    @Nullable
    public EelMountRoot getMountRoot(@NotNull EelPath path2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        EelDescriptor descriptor2 = path2.getDescriptor();
        if (!(descriptor2 instanceof DockerEelDescriptor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DockerEelMachineProvider dockerEelMachineProvider = (DockerEelMachineProvider)EelMachineProvider.Companion.getEP_NAME().findExtension(DockerEelMachineProvider.class);
        if (dockerEelMachineProvider == null) {
            return null;
        }
        DockerEelMachineProvider provider = dockerEelMachineProvider;
        DockerEelMachine dockerEelMachine = provider.getResolvedEelMachine(descriptor2);
        if (dockerEelMachine == null) {
            return null;
        }
        DockerEelMachine machine = dockerEelMachine;
        DockerAgentContainer dockerAgentContainer = machine.getContainer();
        if ((dockerAgentContainer != null && (dockerAgentContainer = dockerAgentContainer.getInfo()) != null && (dockerAgentContainer = dockerAgentContainer.getHostConfig()) != null ? dockerAgentContainer.getMounts() : (list = null)) == null) {
            list = CollectionsKt.emptyList();
        }
        for (Mount mount : list) {
            String targetRoot;
            if (mount.getType() != MountType.BIND) continue;
            String string = mount.getTarget();
            if (string == null) continue;
            String it = string;
            boolean bl = false;
            EelPath eelPath = EelPath.Companion.parse(it, descriptor2);
            string = eelPath;
            if (eelPath == null || !path2.startsWith((EelPath)(targetRoot = string))) continue;
            Intrinsics.checkNotNull((Object)mount);
            EelPath eelPath2 = this.adjustSourcePath(mount);
            if (eelPath2 == null) continue;
            EelPath sourceRoot = eelPath2;
            Boolean bl2 = mount.getReadOnly();
            boolean readOnly = bl2 != null ? bl2 : false;
            return new DockerMountRoot((EelPath)targetRoot, sourceRoot, readOnly);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final EelPath adjustSourcePath(@NotNull Mount mount) {
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        try {
            EelPath eelPath;
            String string = mount.getSource();
            if (string == null) return null;
            String source = string;
            boolean bl = false;
            if (SystemInfo.isMac) {
                eelPath = EelPath.Companion.parse(StringsKt.removePrefix((String)source, (CharSequence)"/host_mnt"), (EelDescriptor)LocalEelDescriptor.INSTANCE);
                return eelPath;
            } else if (SystemInfo.isWindows) {
                String mountPath = StringsKt.removePrefix((String)source, (CharSequence)"/run/desktop/mnt/host/");
                if (mountPath.length() <= 1) return null;
                char c = mountPath.charAt(0);
                if ('a' > c) return null;
                if (c >= '{') return null;
                boolean bl2 = true;
                if (!bl2) return null;
                if (mountPath.charAt(1) != '/') return null;
                eelPath = EelPath.Companion.parse(DockerMountsAwareHelperKt.access$convertToWindowsPath(mountPath), (EelDescriptor)LocalEelDescriptor.INSTANCE);
                return eelPath;
            } else {
                eelPath = EelPath.Companion.parse(source, (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            return eelPath;
        }
        catch (EelPathException eelPathException) {
            return null;
        }
    }
}

