/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.github.dockerjava.api.command.PruneCmd;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.model.PruneResponse;
import com.github.dockerjava.api.model.PruneType;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerStatus;
import com.intellij.docker.action.DockerNetworksGroupHelper;
import com.intellij.docker.action.DockerVolumesGroupHelper;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.util.DockerJavaUtilsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.BackendDockerRuntimeRegistry;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntimeKt;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeDetailsProvider;
import com.intellij.docker.runtimes.DockerVolumeRuntime;
import com.intellij.docker.runtimes.presentation.DockerContainersGroupRuntimePresentationInterface;
import com.intellij.docker.runtimes.presentation.DockerImagesGroupRuntimePresentationInterface;
import com.intellij.docker.runtimes.presentation.DockerNetworksGroupRuntimePresentationInterface;
import com.intellij.docker.runtimes.presentation.DockerVolumesGroupRuntimePresentationInterface;
import com.intellij.docker.runtimes.presentation.api.DockerGroupRuntimePresentationInterface;
import com.intellij.docker.ui.scaffold.Scaffold;
import com.intellij.docker.ui.scaffold.ScaffoldKt;
import com.intellij.docker.ui.utils.SharedDockerUiUtilsKt;
import com.intellij.docker.view.DockerRuntimeServiceViewContributor;
import com.intellij.docker.view.details.container.DockerContainersGroupDetailsProvider;
import com.intellij.docker.view.details.container.DockerDevcontainersGroupDetailsProvider;
import com.intellij.docker.view.details.image.DockerImagesGroupDetailsProvider;
import com.intellij.docker.view.details.network.DockerNetworksGroupDetailsProvider;
import com.intellij.docker.view.details.volume.DockerVolumesGroupDetailsProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\b\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB\u0019\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H$R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime;", "T", "Lcom/intellij/docker/runtimes/DockerRuntimeBase;", "Lcom/intellij/docker/runtimes/DockerRuntime;", "Lcom/intellij/docker/runtimes/presentation/api/DockerGroupRuntimePresentationInterface;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/openapi/project/Project;)V", "getContext", "()Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "uniqueId", "Ljava/util/UUID;", "getUniqueId", "()Ljava/util/UUID;", "getChildren", "", "doGetChildren", "", "Default", "Flat", "DevcontainersGroup", "ComposeApplicationsGroup", "ContainersGroup", "ImagesGroup", "VolumesGroup", "NetworksGroup", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$Default;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$Flat;", "intellij.clouds.docker"})
public abstract sealed class DockerGroupRuntime<T extends DockerRuntimeBase>
extends DockerRuntime
implements DockerGroupRuntimePresentationInterface {
    @NotNull
    private final DockerRuntimeContext context;
    @NotNull
    private final UUID uniqueId;

    private DockerGroupRuntime(DockerRuntimeContext context, Project project) {
        super(project);
        this.context = context;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uniqueId = uUID;
        BackendDockerRuntimeRegistry.Companion.getInstance(project).registerRuntime(this);
    }

    @NotNull
    public final DockerRuntimeContext getContext() {
        return this.context;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @NotNull
    public List<T> getChildren() {
        return SharedDockerUiUtilsKt.withNaturalSorting((Iterable)this.doGetChildren());
    }

    @NotNull
    protected abstract Collection<T> doGetChildren();

    public /* synthetic */ DockerGroupRuntime(DockerRuntimeContext context, Project project, DefaultConstructorMarker $constructor_marker) {
        this(context, project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$ComposeApplicationsGroup;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$Flat;", "Lcom/intellij/docker/runtimes/ComposeApplicationRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/openapi/project/Project;)V", "doGetChildren", "", "intellij.clouds.docker"})
    public static final class ComposeApplicationsGroup
    extends Flat<ComposeApplicationRuntime> {
        public ComposeApplicationsGroup(@NotNull DockerRuntimeContext context, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(context, project);
        }

        @Override
        @NotNull
        protected Collection<ComposeApplicationRuntime> doGetChildren() {
            return this.getContext().getRuntimesManager().getComposeApplicationRuntimes();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$ContainersGroup;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$Default;", "Lcom/intellij/docker/runtimes/DockerApplicationRuntime;", "Lcom/intellij/docker/runtimes/presentation/DockerContainersGroupRuntimePresentationInterface;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/openapi/project/Project;)V", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "doGetChildren", "", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "pruneType", "Lcom/github/dockerjava/api/model/PruneType;", "getPruneType", "()Lcom/github/dockerjava/api/model/PruneType;", "Companion", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerGroupRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$ContainersGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n774#2:346\n865#2,2:347\n774#2:349\n865#2,2:350\n*S KotlinDebug\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$ContainersGroup\n*L\n181#1:346\n181#1:347,2\n194#1:349\n194#1:350,2\n*E\n"})
    public static final class ContainersGroup
    extends Default<DockerApplicationRuntime>
    implements DockerContainersGroupRuntimePresentationInterface {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DockerRuntimeDetailsProvider detailsProvider;
        @NotNull
        private final String presentableName;
        @NotNull
        private final PruneType pruneType;

        public ContainersGroup(@NotNull DockerRuntimeContext context, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(context, Companion.displayName(), Companion.icon(), project);
            this.detailsProvider = new DockerContainersGroupDetailsProvider(this);
            this.presentableName = Companion.displayName();
            this.pruneType = PruneType.CONTAINERS;
        }

        @Override
        @NotNull
        public DockerRuntimeDetailsProvider getDetailsProvider() {
            return this.detailsProvider;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            return this.presentableName;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected Collection<DockerApplicationRuntime> doGetChildren() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getContext().getRuntimesManager().getContainers().values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DockerApplicationRuntime it = (DockerApplicationRuntime)element$iv$iv;
                boolean bl = false;
                if (!(it.getComposeData() == null && !DockerGroupRuntimeKt.access$isDevcontainer(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public Scaffold.SimpleSegment getHeaderComponent(@NotNull Scaffold scaffold) {
            Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
            Scaffold $this$getHeaderComponent_u24lambda_u240 = scaffold;
            boolean bl = false;
            return $this$getHeaderComponent_u24lambda_u240.segment(arg_0 -> ContainersGroup.getHeaderComponent$lambda$0$0(this, arg_0));
        }

        @Override
        @NotNull
        public PruneType getPruneType() {
            return this.pruneType;
        }

        private static final Unit getHeaderComponent$lambda$0$0(ContainersGroup this$0, Scaffold.SimpleSegment $this$segment) {
            Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
            $this$segment.textFragment(ContainersGroup::getHeaderComponent$lambda$0$0$0);
            $this$segment.textFragment(arg_0 -> ContainersGroup.getHeaderComponent$lambda$0$0$1(this$0, arg_0));
            ScaffoldKt.button$default((Scaffold.SimpleSegment)$this$segment, null, null, (String)"Docker.RemoteServers.Prune", null, (int)11, null);
            return Unit.INSTANCE;
        }

        private static final Unit getHeaderComponent$lambda$0$0$0(Scaffold.SimpleSegment.TextFragment $this$textFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
            $this$textFragment.setIcon(Companion.icon());
            $this$textFragment.append(Companion.displayName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit getHeaderComponent$lambda$0$0$1(ContainersGroup this$0, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
            List containers2 = this$0.getChildren();
            Iterable $this$filter$iv = containers2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DockerApplicationRuntime it = (DockerApplicationRuntime)element$iv$iv;
                boolean bl = false;
                if (!it.isRunning()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List runningContainer = (List)destination$iv$iv;
            Object[] objectArray = new Object[]{runningContainer.size(), containers2.size()};
            $this$textFragment.append(DockerBundle.message((String)"Docker.running.state", (Object[])objectArray), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            return Unit.INSTANCE;
        }

        @JvmStatic
        @Nls
        @NotNull
        public static final String displayName() {
            return Companion.displayName();
        }

        @JvmStatic
        @NotNull
        public static final Icon icon() {
            return Companion.icon();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$ContainersGroup$Companion;", "", "<init>", "()V", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "icon", "Ljavax/swing/Icon;", "intellij.clouds.docker"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Nls
            @NotNull
            public final String displayName() {
                String string = DockerBundle.message((String)"DockerGroupRuntime.ContainersGroup.groupName", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @JvmStatic
            @NotNull
            public final Icon icon() {
                Icon icon = DockerIcons.ContainersList_3;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ContainersList_3");
                return icon;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B,\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$Default;", "T", "Lcom/intellij/docker/runtimes/DockerRuntimeBase;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "icon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/openapi/project/Project;)V", "pruneType", "Lcom/github/dockerjava/api/model/PruneType;", "getPruneType", "()Lcom/github/dockerjava/api/model/PruneType;", "prune", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.docker"})
    public static abstract class Default<T extends DockerRuntimeBase>
    extends DockerGroupRuntime<T> {
        @NotNull
        private final String displayName;
        @Nullable
        private final PruneType pruneType;

        public Default(@NotNull DockerRuntimeContext context, @NotNull String displayName, @NotNull Icon icon, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(context, project, null);
            this.displayName = displayName;
            this.getRuntimeStatusState().setValue((Object)DockerStatus.Companion.create(icon, () -> Default._init_$lambda$0(this)));
        }

        @Nullable
        public PruneType getPruneType() {
            return this.pruneType;
        }

        @Nullable
        public Object prune(@NotNull Continuation<? super Unit> $completion) {
            return Default.prune$suspendImpl(this, $completion);
        }

        static /* synthetic */ <T extends DockerRuntimeBase> Object prune$suspendImpl(Default<T> $this, Continuation<? super Unit> $completion) {
            block1: {
                PruneType pruneType = $this.getPruneType();
                if (pruneType == null) break block1;
                PruneType it = pruneType;
                boolean bl = false;
                PruneCmd pruneCmd = $this.getContext().getAgent().getDockerClient().pruneCmd(it);
                Intrinsics.checkNotNullExpressionValue((Object)pruneCmd, (String)"pruneCmd(...)");
                Object object = DockerJavaUtilsKt.execOnIO((SyncDockerCmd)((SyncDockerCmd)pruneCmd), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                PruneResponse cfr_ignored_0 = (PruneResponse)object;
            }
            return Unit.INSTANCE;
        }

        private static final String _init_$lambda$0(Default this$0) {
            return this$0.displayName;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$DevcontainersGroup;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$Default;", "Lcom/intellij/docker/runtimes/DockerApplicationRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/openapi/project/Project;)V", "doGetChildren", "", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "Companion", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerGroupRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$DevcontainersGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n774#2:346\n865#2,2:347\n774#2:349\n865#2,2:350\n*S KotlinDebug\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$DevcontainersGroup\n*L\n110#1:346\n110#1:347,2\n140#1:349\n140#1:350,2\n*E\n"})
    public static final class DevcontainersGroup
    extends Default<DockerApplicationRuntime> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DockerRuntimeDetailsProvider detailsProvider;
        @NotNull
        private final String presentableName;

        public DevcontainersGroup(@NotNull DockerRuntimeContext context, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = Companion.displayName();
            Icon icon = DockerIcons.DevContainers;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DevContainers");
            super(context, string, icon, project);
            this.detailsProvider = new DockerDevcontainersGroupDetailsProvider(this);
            this.presentableName = Companion.displayName();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected Collection<DockerApplicationRuntime> doGetChildren() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getContext().getRuntimesManager().getContainers().values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DockerApplicationRuntime p0 = (DockerApplicationRuntime)element$iv$iv;
                boolean bl = false;
                if (!DockerGroupRuntimeKt.access$isDevcontainer(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public Scaffold.SimpleSegment getHeaderComponent(@NotNull Scaffold scaffold) {
            Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
            DevcontainersGroup runtime = this;
            Scaffold $this$getHeaderComponent_u24lambda_u240 = scaffold;
            boolean bl = false;
            $this$getHeaderComponent_u24lambda_u240.segment(DevcontainersGroup::getHeaderComponent$lambda$0$0);
            return $this$getHeaderComponent_u24lambda_u240.segment(arg_0 -> DevcontainersGroup.getHeaderComponent$lambda$0$1(runtime, this, arg_0));
        }

        @Override
        @NotNull
        public DockerRuntimeDetailsProvider getDetailsProvider() {
            return this.detailsProvider;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            return this.presentableName;
        }

        private static final Unit getHeaderComponent$lambda$0$0(Scaffold.SimpleSegment $this$segment) {
            Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
            $this$segment.textFragment(DevcontainersGroup::getHeaderComponent$lambda$0$0$0);
            return Unit.INSTANCE;
        }

        private static final Unit getHeaderComponent$lambda$0$0$0(Scaffold.SimpleSegment.TextFragment $this$textFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
            $this$textFragment.setIcon(AllIcons.General.Beta);
            String string = AdvancedSettings.Companion.getBoolean("open.devcontainer.projects.natively") ? DockerBundle.message((String)"devcontainer.promo.panel.used.text", (Object[])new Object[0]) : DockerBundle.message((String)"devcontainer.promo.panel.text", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            String text = string;
            $this$textFragment.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            $this$textFragment.append("   ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            $this$textFragment.append(DockerBundle.message((String)"devcontainer.promo.panel.learn.more", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, DevcontainersGroup::getHeaderComponent$lambda$0$0$0$0);
            return Unit.INSTANCE;
        }

        private static final void getHeaderComponent$lambda$0$0$0$0() {
            HelpManager.getInstance().invokeHelp("open_project_with_dev_container_natively");
        }

        private static final Unit getHeaderComponent$lambda$0$1(DevcontainersGroup $runtime, DevcontainersGroup this$0, Scaffold.SimpleSegment $this$segment) {
            Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
            $this$segment.textFragment(arg_0 -> DevcontainersGroup.getHeaderComponent$lambda$0$1$0($runtime, arg_0));
            $this$segment.textFragment(arg_0 -> DevcontainersGroup.getHeaderComponent$lambda$0$1$1(this$0, arg_0));
            ScaffoldKt.button$default((Scaffold.SimpleSegment)$this$segment, null, null, (String)"Dev.Container.Create", null, (int)11, null);
            ScaffoldKt.button$default((Scaffold.SimpleSegment)$this$segment, (Icon)AllIcons.Actions.Find, null, (String)"Dev.Container.ShowRecent", null, (int)10, null);
            return Unit.INSTANCE;
        }

        private static final Unit getHeaderComponent$lambda$0$1$0(DevcontainersGroup $runtime, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
            $this$textFragment.setIcon($runtime.getStatus().getIcon());
            $this$textFragment.append((String)$runtime.getStatus().getText().get(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit getHeaderComponent$lambda$0$1$1(DevcontainersGroup this$0, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
            List containers2 = this$0.getChildren();
            Iterable $this$filter$iv = containers2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DockerApplicationRuntime it = (DockerApplicationRuntime)element$iv$iv;
                boolean bl = false;
                if (!it.isRunning()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List runningContainer = (List)destination$iv$iv;
            Object[] objectArray = new Object[]{runningContainer.size(), containers2.size()};
            $this$textFragment.append(DockerBundle.message((String)"Docker.running.state", (Object[])objectArray), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            return Unit.INSTANCE;
        }

        @JvmStatic
        @Nls
        @NotNull
        public static final String displayName() {
            return Companion.displayName();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$DevcontainersGroup$Companion;", "", "<init>", "()V", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "intellij.clouds.docker"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Nls
            @NotNull
            public final String displayName() {
                String string = DockerBundle.message((String)"DockerGroupRuntime.DevcontainersGroup.groupName", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$Flat;", "T", "Lcom/intellij/docker/runtimes/DockerRuntimeBase;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/openapi/project/Project;)V", "status", "Lcom/intellij/docker/DockerStatus;", "getStatus", "()Lcom/intellij/docker/DockerStatus;", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "serviceViewContributor", "Lcom/intellij/docker/view/DockerRuntimeServiceViewContributor;", "getServiceViewContributor", "()Lcom/intellij/docker/view/DockerRuntimeServiceViewContributor;", "intellij.clouds.docker"})
    public static abstract class Flat<T extends DockerRuntimeBase>
    extends DockerGroupRuntime<T> {
        @NotNull
        private final DockerRuntimeDetailsProvider detailsProvider;

        public Flat(@NotNull DockerRuntimeContext context, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(context, project, null);
            this.detailsProvider = DockerRuntimeDetailsProvider.Companion.getNO_DETAILS();
        }

        @Override
        @NotNull
        public DockerStatus getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DockerRuntimeDetailsProvider getDetailsProvider() {
            return this.detailsProvider;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DockerRuntimeServiceViewContributor getServiceViewContributor() {
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001fB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0014J!\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$Default;", "Lcom/intellij/docker/runtimes/DockerImageRuntime;", "Lcom/intellij/docker/runtimes/presentation/DockerImagesGroupRuntimePresentationInterface;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/openapi/project/Project;)V", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "doGetChildren", "", "pullImage", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/intellij/docker/agent/progress/DockerResponseItem$AuxDetail;", "tag", "Lcom/intellij/docker/agent/DockerRepoTag;", "pullImage$intellij_clouds_docker", "pruneType", "Lcom/github/dockerjava/api/model/PruneType;", "getPruneType", "()Lcom/github/dockerjava/api/model/PruneType;", "Companion", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerGroupRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n808#2,11:346\n*S KotlinDebug\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup\n*L\n233#1:346,11\n*E\n"})
    public static final class ImagesGroup
    extends Default<DockerImageRuntime>
    implements DockerImagesGroupRuntimePresentationInterface {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String presentableName;
        @NotNull
        private final DockerRuntimeDetailsProvider detailsProvider;
        @NotNull
        private final PruneType pruneType;

        public ImagesGroup(@NotNull DockerRuntimeContext context, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(context, Companion.displayName(), Companion.icon(), project);
            this.presentableName = Companion.displayName();
            this.detailsProvider = new DockerImagesGroupDetailsProvider(this);
            this.pruneType = PruneType.IMAGES;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            return this.presentableName;
        }

        @Override
        @NotNull
        public DockerRuntimeDetailsProvider getDetailsProvider() {
            return this.detailsProvider;
        }

        @Override
        @NotNull
        protected Collection<DockerImageRuntime> doGetChildren() {
            return this.getContext().getRuntimesManager().getImages().values();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CompletableFuture<List<DockerResponseItem.AuxDetail>> pullImage$intellij_clouds_docker(@NotNull DockerRepoTag tag) {
            CompletableFuture<List<Object>> completableFuture;
            CompletableFuture<List<DockerResponseItem.AuxDetail>> completableFuture2;
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Iterable $this$filterIsInstance$iv = this.getTabManager().getTabs();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DockerImagesGroupDetailsProvider.ImagePullTab)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            DockerImagesGroupDetailsProvider.ImagePullTab imagePullTab = (DockerImagesGroupDetailsProvider.ImagePullTab)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (imagePullTab != null && (completableFuture2 = imagePullTab.pullImage(tag)) != null) {
                completableFuture = completableFuture2;
            } else {
                CompletableFuture completableFuture3 = CompletableFuture.failedFuture(new RuntimeException("Can't find pull image tab"));
                completableFuture = completableFuture3;
                Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"failedFuture(...)");
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public PruneType getPruneType() {
            return this.pruneType;
        }

        @JvmStatic
        @Nls
        @NotNull
        public static final String displayName() {
            return Companion.displayName();
        }

        @JvmStatic
        @NotNull
        public static final Icon icon() {
            return Companion.icon();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup$Companion;", "", "<init>", "()V", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "icon", "Ljavax/swing/Icon;", "intellij.clouds.docker"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Nls
            @NotNull
            public final String displayName() {
                String string = DockerBundle.message((String)"DockerGroupRuntime.ImagesGroup.groupName", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @JvmStatic
            @NotNull
            public final Icon icon() {
                Icon icon = DockerIcons.ImagesList_2;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ImagesList_2");
                return icon;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001fB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0014J\u000e\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$NetworksGroup;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$Default;", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "Lcom/intellij/docker/runtimes/presentation/DockerNetworksGroupRuntimePresentationInterface;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/openapi/project/Project;)V", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "doGetChildren", "", "createNetwork", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pruneType", "Lcom/github/dockerjava/api/model/PruneType;", "getPruneType", "()Lcom/github/dockerjava/api/model/PruneType;", "Companion", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerGroupRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$NetworksGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n774#2:346\n865#2,2:347\n*S KotlinDebug\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$NetworksGroup\n*L\n325#1:346\n325#1:347,2\n*E\n"})
    public static final class NetworksGroup
    extends Default<DockerNetworkRuntime>
    implements DockerNetworksGroupRuntimePresentationInterface {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String presentableName;
        @NotNull
        private final DockerRuntimeDetailsProvider detailsProvider;
        @NotNull
        private final PruneType pruneType;

        public NetworksGroup(@NotNull DockerRuntimeContext context, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(context, Companion.displayName(), Companion.icon(), project);
            this.presentableName = Companion.displayName();
            this.detailsProvider = new DockerNetworksGroupDetailsProvider(this);
            this.pruneType = PruneType.NETWORKS;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            return this.presentableName;
        }

        @Override
        @NotNull
        public DockerRuntimeDetailsProvider getDetailsProvider() {
            return this.detailsProvider;
        }

        @Override
        @NotNull
        public Scaffold.SimpleSegment getHeaderComponent(@NotNull Scaffold scaffold) {
            Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
            Scaffold $this$getHeaderComponent_u24lambda_u240 = scaffold;
            boolean bl = false;
            return $this$getHeaderComponent_u24lambda_u240.segment(NetworksGroup::getHeaderComponent$lambda$0$0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected Collection<DockerNetworkRuntime> doGetChildren() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getContext().getRuntimesManager().getNetworks().values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DockerNetworkRuntime it = (DockerNetworkRuntime)element$iv$iv;
                boolean bl = false;
                Map map2 = it.getNetwork().labels;
                if (!((map2 != null ? (String)map2.get("com.docker.compose.project") : null) == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public Object createNetwork(@NotNull Continuation<? super Unit> $completion) {
            Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ NetworksGroup this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DockerNetworksGroupHelper.INSTANCE.createNetworkIn(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Override
        @NotNull
        public PruneType getPruneType() {
            return this.pruneType;
        }

        private static final Unit getHeaderComponent$lambda$0$0(Scaffold.SimpleSegment $this$segment) {
            Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
            $this$segment.textFragment(NetworksGroup::getHeaderComponent$lambda$0$0$0);
            ScaffoldKt.button$default((Scaffold.SimpleSegment)$this$segment, null, null, (String)"Docker.RemoteServers.CreateNetwork", null, (int)11, null);
            ScaffoldKt.button$default((Scaffold.SimpleSegment)$this$segment, null, null, (String)"Docker.RemoteServers.Prune", null, (int)11, null);
            return Unit.INSTANCE;
        }

        private static final Unit getHeaderComponent$lambda$0$0$0(Scaffold.SimpleSegment.TextFragment $this$textFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
            $this$textFragment.setIcon(Companion.icon());
            $this$textFragment.append(Companion.displayName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return Unit.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public static final Icon icon() {
            return Companion.icon();
        }

        @JvmStatic
        @Nls
        @NotNull
        public static final String displayName() {
            return Companion.displayName();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$NetworksGroup$Companion;", "", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "intellij.clouds.docker"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Icon icon() {
                Icon icon = DockerIcons.Network;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Network");
                return icon;
            }

            @JvmStatic
            @Nls
            @NotNull
            public final String displayName() {
                String string = DockerBundle.message((String)"DockerGroupRuntime.NetworksGroup.groupName", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001fB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$VolumesGroup;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$Default;", "Lcom/intellij/docker/runtimes/DockerVolumeRuntime;", "Lcom/intellij/docker/runtimes/presentation/DockerVolumesGroupRuntimePresentationInterface;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/openapi/project/Project;)V", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "doGetChildren", "", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "createVolume", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pruneType", "Lcom/github/dockerjava/api/model/PruneType;", "getPruneType", "()Lcom/github/dockerjava/api/model/PruneType;", "Companion", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerGroupRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$VolumesGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n774#2:346\n865#2,2:347\n*S KotlinDebug\n*F\n+ 1 DockerGroupRuntime.kt\ncom/intellij/docker/runtimes/DockerGroupRuntime$VolumesGroup\n*L\n271#1:346\n271#1:347,2\n*E\n"})
    public static final class VolumesGroup
    extends Default<DockerVolumeRuntime>
    implements DockerVolumesGroupRuntimePresentationInterface {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String presentableName;
        @NotNull
        private final DockerRuntimeDetailsProvider detailsProvider;
        @NotNull
        private final PruneType pruneType;

        public VolumesGroup(@NotNull DockerRuntimeContext context, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(context, Companion.displayName(), Companion.icon(), project);
            this.presentableName = Companion.displayName();
            this.detailsProvider = new DockerVolumesGroupDetailsProvider(this);
            this.pruneType = PruneType.VOLUMES;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            return this.presentableName;
        }

        @Override
        @NotNull
        public DockerRuntimeDetailsProvider getDetailsProvider() {
            return this.detailsProvider;
        }

        @Override
        @NotNull
        protected Collection<DockerVolumeRuntime> doGetChildren() {
            return this.getContext().getRuntimesManager().getVolumes().values();
        }

        @Override
        @NotNull
        public Scaffold.SimpleSegment getHeaderComponent(@NotNull Scaffold scaffold) {
            Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
            Scaffold $this$getHeaderComponent_u24lambda_u240 = scaffold;
            boolean bl = false;
            return $this$getHeaderComponent_u24lambda_u240.segment(arg_0 -> VolumesGroup.getHeaderComponent$lambda$0$0(this, arg_0));
        }

        @Nullable
        public Object createVolume(@NotNull Continuation<? super Unit> $completion) {
            Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ VolumesGroup this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DockerVolumesGroupHelper.INSTANCE.createVolumeIn(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Override
        @NotNull
        public PruneType getPruneType() {
            return this.pruneType;
        }

        private static final Unit getHeaderComponent$lambda$0$0(VolumesGroup this$0, Scaffold.SimpleSegment $this$segment) {
            Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
            $this$segment.textFragment(VolumesGroup::getHeaderComponent$lambda$0$0$0);
            $this$segment.textFragment(arg_0 -> VolumesGroup.getHeaderComponent$lambda$0$0$1(this$0, arg_0));
            ScaffoldKt.button$default((Scaffold.SimpleSegment)$this$segment, null, null, (String)"Docker.RemoteServers.InspectContainerOrImage", null, (int)11, null);
            ScaffoldKt.button$default((Scaffold.SimpleSegment)$this$segment, null, null, (String)"Docker.RemoteServers.Prune", null, (int)11, null);
            return Unit.INSTANCE;
        }

        private static final Unit getHeaderComponent$lambda$0$0$0(Scaffold.SimpleSegment.TextFragment $this$textFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
            $this$textFragment.setIcon(Companion.icon());
            $this$textFragment.append(Companion.displayName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit getHeaderComponent$lambda$0$0$1(VolumesGroup this$0, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
            List allVolumes = this$0.getChildren();
            Iterable $this$filter$iv = allVolumes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DockerVolumeRuntime it = (DockerVolumeRuntime)element$iv$iv;
                boolean bl = false;
                if (!(UtilKt.nullize(it.getAttachedContainers()) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List usedVolumes = (List)destination$iv$iv;
            Object[] objectArray = new Object[]{usedVolumes.size(), allVolumes.size()};
            $this$textFragment.append(DockerBundle.message((String)"DockerVolumeDashboardTab.in.use.count", (Object[])objectArray), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            return Unit.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public static final Icon icon() {
            return Companion.icon();
        }

        @JvmStatic
        @Nls
        @NotNull
        public static final String displayName() {
            return Companion.displayName();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/runtimes/DockerGroupRuntime$VolumesGroup$Companion;", "", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "intellij.clouds.docker"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Icon icon() {
                Icon icon = DockerIcons.Volume;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Volume");
                return icon;
            }

            @JvmStatic
            @Nls
            @NotNull
            public final String displayName() {
                String string = DockerBundle.message((String)"DockerGroupRuntime.VolumesGroup.groupName", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

