/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralSettingsKt;
import com.intellij.ide.GeneralSettingsState;
import com.intellij.ide.ProcessCloseConfirmation;
import com.intellij.ide.ui.UINumericRange;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.platform.ide.core.customization.IdeLifecycleUiCustomization;
import com.intellij.platform.ide.core.customization.ProjectLifecycleUiCustomization;
import com.intellij.util.PlatformUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GeneralSettings", storages={@Storage(value="ide.general.xml")}, category=SettingsCategory.SYSTEM)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 C2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003CDEB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001eH\u0002J\b\u0010=\u001a\u00020\u0002H\u0016J\b\u0010>\u001a\u00020;H\u0016J\u0010\u0010?\u001a\u00020;2\u0006\u0010\u0005\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR$\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR$\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR$\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000fR$\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR$\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R$\u0010#\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000fR$\u0010%\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\r\"\u0004\b&\u0010\u000fR$\u0010'\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\r\"\u0004\b(\u0010\u000fR$\u0010*\u001a\u00020)2\u0006\u0010\n\u001a\u00020)8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u00100\u001a\u00020/2\u0006\u0010\n\u001a\u00020/8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00105\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\r\"\u0004\b6\u0010\u000fR$\u00107\u001a\u00020)2\u0006\u0010\n\u001a\u00020)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010,\"\u0004\b9\u0010.R\u0018\u0010@\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\bA8G\u00a2\u0006\u0006\u001a\u0004\bB\u0010\t\u00a8\u0006F"}, d2={"Lcom/intellij/ide/GeneralSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ide/GeneralSettingsState;", "<init>", "()V", "state", "browserPath", "", "getBrowserPath", "()Ljava/lang/String;", "value", "", "isShowTipsOnStartup", "()Z", "setShowTipsOnStartup", "(Z)V", "isReopenLastProject", "setReopenLastProject", "isSyncOnFrameActivation", "setSyncOnFrameActivation", "isBackgroundSync", "setBackgroundSync", "isSaveOnFrameDeactivation", "setSaveOnFrameDeactivation", "isAutoSaveIfInactive", "setAutoSaveIfInactive", "isUseSafeWrite", "setUseSafeWrite", "_propertyChangedFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/ide/GeneralSettings$PropertyNames;", "propertyChangedFlow", "Lkotlinx/coroutines/flow/Flow;", "getPropertyChangedFlow", "()Lkotlinx/coroutines/flow/Flow;", "isSearchInBackground", "setSearchInBackground", "isConfirmExit", "setConfirmExit", "isShowWelcomeScreen", "setShowWelcomeScreen", "", "confirmOpenNewProject", "getConfirmOpenNewProject", "()I", "setConfirmOpenNewProject", "(I)V", "Lcom/intellij/ide/ProcessCloseConfirmation;", "processCloseConfirmation", "getProcessCloseConfirmation", "()Lcom/intellij/ide/ProcessCloseConfirmation;", "setProcessCloseConfirmation", "(Lcom/intellij/ide/ProcessCloseConfirmation;)V", "isSupportScreenReaders", "setSupportScreenReaders", "inactiveTimeout", "getInactiveTimeout", "setInactiveTimeout", "propertyChanged", "", "property", "getState", "noStateLoaded", "loadState", "defaultProjectDirectory", "Lorg/jetbrains/annotations/SystemDependent;", "getDefaultProjectDirectory", "Companion", "PropertyNames", "OpenNewProjectOption", "intellij.platform.ide.core"})
public final class GeneralSettings
implements PersistentStateComponent<GeneralSettingsState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private GeneralSettingsState state = new GeneralSettingsState(null, null, null, false, false, false, false, false, false, false, false, false, false, null, null, 0, false, 131071, null);
    @NotNull
    private final MutableSharedFlow<PropertyNames> _propertyChangedFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)16, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
    @NotNull
    private final Flow<PropertyNames> propertyChangedFlow = (Flow)FlowKt.asSharedFlow(this._propertyChangedFlow);
    @NotNull
    public static final String IDE_GENERAL_XML = "ide.general.xml";
    public static final int OPEN_PROJECT_ASK = -1;
    public static final int OPEN_PROJECT_NEW_WINDOW = 0;
    public static final int OPEN_PROJECT_SAME_WINDOW = 1;
    public static final int OPEN_PROJECT_SAME_WINDOW_ATTACH = 2;
    @NotNull
    public static final String SUPPORT_SCREEN_READERS = "ide.support.screenreaders.enabled";
    @NotNull
    private static final UINumericRange SAVE_FILES_AFTER_IDLE_SEC = new UINumericRange(15, 1, 300);

    public GeneralSettings() {
        PropertiesComponent propertyManager;
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isHeadlessEnvironment() && (PlatformUtils.isPyCharmEducational() || PlatformUtils.isRubyMine() || PlatformUtils.isWebStorm()) && !(propertyManager = PropertiesComponent.getInstance()).isValueSet("GeneralSettings.initiallyConfigured")) {
            propertyManager.setValue("GeneralSettings.initiallyConfigured", true);
            this.state.showTipsOnStartup = false;
        }
    }

    @Deprecated(message="Use {@link GeneralLocalSettings#getBrowserPath()} instead.")
    @Nullable
    public final String getBrowserPath() {
        return this.state.browserPath;
    }

    public final boolean isShowTipsOnStartup() {
        Boolean bl = this.state.showTipsOnStartup;
        return bl != null ? bl : Boolean.parseBoolean(System.getProperty("ide.show.tips.on.startup.default.value", "false"));
    }

    public final void setShowTipsOnStartup(boolean value) {
        this.state.showTipsOnStartup = value;
    }

    public final boolean isReopenLastProject() {
        return ProjectLifecycleUiCustomization.Companion.getInstance().getCanReopenProjectOnStartup() && this.state.reopenLastProject;
    }

    public final void setReopenLastProject(boolean value) {
        this.state.reopenLastProject = value;
    }

    public final boolean isSyncOnFrameActivation() {
        return this.state.autoSyncFiles;
    }

    public final void setSyncOnFrameActivation(boolean value) {
        this.state.autoSyncFiles = value;
    }

    public final boolean isBackgroundSync() {
        return this.state.backgroundSyncFiles;
    }

    public final void setBackgroundSync(boolean value) {
        this.state.backgroundSyncFiles = value;
    }

    public final boolean isSaveOnFrameDeactivation() {
        return this.state.autoSaveFiles;
    }

    public final void setSaveOnFrameDeactivation(boolean value) {
        this.state.autoSaveFiles = value;
    }

    public final boolean isAutoSaveIfInactive() {
        return this.state.autoSaveIfInactive;
    }

    public final void setAutoSaveIfInactive(boolean value) {
        boolean changed = this.state.autoSaveIfInactive != value;
        this.state.autoSaveIfInactive = value;
        if (changed) {
            this.propertyChanged(PropertyNames.autoSaveIfInactive);
        }
    }

    public final boolean isUseSafeWrite() {
        return this.state.isUseSafeWrite;
    }

    public final void setUseSafeWrite(boolean value) {
        this.state.isUseSafeWrite = value;
    }

    @NotNull
    public final Flow<PropertyNames> getPropertyChangedFlow() {
        return this.propertyChangedFlow;
    }

    public final boolean isSearchInBackground() {
        return this.state.searchInBackground;
    }

    public final void setSearchInBackground(boolean value) {
        this.state.searchInBackground = value;
    }

    public final boolean isConfirmExit() {
        return IdeLifecycleUiCustomization.Companion.getInstance().getCanShowExitConfirmation() && this.state.confirmExit;
    }

    public final void setConfirmExit(boolean value) {
        this.state.confirmExit = value;
    }

    public final boolean isShowWelcomeScreen() {
        return this.state.isShowWelcomeScreen;
    }

    public final void setShowWelcomeScreen(boolean value) {
        this.state.isShowWelcomeScreen = value;
    }

    @OpenNewProjectOption
    public final int getConfirmOpenNewProject() {
        int n;
        if (ProjectLifecycleUiCustomization.Companion.getInstance().getAlwaysOpenProjectInNewWindow()) {
            n = 0;
        } else {
            Integer n2 = this.state.confirmOpenNewProject2;
            n = n2 != null ? n2.intValue() : Companion.defaultConfirmNewProject();
        }
        return n;
    }

    public final void setConfirmOpenNewProject(int value) {
        this.state.confirmOpenNewProject2 = value;
    }

    @NotNull
    public final ProcessCloseConfirmation getProcessCloseConfirmation() {
        return this.state.processCloseConfirmation;
    }

    public final void setProcessCloseConfirmation(@NotNull ProcessCloseConfirmation value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.state.processCloseConfirmation = value;
    }

    public final boolean isSupportScreenReaders() {
        Boolean bl = GeneralSettingsKt.access$getSUPPORT_SCREEN_READERS_OVERRIDDEN$p();
        return bl != null ? bl : this.state.supportScreenReaders;
    }

    public final void setSupportScreenReaders(boolean value) {
        boolean changed = this.state.supportScreenReaders != value;
        this.state.supportScreenReaders = value;
        if (changed) {
            this.propertyChanged(PropertyNames.supportScreenReaders);
        }
    }

    public final int getInactiveTimeout() {
        return SAVE_FILES_AFTER_IDLE_SEC.fit(this.state.inactiveTimeout);
    }

    public final void setInactiveTimeout(int value) {
        int newValue = SAVE_FILES_AFTER_IDLE_SEC.fit(value);
        boolean changed = this.state.inactiveTimeout != newValue;
        this.state.inactiveTimeout = newValue;
        if (changed) {
            this.propertyChanged(PropertyNames.inactiveTimeout);
        }
    }

    private final void propertyChanged(PropertyNames property) {
        if (!this._propertyChangedFlow.tryEmit((Object)property)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @NotNull
    public GeneralSettingsState getState() {
        return this.state;
    }

    public void noStateLoaded() {
        this.loadState(new GeneralSettingsState(null, null, null, false, false, false, false, false, false, false, false, false, false, null, null, 0, false, 131071, null));
    }

    public void loadState(@NotNull GeneralSettingsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @Deprecated(message="Use {@link GeneralLocalSettings#getDefaultProjectDirectory()} instead.")
    @Nullable
    public final String getDefaultProjectDirectory() {
        return this.state.defaultProjectDirectory;
    }

    @JvmStatic
    @NotNull
    public static final GeneralSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0006\u0010\u0013\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/GeneralSettings$Companion;", "", "<init>", "()V", "IDE_GENERAL_XML", "", "OPEN_PROJECT_ASK", "", "OPEN_PROJECT_NEW_WINDOW", "OPEN_PROJECT_SAME_WINDOW", "OPEN_PROJECT_SAME_WINDOW_ATTACH", "SUPPORT_SCREEN_READERS", "getSUPPORT_SCREEN_READERS$annotations", "SAVE_FILES_AFTER_IDLE_SEC", "Lcom/intellij/ide/ui/UINumericRange;", "getSAVE_FILES_AFTER_IDLE_SEC", "()Lcom/intellij/ide/ui/UINumericRange;", "getInstance", "Lcom/intellij/ide/GeneralSettings;", "defaultConfirmNewProject", "intellij.platform.ide.core"})
    @SourceDebugExtension(value={"SMAP\nGeneralSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralSettings.kt\ncom/intellij/ide/GeneralSettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,259:1\n30#2,2:260\n*S KotlinDebug\n*F\n+ 1 GeneralSettings.kt\ncom/intellij/ide/GeneralSettings$Companion\n*L\n149#1:260,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getSUPPORT_SCREEN_READERS$annotations() {
        }

        @NotNull
        public final UINumericRange getSAVE_FILES_AFTER_IDLE_SEC() {
            return SAVE_FILES_AFTER_IDLE_SEC;
        }

        @JvmStatic
        @NotNull
        public final GeneralSettings getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<GeneralSettings> serviceClass$iv = GeneralSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GeneralSettings)object;
        }

        public final int defaultConfirmNewProject() {
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0080\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/intellij/ide/GeneralSettings$OpenNewProjectOption;", "", "intellij.platform.ide.core"})
    public static @interface OpenNewProjectOption {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/GeneralSettings$PropertyNames;", "", "<init>", "(Ljava/lang/String;I)V", "inactiveTimeout", "autoSaveIfInactive", "supportScreenReaders", "intellij.platform.ide.core"})
    public static final class PropertyNames
    extends Enum<PropertyNames> {
        public static final /* enum */ PropertyNames inactiveTimeout = new PropertyNames();
        public static final /* enum */ PropertyNames autoSaveIfInactive = new PropertyNames();
        public static final /* enum */ PropertyNames supportScreenReaders = new PropertyNames();
        private static final /* synthetic */ PropertyNames[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PropertyNames[] values() {
            return (PropertyNames[])$VALUES.clone();
        }

        public static PropertyNames valueOf(String value) {
            return Enum.valueOf(PropertyNames.class, value);
        }

        @NotNull
        public static EnumEntries<PropertyNames> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = propertyNamesArray = new PropertyNames[]{PropertyNames.inactiveTimeout, PropertyNames.autoSaveIfInactive, PropertyNames.supportScreenReaders};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

