/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.system.OS;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class NativeFileType
implements INativeFileType {
    public static final NativeFileType INSTANCE = new NativeFileType();

    private NativeFileType() {
    }

    @NotNull
    public String getName() {
        return "Native";
    }

    @NotNull
    public String getDescription() {
        String string = IdeCoreBundle.message("filetype.native.description", new Object[0]);
        if (string == null) {
            NativeFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = IdeCoreBundle.message("filetype.native.display.name", new Object[0]);
        if (string == null) {
            NativeFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Custom;
    }

    public boolean isBinary() {
        return true;
    }

    public boolean openFileInAssociatedApplication(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            NativeFileType.$$$reportNull$$$0(2);
        }
        return NativeFileType.openAssociatedApplication(file);
    }

    public boolean useNativeIcon() {
        return true;
    }

    public static boolean openAssociatedApplication(@NotNull VirtualFile file) {
        if (file == null) {
            NativeFileType.$$$reportNull$$$0(3);
        }
        if (!file.isInLocalFileSystem()) {
            throw new IllegalArgumentException("Non-local file: " + String.valueOf(file) + "; FS=" + String.valueOf(file.getFileSystem()));
        }
        ArrayList<String> commands = new ArrayList<String>();
        if (OS.CURRENT == OS.Windows) {
            commands.add("rundll32.exe");
            commands.add("url.dll,FileProtocolHandler");
        } else if (OS.CURRENT == OS.macOS) {
            commands.add("/usr/bin/open");
        } else if (PathEnvironmentVariableUtil.isOnPath((String)"xdg-open")) {
            commands.add("xdg-open");
        } else {
            return false;
        }
        commands.add(file.getPresentableUrl());
        try {
            new GeneralCommandLine(commands).createProcess();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/NativeFileType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/NativeFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openFileInAssociatedApplication";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openAssociatedApplication";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

