/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl;

import com.intellij.platform.eel.EelTunnelsApi;
import com.intellij.platform.eel.impl.ResolvedV4SocketAddressImpl;
import com.intellij.platform.eel.impl.ResolvedV6SocketAddressImpl;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"asResolvedSocketAddress", "Lcom/intellij/platform/eel/EelTunnelsApi$ResolvedSocketAddress;", "Ljava/net/SocketAddress;", "getAsResolvedSocketAddress", "(Ljava/net/SocketAddress;)Lcom/intellij/platform/eel/EelTunnelsApi$ResolvedSocketAddress;", "intellij.platform.eel.impl"})
@SourceDebugExtension(value={"SMAP\nIpAddressesImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpAddressesImpl.kt\ncom/intellij/platform/eel/impl/IpAddressesImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class IpAddressesImplKt {
    @NotNull
    public static final EelTunnelsApi.ResolvedSocketAddress getAsResolvedSocketAddress(@NotNull SocketAddress $this$asResolvedSocketAddress) {
        EelTunnelsApi.ResolvedSocketAddress resolvedSocketAddress;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$asResolvedSocketAddress, (String)"<this>");
        if (!($this$asResolvedSocketAddress instanceof InetSocketAddress)) {
            throw new IllegalStateException(("Socket family " + $this$asResolvedSocketAddress + " not supported").toString());
        }
        InetAddress inetAddress = ((InetSocketAddress)$this$asResolvedSocketAddress).getAddress();
        boolean bl2 = bl = ((InetSocketAddress)$this$asResolvedSocketAddress).getPort() >= 0 && ((InetSocketAddress)$this$asResolvedSocketAddress).getPort() < (0xFFFFFFFF & 0xFFFF);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-IpAddressesImplKt$asResolvedSocketAddress$22 = false;
            String $i$a$-assert-IpAddressesImplKt$asResolvedSocketAddress$22 = "port " + ((InetSocketAddress)$this$asResolvedSocketAddress).getPort() + " is wrong";
            throw new AssertionError((Object)$i$a$-assert-IpAddressesImplKt$asResolvedSocketAddress$22);
        }
        short port = UShort.constructor-impl((short)((short)((InetSocketAddress)$this$asResolvedSocketAddress).getPort()));
        ByteBuffer buffer = ByteBuffer.allocate(inetAddress.getAddress().length).order(ByteOrder.BIG_ENDIAN).put(inetAddress.getAddress()).rewind();
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress2 instanceof Inet4Address) {
            boolean bl3;
            boolean bl4 = bl3 = buffer.limit() == 4;
            if (_Assertions.ENABLED && !bl3) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            resolvedSocketAddress = (EelTunnelsApi.ResolvedSocketAddress)new ResolvedV4SocketAddressImpl(port, UInt.constructor-impl((int)buffer.getInt()), null);
        } else if (inetAddress2 instanceof Inet6Address) {
            boolean bl5;
            boolean bl6 = bl5 = buffer.limit() == 16;
            if (_Assertions.ENABLED && !bl5) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            resolvedSocketAddress = (EelTunnelsApi.ResolvedSocketAddress)new ResolvedV6SocketAddressImpl(port, ULong.constructor-impl((long)buffer.getLong()), ULong.constructor-impl((long)buffer.getLong()), null);
        } else {
            throw new IllegalStateException(("Inet family " + ((InetSocketAddress)$this$asResolvedSocketAddress).getAddress() + " not supported").toString());
        }
        return resolvedSocketAddress;
    }
}

