/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.changes;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelDataExKt;
import com.intellij.platform.vcs.changes.ChangesUtil;
import com.intellij.platform.vcs.impl.frontend.changes.ChangesViewDiffableSelectionHelperKt;
import com.intellij.platform.vcs.impl.shared.changes.ChangesTreePath;
import com.intellij.platform.vcs.impl.shared.rpc.ChangesViewDiffableSelection;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0003J\n\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0003J(\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002J \u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0003J\u0014\u0010\u001a\u001a\u00020\u00102\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/changes/ChangesViewDiffableSelectionHelper;", "", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;)V", "_diffableSelection", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/platform/vcs/impl/shared/rpc/ChangesViewDiffableSelection;", "diffableSelection", "Lkotlinx/coroutines/flow/StateFlow;", "getDiffableSelection", "()Lkotlinx/coroutines/flow/StateFlow;", "tryUpdateSelection", "", "shouldUpdateSelection", "", "previousSelection", "getPathOrLog", "Lcom/intellij/platform/vcs/impl/shared/changes/ChangesTreePath;", "prevNode", "log", "Lkotlin/Function1;", "findPreviousAndNextDiffableNodes", "Lkotlin/Pair;", "selectedDiffableNode", "isDiffableNode", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "intellij.platform.vcs.impl.frontend"})
@SourceDebugExtension(value={"SMAP\nChangesViewDiffableSelectionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesViewDiffableSelectionHelper.kt\ncom/intellij/platform/vcs/impl/frontend/changes/ChangesViewDiffableSelectionHelper\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n230#2,5:103\n1761#3,3:108\n1#4:111\n*S KotlinDebug\n*F\n+ 1 ChangesViewDiffableSelectionHelper.kt\ncom/intellij/platform/vcs/impl/frontend/changes/ChangesViewDiffableSelectionHelper\n*L\n28#1:103,5\n37#1:108,3\n*E\n"})
public final class ChangesViewDiffableSelectionHelper {
    @NotNull
    private final ChangesListView changesView;
    @NotNull
    private final MutableStateFlow<ChangesViewDiffableSelection> _diffableSelection;
    @NotNull
    private final StateFlow<ChangesViewDiffableSelection> diffableSelection;

    public ChangesViewDiffableSelectionHelper(@NotNull ChangesListView changesView) {
        Intrinsics.checkNotNullParameter((Object)changesView, (String)"changesView");
        this.changesView = changesView;
        this._diffableSelection = StateFlowKt.MutableStateFlow(null);
        this.diffableSelection = FlowKt.asStateFlow(this._diffableSelection);
    }

    @NotNull
    public final StateFlow<ChangesViewDiffableSelection> getDiffableSelection() {
        return this.diffableSelection;
    }

    @RequiresEdt
    public final void tryUpdateSelection() {
        ChangesViewDiffableSelection currentValue;
        ChangesViewDiffableSelection nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<ChangesViewDiffableSelection> $this$update$iv = this._diffableSelection;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            currentValue = (ChangesViewDiffableSelection)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = this.shouldUpdateSelection(currentValue) ? this.getDiffableSelection() : currentValue)));
    }

    @RequiresEdt
    private final boolean shouldUpdateSelection(ChangesViewDiffableSelection previousSelection) {
        boolean bl;
        block4: {
            if (previousSelection == null) {
                return true;
            }
            JBIterable jBIterable = this.changesView.getSelectedChangesNodes();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getSelectedChangesNodes(...)");
            Iterable $this$any$iv = (Iterable)jBIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ChangesBrowserNode node = (ChangesBrowserNode)element$iv;
                    boolean bl2 = false;
                    Object obj = node.getUserObject();
                    boolean bl3 = obj instanceof Change ? ChangesUtil.matches((Change)((Change)obj), (FilePath)previousSelection.getSelectedChange().getFilePath().getFilePath()) : (obj instanceof FilePath ? Intrinsics.areEqual((Object)obj, (Object)previousSelection.getSelectedChange().getFilePath().getFilePath()) : false);
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean currentValueIsSelected = bl;
        return !currentValueIsSelected;
    }

    @RequiresEdt
    private final ChangesViewDiffableSelection getDiffableSelection() {
        JBIterable jBIterable = this.changesView.getSelectedChanges();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getSelectedChanges(...)");
        Change change = (Change)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
        if (change == null) {
            JBIterable jBIterable2 = this.changesView.getSelectedUnversionedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"getSelectedUnversionedFiles(...)");
            change = (FilePath)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable2));
            if (change == null) {
                return null;
            }
        }
        Change selectedDiffableNode = change;
        ChangesTreePath changesTreePath = this.getPathOrLog(selectedDiffableNode, (Function1<Object, Unit>)((Function1)ChangesViewDiffableSelectionHelper::getDiffableSelection$lambda$0));
        if (changesTreePath == null) {
            return null;
        }
        ChangesTreePath selectedNodePath = changesTreePath;
        Pair<Object, Object> pair = this.findPreviousAndNextDiffableNodes(selectedDiffableNode);
        Object prevNode = pair.component1();
        Object nextNode = pair.component2();
        return new ChangesViewDiffableSelection(selectedNodePath, this.getPathOrLog(prevNode, (Function1<Object, Unit>)((Function1)ChangesViewDiffableSelectionHelper::getDiffableSelection$lambda$1)), this.getPathOrLog(nextNode, (Function1<Object, Unit>)((Function1)ChangesViewDiffableSelectionHelper::getDiffableSelection$lambda$2)));
    }

    private final ChangesTreePath getPathOrLog(Object prevNode, Function1<Object, Unit> log) {
        ChangesTreePath changesTreePath;
        Object object = prevNode;
        if (object != null) {
            ChangesTreePath changesTreePath2;
            Object node = object;
            boolean bl = false;
            ChangesTreePath path = changesTreePath2 = ChangesTreePath.Companion.create(node);
            boolean bl2 = false;
            if (path == null) {
                log.invoke(node);
            }
            changesTreePath = changesTreePath2;
        } else {
            changesTreePath = null;
        }
        return changesTreePath;
    }

    @RequiresEdt
    private final Pair<Object, Object> findPreviousAndNextDiffableNodes(Object selectedDiffableNode) {
        Object previousNode = null;
        Object nextNode = null;
        boolean selectedNodeWasFound = false;
        for (ChangesBrowserNode node : VcsTreeModelData.all((JTree)((JTree)this.changesView)).iterateNodes()) {
            if (nextNode != null) break;
            Object userObject = node.getUserObject();
            if (userObject == selectedDiffableNode) {
                selectedNodeWasFound = true;
                continue;
            }
            Intrinsics.checkNotNull((Object)node);
            if (!this.isDiffableNode(node)) continue;
            if (selectedNodeWasFound) {
                nextNode = userObject;
                continue;
            }
            previousNode = userObject;
        }
        return TuplesKt.to(previousNode, nextNode);
    }

    private final boolean isDiffableNode(ChangesBrowserNode<?> node) {
        boolean bl;
        Object object = node.getUserObject();
        if (object instanceof Change) {
            bl = true;
        } else if (object instanceof FilePath) {
            ChangesBrowserNode.Tag tag = ChangesBrowserNode.UNVERSIONED_FILES_TAG;
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"UNVERSIONED_FILES_TAG");
            bl = VcsTreeModelDataExKt.isUnderTag(node, (ChangesBrowserNode.Tag)tag);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Unit getDiffableSelection$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChangesViewDiffableSelectionHelperKt.access$getLOG$p().warn("Could not create path for selected node: " + it);
        return Unit.INSTANCE;
    }

    private static final Unit getDiffableSelection$lambda$1(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChangesViewDiffableSelectionHelperKt.access$getLOG$p().warn("Could not create path for previous node: " + it);
        return Unit.INSTANCE;
    }

    private static final Unit getDiffableSelection$lambda$2(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChangesViewDiffableSelectionHelperKt.access$getLOG$p().warn("Could not create path for next node: " + it);
        return Unit.INSTANCE;
    }
}

