/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesViewModifier;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.platform.vcs.impl.shared.changes.ChangeListsViewModel;
import com.intellij.platform.vcs.impl.shared.changes.TreeModelBuilderEx;
import com.intellij.platform.vcs.impl.shared.commit.PartialCommitChangeNodeDecorator;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002JN\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewUtil;", "", "<init>", "()V", "getChangeDecoratorProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/changes/ui/ChangeNodeDecorator;", "Lcom/intellij/openapi/vcs/changes/DecoratorProvider;", "project", "Lcom/intellij/openapi/project/Project;", "isAllowExcludeFromCommit", "Lkotlin/Function0;", "", "createTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "changeLists", "", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "unversionedFiles", "Lcom/intellij/openapi/vcs/FilePath;", "ignoredFiles", "intellij.platform.vcs.impl.shared"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nChangesViewUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesViewUtil.kt\ncom/intellij/openapi/vcs/changes/ChangesViewUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class ChangesViewUtil {
    @NotNull
    public static final ChangesViewUtil INSTANCE = new ChangesViewUtil();

    private ChangesViewUtil() {
    }

    private final Function1<ChangeNodeDecorator, ChangeNodeDecorator> getChangeDecoratorProvider(Project project, Function0<Boolean> isAllowExcludeFromCommit) {
        return arg_0 -> ChangesViewUtil.getChangeDecoratorProvider$lambda$0(project, isAllowExcludeFromCommit, arg_0);
    }

    @NotNull
    public final DefaultTreeModel createTreeModel(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping, @NotNull List<? extends LocalChangeList> changeLists, @NotNull List<? extends FilePath> unversionedFiles, @NotNull List<? extends FilePath> ignoredFiles, @NotNull Function0<Boolean> isAllowExcludeFromCommit) {
        TreeModelBuilder treeModelBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)grouping, (String)"grouping");
        Intrinsics.checkNotNullParameter(changeLists, (String)"changeLists");
        Intrinsics.checkNotNullParameter(unversionedFiles, (String)"unversionedFiles");
        Intrinsics.checkNotNullParameter(ignoredFiles, (String)"ignoredFiles");
        Intrinsics.checkNotNullParameter(isAllowExcludeFromCommit, (String)"isAllowExcludeFromCommit");
        boolean skipSingleDefaultChangeList = (Boolean)ChangeListsViewModel.Companion.getInstance(project).getAreChangeListsEnabled().getValue() == false;
        TreeModelBuilder it = treeModelBuilder = new TreeModelBuilder(project, grouping).setChangeLists((Collection<? extends ChangeList>)changeLists, skipSingleDefaultChangeList, arg_0 -> ChangesViewUtil.createTreeModel$lambda$0(this.getChangeDecoratorProvider(project, isAllowExcludeFromCommit), arg_0));
        boolean bl = false;
        TreeModelBuilderEx treeModelBuilderEx = TreeModelBuilderEx.Companion.getInstanceOrNull(project);
        if (treeModelBuilderEx != null) {
            Intrinsics.checkNotNull((Object)it);
            treeModelBuilderEx.modifyTreeModelBuilder(it);
        }
        TreeModelBuilder treeModelBuilder2 = treeModelBuilder.setUnversioned(unversionedFiles);
        Intrinsics.checkNotNullExpressionValue((Object)treeModelBuilder2, (String)"setUnversioned(...)");
        TreeModelBuilder treeModelBuilder3 = treeModelBuilder2;
        treeModelBuilder3.setIgnored(ignoredFiles);
        for (ChangesViewModifier extension : ChangesViewModifier.KEY.getExtensions((AreaInstance)project)) {
            try {
                extension.modifyTreeModelBuilder(treeModelBuilder3);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                Logger.getInstance(this.getClass()).error(t);
            }
        }
        DefaultTreeModel defaultTreeModel = treeModelBuilder3.build(true);
        Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"build(...)");
        return defaultTreeModel;
    }

    private static final PartialCommitChangeNodeDecorator getChangeDecoratorProvider$lambda$0(Project $project, Function0 $isAllowExcludeFromCommit, ChangeNodeDecorator baseDecorator) {
        return new PartialCommitChangeNodeDecorator($project, baseDecorator, (Function0<Boolean>)$isAllowExcludeFromCommit);
    }

    private static final ChangeNodeDecorator createTreeModel$lambda$0(Function1 $tmp0, Object p0) {
        return (ChangeNodeDecorator)$tmp0.invoke(p0);
    }
}

