/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeCellRenderer;
import com.intellij.openapi.vcs.changes.ui.HoverIcon;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b&\u0018\u0000 %2\u00020\u0001:\u0006 !\"#$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H&J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree;", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;)V", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "value", "Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$HoverData;", "_hoverData", "set_hoverData", "(Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$HoverData;)V", "install", "", "getHoverIcon", "Lcom/intellij/openapi/vcs/changes/ui/HoverIcon;", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "getHoverData", "point", "Ljava/awt/Point;", "getComponentBounds", "Ljava/awt/Rectangle;", "path", "Ljavax/swing/tree/TreePath;", "icon", "Ljavax/swing/Icon;", "getComponentXCoordinate", "", "componentWidth", "getComponentWidth", "HoverChangesTreeRenderer", "FloatingIcon", "MyMouseListener", "MyClickListener", "HoverData", "Companion", "intellij.platform.vcs.impl.shared"})
public abstract class HoverChangesTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChangesTree tree;
    @Nullable
    private HoverData _hoverData;

    public HoverChangesTree(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.tree = tree;
    }

    @NotNull
    public final ChangesTree getTree() {
        return this.tree;
    }

    private final void set_hoverData(HoverData value) {
        if (!Intrinsics.areEqual((Object)this._hoverData, (Object)value)) {
            this._hoverData = value;
            this.tree.repaint();
        }
    }

    public final void install() {
        MyMouseListener myMouseListener;
        ChangesBrowserNodeRenderer nodeRenderer = new ChangesBrowserNodeRenderer(this.tree.getProject(), () -> HoverChangesTree.install$lambda$0(this), this.tree.isHighlightProblems());
        this.tree.setCellRenderer(new HoverChangesTreeRenderer(nodeRenderer));
        MyMouseListener it = myMouseListener = new MyMouseListener();
        boolean bl = false;
        this.tree.addMouseMotionListener(it);
        this.tree.addMouseListener(it);
        new MyClickListener().installOn((Component)((Object)this.tree));
    }

    @Nullable
    public abstract HoverIcon getHoverIcon(@NotNull ChangesBrowserNode<?> var1);

    private final HoverData getHoverData(Point point) {
        TreePath treePath = TreeUtil.getPathForLocation((JTree)((JTree)((Object)this.tree)), (int)point.x, (int)point.y);
        if (treePath == null) {
            return null;
        }
        TreePath path = treePath;
        Object object = path.getLastPathComponent();
        ChangesBrowserNode changesBrowserNode = object instanceof ChangesBrowserNode ? (ChangesBrowserNode)object : null;
        if (changesBrowserNode == null) {
            return null;
        }
        ChangesBrowserNode node = changesBrowserNode;
        HoverIcon hoverIcon = this.getHoverIcon(node);
        if (hoverIcon == null) {
            return null;
        }
        HoverIcon hoverIcon2 = hoverIcon;
        Rectangle rectangle = this.getComponentBounds(path, hoverIcon2.getIcon());
        if (rectangle == null) {
            return null;
        }
        Rectangle componentBounds = rectangle;
        return new HoverData(node, componentBounds.contains(point), hoverIcon2);
    }

    private final Rectangle getComponentBounds(TreePath path, Icon icon) {
        Rectangle rectangle = this.tree.getPathBounds(path);
        if (rectangle == null) {
            return null;
        }
        Rectangle bounds = rectangle;
        int componentWidth = this.getComponentWidth(icon);
        bounds.setLocation(this.getComponentXCoordinate(componentWidth), bounds.y);
        bounds.setSize(componentWidth, bounds.height);
        return bounds;
    }

    private final int getComponentXCoordinate(int componentWidth) {
        return this.tree.getVisibleRect().width + this.tree.getVisibleRect().x - componentWidth;
    }

    private final int getComponentWidth(Icon icon) {
        int transparentScrollbarWidth = Companion.getTransparentScrollbarWidth((Component)((Object)this.tree));
        int borderWidth = transparentScrollbarWidth == 0 ? JBUI.scale((int)2) : 0;
        return icon.getIconWidth() + transparentScrollbarWidth + borderWidth;
    }

    private static final boolean install$lambda$0(HoverChangesTree this$0) {
        return this$0.tree.isShowFlatten();
    }

    public static final /* synthetic */ HoverData access$get_hoverData$p(HoverChangesTree $this) {
        return $this._hoverData;
    }

    public static final /* synthetic */ int access$getComponentWidth(HoverChangesTree $this, Icon icon) {
        return $this.getComponentWidth(icon);
    }

    public static final /* synthetic */ int access$getComponentXCoordinate(HoverChangesTree $this, int componentWidth) {
        return $this.getComponentXCoordinate(componentWidth);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u000f\u001a\u00020\b*\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$Companion;", "", "<init>", "()V", "getBackground", "Ljava/awt/Color;", "Lcom/intellij/ui/treeStructure/Tree;", "row", "", "selected", "", "getRowHeight", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeCellRenderer;", "getTransparentScrollbarWidth", "Ljava/awt/Component;", "intellij.platform.vcs.impl.shared"})
    @SourceDebugExtension(value={"SMAP\nHoverChangesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoverChangesTree.kt\ncom/intellij/openapi/vcs/changes/ui/HoverChangesTree$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getBackground(@NotNull Tree $this$getBackground, int row, boolean selected) {
            Serializable serializable;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)$this$getBackground, (String)"<this>");
                    if (selected) {
                        Color color = RenderingUtil.getBackground((JTree)((JTree)$this$getBackground), (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
                        return color;
                    }
                    serializable = $this$getBackground.getPathForRow(row);
                    if (serializable == null) break block4;
                    TreePath path = serializable;
                    boolean bl = false;
                    Color color = $this$getBackground.getPathBackground(path, row);
                    serializable = color;
                    if (color != null) break block5;
                }
                Color color = RenderingUtil.getBackground((JTree)((JTree)$this$getBackground), (boolean)false);
                serializable = color;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
            }
            return serializable;
        }

        public final int getRowHeight(@NotNull ChangesTree $this$getRowHeight, @NotNull ChangesTreeCellRenderer renderer) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$getRowHeight), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            return $this$getRowHeight.isFixedRowHeight() ? $this$getRowHeight.getRowHeight() : renderer.getPreferredSize().height;
        }

        public final int getTransparentScrollbarWidth(@NotNull Component $this$getTransparentScrollbarWidth) {
            boolean hasTransparentScrollbar;
            Intrinsics.checkNotNullParameter((Object)$this$getTransparentScrollbarWidth, (String)"<this>");
            JScrollPane jScrollPane = ComponentUtil.getScrollPane((Component)$this$getTransparentScrollbarWidth);
            JScrollBar scrollBar = jScrollPane != null ? jScrollPane.getVerticalScrollBar() : null;
            boolean bl = hasTransparentScrollbar = scrollBar != null && scrollBar.isVisible() && !scrollBar.isOpaque();
            if (hasTransparentScrollbar) {
                return UIUtil.getScrollBarWidth();
            }
            return 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$FloatingIcon;", "", "icon", "Ljavax/swing/Icon;", "location", "", "<init>", "(Ljavax/swing/Icon;I)V", "getIcon", "()Ljavax/swing/Icon;", "getLocation", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.vcs.impl.shared"})
    private static final class FloatingIcon {
        @NotNull
        private final Icon icon;
        private final int location;

        public FloatingIcon(@NotNull Icon icon, int location) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            this.icon = icon;
            this.location = location;
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        public final int getLocation() {
            return this.location;
        }

        @NotNull
        public final Icon component1() {
            return this.icon;
        }

        public final int component2() {
            return this.location;
        }

        @NotNull
        public final FloatingIcon copy(@NotNull Icon icon, int location) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            return new FloatingIcon(icon, location);
        }

        public static /* synthetic */ FloatingIcon copy$default(FloatingIcon floatingIcon, Icon icon, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                icon = floatingIcon.icon;
            }
            if ((n2 & 2) != 0) {
                n = floatingIcon.location;
            }
            return floatingIcon.copy(icon, n);
        }

        @NotNull
        public String toString() {
            return "FloatingIcon(icon=" + this.icon + ", location=" + this.location + ")";
        }

        public int hashCode() {
            int result = this.icon.hashCode();
            result = result * 31 + Integer.hashCode(this.location);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FloatingIcon)) {
                return false;
            }
            FloatingIcon floatingIcon = (FloatingIcon)other;
            if (!Intrinsics.areEqual((Object)this.icon, (Object)floatingIcon.icon)) {
                return false;
            }
            return this.location == floatingIcon.location;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J,\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J)\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0!\"\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\"R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$HoverChangesTreeRenderer;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeCellRenderer;", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree;Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;)V", "floatingIcon", "Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$FloatingIcon;", "paint", "", "g", "Ljava/awt/Graphics;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "prepareIcon", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "createLayeredIcon", "Ljavax/swing/Icon;", "background", "foreground", "", "(Ljavax/swing/Icon;[Ljavax/swing/Icon;)Ljavax/swing/Icon;", "intellij.platform.vcs.impl.shared"})
    @SourceDebugExtension(value={"SMAP\nHoverChangesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoverChangesTree.kt\ncom/intellij/openapi/vcs/changes/ui/HoverChangesTree$HoverChangesTreeRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
    private final class HoverChangesTreeRenderer
    extends ChangesTreeCellRenderer {
        @Nullable
        private FloatingIcon floatingIcon;

        public HoverChangesTreeRenderer(ChangesBrowserNodeRenderer renderer) {
            Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
            super(renderer);
        }

        public void paint(@NotNull Graphics g) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paint(g);
                FloatingIcon floatingIcon = this.floatingIcon;
                if (floatingIcon == null) break block0;
                FloatingIcon it = floatingIcon;
                boolean bl = false;
                it.getIcon().paintIcon((Component)((Object)this), g, it.getLocation(), 0);
            }
        }

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Component rendererComponent = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.floatingIcon = this.prepareIcon((ChangesTree)((Object)tree), (ChangesBrowserNode)value, row, selected);
            return rendererComponent;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final FloatingIcon prepareIcon(@NotNull ChangesTree tree, @NotNull ChangesBrowserNode<?> node, int row, boolean selected) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter(node, (String)"node");
            if (tree.getExpandableItemsHandler().getExpandedItems().contains(row)) {
                return null;
            }
            v0 = hoverData = HoverChangesTree.access$get_hoverData$p(HoverChangesTree.this);
            hovered = Intrinsics.areEqual(v0 != null ? v0.getNode() : null, node);
            if (!(hovered || selected && tree.getLeadSelectionRow() == row)) {
                return null;
            }
            if (hovered) {
                v1 = hoverData;
                Intrinsics.checkNotNull((Object)v1);
                v2 = v1.getHoverIcon().getIcon();
            } else if (selected) {
                v2 = HoverChangesTree.this.getHoverIcon(node);
                if (v2 == null || (v2 = v2.getIcon()) == null) {
                    return null;
                }
            } else {
                return null;
            }
            foreground = v2;
            componentWidth = HoverChangesTree.access$getComponentWidth(HoverChangesTree.this, foreground);
            componentHeight = HoverChangesTree.Companion.getRowHeight(tree, this);
            background = new ColorIcon(componentWidth, componentHeight, componentWidth, componentHeight, HoverChangesTree.Companion.getBackground(tree, row, selected), false);
            if (!hovered) ** GOTO lbl-1000
            v3 = hoverData;
            Intrinsics.checkNotNull((Object)v3);
            if (v3.isOverOperationIcon()) {
                v4 = JBUI.CurrentTheme.ActionButton.hoverBackground();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"hoverBackground(...)");
                hoverBackground = v4;
                it = var14_13 = JBUI.CurrentTheme.ActionButton.hoverBorder();
                $i$a$-takeIf-HoverChangesTree$HoverChangesTreeRenderer$prepareIcon$icon$hoverBorder$1 = false;
                hoverBorder = Intrinsics.areEqual((Object)it, (Object)hoverBackground) == false != false ? var14_13 : null;
                highlight = new ColorIcon(foreground.getIconWidth(), componentHeight, foreground.getIconWidth(), foreground.getIconHeight(), (Color)hoverBackground, hoverBorder, JBUI.scale((int)4));
                var15_14 = new Icon[]{highlight, foreground};
                v5 = this.createLayeredIcon((Icon)background, var15_14);
            } else lbl-1000:
            // 2 sources

            {
                hoverBackground = new Icon[]{foreground};
                v5 = this.createLayeredIcon((Icon)background, hoverBackground);
            }
            icon = v5;
            location = HoverChangesTree.access$getComponentXCoordinate(HoverChangesTree.this, componentWidth) - (TreeUtil.getNodeRowX((JTree)((JTree)tree), (int)row) + tree.getInsets().left);
            return new FloatingIcon(icon, location);
        }

        private final Icon createLayeredIcon(Icon background, Icon ... foreground) {
            LayeredIcon layeredIcon;
            LayeredIcon $this$createLayeredIcon_u24lambda_u240 = layeredIcon = new LayeredIcon(foreground.length + 1);
            boolean bl = false;
            $this$createLayeredIcon_u24lambda_u240.setIcon(background, 0);
            int n = foreground.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                Icon f = foreground[i];
                $this$createLayeredIcon_u24lambda_u240.setIcon(f, i2 + 1, 7);
            }
            return (Icon)layeredIcon;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$HoverData;", "", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "isOverOperationIcon", "", "hoverIcon", "Lcom/intellij/openapi/vcs/changes/ui/HoverIcon;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;ZLcom/intellij/openapi/vcs/changes/ui/HoverIcon;)V", "getNode", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "()Z", "getHoverIcon", "()Lcom/intellij/openapi/vcs/changes/ui/HoverIcon;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl.shared"})
    private static final class HoverData {
        @NotNull
        private final ChangesBrowserNode<?> node;
        private final boolean isOverOperationIcon;
        @NotNull
        private final HoverIcon hoverIcon;

        public HoverData(@NotNull ChangesBrowserNode<?> node, boolean isOverOperationIcon, @NotNull HoverIcon hoverIcon) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)hoverIcon, (String)"hoverIcon");
            this.node = node;
            this.isOverOperationIcon = isOverOperationIcon;
            this.hoverIcon = hoverIcon;
        }

        @NotNull
        public final ChangesBrowserNode<?> getNode() {
            return this.node;
        }

        public final boolean isOverOperationIcon() {
            return this.isOverOperationIcon;
        }

        @NotNull
        public final HoverIcon getHoverIcon() {
            return this.hoverIcon;
        }

        @NotNull
        public final ChangesBrowserNode<?> component1() {
            return this.node;
        }

        public final boolean component2() {
            return this.isOverOperationIcon;
        }

        @NotNull
        public final HoverIcon component3() {
            return this.hoverIcon;
        }

        @NotNull
        public final HoverData copy(@NotNull ChangesBrowserNode<?> node, boolean isOverOperationIcon, @NotNull HoverIcon hoverIcon) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)hoverIcon, (String)"hoverIcon");
            return new HoverData(node, isOverOperationIcon, hoverIcon);
        }

        public static /* synthetic */ HoverData copy$default(HoverData hoverData, ChangesBrowserNode changesBrowserNode, boolean bl, HoverIcon hoverIcon, int n, Object object) {
            if ((n & 1) != 0) {
                changesBrowserNode = hoverData.node;
            }
            if ((n & 2) != 0) {
                bl = hoverData.isOverOperationIcon;
            }
            if ((n & 4) != 0) {
                hoverIcon = hoverData.hoverIcon;
            }
            return hoverData.copy(changesBrowserNode, bl, hoverIcon);
        }

        @NotNull
        public String toString() {
            return "HoverData(node=" + this.node + ", isOverOperationIcon=" + this.isOverOperationIcon + ", hoverIcon=" + this.hoverIcon + ")";
        }

        public int hashCode() {
            int result = this.node.hashCode();
            result = result * 31 + Boolean.hashCode(this.isOverOperationIcon);
            result = result * 31 + this.hoverIcon.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HoverData)) {
                return false;
            }
            HoverData hoverData = (HoverData)other;
            if (!Intrinsics.areEqual(this.node, hoverData.node)) {
                return false;
            }
            if (this.isOverOperationIcon != hoverData.isOverOperationIcon) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hoverIcon, (Object)hoverData.hoverIcon);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$MyClickListener;", "Lcom/intellij/ui/ClickListener;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree;)V", "onClick", "", "event", "Ljava/awt/event/MouseEvent;", "clickCount", "", "intellij.platform.vcs.impl.shared"})
    private final class MyClickListener
    extends ClickListener {
        public boolean onClick(@NotNull MouseEvent event, int clickCount) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Point point = event.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            HoverData hoverData = HoverChangesTree.this.getHoverData(point);
            if (hoverData == null) {
                return false;
            }
            HoverData hoverData2 = hoverData;
            if (!hoverData2.isOverOperationIcon()) {
                return false;
            }
            WriteIntentReadAction.run(() -> MyClickListener.onClick$lambda$0(hoverData2));
            return true;
        }

        private static final void onClick$lambda$0(HoverData $hoverData) {
            $hoverData.getHoverIcon().invokeAction($hoverData.getNode());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree;)V", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "setHoverData", "data", "Lcom/intellij/openapi/vcs/changes/ui/HoverChangesTree$HoverData;", "intellij.platform.vcs.impl.shared"})
    private final class MyMouseListener
    extends MouseAdapter {
        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            this.setHoverData(HoverChangesTree.this.getHoverData(point));
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.setHoverData(null);
        }

        private final void setHoverData(HoverData data) {
            HoverChangesTree.this.set_hoverData(data);
            if (data != null && data.isOverOperationIcon()) {
                HoverChangesTree.this.getTree().setToolTipText(data.getHoverIcon().getTooltip());
                HoverChangesTree.this.getTree().getExpandableItemsHandler().setEnabled(false);
            } else {
                HoverChangesTree.this.getTree().setToolTipText(null);
                HoverChangesTree.this.getTree().getExpandableItemsHandler().setEnabled(true);
            }
        }
    }
}

