/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.shared;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000bJ\u000f\u0010\f\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/vcs/impl/shared/ProjectBasePathHolder;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "presentablePath", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/vcs/FilePath;", "getPresentablePath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "guessProjectDirAndCache", "Lcom/intellij/openapi/util/NlsSafe;", "consumePresentablePath", "", "intellij.platform.vcs.impl.shared"})
public final class ProjectBasePathHolder {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<FilePath> presentablePath;

    public ProjectBasePathHolder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.presentablePath = new AtomicReference();
    }

    @Nullable
    public final String getPresentablePath() {
        FilePath path = this.presentablePath.get();
        Object object = path;
        if (object == null || (object = object.getPresentableUrl()) == null) {
            object = this.guessProjectDirAndCache();
        }
        return object;
    }

    private final String guessProjectDirAndCache() {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile projectDir = virtualFile;
        FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(projectDir);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"createFilePathOn(...)");
        FilePath newValue = filePath;
        this.presentablePath.compareAndSet(null, newValue);
        return newValue.getPresentableUrl();
    }

    public final void consumePresentablePath(@NotNull FilePath presentablePath) {
        Intrinsics.checkNotNullParameter((Object)presentablePath, (String)"presentablePath");
        this.presentablePath.set(presentablePath);
    }
}

