/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.shared.commit;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.LocalRangeKt;
import com.intellij.platform.vcs.impl.shared.changes.PartialChangesHolder;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/vcs/impl/shared/commit/PartialCommitChangeNodeDecorator;", "Lcom/intellij/openapi/vcs/changes/ui/ChangeNodeDecorator;", "project", "Lcom/intellij/openapi/project/Project;", "baseDecorator", "isVisible", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/ChangeNodeDecorator;Lkotlin/jvm/functions/Function0;)V", "decorate", "", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "renderer", "Lcom/intellij/ui/SimpleColoredComponent;", "isShowFlatten", "appendPartialCommitState", "preDecorate", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "intellij.platform.vcs.impl.shared"})
@ApiStatus.Internal
public final class PartialCommitChangeNodeDecorator
implements ChangeNodeDecorator {
    @NotNull
    private final Project project;
    @Nullable
    private final ChangeNodeDecorator baseDecorator;
    @NotNull
    private final Function0<Boolean> isVisible;

    @JvmOverloads
    public PartialCommitChangeNodeDecorator(@NotNull Project project, @Nullable ChangeNodeDecorator baseDecorator, @NotNull Function0<Boolean> isVisible) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(isVisible, (String)"isVisible");
        this.project = project;
        this.baseDecorator = baseDecorator;
        this.isVisible = isVisible;
    }

    public /* synthetic */ PartialCommitChangeNodeDecorator(Project project, ChangeNodeDecorator changeNodeDecorator, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = PartialCommitChangeNodeDecorator::_init_$lambda$0;
        }
        this(project, changeNodeDecorator, (Function0<Boolean>)function0);
    }

    @Override
    public void decorate(@NotNull Change change, @NotNull SimpleColoredComponent renderer, boolean isShowFlatten) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            if (this.project.isDisposed()) {
                return;
            }
            if (((Boolean)this.isVisible.invoke()).booleanValue()) {
                ActionsKt.runReadAction(() -> PartialCommitChangeNodeDecorator.decorate$lambda$0(this, change, renderer));
            }
            ChangeNodeDecorator changeNodeDecorator = this.baseDecorator;
            if (changeNodeDecorator == null) break block2;
            changeNodeDecorator.decorate(change, renderer, isShowFlatten);
        }
    }

    private final void appendPartialCommitState(Change change, SimpleColoredComponent renderer) {
        Object object = change instanceof ChangeListChange ? (ChangeListChange)change : null;
        if (object == null || (object = object.getChangeListId()) == null) {
            return;
        }
        Object changeListId = object;
        ContentRevision contentRevision = ((ChangeListChange)change).getAfterRevision();
        if (contentRevision == null || (contentRevision = contentRevision.getFile()) == null) {
            return;
        }
        ContentRevision filePath = contentRevision;
        List<LocalRange> list = PartialChangesHolder.Companion.getInstance(this.project).getRanges((FilePath)filePath);
        if (list == null) {
            return;
        }
        List<LocalRange> ranges = list;
        int rangesToCommit = LocalRangeKt.countIncludedChanges(LocalRangeKt.changesInChangeList(ranges, (String)changeListId));
        int totalRanges = LocalRangeKt.countAllChanges(ranges);
        if (rangesToCommit != 0 && rangesToCommit != totalRanges) {
            Object[] objectArray = new Object[]{rangesToCommit, totalRanges};
            renderer.append(FontUtil.spaceAndThinSpace()).append(VcsBundle.message((String)"ranges.to.commit.of.ranges.size.changes", (Object[])objectArray), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Override
    public void preDecorate(@NotNull Change change, @NotNull ChangesBrowserNodeRenderer renderer, boolean isShowFlatten) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
            ChangeNodeDecorator changeNodeDecorator = this.baseDecorator;
            if (changeNodeDecorator == null) break block0;
            changeNodeDecorator.preDecorate(change, renderer, isShowFlatten);
        }
    }

    @JvmOverloads
    public PartialCommitChangeNodeDecorator(@NotNull Project project, @Nullable ChangeNodeDecorator baseDecorator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, baseDecorator, null, 4, null);
    }

    private static final boolean _init_$lambda$0() {
        return true;
    }

    private static final Unit decorate$lambda$0(PartialCommitChangeNodeDecorator this$0, Change $change, SimpleColoredComponent $renderer) {
        this$0.appendPartialCommitState($change, $renderer);
        return Unit.INSTANCE;
    }
}

