/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.TestSuiteStack;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class GeneralToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private final Map<String, SMTestProxy> myRunningTestsFullNameToProxy;
    private final TestSuiteStack mySuitesStack;
    private final Map<String, List<SMTestProxy>> myCurrentChildren;
    private boolean myIsTestingFinished;

    public GeneralToSMTRunnerEventsConvertor(Project project, @NotNull SMTestProxy.SMRootTestProxy testsRootNode, @NotNull String testFrameworkName) {
        if (testsRootNode == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(1);
        }
        super(project, testFrameworkName, testsRootNode);
        this.myRunningTestsFullNameToProxy = new ConcurrentHashMap<String, SMTestProxy>();
        this.myCurrentChildren = new HashMap<String, List<SMTestProxy>>();
        this.mySuitesStack = new TestSuiteStack(testFrameworkName);
    }

    @Override
    protected SMTestProxy createProxy(String testName, String locationHint, String metaInfo, String id, String parentNodeId) {
        SMTestProxy proxy = super.createProxy(testName, locationHint, metaInfo, id, parentNodeId);
        SMTestProxy currentSuite = this.getCurrentSuite();
        currentSuite.addChild(proxy);
        return proxy;
    }

    @Override
    protected SMTestProxy createSuite(String suiteName, String locationHint, String metaInfo, String id, String parentNodeId) {
        SMTestProxy newSuite = super.createSuite(suiteName, locationHint, metaInfo, id, parentNodeId);
        SMTestProxy parentSuite = this.getCurrentSuite();
        parentSuite.addChild(newSuite);
        this.mySuitesStack.pushSuite(newSuite);
        return newSuite;
    }

    @Override
    public void onSuiteTreeEnded(String suiteName) {
        this.myBuildTreeRunnables.add(() -> {
            this.mySuitesStack.popSuite(suiteName);
            this.myEventPublisher.onSuiteTreeEnded(this.myTestsRootProxy, suiteName);
        });
        super.onSuiteTreeEnded(suiteName);
    }

    @Override
    public void onStartTesting() {
        this.mySuitesStack.pushSuite(this.myTestsRootProxy);
        this.myTestsRootProxy.setStarted();
        this.fireOnTestingStarted(this.myTestsRootProxy);
    }

    @Override
    public void onTestsReporterAttached() {
        GeneralToSMTRunnerEventsConvertor.fireOnTestsReporterAttached(this.myTestsRootProxy);
    }

    @Override
    public void onFinishTesting() {
        this.fireOnBeforeTestingFinished(this.myTestsRootProxy);
        if (this.myIsTestingFinished) {
            return;
        }
        this.myIsTestingFinished = true;
        if (!GeneralToSMTRunnerEventsConvertor.isTreeComplete(this.myRunningTestsFullNameToProxy.keySet(), this.myTestsRootProxy)) {
            this.myTestsRootProxy.setTerminated();
            this.myRunningTestsFullNameToProxy.clear();
        }
        this.mySuitesStack.clear();
        this.myTestsRootProxy.setFinished();
        this.myCurrentChildren.clear();
        this.fireOnTestingFinished(this.myTestsRootProxy);
        super.onFinishTesting();
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        if (printerProvider == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void onTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        SMTestProxy parentSuite;
        SMTestProxy testProxy;
        if (testStartedEvent == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(3);
        }
        String testName = testStartedEvent.getName();
        String locationUrl = testStartedEvent.getLocationUrl();
        String metainfo = testStartedEvent.getMetainfo();
        boolean isConfig = testStartedEvent.isConfig();
        String fullName = this.getFullTestName(testName);
        if (this.myRunningTestsFullNameToProxy.containsKey(fullName)) {
            this.logProblem("Test [" + fullName + "] has been already started");
            if (SMTestRunnerConnectionUtil.isInDebugMode()) {
                return;
            }
        }
        if ((testProxy = this.findChild(parentSuite = this.getCurrentSuite(), locationUrl != null ? locationUrl : fullName, false)) != null && "Class Configuration".equals(fullName)) {
            parentSuite = testProxy;
            testProxy = null;
        }
        if (testProxy == null) {
            testProxy = new SMTestProxy(testName, false, locationUrl, metainfo, false);
            testProxy.setConfig(isConfig);
            if (this.myTreeBuildBeforeStart) {
                testProxy.setTreeBuildBeforeStart();
            }
            if (this.myLocator != null) {
                testProxy.setLocator(this.myLocator);
            }
            parentSuite.addChild(testProxy);
        } else if (metainfo != null) {
            testProxy.setMetainfo(metainfo);
        }
        this.myRunningTestsFullNameToProxy.put(fullName, testProxy);
        testProxy.setStarted();
        this.fireOnTestStarted(testProxy);
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        if (suiteStartedEvent == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(4);
        }
        String suiteName = suiteStartedEvent.getName();
        String locationUrl = suiteStartedEvent.getLocationUrl();
        String metainfo = suiteStartedEvent.getMetainfo();
        SMTestProxy parentSuite = this.getCurrentSuite();
        SMTestProxy newSuite = this.findChild(parentSuite, locationUrl != null ? locationUrl : suiteName, true);
        if (newSuite == null) {
            newSuite = new SMTestProxy(suiteName, true, locationUrl, metainfo, parentSuite.isPreservePresentableName());
            if (this.myTreeBuildBeforeStart) {
                newSuite.setTreeBuildBeforeStart();
            }
            if (this.myLocator != null) {
                newSuite.setLocator(this.myLocator);
            }
            parentSuite.addChild(newSuite);
        } else if (metainfo != null) {
            newSuite.setMetainfo(metainfo);
        }
        this.initCurrentChildren(newSuite, true);
        this.mySuitesStack.pushSuite(newSuite);
        newSuite.setSuiteStarted();
        this.fireOnSuiteStarted(newSuite);
    }

    private void initCurrentChildren(SMTestProxy newSuite, boolean preferSuite) {
        if (this.myTreeBuildBeforeStart) {
            for (SMTestProxy sMTestProxy : newSuite.getChildren()) {
                if (sMTestProxy.isFinal() && (!preferSuite || !sMTestProxy.isSuite())) continue;
                String url = sMTestProxy.getLocationUrl();
                if (url != null) {
                    this.myCurrentChildren.computeIfAbsent(url, l -> new ArrayList()).add(sMTestProxy);
                }
                this.myCurrentChildren.computeIfAbsent(sMTestProxy.getName(), l -> new ArrayList()).add(sMTestProxy);
            }
        }
    }

    @VisibleForTesting
    public SMTestProxy findChild(SMTestProxy parentSuite, String fullName, boolean preferSuite) {
        if (this.myTreeBuildBeforeStart) {
            LinkedHashSet<SMTestProxy> acceptedProxies = new LinkedHashSet<SMTestProxy>();
            Collection children = this.myCurrentChildren.get(fullName);
            if (children == null) {
                this.initCurrentChildren(parentSuite, preferSuite);
                children = this.myCurrentChildren.get(fullName);
            }
            if (children != null) {
                for (SMTestProxy proxy : children) {
                    if (proxy.isFinal() && (!preferSuite || !proxy.isSuite())) continue;
                    acceptedProxies.add(proxy);
                }
                if (!acceptedProxies.isEmpty()) {
                    SMTestProxy accepted = null;
                    for (SMTestProxy proxy : acceptedProxies) {
                        if (proxy.isSuite() != preferSuite || proxy.getParent() != parentSuite) continue;
                        if (!proxy.isFinal()) {
                            return proxy;
                        }
                        if (accepted != null) continue;
                        accepted = proxy;
                    }
                    return accepted != null ? accepted : (SMTestProxy)((Object)acceptedProxies.iterator().next());
                }
            }
        }
        return null;
    }

    @Override
    public void onTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        if (testFinishedEvent == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(5);
        }
        String testName = testFinishedEvent.getName();
        Long duration = testFinishedEvent.getDuration();
        String fullTestName = this.getFullTestName(testName);
        SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
        if (testProxy == null) {
            this.logProblem("Test wasn't started! TestFinished event: name = {" + testName + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
            return;
        }
        testProxy.setDuration(duration != null ? duration : 0L);
        testProxy.setFrameworkOutputFile(testFinishedEvent.getOutputFile());
        testProxy.setFinished();
        this.myRunningTestsFullNameToProxy.remove(fullTestName);
        this.clearCurrentChildren(fullTestName, testProxy);
        this.fireOnTestFinished(testProxy);
    }

    private void clearCurrentChildren(String fullTestName, SMTestProxy testProxy) {
        this.myCurrentChildren.remove(fullTestName);
        String url = testProxy.getLocationUrl();
        if (url != null) {
            this.myCurrentChildren.remove(url);
        }
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        String suiteName;
        SMTestProxy mySuite;
        if (suiteFinishedEvent == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(6);
        }
        if ((mySuite = this.mySuitesStack.popSuite(suiteName = suiteFinishedEvent.getName())) != null) {
            mySuite.setFinished();
            this.myCurrentChildren.remove(suiteName);
            String locationUrl = mySuite.getLocationUrl();
            if (locationUrl != null) {
                this.myCurrentChildren.remove(locationUrl);
            }
            this.fireOnSuiteFinished(mySuite);
        }
    }

    @Override
    public void onUncapturedOutput(@NotNull String text, Key outputType) {
        if (text == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(7);
        }
        SMTestProxy currentProxy = this.findCurrentTestOrSuite();
        currentProxy.addOutput(text, outputType);
        this.myEventPublisher.onUncapturedOutput(currentProxy, text, outputType);
    }

    @Override
    public void onError(@NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        if (localizedMessage == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(8);
        }
        SMTestProxy currentProxy = this.findCurrentTestOrSuite();
        currentProxy.addError(localizedMessage, stackTrace, isCritical);
    }

    @Override
    public void onTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        String testName;
        if (testFailedEvent == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(9);
        }
        if ((testName = testFailedEvent.getName()) == null) {
            this.logProblem("No test name specified in " + String.valueOf(testFailedEvent));
            return;
        }
        String localizedMessage = testFailedEvent.getLocalizedFailureMessage();
        String stackTrace = testFailedEvent.getStacktrace();
        boolean isTestError = testFailedEvent.isTestError();
        String comparisionFailureActualText = testFailedEvent.getComparisonFailureActualText();
        String comparisionFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
        boolean inDebugMode = SMTestRunnerConnectionUtil.isInDebugMode();
        String fullTestName = this.getFullTestName(testName);
        SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
        if (testProxy == null) {
            this.logProblem("Test wasn't started! TestFailure event: name = {" + testName + "}, message = {" + localizedMessage + "}, stackTrace = {" + stackTrace + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
            if (inDebugMode) {
                return;
            }
            this.onTestStarted(new TestStartedEvent(testName, null));
            testProxy = this.getProxyByFullTestName(fullTestName);
        }
        if (testProxy == null) {
            return;
        }
        if (comparisionFailureActualText != null && comparisionFailureExpectedText != null) {
            testProxy.setTestComparisonFailed(localizedMessage, stackTrace, comparisionFailureActualText, comparisionFailureExpectedText, testFailedEvent);
        } else if (comparisionFailureActualText == null && comparisionFailureExpectedText == null) {
            testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
        } else {
            testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
            this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisionFailureExpectedText + "\nActual:\n" + comparisionFailureActualText);
        }
        this.fireOnTestFailed(testProxy);
    }

    @Override
    public void onTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        String testName;
        if (testIgnoredEvent == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(10);
        }
        if ((testName = testIgnoredEvent.getName()) == null) {
            this.logProblem("TestIgnored event: no name");
        }
        String ignoreComment = testIgnoredEvent.getIgnoreComment();
        String stackTrace = testIgnoredEvent.getStacktrace();
        String fullTestName = this.getFullTestName(testName);
        SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
        if (testProxy == null) {
            boolean debugMode = SMTestRunnerConnectionUtil.isInDebugMode();
            this.logProblem("Test wasn't started! TestIgnored event: name = {" + testName + "}, message = {" + ignoreComment + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
            if (debugMode) {
                return;
            }
            this.onTestStarted(new TestStartedEvent(testName, null));
            testProxy = this.getProxyByFullTestName(fullTestName);
        }
        if (testProxy == null) {
            return;
        }
        testProxy.setTestIgnored(ignoreComment, stackTrace);
        this.fireOnTestIgnored(testProxy);
    }

    @Override
    public void onTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        if (testOutputEvent == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(11);
        }
        String testName = testOutputEvent.getName();
        String text = testOutputEvent.getText();
        Key<?> outputType = testOutputEvent.getOutputType();
        String fullTestName = this.getFullTestName(testName);
        SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
        if (testProxy == null) {
            this.logProblem("Test wasn't started! TestOutput event: name = {" + testName + "}, outputType = " + String.valueOf(outputType) + ", text = {" + text + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
            return;
        }
        testProxy.addOutput(text, outputType);
        this.myEventPublisher.onTestOutput(testProxy, testOutputEvent);
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.fireOnTestsCountInSuite(count);
    }

    @VisibleForTesting
    @NotNull
    public final SMTestProxy getCurrentSuite() {
        SMTestProxy currentSuite = this.mySuitesStack.getCurrentSuite();
        if (currentSuite != null) {
            SMTestProxy sMTestProxy = currentSuite;
            if (sMTestProxy == null) {
                GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(12);
            }
            return sMTestProxy;
        }
        this.logProblem("Current suite is undefined. Root suite will be used.");
        SMTestProxy.SMRootTestProxy sMRootTestProxy = this.myTestsRootProxy;
        if (sMRootTestProxy == null) {
            GeneralToSMTRunnerEventsConvertor.$$$reportNull$$$0(13);
        }
        return sMRootTestProxy;
    }

    @VisibleForTesting
    public String getFullTestName(String testName) {
        return testName;
    }

    @TestOnly
    public int getRunningTestsQuantity() {
        return this.myRunningTestsFullNameToProxy.size();
    }

    @VisibleForTesting
    @Nullable
    public SMTestProxy getProxyByFullTestName(String fullTestName) {
        return this.myRunningTestsFullNameToProxy.get(fullTestName);
    }

    @TestOnly
    public void clearInternalSuitesStack() {
        this.mySuitesStack.clear();
    }

    private String cannotFindFullTestNameMsg(String fullTestName) {
        return "Cant find running test for [" + fullTestName + "]. Current running tests: {" + String.valueOf(this.dumpRunningTestsNames()) + "}";
    }

    private StringBuilder dumpRunningTestsNames() {
        Set<String> names = this.myRunningTestsFullNameToProxy.keySet();
        StringBuilder namesDump = new StringBuilder();
        for (String name : names) {
            namesDump.append('[').append(name).append(']').append(',');
        }
        return namesDump;
    }

    @Override
    public void dispose() {
        Application application;
        super.dispose();
        if (!(this.myRunningTestsFullNameToProxy.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
            this.logProblem("Not all events were processed! " + String.valueOf(this.dumpRunningTestsNames()));
        }
        this.myRunningTestsFullNameToProxy.clear();
        this.mySuitesStack.clear();
    }

    private SMTestProxy findCurrentTestOrSuite() {
        SMTestProxy currentProxy = null;
        Iterator<SMTestProxy> iterator = this.myRunningTestsFullNameToProxy.values().iterator();
        if (iterator.hasNext()) {
            currentProxy = iterator.next();
            if (iterator.hasNext()) {
                currentProxy = null;
            }
        }
        if (currentProxy == null) {
            SMTestProxy currentSuite = this.mySuitesStack.getCurrentSuite();
            currentProxy = currentSuite != null ? currentSuite : this.myTestsRootProxy;
        }
        return currentProxy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRootNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printerProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testStartedEvent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteStartedEvent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFinishedEvent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteFinishedEvent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFailedEvent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIgnoredEvent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOutputEvent";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPrinterProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onTestStarted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onTestFinished";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteFinished";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onUncapturedOutput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onTestFailure";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onTestIgnored";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onTestOutput";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13 -> new IllegalStateException(string);
        };
    }
}

