/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.testframework.sm.ServiceMessageUtil;
import com.intellij.execution.testframework.sm.runner.Shortener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u001a\"\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\f"}, d2={"ELLIPSIS", "", "FIELDS_NOT_TO_TOUCH", "", "EXPECTED_ACTUAL", "", "[Ljava/lang/String;", "cutLineIfTooLong", "text", "maxLength", "", "margin", "intellij.platform.smRunner"})
@SourceDebugExtension(value={"SMAP\nLongLineCutter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongLineCutter.kt\ncom/intellij/execution/testframework/sm/runner/LongLineCutterKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,74:1\n536#2:75\n521#2,6:76\n1068#3:82\n1563#3:83\n1634#3,3:84\n13805#4,2:87\n*S KotlinDebug\n*F\n+ 1 LongLineCutter.kt\ncom/intellij/execution/testframework/sm/runner/LongLineCutterKt\n*L\n35#1:75\n35#1:76,6\n37#1:82\n38#1:83\n38#1:84,3\n47#1:87,2\n*E\n"})
public final class LongLineCutterKt {
    @NotNull
    private static final String ELLIPSIS = "<...>";
    @NotNull
    private static final Set<String> FIELDS_NOT_TO_TOUCH;
    @NotNull
    private static final String[] EXPECTED_ACTUAL;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cutLineIfTooLong(@NotNull String text, int maxLength, int margin) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedByDescending$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int minValueLengthToCut = margin * 2 + 5;
        if (text.length() <= maxLength || maxLength < minValueLengthToCut) {
            return text;
        }
        ServiceMessage message = ServiceMessageUtil.parse(((Object)StringsKt.trim((CharSequence)text)).toString(), false, false);
        if (message == null) {
            String string = text.substring(0, maxLength - 5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string + ELLIPSIS;
        }
        HashMap attributes = new HashMap(message.getAttributes());
        Map map = attributes;
        boolean $i$f$filter = false;
        void var9_9 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!FIELDS_NOT_TO_TOUCH.contains(it.getKey()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = MapsKt.toList((Map)destination$iv$iv);
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((String)it.getSecond()).length());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((String)it.getSecond()).length()));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((String)it.getFirst());
        }
        List attributesToCut = (List)destination$iv$iv;
        Shortener shortener = new Shortener(attributes, text.length(), margin, minValueLengthToCut);
        for (String attr : attributesToCut) {
            if (shortener.getCurrentLength() < maxLength) break;
            Intrinsics.checkNotNull((Object)attr);
            shortener.shortenAttribute(attr);
            if (!ArraysKt.contains((Object[])EXPECTED_ACTUAL, (Object)attr)) continue;
            String[] $this$forEach$iv = EXPECTED_ACTUAL;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String p0 = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                shortener.shortenAttribute(p0);
            }
        }
        String string = ServiceMessage.asString((String)message.getMessageName(), (Map)attributes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    public static /* synthetic */ String cutLineIfTooLong$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = ConsoleBuffer.getCycleBufferSize();
        }
        if ((n3 & 4) != 0) {
            n2 = 1000;
        }
        return LongLineCutterKt.cutLineIfTooLong(string, n, n2);
    }

    static {
        Object[] objectArray = new String[]{"name", "duration", "type", "flowId", "nodeId", "parentNodeId"};
        FIELDS_NOT_TO_TOUCH = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"expected", "actual"};
        EXPECTED_ACTUAL = objectArray;
    }
}

