/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.testframework.sm.runner.LongLineCutterKt;
import com.intellij.openapi.util.Key;
import com.intellij.smRunner.OutputEventSplitterBase;
import com.intellij.smRunner.OutputStreamType;
import com.intellij.smRunner.OutputType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u001c\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\rH&J\u001c\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010J\u001c\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u0012\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010*\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/testframework/sm/runner/OutputEventSplitter;", "Lcom/intellij/smRunner/OutputEventSplitterBase;", "Lcom/intellij/execution/process/ProcessOutputType;", "bufferTextUntilNewLine", "", "cutNewLineBeforeServiceMessage", "<init>", "(ZZ)V", "process", "", "text", "", "processOutputType", "Lcom/intellij/openapi/util/Key;", "onTextAvailable", "outputType", "Lcom/intellij/smRunner/OutputType;", "onTextAvailableInternal", "toOutputType", "Companion", "intellij.platform.smRunner"})
public abstract class OutputEventSplitter
extends OutputEventSplitterBase<ProcessOutputType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean bufferTextUntilNewLine;
    private final boolean cutNewLineBeforeServiceMessage;
    private static final boolean USE_CYCLE_BUFFER = ConsoleBuffer.useCycleBuffer();
    @NotNull
    private static final OutputType<ProcessOutputType> stdout = new OutputType((Object)ProcessOutputType.STDOUT, OutputStreamType.STDOUT);
    @NotNull
    private static final OutputType<ProcessOutputType> stderr = new OutputType((Object)ProcessOutputType.STDERR, OutputStreamType.STDERR);
    @NotNull
    private static final OutputType<ProcessOutputType> system = new OutputType((Object)ProcessOutputType.SYSTEM, OutputStreamType.SYSTEM);

    public OutputEventSplitter(boolean bufferTextUntilNewLine, boolean cutNewLineBeforeServiceMessage) {
        super("##teamcity[", bufferTextUntilNewLine, cutNewLineBeforeServiceMessage);
        this.bufferTextUntilNewLine = bufferTextUntilNewLine;
        this.cutNewLineBeforeServiceMessage = cutNewLineBeforeServiceMessage;
    }

    public /* synthetic */ OutputEventSplitter(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    public final void process(@NotNull String text, @NotNull Key<?> processOutputType) {
        OutputType<ProcessOutputType> outputType;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(processOutputType, (String)"processOutputType");
        ProcessOutputType processOutputType2 = processOutputType instanceof ProcessOutputType ? (ProcessOutputType)processOutputType : null;
        OutputType<ProcessOutputType> outputType2 = outputType = processOutputType2 != null ? this.toOutputType(processOutputType2) : null;
        if (outputType != null) {
            this.process(text, outputType);
        } else {
            this.onTextAvailableInternal(text, processOutputType);
        }
    }

    public abstract void onTextAvailable(@NotNull String var1, @NotNull Key<?> var2);

    public final void onTextAvailable(@NotNull String text, @NotNull OutputType<ProcessOutputType> outputType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        this.onTextAvailableInternal(text, (Key)outputType.getData());
    }

    private final void onTextAvailableInternal(String text, Key<?> processOutputType) {
        String textToAdd = USE_CYCLE_BUFFER ? LongLineCutterKt.cutLineIfTooLong$default(text, 0, 0, 6, null) : text;
        this.onTextAvailable(textToAdd, processOutputType);
    }

    private final OutputType<ProcessOutputType> toOutputType(ProcessOutputType $this$toOutputType) {
        OutputType outputType;
        ProcessOutputType processOutputType = $this$toOutputType;
        if (Intrinsics.areEqual((Object)processOutputType, (Object)ProcessOutputType.STDOUT)) {
            outputType = stdout;
        } else if (Intrinsics.areEqual((Object)processOutputType, (Object)ProcessOutputType.STDERR)) {
            outputType = stderr;
        } else if (Intrinsics.areEqual((Object)processOutputType, (Object)ProcessOutputType.SYSTEM)) {
            outputType = system;
        } else {
            ProcessOutputType processOutputType2 = $this$toOutputType.getBaseOutputType();
            OutputStreamType streamType = Intrinsics.areEqual((Object)processOutputType2, (Object)ProcessOutputType.STDOUT) ? OutputStreamType.STDOUT : (Intrinsics.areEqual((Object)processOutputType2, (Object)ProcessOutputType.STDERR) ? OutputStreamType.STDERR : (Intrinsics.areEqual((Object)processOutputType2, (Object)ProcessOutputType.SYSTEM) ? OutputStreamType.SYSTEM : OutputStreamType.STDOUT));
            outputType = new OutputType((Object)$this$toOutputType, streamType);
        }
        return outputType;
    }

    public OutputEventSplitter() {
        this(false, false, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/testframework/sm/runner/OutputEventSplitter$Companion;", "", "<init>", "()V", "USE_CYCLE_BUFFER", "", "stdout", "Lcom/intellij/smRunner/OutputType;", "Lcom/intellij/execution/process/ProcessOutputType;", "kotlin.jvm.PlatformType", "stderr", "system", "intellij.platform.smRunner"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

