/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.TestComparisonFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class CompoundTestFailedState
extends TestFailedState {
    final List<TestFailedState> myStates = ContainerUtil.createLockFreeCopyOnWriteList();

    public CompoundTestFailedState() {
        super(null, null);
    }

    public void addFailure(TestFailedState state) {
        this.myStates.add(state);
        Disposer.register((Disposable)this, (Disposable)state);
    }

    @Override
    public void printOn(Printer printer) {
        for (TestFailedState state : this.myStates) {
            state.printOn(printer);
        }
    }

    @NotNull
    public @Unmodifiable List<DiffHyperlink> getHyperlinks() {
        List list = ContainerUtil.map((Collection)ContainerUtil.filter(this.myStates, state -> state instanceof TestComparisonFailedState), state -> ((TestComparisonFailedState)state).getHyperlink());
        if (list == null) {
            CompoundTestFailedState.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/states/CompoundTestFailedState", "getHyperlinks"));
    }
}

