/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestComparisonFailedState
extends TestFailedState {
    @NotNull
    private final DiffHyperlink myHyperlink;
    private boolean myToDeleteExpectedFile;
    private boolean myToDeleteActualFile;

    public TestComparisonFailedState(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, boolean printExpectedAndActualValues, @Nullable String expectedFilePath, @Nullable String actualFilePath) {
        if (actualText == null) {
            TestComparisonFailedState.$$$reportNull$$$0(0);
        }
        if (expectedText == null) {
            TestComparisonFailedState.$$$reportNull$$$0(1);
        }
        super(localizedMessage, stackTrace);
        this.myHyperlink = new DiffHyperlink(expectedText, actualText, expectedFilePath, actualFilePath, printExpectedAndActualValues);
    }

    @Override
    public void printOn(Printer printer) {
        printer.mark();
        String errorMsgPresentation = this.getErrorMsgPresentation();
        if (!StringUtil.isEmptyOrSpaces((String)errorMsgPresentation)) {
            printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
            printer.printWithAnsiColoring(errorMsgPresentation, ProcessOutputTypes.STDERR);
        }
        this.myHyperlink.printOn(printer);
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.printWithAnsiColoring(this.getStacktracePresentation(), ProcessOutputTypes.STDERR);
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
    }

    @NotNull
    public DiffHyperlink getHyperlink() {
        DiffHyperlink diffHyperlink = this.myHyperlink;
        if (diffHyperlink == null) {
            TestComparisonFailedState.$$$reportNull$$$0(2);
        }
        return diffHyperlink;
    }

    public void setToDeleteExpectedFile(boolean expectedTemp) {
        this.myToDeleteExpectedFile = expectedTemp;
    }

    public void setToDeleteActualFile(boolean actualTemp) {
        this.myToDeleteActualFile = actualTemp;
    }

    @Override
    public void dispose() {
        if (this.myToDeleteActualFile) {
            FileUtil.delete((File)new File(this.myHyperlink.getActualFilePath()));
        }
        if (this.myToDeleteExpectedFile) {
            FileUtil.delete((File)new File(this.myHyperlink.getFilePath()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/states/TestComparisonFailedState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/states/TestComparisonFailedState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHyperlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

