/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

public class TestStackTraceParser {
    private static final Pattern outerPattern = Pattern.compile("\tat (.*)\\.([^.]*)\\((.*)\\)");
    private static final Pattern innerPattern = Pattern.compile("(.*):(\\d*)");
    private int myFailedLine = -1;
    private String myFailedMethodName;
    private String myErrorMessage;
    private String myTopLocationLine;

    public int getFailedLine() {
        return this.myFailedLine;
    }

    public String getFailedMethodName() {
        return this.myFailedMethodName;
    }

    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public String getTopLocationLine() {
        return this.myTopLocationLine;
    }

    protected TestStackTraceParser(int failedLine, String failedMethodName, String errorMessage, String topLocationLine) {
        this.myFailedLine = failedLine;
        this.myFailedMethodName = failedMethodName;
        this.myErrorMessage = errorMessage;
        this.myTopLocationLine = topLocationLine;
    }

    @ApiStatus.Internal
    public TestStackTraceParser(String url, String stacktrace, String errorMessage, SMTestLocator locator, Project project) {
        this.myErrorMessage = errorMessage;
        if (stacktrace == null || url == null) {
            return;
        }
        int i = url.indexOf("//");
        if (i == -1) {
            return;
        }
        String path = "\tat " + url.substring(i + 2).replaceFirst("/", ".");
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        try (BufferedReader reader = new BufferedReader(new StringReader(stacktrace));){
            String line;
            String previous = null;
            while ((line = reader.readLine()) != null) {
                List<Location> location;
                if (StringUtil.isEmpty((String)this.myErrorMessage)) {
                    this.myErrorMessage = line;
                }
                if (this.myTopLocationLine == null && !(location = locator.getLocation(line, project, scope)).isEmpty()) {
                    this.myTopLocationLine = line;
                }
                if (line.startsWith(path)) {
                    Matcher matcher = outerPattern.matcher(line);
                    if (!matcher.matches()) {
                        return;
                    }
                    Matcher matcher1 = innerPattern.matcher(matcher.group(3));
                    if (!matcher1.matches()) {
                        return;
                    }
                    this.myFailedLine = Integer.parseInt(matcher1.group(2));
                    if (previous == null) {
                        return;
                    }
                    Matcher matcher2 = outerPattern.matcher(previous);
                    if (!matcher2.matches()) {
                        return;
                    }
                    this.myFailedMethodName = matcher2.group(2);
                }
                previous = line;
            }
        }
        catch (IOException | NumberFormatException exception) {
            // empty catch block
        }
    }
}

