/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerNodeDescriptor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.accessibility.AccessibleContext;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestTreeRenderer
extends ColoredTreeCellRenderer {
    @NonNls
    private static final String SPACE_STRING = " ";
    private final TestConsoleProperties myConsoleProperties;
    private SMRootTestProxyFormatter myAdditionalRootFormatter;
    private String myDurationText;
    private Color myDurationColor;
    private int myDurationWidth;
    private int myDurationLeftInset;
    private int myDurationRightInset;
    @Nullable
    private Computable<String> myAccessibleStatus = null;

    public TestTreeRenderer(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            TestTreeRenderer.$$$reportNull$$$0(0);
        }
        this.myDurationText = null;
        this.myDurationColor = null;
        this.myDurationWidth = 0;
        this.myDurationLeftInset = 0;
        this.myDurationRightInset = 0;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj instanceof SMTRunnerNodeDescriptor) {
            SMTRunnerNodeDescriptor desc = (SMTRunnerNodeDescriptor)((Object)userObj);
            SMTestProxy testProxy = (SMTestProxy)desc.getElement();
            if (testProxy instanceof SMTestProxy.SMRootTestProxy) {
                SMTestProxy.SMRootTestProxy rootTestProxy = (SMTestProxy.SMRootTestProxy)testProxy;
                if (rootTestProxy.isLeaf()) {
                    TestsPresentationUtil.formatRootNodeWithoutChildren(rootTestProxy, this);
                } else {
                    TestsPresentationUtil.formatRootNodeWithChildren(rootTestProxy, this);
                }
                if (this.myAdditionalRootFormatter != null) {
                    this.myAdditionalRootFormatter.format(rootTestProxy, this);
                }
            } else {
                TestsPresentationUtil.formatTestProxy(testProxy, this);
            }
            if (TestConsoleProperties.SHOW_INLINE_STATISTICS.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties)) {
                this.myDurationText = this.getDurationText(testProxy, this.myConsoleProperties);
                if (this.myDurationText != null) {
                    FontMetrics metrics = this.getFontMetrics(RelativeFont.SMALL.derive(this.getFont()));
                    this.myDurationWidth = metrics.stringWidth(this.myDurationText);
                    this.myDurationLeftInset = metrics.getHeight() / 4;
                    this.myDurationRightInset = ExperimentalUI.isNewUI() ? tree.getInsets().right + JBUI.scale((int)4) : this.myDurationLeftInset;
                    this.myDurationColor = selected ? UIUtil.getTreeSelectionForeground((boolean)hasFocus) : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
                }
            }
            return;
        }
        @NlsSafe String text = node.toString();
        this.append(text != null ? text : SPACE_STRING, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Nls
    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public String getDurationText(@NotNull SMTestProxy testProxy, @NotNull TestConsoleProperties consoleProperties) {
        if (testProxy == null) {
            TestTreeRenderer.$$$reportNull$$$0(1);
        }
        if (consoleProperties == null) {
            TestTreeRenderer.$$$reportNull$$$0(2);
        }
        return testProxy.getDurationString(this.myConsoleProperties);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.myDurationWidth > 0) {
            preferredSize.width += this.myDurationWidth + this.myDurationLeftInset + this.myDurationRightInset;
        }
        Dimension dimension = preferredSize;
        if (dimension == null) {
            TestTreeRenderer.$$$reportNull$$$0(3);
        }
        return dimension;
    }

    public TestConsoleProperties getConsoleProperties() {
        return this.myConsoleProperties;
    }

    public void setAdditionalRootFormatter(@NotNull SMRootTestProxyFormatter formatter) {
        if (formatter == null) {
            TestTreeRenderer.$$$reportNull$$$0(4);
        }
        this.myAdditionalRootFormatter = formatter;
    }

    public void removeAdditionalRootFormatter() {
        this.myAdditionalRootFormatter = null;
    }

    protected void paintComponent(Graphics g) {
        UISettings.setupAntialiasing((Graphics)g);
        Shape clip = null;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        if (this.myDurationWidth > 0 && (width -= this.myDurationWidth + this.myDurationLeftInset + this.myDurationRightInset) > 0 && height > 0) {
            g.setColor(this.myDurationColor);
            g.setFont(RelativeFont.SMALL.derive(this.getFont()));
            g.drawString(this.myDurationText, width + this.myDurationLeftInset, TestTreeRenderer.getTextBaseLine((FontMetrics)g.getFontMetrics(), (int)height));
            clip = g.getClip();
            g.clipRect(0, 0, width, height);
        }
        super.paintComponent(g);
        if (clip != null) {
            g.setClip(clip);
        }
    }

    @ApiStatus.Experimental
    @Nullable
    @NlsSafe
    public String getAccessibleStatus() {
        if (this.myAccessibleStatus == null) {
            return null;
        }
        return (String)this.myAccessibleStatus.get();
    }

    @ApiStatus.Experimental
    public void setAccessibleStatus(@Nullable Computable<String> accessibleStatus) {
        this.myAccessibleStatus = accessibleStatus;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new ColoredTreeCellRenderer.AccessibleColoredTreeCellRendererWithContextMenu((ColoredTreeCellRenderer)this, new ColoredTreeCellRenderer.AccessibleColoredTreeCellRenderer(){

                protected String getOriginalAccessibleName() {
                    return this.getAccessibleNameWithoutIconTooltip();
                }
            });
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/ui/TestTreeRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/ui/TestTreeRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDurationText";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalRootFormatter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

