/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EDT;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.LoadingDetailsImpl;
import com.intellij.vcs.log.data.LoadingDetailsWithRoot;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 G2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002FGBE\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0012\u0010$\u001a\u00020\u00022\n\u0010%\u001a\u00060\u0018j\u0002`\u001aJ&\u0010&\u001a\u00020\u00022\n\u0010%\u001a\u00060\u0018j\u0002`\u001a2\u0010\u0010'\u001a\f\u0012\b\u0012\u00060\u0018j\u0002`\u001a0(H\u0007J\u0016\u0010)\u001a\u0004\u0018\u00010\u00022\n\u0010%\u001a\u00060\u0018j\u0002`\u001aH\u0002J\u0016\u0010*\u001a\u0004\u0018\u00010\u00022\n\u0010%\u001a\u00060\u0018j\u0002`\u001aH\u0016J \u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020+2\u0010\u0010,\u001a\f\u0012\b\u0012\u00060\u0018j\u0002`\u001a0-H\u0014J\u001c\u0010.\u001a\u00020/2\n\u0010%\u001a\u00060\u0018j\u0002`\u001a2\u0006\u00100\u001a\u00020\u0002H\u0014J\u001c\u00101\u001a\u00020/2\n\u00102\u001a\u00060\u0018j\u0002`\u001a2\u0006\u00103\u001a\u00020\u001fH\u0003J\u0010\u00104\u001a\u00020/2\u0006\u0010,\u001a\u000205H\u0015J \u00106\u001a\u00020/2\u0006\u0010,\u001a\u0002072\u000e\u00108\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000209H\u0015J*\u00106\u001a\u00020/2\u0006\u0010,\u001a\u0002072\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020/0:H\u0007J6\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\t2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0-2\u000e\u00108\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000209H\u0015J\u001c\u0010@\u001a\u00020\u00022\n\u0010%\u001a\u00060\u0018j\u0002`\u001a2\u0006\u00103\u001a\u00020\u001fH\u0002J\u000e\u0010A\u001a\u00020/2\u0006\u0010B\u001a\u00020\"J\u000e\u0010C\u001a\u00020/2\u0006\u0010B\u001a\u00020\"J\b\u0010D\u001a\u00020/H\u0014J\b\u0010E\u001a\u00020/H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u001c\u0012\r\u0012\u000b0\u0018j\u0002`\u001a\u00a2\u0006\u0002\b\u0019\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u001d0\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/vcs/log/data/MiniDetailsGetter;", "Lcom/intellij/vcs/log/data/AbstractDataGetter;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "topCommitsDetailsCache", "Lcom/intellij/vcs/log/data/TopCommitsCache;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Map;Lcom/intellij/vcs/log/data/TopCommitsCache;Lcom/intellij/vcs/log/data/index/VcsLogIndex;Lcom/intellij/openapi/Disposable;)V", "factory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "kotlin.jvm.PlatformType", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "loader", "Lcom/intellij/vcs/log/util/SequentialLimitedLifoExecutor;", "Lcom/intellij/vcs/log/data/MiniDetailsGetter$TaskDescriptor;", "currentTaskIndex", "", "loadingFinishedListeners", "Ljava/util/ArrayList;", "Ljava/lang/Runnable;", "Lkotlin/collections/ArrayList;", "getCachedDataOrPlaceholder", "commit", "getCommitData", "commitsToLoad", "", "getFromCacheAndCleanOldPlaceholder", "getCachedData", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "commits", "", "saveInCache", "", "details", "cacheCommit", "commitId", "taskNumber", "cacheCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "doLoadCommitsData", "Lit/unimi/dsi/fastutil/ints/IntSet;", "consumer", "Lcom/intellij/util/Consumer;", "Lkotlin/Function2;", "doLoadCommitsDataFromProvider", "logProvider", "root", "hashes", "", "createPlaceholderCommit", "addDetailsLoadedListener", "runnable", "removeDetailsLoadedListener", "notifyLoaded", "dispose", "TaskDescriptor", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nMiniDetailsGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter$Companion\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,204:1\n23#2:205\n1#3:206\n190#4,6:207\n216#5,2:213\n*S KotlinDebug\n*F\n+ 1 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter\n*L\n55#1:205\n93#1:207,6\n129#1:213,2\n*E\n"})
public final class MiniDetailsGetter
extends AbstractDataGetter<VcsCommitMetadata> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TopCommitsCache topCommitsDetailsCache;
    @NotNull
    private final VcsLogIndex index;
    private final VcsLogObjectsFactory factory;
    @NotNull
    private final Cache<Integer, VcsCommitMetadata> cache;
    @NotNull
    private final SequentialLimitedLifoExecutor<TaskDescriptor> loader;
    private long currentTaskIndex;
    @NotNull
    private final ArrayList<Runnable> loadingFinishedListeners;
    private static final int MAX_LOADING_TASKS = 10;

    public MiniDetailsGetter(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)topCommitsDetailsCache, (String)"topCommitsDetailsCache");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(storage, logProviders, parentDisposable);
        this.topCommitsDetailsCache = topCommitsDetailsCache;
        this.index = index;
        this.factory = (VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class);
        Cache cache = Caffeine.newBuilder().maximumSize(10000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
        this.loader = new SequentialLimitedLifoExecutor(this, 10, arg_0 -> MiniDetailsGetter.loader$lambda$1(arg_0 -> MiniDetailsGetter.loader$lambda$0(this, arg_0), arg_0));
        this.loadingFinishedListeners = new ArrayList();
    }

    @NotNull
    public final VcsCommitMetadata getCachedDataOrPlaceholder(int commit) {
        return this.getCommitData(commit, SetsKt.emptySet());
    }

    @ApiStatus.Internal
    @NotNull
    public final VcsCommitMetadata getCommitData(int commit, @NotNull Iterable<Integer> commitsToLoad) {
        VcsCommitMetadata details;
        Intrinsics.checkNotNullParameter(commitsToLoad, (String)"commitsToLoad");
        VcsCommitMetadata vcsCommitMetadata = details = this.getFromCacheAndCleanOldPlaceholder(commit);
        if (vcsCommitMetadata != null) {
            return vcsCommitMetadata;
        }
        if (!EDT.isCurrentThreadEdt()) {
            MiniDetailsGetter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(MiniDetailsGetter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.assertTrue(CollectionsKt.none(commitsToLoad), (Object)"Requesting loading commits in background thread is not supported.");
            return this.createPlaceholderCommit(commit, 0L);
        }
        IntOpenHashSet toLoad = new IntOpenHashSet(commitsToLoad.iterator());
        if (toLoad.isEmpty()) {
            VcsCommitMetadata vcsCommitMetadata2 = (VcsCommitMetadata)this.cache.getIfPresent((Object)commit);
            if (vcsCommitMetadata2 == null) {
                vcsCommitMetadata2 = this.createPlaceholderCommit(commit, 0L);
            }
            return vcsCommitMetadata2;
        }
        long l = this.currentTaskIndex;
        this.currentTaskIndex = l + 1L;
        long taskNumber = l;
        toLoad.forEach(arg_0 -> MiniDetailsGetter.getCommitData$lambda$0(this, taskNumber, arg_0));
        this.loader.queue(new TaskDescriptor((IntSet)toLoad));
        VcsCommitMetadata vcsCommitMetadata3 = (VcsCommitMetadata)this.cache.getIfPresent((Object)commit);
        if (vcsCommitMetadata3 == null) {
            vcsCommitMetadata3 = this.createPlaceholderCommit(commit, taskNumber);
        }
        return vcsCommitMetadata3;
    }

    private final VcsCommitMetadata getFromCacheAndCleanOldPlaceholder(int commit) {
        if (!EDT.isCurrentThreadEdt()) {
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)this.cache.getIfPresent((Object)commit);
            if (vcsCommitMetadata == null) {
                vcsCommitMetadata = this.topCommitsDetailsCache.get(commit);
            }
            return vcsCommitMetadata;
        }
        VcsCommitMetadata details = (VcsCommitMetadata)this.cache.getIfPresent((Object)commit);
        if (details != null) {
            if (details instanceof LoadingDetailsImpl && ((LoadingDetailsImpl)details).getLoadingTaskIndex() <= this.currentTaskIndex - (long)10) {
                this.cache.asMap().remove(commit, details);
                return null;
            }
            return details;
        }
        return this.topCommitsDetailsCache.get(commit);
    }

    @Nullable
    public VcsCommitMetadata getCachedData(int commit) {
        Object object = this.cache.getIfPresent((Object)commit);
        VcsCommitMetadata it = (VcsCommitMetadata)object;
        boolean bl = false;
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)(!(it instanceof LoadingDetails) ? object : null);
        if (vcsCommitMetadata == null) {
            vcsCommitMetadata = this.topCommitsDetailsCache.get(commit);
        }
        return vcsCommitMetadata;
    }

    @Override
    @NotNull
    protected Int2ObjectMap<VcsCommitMetadata> getCachedData(@NotNull List<Integer> commits) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Companion companion = Companion;
        Iterable $this$associateNotNull$iv = commits;
        boolean $i$f$associateNotNull = false;
        Int2ObjectOpenHashMap result$iv = new Int2ObjectOpenHashMap();
        Iterator iterator = $this$associateNotNull$iv.iterator();
        while (iterator.hasNext()) {
            VcsCommitMetadata value$iv;
            int element$iv;
            int it = element$iv = ((Number)iterator.next()).intValue();
            boolean bl = false;
            if (this.getCachedData(it) == null) continue;
            ((Map)result$iv).put(element$iv, value$iv);
        }
        return (Int2ObjectMap)result$iv;
    }

    @Override
    protected void saveInCache(int commit, @NotNull VcsCommitMetadata details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.cache.put((Object)commit, (Object)details);
    }

    @RequiresEdt
    private final void cacheCommit(int commitId, long taskNumber) {
        if (this.cache.getIfPresent((Object)commitId) == null) {
            this.cache.put((Object)commitId, (Object)this.createPlaceholderCommit(commitId, taskNumber));
        }
    }

    @Override
    @RequiresEdt
    protected void cacheCommits(@NotNull IntOpenHashSet commits) {
        Intrinsics.checkNotNullParameter((Object)commits, (String)"commits");
        long l = this.currentTaskIndex;
        this.currentTaskIndex = l + 1L;
        long taskNumber = l;
        commits.forEach(arg_0 -> MiniDetailsGetter.cacheCommits$lambda$0(this, taskNumber, arg_0));
    }

    @Override
    @RequiresBackgroundThread
    protected void doLoadCommitsData(@NotNull IntSet commits, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)commits, (String)"commits");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.doLoadCommitsData(commits, (Function2<? super Integer, ? super VcsCommitMetadata, Unit>)((Function2)(arg_0, arg_1) -> MiniDetailsGetter.doLoadCommitsData$lambda$0(consumer, arg_0, arg_1)));
    }

    @RequiresBackgroundThread
    public final void doLoadCommitsData(@NotNull IntSet commits, @NotNull Function2<? super Integer, ? super VcsCommitMetadata, Unit> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)commits, (String)"commits");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        IndexDataGetter dataGetter = this.index.getDataGetter();
        if (dataGetter == null) {
            super.doLoadCommitsData(commits, arg_0 -> MiniDetailsGetter.doLoadCommitsData$lambda$2(arg_0 -> MiniDetailsGetter.doLoadCommitsData$lambda$1(consumer, this, arg_0), arg_0));
            return;
        }
        Set set = (Set)commits;
        VcsLogStorage vcsLogStorage = this.getStorage();
        VcsLogObjectsFactory vcsLogObjectsFactory = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogObjectsFactory, (String)"factory");
        Int2ObjectMap<VcsCommitMetadata> metadata = IndexedDetails.Companion.createMetadata(set, dataGetter, vcsLogStorage, vcsLogObjectsFactory);
        Map $this$forEach$iv = (Map)metadata;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Integer commit = (Integer)entry.getKey();
            VcsCommitMetadata metadata2 = (VcsCommitMetadata)entry.getValue();
            Intrinsics.checkNotNull((Object)commit);
            Intrinsics.checkNotNull((Object)metadata2);
            consumer.invoke((Object)commit, (Object)metadata2);
        }
        Set set2 = metadata.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        IntSet notIndexed = MiniDetailsGetter.Companion.minus(commits, (IntSet)set2);
        if (!notIndexed.isEmpty()) {
            super.doLoadCommitsData(notIndexed, arg_0 -> MiniDetailsGetter.doLoadCommitsData$lambda$5(arg_0 -> MiniDetailsGetter.doLoadCommitsData$lambda$4(consumer, this, arg_0), arg_0));
        }
    }

    @Override
    @RequiresBackgroundThread
    protected void doLoadCommitsDataFromProvider(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)logProvider, (String)"logProvider");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        logProvider.readMetadata(root, hashes, consumer);
    }

    private final VcsCommitMetadata createPlaceholderCommit(int commit, long taskNumber) {
        VcsCommitMetadata vcsCommitMetadata;
        IndexDataGetter dataGetter = this.index.getDataGetter();
        if (dataGetter != null && Registry.Companion.is("vcs.log.use.indexed.details")) {
            vcsCommitMetadata = (VcsCommitMetadata)new IndexedDetails(dataGetter, this.getStorage(), commit, taskNumber);
        } else {
            LoadingDetailsImpl loadingDetailsImpl;
            VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((Iterable)this.getLogProviders().keySet());
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                loadingDetailsImpl = new LoadingDetailsWithRoot(this.getStorage(), commit, it, taskNumber);
            } else {
                loadingDetailsImpl = new LoadingDetailsImpl(this.getStorage(), commit, taskNumber);
            }
            vcsCommitMetadata = (VcsCommitMetadata)loadingDetailsImpl;
        }
        return vcsCommitMetadata;
    }

    public final void addDetailsLoadedListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.loadingFinishedListeners.add(runnable);
    }

    public final void removeDetailsLoadedListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.loadingFinishedListeners.remove(runnable);
    }

    @Override
    protected void notifyLoaded() {
        BaseSingleTaskControllerKt.runInEdt(this.getDisposableFlag(), (Function0<Unit>)((Function0)() -> MiniDetailsGetter.notifyLoaded$lambda$0(this)));
    }

    public void dispose() {
        this.loadingFinishedListeners.clear();
    }

    private static final Unit loader$lambda$0(MiniDetailsGetter this$0, TaskDescriptor task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        this$0.doLoadCommitsData(task2.getCommits(), (Function2<? super Integer, ? super VcsCommitMetadata, Unit>)((Function2)(arg_0, arg_1) -> MiniDetailsGetter.loader$lambda$0$0(this$0, arg_0, arg_1)));
        this$0.notifyLoaded();
        return Unit.INSTANCE;
    }

    private static final Unit loader$lambda$0$0(MiniDetailsGetter this$0, int commitId, VcsCommitMetadata data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this$0.saveInCache(commitId, data2);
        return Unit.INSTANCE;
    }

    private static final void loader$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void getCommitData$lambda$0(MiniDetailsGetter this$0, long $taskNumber, int it) {
        this$0.cacheCommit(it, $taskNumber);
    }

    private static final void cacheCommits$lambda$0(MiniDetailsGetter this$0, long $taskNumber, int commit) {
        this$0.cacheCommit(commit, $taskNumber);
    }

    private static final Unit doLoadCommitsData$lambda$0(Consumer $consumer, int n, VcsCommitMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        $consumer.consume((Object)metadata);
        return Unit.INSTANCE;
    }

    private static final Unit doLoadCommitsData$lambda$1(Function2 $consumer, MiniDetailsGetter this$0, VcsCommitMetadata data2) {
        VcsLogStorage vcsLogStorage = this$0.getStorage();
        Object object = data2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
        Hash hash = (Hash)object;
        VirtualFile virtualFile = data2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        Integer n = vcsLogStorage.getCommitIndex(hash, virtualFile);
        Intrinsics.checkNotNull((Object)data2);
        $consumer.invoke((Object)n, (Object)data2);
        return Unit.INSTANCE;
    }

    private static final void doLoadCommitsData$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit doLoadCommitsData$lambda$4(Function2 $consumer, MiniDetailsGetter this$0, VcsCommitMetadata data2) {
        VcsLogStorage vcsLogStorage = this$0.getStorage();
        Object object = data2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
        Hash hash = (Hash)object;
        VirtualFile virtualFile = data2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        Integer n = vcsLogStorage.getCommitIndex(hash, virtualFile);
        Intrinsics.checkNotNull((Object)data2);
        $consumer.invoke((Object)n, (Object)data2);
        return Unit.INSTANCE;
    }

    private static final void doLoadCommitsData$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit notifyLoaded$lambda$0(MiniDetailsGetter this$0) {
        Iterator<Runnable> iterator = this$0.loadingFinishedListeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Runnable> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Runnable loadingFinishedListener = iterator2.next();
            loadingFinishedListener.run();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u00020\u00050\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\b0\u000bH\u0082\bJ\u0015\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0082\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/data/MiniDetailsGetter$Companion;", "", "<init>", "()V", "MAX_LOADING_TASKS", "", "associateNotNull", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "V", "", "transform", "Lkotlin/Function1;", "minus", "Lit/unimi/dsi/fastutil/ints/IntSet;", "other", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nMiniDetailsGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,204:1\n855#2,2:205\n*S KotlinDebug\n*F\n+ 1 MiniDetailsGetter.kt\ncom/intellij/vcs/log/data/MiniDetailsGetter$Companion\n*L\n200#1:205,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final <V> Int2ObjectMap<V> associateNotNull(Iterable<Integer> $this$associateNotNull, Function1<? super Integer, ? extends V> transform) {
            boolean $i$f$associateNotNull = false;
            Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
            Iterator<Integer> iterator = $this$associateNotNull.iterator();
            while (iterator.hasNext()) {
                Object value;
                int element = ((Number)iterator.next()).intValue();
                if (transform.invoke((Object)element) == null) continue;
                ((Map)result).put(element, value);
            }
            return (Int2ObjectMap)result;
        }

        /*
         * WARNING - void declaration
         */
        private final IntSet minus(IntSet $this$minus, IntSet other) {
            void $this$filterNotTo$iv;
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
            if (other.isEmpty()) {
                return $this$minus;
            }
            Iterable iterable = (Iterable)$this$minus;
            Collection destination$iv = (Collection)new IntOpenHashSet();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv : $this$filterNotTo$iv) {
                Integer it = (Integer)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (other.contains(it.intValue())) continue;
                destination$iv.add(element$iv);
            }
            return (IntSet)destination$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/data/MiniDetailsGetter$TaskDescriptor;", "", "commits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "<init>", "(Lit/unimi/dsi/fastutil/ints/IntSet;)V", "getCommits", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "intellij.platform.vcs.log.impl"})
    private static final class TaskDescriptor {
        @NotNull
        private final IntSet commits;

        public TaskDescriptor(@NotNull IntSet commits) {
            Intrinsics.checkNotNullParameter((Object)commits, (String)"commits");
            this.commits = commits;
        }

        @NotNull
        public final IntSet getCommits() {
            return this.commits;
        }
    }
}

