/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.observable.properties;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.operation.OperationExecutionId;
import com.intellij.openapi.observable.operation.OperationExecutionStatus;
import com.intellij.openapi.observable.operation.core.AtomicOperationTrace;
import com.intellij.openapi.observable.operation.core.MutableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTraceUtil;
import com.intellij.openapi.observable.operation.core.OperationUtilKt;
import com.intellij.openapi.observable.properties.AtomicMutableProperty;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.GraphPropertyImpl;
import com.intellij.openapi.observable.properties.ListenerUtilKt;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001+B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001aJ\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u0016J>\u0010\u001c\u001a\u00020\u001d\"\u0004\b\u0000\u0010\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\f2\b\b\u0002\u0010!\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001aJ\u0019\u0010#\u001a\u00020\u001d2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\fH\u0000\u00a2\u0006\u0002\b$J\u0014\u0010%\u001a\u00020\u001d2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u0014\u0010&\u001a\u00020\u001d2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u0014\u0010'\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aJ\u001e\u0010'\u001a\u00020\u001d2\b\u0010)\u001a\u0004\u0018\u00010*2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0010\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0012*\b\u0012\u0002\b\u0003\u0018\u00010\f0\f0\u0011\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/observable/properties/PropertyGraph;", "", "debugName", "", "isBlockPropagation", "", "<init>", "(Ljava/lang/String;Z)V", "propagation", "Lcom/intellij/openapi/observable/operation/core/AtomicOperationTrace;", "properties", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "dependencyMatrix", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/openapi/observable/properties/PropertyGraph$Dependency;", "recursionGuard", "Lcom/intellij/openapi/util/RecursionGuard;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "property", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "T", "initial", "(Ljava/lang/Object;)Lcom/intellij/openapi/observable/properties/GraphProperty;", "lazyProperty", "Lkotlin/Function0;", "lateinitProperty", "dependsOn", "", "child", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "parent", "deleteWhenChildModified", "update", "registerIfNeeded", "registerIfNeeded$intellij_platform_ide_observable", "removeDependenciesIfNeeded", "propagateChange", "afterPropagation", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Dependency", "intellij.platform.ide.observable"})
@SourceDebugExtension(value={"SMAP\nPropertyGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyGraph.kt\ncom/intellij/openapi/observable/properties/PropertyGraph\n+ 2 OperationUtil.kt\ncom/intellij/openapi/observable/operation/core/OperationUtilKt\n*L\n1#1,131:1\n55#2,15:132\n80#2:147\n71#2,7:148\n*S KotlinDebug\n*F\n+ 1 PropertyGraph.kt\ncom/intellij/openapi/observable/properties/PropertyGraph\n*L\n90#1:132,15\n90#1:147\n90#1:148,7\n*E\n"})
public final class PropertyGraph {
    private final boolean isBlockPropagation;
    @NotNull
    private final AtomicOperationTrace propagation;
    @NotNull
    private final ConcurrentHashMap<ObservableProperty<?>, Boolean> properties;
    @NotNull
    private final ConcurrentHashMap<ObservableProperty<?>, CopyOnWriteArrayList<Dependency<?>>> dependencyMatrix;
    @NotNull
    private final RecursionGuard<ObservableProperty<?>> recursionGuard;

    public PropertyGraph(@Nullable String debugName, boolean isBlockPropagation) {
        this.isBlockPropagation = isBlockPropagation;
        String string = debugName;
        if (string == null) {
            string = "UNKNOWN";
        }
        this.propagation = new AtomicOperationTrace("Graph " + string + " propagation");
        this.properties = new ConcurrentHashMap();
        this.dependencyMatrix = new ConcurrentHashMap();
        RecursionGuard recursionGuard = RecursionManager.createGuard((String)PropertyGraph.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)recursionGuard, (String)"createGuard(...)");
        this.recursionGuard = recursionGuard;
    }

    public /* synthetic */ PropertyGraph(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    @NotNull
    public final <T> GraphProperty<T> property(T initial) {
        return new GraphPropertyImpl(this, () -> PropertyGraph.property$lambda$0(initial));
    }

    @NotNull
    public final <T> GraphProperty<T> lazyProperty(@NotNull Function0<? extends T> initial) {
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        return new GraphPropertyImpl<T>(this, initial);
    }

    @NotNull
    public final <T> GraphProperty<T> lateinitProperty() {
        return this.lazyProperty(PropertyGraph::lateinitProperty$lambda$0);
    }

    public final <T> void dependsOn(@NotNull ObservableMutableProperty<T> child, @NotNull ObservableProperty<?> parent, boolean deleteWhenChildModified, @NotNull Function0<? extends T> update) {
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(update, (String)"update");
        this.registerIfNeeded$intellij_platform_ide_observable((ObservableProperty)child);
        this.registerIfNeeded$intellij_platform_ide_observable(parent);
        CopyOnWriteArrayList copyOnWriteArrayList = this.dependencyMatrix.computeIfAbsent(parent, arg_0 -> PropertyGraph.dependsOn$lambda$1(PropertyGraph::dependsOn$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)copyOnWriteArrayList, (String)"computeIfAbsent(...)");
        CopyOnWriteArrayList dependencies = copyOnWriteArrayList;
        dependencies.add(new Dependency<T>(child, deleteWhenChildModified, update));
    }

    public static /* synthetic */ void dependsOn$default(PropertyGraph propertyGraph, ObservableMutableProperty observableMutableProperty, ObservableProperty observableProperty, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            bl = propertyGraph.isBlockPropagation;
        }
        propertyGraph.dependsOn(observableMutableProperty, observableProperty, bl, function0);
    }

    public final void registerIfNeeded$intellij_platform_ide_observable(@NotNull ObservableProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (this.properties.putIfAbsent(property, true) == null) {
            ListenerUtilKt.whenPropertyChanged(property, arg_0 -> PropertyGraph.registerIfNeeded$lambda$0(this, property, arg_0));
        }
    }

    private final void removeDependenciesIfNeeded(ObservableProperty<?> property) {
        Iterator<CopyOnWriteArrayList<Dependency<?>>> iterator = this.dependencyMatrix.values().iterator();
        while (iterator.hasNext()) {
            CopyOnWriteArrayList<Dependency<?>> dependencies;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            dependencies.removeIf(arg_0 -> PropertyGraph.removeDependenciesIfNeeded$lambda$1(arg_0 -> PropertyGraph.removeDependenciesIfNeeded$lambda$0(property, arg_0), arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void propagateChange(ObservableProperty<?> property) {
        MutableOperationTrace $this$traceRun_u24default$iv = this.propagation;
        OperationExecutionId id$iv = OperationExecutionId.Companion.getNONE();
        boolean $i$f$traceRun = false;
        boolean $i$f$traceRun2 = false;
        OperationExecutionStatus status$iv$iv = OperationExecutionStatus.Success.INSTANCE;
        try {
            boolean bl = false;
            $this$traceRun_u24default$iv.traceStart(id$iv);
            boolean bl2 = false;
            CopyOnWriteArrayList<Dependency<?>> copyOnWriteArrayList = this.dependencyMatrix.get(property);
            List dependencies = copyOnWriteArrayList != null ? (List)copyOnWriteArrayList : CollectionsKt.emptyList();
            for (Dependency dependency : dependencies) {
                this.recursionGuard.doPreventingRecursion(dependency.getProperty(), false, () -> PropertyGraph.propagateChange$lambda$0$0(dependency));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (ProcessCanceledException exception$iv$iv) {
            status$iv$iv = OperationExecutionStatus.Cancel.INSTANCE;
            throw exception$iv$iv;
        }
        catch (Throwable exception$iv$iv) {
            status$iv$iv = new OperationExecutionStatus.Failure(exception$iv$iv);
            throw exception$iv$iv;
        }
        finally {
            OperationExecutionStatus it$iv = status$iv$iv;
            boolean bl = false;
            MutableOperationTrace.traceFinish$default($this$traceRun_u24default$iv, id$iv, null, 2, null);
        }
    }

    public final void afterPropagation(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.afterPropagation(null, listener2);
    }

    public final void afterPropagation(@Nullable Disposable parentDisposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        ObservableOperationTraceUtil.whenOperationFinished((ObservableOperationTrace)this.propagation, parentDisposable, listener2);
    }

    private static final Object property$lambda$0(Object $initial) {
        return $initial;
    }

    private static final Object lateinitProperty$lambda$0() {
        throw new UninitializedPropertyAccessException();
    }

    private static final CopyOnWriteArrayList dependsOn$lambda$0(ObservableProperty it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new CopyOnWriteArrayList();
    }

    private static final CopyOnWriteArrayList dependsOn$lambda$1(Function1 $tmp0, Object p0) {
        return (CopyOnWriteArrayList)$tmp0.invoke(p0);
    }

    private static final Unit registerIfNeeded$lambda$0(PropertyGraph this$0, ObservableProperty $property, Object it) {
        if (OperationUtilKt.isOperationCompleted(this$0.propagation)) {
            this$0.removeDependenciesIfNeeded($property);
            Unit cfr_ignored_0 = (Unit)this$0.recursionGuard.doPreventingRecursion((Object)$property, false, () -> PropertyGraph.registerIfNeeded$lambda$0$0(this$0, $property));
        } else {
            this$0.propagateChange($property);
        }
        return Unit.INSTANCE;
    }

    private static final Unit registerIfNeeded$lambda$0$0(PropertyGraph this$0, ObservableProperty $property) {
        this$0.propagateChange($property);
        return Unit.INSTANCE;
    }

    private static final boolean removeDependenciesIfNeeded$lambda$0(ObservableProperty $property, Dependency it) {
        return Intrinsics.areEqual(it.getProperty(), (Object)$property) && it.getDeleteWhenPropertyModified();
    }

    private static final boolean removeDependenciesIfNeeded$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit propagateChange$lambda$0$0(Dependency $dependency) {
        $dependency.applyUpdate();
        return Unit.INSTANCE;
    }

    public PropertyGraph() {
        this(null, false, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/observable/properties/PropertyGraph$Dependency;", "T", "", "property", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "deleteWhenPropertyModified", "", "update", "Lkotlin/Function0;", "<init>", "(Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;ZLkotlin/jvm/functions/Function0;)V", "getProperty", "()Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "getDeleteWhenPropertyModified", "()Z", "applyUpdate", "", "intellij.platform.ide.observable"})
    private static final class Dependency<T> {
        @NotNull
        private final ObservableMutableProperty<T> property;
        private final boolean deleteWhenPropertyModified;
        @NotNull
        private final Function0<T> update;

        public Dependency(@NotNull ObservableMutableProperty<T> property, boolean deleteWhenPropertyModified, @NotNull Function0<? extends T> update) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            Intrinsics.checkNotNullParameter(update, (String)"update");
            this.property = property;
            this.deleteWhenPropertyModified = deleteWhenPropertyModified;
            this.update = update;
        }

        @NotNull
        public final ObservableMutableProperty<T> getProperty() {
            return this.property;
        }

        public final boolean getDeleteWhenPropertyModified() {
            return this.deleteWhenPropertyModified;
        }

        public final void applyUpdate() {
            if (this.property instanceof AtomicMutableProperty) {
                ((AtomicMutableProperty)this.property).updateAndGet(arg_0 -> Dependency.applyUpdate$lambda$0(this, arg_0));
            } else {
                this.property.set(this.update.invoke());
            }
        }

        private static final Object applyUpdate$lambda$0(Dependency this$0, Object it) {
            return this$0.update.invoke();
        }
    }
}

